#version 450

#extension GL_EXT_shader_explicit_arithmetic_types : enable
#extension GL_ARB_shader_ballot : enable
#extension GL_KHR_shader_subgroup_ballot : enable
#extension GL_EXT_debug_printf : enable
#define HAS_16BIT_TYPES

#include <shaders/materials/commons.glsl>
#include <shaders/geometry_partitioning/raytrace_buffers.glsl>
#include <shaders/geometry_partitioning/raytrace_commons.glsl>

layout(points) in;
layout(points, max_vertices = 1) out;

layout(r32ui) uniform uimage3D imGridMarkers0;
layout(r32ui) uniform uimage3D imGridMarkers2;

// for projection we use calculated bounding box converted to the grid coords

layout(location = 1) in Vertex
{
	vec3    vLocalPos;
	f16vec4 vColor;
	f16vec2 vUV0;
	uint    vIdx;
} vtx_inputs[];

// no interpolation, can use intergers

layout(location = 1) out vec3 vGridCoords;
layout(location = 2) out f16vec2 vUV0;
layout(location = 8) out vec4 vColor;

layout(location = 5) out noperspective vec3 vPointCoords;

struct PartitionGeometryDrawParams
{
	uint64_t buff_grid_markers_ptr;
	uint     instance_idx;
};


layout(std140, row_major) uniform PartitionGeometryDrawParamsBuffer{
	PartitionGeometryDrawParams partition_geometry_params;
};

void main()
{
	vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;

	// translate and scale gerometry. do not use bbox as we need grid-aligned offsets
	// TODO: we can actually convert bbox to be grid_size aligned (cell size aligned)

	vec3 v0 = vtx_inputs[0].vLocalPos.xyz;
	
	if (vtx_inputs[0].vIdx == 0)
		return;
	
	vec3 s = -bbox_origin;
	v0 += s;
	
	vec3 f = vec3(1.0) / bbox_grid_size;
	v0 *= f;
		
	vec3 grid_v0 = v0;

	vPointCoords = v0;

	gl_Position = vec4(grid_v0 * 2.0 - vec3(GRID_RES), GRID_RES);
	
	vGridCoords = grid_v0;
	vUV0   = vtx_inputs[0].vUV0;
	vColor = vtx_inputs[0].vColor;
	
	EmitVertex();
	EndPrimitive();
}



