#version 450

#extension GL_EXT_shader_explicit_arithmetic_types : enable
#extension GL_ARB_shader_ballot : enable
#extension GL_KHR_shader_subgroup_ballot : enable
#extension GL_EXT_debug_printf : enable
#define HAS_16BIT_TYPES

#include <shaders/materials/commons.glsl>
#include <shaders/geometry_partitioning/raytrace_buffers.glsl>
#include <shaders/geometry_partitioning/raytrace_commons.glsl>

layout(lines) in;
layout(line_strip, max_vertices = 2) out;

layout(r32ui) uniform uimage3D imGridMarkers0;
layout(r32ui) uniform uimage3D imGridMarkers2;

// for projection we use calculated bounding box converted to the grid coords

layout(location = 1) in Vertex
{
	vec3    vLocalPos;
	f16vec4 vColor;
	f16vec2 vUV0;
	uint    vIdx;
} vtx_inputs[];

// no interpolation, can use intergers

layout(location = 0) flat out int vOrientationIndex;

layout(location = 1) out vec3 vGridCoords;
layout(location = 2) out f16vec2 vUV0;
layout(location = 8) out vec4 vColor;

layout(location = 5) out noperspective vec3 vLineCoords[];

struct PartitionGeometryDrawParams
{
	uint64_t buff_grid_markers_ptr;
	uint     instance_idx;
};


layout(std140, row_major) uniform PartitionGeometryDrawParamsBuffer{
	PartitionGeometryDrawParams partition_geometry_params;
};

// we need to output orientation to properly place it into grid when running in PS
void main()
{
	vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;

	int orientation_index;
	vec3 v0, v1;

	// translate and scale gerometry. do not use bbox as we need grid-aligned offsets
	// TODO: we can actually convert bbox to be grid_size aligned (cell size aligned)

	v0 = vtx_inputs[0].vLocalPos.xyz;
	v1 = vtx_inputs[1].vLocalPos.xyz;
	
	if (vtx_inputs[0].vIdx == 0 || vtx_inputs[1].vIdx == 0)
	{
		return;
	}
	
	// small primitive optimization. NOTE: seems we can not write both from GS and FS
	// so only the counting pass is optimized for now:(

	vec3 s = -bbox_origin;
	v0 += s;
	v1 += s;
	
	vec3 f = vec3(1.0) / bbox_grid_size;
	v0 *= f;
	v1 *= f;

	//v0 = vec3(0, 0, 0);
	//v1 = vec3( GRID_RES,  GRID_RES,  GRID_RES);
	
	// instead of normal, use largest gradient
	vec3 d = v0 - v1;
	d = abs(d);
	
	// NOTE: This is actually a problem, for very short lines we might get holes.
	// No idea if we want to reject even the smallest ones?
	float length = length(v1 - v0);
	//if (length <= 0.001)
	//	return;

	vec3 grid_v0 = v0;
	vec3 grid_v1 = v1;

#if 1
	if (d.x < d.y && d.x < d.z)
	{
		// X dominant
		grid_v0 = grid_v0.yzx;
		grid_v1 = grid_v1.yzx;
		orientation_index = 0;
	}
	else if (d.y < d.x && d.y < d.z)
	{
		// Y dominant
		grid_v0 = grid_v0.zxy;
		grid_v1 = grid_v1.zxy;
		orientation_index = 1;
	}
	else// if (n.x > n.y && n.x > n.z)
	{
		// Z dominant
		grid_v0 = grid_v0.xyz;
		grid_v1 = grid_v1.xyz;
		orientation_index = 2;
	}
#else
	// Z dominant
	grid_v0 = grid_v0.xyz;
	grid_v1 = grid_v1.xyz;
	grid_v2 = grid_v2.xyz;
	orientation_index = 2;

#endif

#if 1
	
	vLineCoords[0] = v0;
	vLineCoords[1] = v1;

	vOrientationIndex = orientation_index;
	gl_Position = vec4(grid_v0 * 2.0 - vec3(GRID_RES), GRID_RES);
	
	vGridCoords = grid_v0;
	vUV0   = vtx_inputs[0].vUV0;
	vColor = vtx_inputs[0].vColor;

	EmitVertex();

	vLineCoords[0] = v0;
	vLineCoords[1] = v1;
	
	vOrientationIndex = orientation_index;
	gl_Position = vec4(grid_v1 * 2.0 - vec3(GRID_RES), GRID_RES);
	
	vGridCoords = grid_v1;
	vUV0   = vtx_inputs[1].vUV0;
	vColor = vtx_inputs[1].vColor;

	EmitVertex();

	
	EndPrimitive();
#else
		EndPrimitive();
#endif
}


