#version 460
#extension GL_EXT_debug_printf : enable

uniform sampler2D      s_LTC1;
uniform sampler2D      s_LTC2;
uniform sampler2D      s_BRDF;
uniform sampler2DArray s_BlueNoise;

uniform samplerCube    sEnviromentMap;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_sampling.glsl>
#include <shaders/geometry_partitioning/raytrace_buffers.glsl>
#include <shaders/geometry_partitioning/raytrace_commons.glsl>

#include <shaders/deferred/lighting/lighting_support.glsl>

struct VoxelizationDispatchParams
{
	int  lights_num;
	uint component_tags;
	float env_map_intensity;
};

layout (std140, row_major) uniform VoxelizationDispatchParamsBuffer
{
	VoxelizationDispatchParams dispatch_params;
};

struct RibbonRenderParams
{
	int   max_segments;
	float voxelize_thickness;
	int   base_segment;
	int   particles_per_segment;
	float thickness;
	int   lights_num;
	int   material_index;
	float first_segment_time_factor;
	int   render_as_strips;
	int   segment_subdivisions;
	int   _pad1;
	int   _pad2;
};

layout(std140) uniform RibbonRenderParamsBuffer {
	RibbonRenderParams ribbon_render_params;
};

layout (location = 0) flat in int vOrientationIndex;
layout (location = 1) in vec3 vGridCoords;
layout (location = 2) in f16vec2 vUV0;
layout (location = 5) in vec3 vLineCoords[2];
layout (location = 8) in vec4 vColor;

#include <shaders/geometry_partitioning/partition_commons.glsl>
#include <shaders/deferred/lighting/ltc_quad.glsl>

// ------------------------------------------------------------------------------------------------------------------

vec3 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	return vec3(d);
}

// ------------------------------------------------------------------------------------------------------------------

// 1 : mark cell as used
// 2 : if the cell was unmarked then initilize linked list. consume some constant amount of indices from the buffer
// 3 : if the cell was initialized then calculate brick in the cell and insert new triangle into it

// orientation index is to transform triangle into original coors space (0, 1, 2 -> YZ, XZ, XY)

// Thick mode has a problem that is overwrites cells which are shadowed. We should probably
// go with the 'min' mode for color and 'max' for occlusion

//#define VX_FRACTIONAL_OCCLUSION
// Following defines are set up in the voxelizer per user selection
//#define VX_FRACTIONAL_OCCLUSION_THICK
#define VX_AS_EMISSIVE

float point_to_segment_distance(vec3 A, vec3 B, vec3 P)
{
    vec3 AB = B - A;
    vec3 AP = P - A;
    float t = dot(AP, AB) / dot(AB, AB);
    t = clamp(t, 0.0, 1.0);
    vec3 Q = A + t * AB;
    return length(P - Q);
}

uint build_step_dir()
{
	if (vOrientationIndex == 0)
		return 1;
	else if (vOrientationIndex == 1)
		return 2;
	else // if (vOrientationIndex == 2)
		return 4;
}

ivec3 unpack_step_dir(uint step_dir)
{
	return ivec3(
		(step_dir & 1) != 0 ? 1 : 0,
		(step_dir & 2) != 0 ? 1 : 0,
		(step_dir & 4) != 0 ? 1 : 0
	);
}

void main()
{
	vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
	vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;

	vec3 pos = vGridCoords;

	uint cx;// = uint(gl_FragCoord.x);
	uint cy;// = uint(gl_FragCoord.y);
	uint cz;// = uint(gl_FragCoord.z * GRID_RES);

	vec3 gc = gl_FragCoord.xyz / vec3(1.0, 1.0, 1.0/GRID_RES) + vec3(0.0, 0.0, 0.0);
#ifdef SPIRV_VULKAN
    gc.y = 255.5 - gc.y;
#endif
	//vec3 gc = vGridCoords;
	
	// triangle bbox

	ivec3 mi = ivec3(floor(min(vLineCoords[0], vLineCoords[1])));
	ivec3 ma = ivec3(ceil(max(vLineCoords[0], vLineCoords[1])));
	
    //mi = ivec3(0,0,0);
    //ma = ivec3(GRID_RES-1,GRID_RES-1,GRID_RES-1);

	mi = clamp(mi, ivec3(0), ivec3(GRID_RES-1));
	ma = clamp(ma, ivec3(0), ivec3(GRID_RES-1));

	uint stepDir = 0;
	uvec3 stepStart = uvec3(0);
	int steps;

	if (vOrientationIndex == 0)
	{
		cy = uint(gc.x);
		cz = uint(gc.y);
		cx = uint(gc.z);
		stepStart = uvec3(cx, cy, cz);
		steps = ma.x - mi.x;
	}
	else if (vOrientationIndex == 1)
	{
		cz = uint(gc.x);
		cx = uint(gc.y);
		cy = uint(gc.z);

		stepStart = uvec3(cx, cy, cz);
		steps = ma.y - mi.y;
	}
	else
	{
		cx = uint(gc.x);
		cy = uint(gc.y);
		cz = uint(gc.z);
		stepStart = uvec3(cx, cy, cz);
		steps = ma.z - mi.z;
	}

	stepDir = build_step_dir();

	int stepMin = 0;
	int stepCount = 0;

	const bool early_occlusion_store = true;

	// calculate color only once
	vec3 voxel_color = vec3(0.0, 0.0, 0.0);

	// in vColor.a we smuggle lifetime-based thickness modifier
	int sampling_r = int(ceil(ribbon_render_params.voxelize_thickness * vColor.a));

	//int s = 0;

	MaterialPropertiesGPU material = materials.material_properties[ribbon_render_params.material_index];
	float roughness = material.roughness;

	{
		vec3 world = (vec3(stepStart)) * in_bbox_data.grid_size_voxelize.xyz + in_bbox_data.bbox_voxelize_min.xyz;

		// albedo color. This is very simplistic and should be unified with normal shader
		// TODO: Make fragment shader modifiers pluggable (properly) so we can share them here
		vec3 base_albedo = vColor.rgb;
		vec3 base_emissive = vec3(1.0);
		if (material.albedo_sampler >= 0 && material.albedo_sampler < 16)
			base_albedo.rgb *= textureLod(material_textures[material.albedo_sampler], vUV0, 2.0).rgb;
		if (material.emissive_sampler >= 0 && material.emissive_sampler < 16)
			base_emissive.rgb = textureLod(material_textures[material.emissive_sampler], vUV0, 2.0).rgb;

		// iterate through lights. no specular component, only diffuse
		for(int light_idx = 0; light_idx < ribbon_render_params.lights_num; light_idx++)
		{
			LightProperties light = lights.light_properties[light_idx];

			if ((light.type & LightType_Raytraced) != 0)
				continue;

			f16vec4 projector_color = f16vec4(0.0);

			vec3 pointToLight = light.position.xyz - world.xyz;
			if ((light.type & LightType_Directional) != 0)
				pointToLight = -light.direction.xyz;

			vec3 lighting = material.diffuse.rgb;
			
			float shadow = 0.0;

			#if 0 // for now we don't have shadowmap at this point in time
			{
				bool calculate_shadows = ((material.flags & MaterialFlag_ShadowReceive) != 0)
				  && ((light.type & LightType_Shadowcasting) != 0);

				if ((light.type & (LightType_Spot | LightType_Directional)) != 0 && calculate_shadows)
				{
					// shadows. NOTE: Here we actually reduce the penumbra as we use simpler sampling
					// NOTE: Might want to include contact shadows for all lights. This greatly reduces
					// leaking...

					float penumbra_scaling_factor = 0.5;

					vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world.xyz, 1.0);
		
					// TODO: Make this configurable, same as in normal lighting
					float penumbraSampleNoise = 0.0;
					#if 0
					float penumbra = PenumbraFromOccluderSearch(
						LightShadowmapSamplers[light.shadowmap_sampler0],
						penumbraSampleNoise,
						vShadowCoords,
						penumbra_scaling_factor * roughness * light.roughness_modifier / 1024.0,
						4,
						materials.material_properties[materialIndex].shadowmap_bias);
					#else
					float penumbra = 0.5;
					#endif

					float in_frustum = 0.0;
					//shadow = sampleShadow(LightShadowmapCmpSamplers[light.shadowmap_sampler0], vShadowCoords, in_frustum, projector_color);
					shadow = sampleShadowPCF(
						LightShadowmapCmpSamplers[light.shadowmap_sampler0],
						vShadowCoords,
						in_frustum,
						3,
						penumbra_scaling_factor * roughness * penumbra * light.roughness_modifier / 1024.0);
				}

			}
			#endif

			lighting = lighting * light.diffuse.rgb * light.intensity;
			lighting = lighting * (1.0 - shadow);

			if ((light.type & (LightType_Spot | LightType_Attenuating)) == (LightType_Spot | LightType_Attenuating))
			{
				float attenuation = light_calculate_spot_attenuation(light, world.xyz);
				lighting.rgb *= attenuation;

				#if 0
				if ((light.type & LightType_Projector) != 0)
				{
					vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world.xyz, 1.0);

					vec3 projector_color = sampleProjectorTexture(
						LightProjectorSamplers[light.projector_sampler],
						vShadowCoords).rgb * light.projector_intensity;

					lighting.rgb *= projector_color;
				}
				#endif
			}

			voxel_color.rgb += vec3(lighting);
		}

		voxel_color.rgb *= base_albedo;
		voxel_color.rgb += material.emissive.rgb * base_emissive * material.emissive_factor;

		{
			//vec3 f0 = vec3(0.04, 0.04, 0.04);
			//float metalness = 0.5; // TODO
			//vec3 diffuseColor = base_albedo.rgb * (vec3(1.0, 1.0, 1.0) - f0) * (1.0 - metalness);
	
			//IBLOutput ibl = ibl(vTriNormalForLighting, diffuseColor);
			//voxel_color.rgb += ibl.color_weighted * dispatch_params.env_map_intensity;
		}
	}

	for(int sz = -sampling_r; sz <= sampling_r; sz++)
	{
		for(int sy = -sampling_r; sy <= sampling_r; sy++)
		{
			for(int sx = -sampling_r; sx <= sampling_r; sx++)
			{
				uvec3 cc = stepStart + ivec3(sx, sy, sz);
				vec3 cellPos = vec3(cc);
				vec3 cellSize = vec3(1.0);

				vec3 sampling_pos = cellPos + cellSize * 0.5;
				float line_segment_d = point_to_segment_distance(vLineCoords[0], vLineCoords[1], sampling_pos);
				float max_d = cellSize.x * ribbon_render_params.voxelize_thickness * vColor.a;

				if (line_segment_d < max_d)
				{
					float occ = 1.0 - line_segment_d / max_d;
					rt_store_voxel_occlusion(cc.x, cc.y, cc.z, occ);
					rt_store_voxel_color_emissive(cc.x, cc.y, cc.z, vec4(voxel_color, 1.0) * occ);
				}

				//if (checkTriCellOverlap(vTriCoords[0], vTriCoords[1], vTriCoords[2], vTriNormal, cellPos + cellSize * 0.5, cellSize * 0.5))
				if (false)
				{
					//if (stepMin == -1)
					//	stepMin = s;

					// store occlusion information. cell center distance to the triangle. use non-uniform normal and lets see
					// how it works
					if (early_occlusion_store)
					{
					#ifdef VX_FRACTIONAL_OCCLUSION
						float d = -dot(vTriNormal, vTriCoords[0]);
						float distance = dot(vTriNormal, cellPos + cellSize * 0.5) + d;
						rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0 - clamp(0.5 + distance, 0.0, 1.0));

						#ifdef VX_FRACTIONAL_OCCLUSION_THICK
							if (vOrientationIndex == 0)
								cc.x = uint(clamp(int(cc.x) - sign(vTriNormal.x), 0, GRID_RES-1));
							else if (vOrientationIndex == 1)
								cc.y = uint(clamp(int(cc.y) - sign(vTriNormal.y), 0, GRID_RES-1));
							else if (vOrientationIndex == 2)
								cc.z = uint(clamp(int(cc.z) - sign(vTriNormal.z), 0, GRID_RES-1));

							rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0);
						#endif
					#else
						rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0);
						rt_store_voxel_color_emissive(cc.x, cc.y, cc.z, vec4(voxel_color, 1.0));
					#endif
					}
					stepCount++;
				}

			}
		}
	}

	return;

	for(int s = -1; s <= 0; s++)
	{
		uvec3 cc = stepStart + unpack_step_dir(stepDir) * s;
		vec3 cellPos = vec3(cc);
		vec3 cellSize = vec3(1.0);

		//if (checkTriCellOverlap(vTriCoords[0], vTriCoords[1], vTriCoords[2], vTriNormal, cellPos + cellSize * 0.5, cellSize * 0.5))
		if (false)
		{
			//if (stepMin == -1)
			//	stepMin = s;

			// store occlusion information. cell center distance to the triangle. use non-uniform normal and lets see
			// how it works
			if (early_occlusion_store)
			{
			#ifdef VX_FRACTIONAL_OCCLUSION
				float d = -dot(vTriNormal, vTriCoords[0]);
				float distance = dot(vTriNormal, cellPos + cellSize * 0.5) + d;
				rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0 - clamp(0.5 + distance, 0.0, 1.0));

				#ifdef VX_FRACTIONAL_OCCLUSION_THICK
					if (vOrientationIndex == 0)
						cc.x = uint(clamp(int(cc.x) - sign(vTriNormal.x), 0, GRID_RES-1));
					else if (vOrientationIndex == 1)
						cc.y = uint(clamp(int(cc.y) - sign(vTriNormal.y), 0, GRID_RES-1));
					else if (vOrientationIndex == 2)
						cc.z = uint(clamp(int(cc.z) - sign(vTriNormal.z), 0, GRID_RES-1));

					rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0);
				#endif
			#else
				rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0);
				rt_store_voxel_color_emissive(cc.x, cc.y, cc.z, vec4(voxel_color, 1.0));
			#endif
			}
			stepCount++;
		}
	};

	if (stepCount == 0)
		return;

	// TODO: For now just emissive, so put it into main loop. This is super hacky
	return;

	stepStart = stepStart + unpack_step_dir(stepDir) * stepMin;

	//voxel_color.rgb *= 0.01;

	while(stepCount-- > 0)
	{
		uint ccx = stepStart.x;
		uint ccy = stepStart.y;
		uint ccz = stepStart.z;

		if (!early_occlusion_store)
		{
			uvec3 cc = uvec3(ccx, ccy, ccz);
			vec3 cellPos = vec3(cc.x, cc.y, cc.z);
			vec3 cellSize = vec3(1.0);

			#ifdef VX_FRACTIONAL_OCCLUSION
				float d = -dot(vTriNormal, vTriCoords[0]);
				float distance = dot(vTriNormal, cellPos + cellSize * 0.5) + d;
				float fractional_occlusion = 1.0 - clamp(0.5 + distance, 0.0, 1.0);
				rt_store_voxel_occlusion(cc.x, cc.y, cc.z, fractional_occlusion);

				#ifdef VX_FRACTIONAL_OCCLUSION_THICK
					if (vOrientationIndex == 0)
						cc.x = uint(clamp(int(cc.x) - sign(vTriNormal.x), 0, GRID_RES-1));
					else if (vOrientationIndex == 1)
						cc.y = uint(clamp(int(cc.y) - sign(vTriNormal.y), 0, GRID_RES-1));
					else if (vOrientationIndex == 2)
						cc.z = uint(clamp(int(cc.z) - sign(vTriNormal.z), 0, GRID_RES-1));

					rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0);
				#endif
			#else
				rt_store_voxel_occlusion(cc.x, cc.y, cc.z, 1.0);
			#endif
		}
		//if (rt_get_voxel_color(ccx, ccy, ccz).a == 0.0)
		{
			//rt_store_voxel_color(ccx, ccy, ccz, vec4(vec3(1.0, 0.0, 0.0), 1.0));

			#ifdef VX_AS_EMISSIVE
				rt_store_voxel_color_emissive(ccx, ccy, ccz, vec4(voxel_color, 1.0));
			#else
				rt_store_voxel_color(ccx, ccy, ccz, vec4(voxel_color, 1.0));
			#endif
			//rt_store_voxel_color(ccx, ccy, ccz, vec4(0.0,0.0, 0.0, 1.0));
			//rt_store_voxel_normal(int(ccx), int(ccy), int(ccz), vTriNormal);
		}

		#ifdef VX_FRACTIONAL_OCCLUSION
		#ifdef VX_FRACTIONAL_OCCLUSION_THICK

		// NOTE: This is disabled because we actually have tighter range here than with occlusion
		if (vOrientationIndex == 0)
			ccx = uint(clamp(int(ccx) - sign(vTriNormal.x), 0, GRID_RES-1));
		else if (vOrientationIndex == 1)
			ccy = uint(clamp(int(ccy) - sign(vTriNormal.y), 0, GRID_RES-1));
		else if (vOrientationIndex == 2)
			ccz = uint(clamp(int(ccz) - sign(vTriNormal.z), 0, GRID_RES-1));

		//rt_store_voxel_color_emissive(ccx, ccy, ccz, vec4(voxel_color, 1.0));

		#endif
		#endif

		stepStart += unpack_step_dir(stepDir);
	}

}


