#version 460

#ifndef SPIRV_ENABLED
#extension GL_NV_gpu_shader5 : enable
#endif

#include <shaders/materials/commons.glsl>
#include <shaders/particles/particles_commons.glsl>

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXNormals {
	float normals[];
} vtx_normals;

vec3 vtx_normals_load(uint idx)
{
	return vec3(vtx_normals.normals[idx * 3 + 0], vtx_normals.normals[idx * 3 + 1], vtx_normals.normals[idx * 3 + 2]);
}

struct InstancedMeshParams
{
	float scale;
	int   merged_clones;			// how many times base mesh is cloned into single mesh
	int   base_verts_num;			// how many verts total it has
};

layout(std140, row_major) uniform InstancedMeshParamsBuffer {
	InstancedMeshParams instanced_mesh_params;
};

#ifndef SPIRV_ENABLED
out Vertex
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_output;

out uint instanceID;
#else
layout(location = 1) out struct
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_output;

layout(location = 0) out uint instanceID;
#endif

//#define RENDER_POINTS

void main() {
	
#ifndef RENDER_POINTS
	// fetch input data
	int instance_idx = SYS_InstanceIndex * instanced_mesh_params.merged_clones + SYS_VertexIndex / instanced_mesh_params.base_verts_num;
	//int instance_idx = SYS_InstanceIndex;
	vec3 vInstPosition = prt_get_position(instance_idx);
	vec4 vInstColor = prt_get_color(instance_idx);
	bool is_alive = prt_is_alive(instance_idx);

	instanceID = SYS_InstanceIndex;

	//vec3ivNormal = vec3(indata.verts[instance_idx].nx, indata.verts[instance_idx].ny, indata.verts[instance_idx].nz);
	//ivColor = vec4(indata.verts[instance_idx].cr, indata.verts[instance_idx].cg, indata.verts[instance_idx].cb, indata.verts[instance_idx].ca);

	// rotate base cube

	vec3 angles = vec3(0.0);// vec3(indata.verts[instance_idx].nx, indata.verts[instance_idx].ny, indata.verts[instance_idx].nz);
	float cosb = cos(angles.z);   // don't change x with z. This is a correct order.
	float sinb = sin(angles.z);
	float cosp = cos(angles.x);
	float sinp = sin(angles.x);
	float cosh = cos(angles.y);
	float sinh = sin(angles.y);

	vec3 mx, my, mz;
	mx.x = cosh * cosb + (sinh * sinp * sinb);
	mx.y = sinh * sinp * cosb - (cosh * sinb);
	mx.z = sinh * cosp;
	my.x = cosp * sinb;
	my.y = cosp * cosb;
	my.z = -sinp;
	mz.x = cosh * sinp * sinb - (sinh * cosb);
	mz.y = sinh * sinb + (cosh * sinp * cosb);
	mz.z = cosh * cosp;

	vec3 cube_coords = vtx_coords_load(SYS_VertexIndex);
	vec3 cube_normal = vtx_normals_load(SYS_VertexIndex);
	float cube_scale = is_alive ? instanced_mesh_params.scale : 0.0;// indata.verts[instance_idx].ca;
	cube_coords = vec3(dot(cube_coords, mx), dot(cube_coords, my), dot(cube_coords, mz));
	cube_normal = vec3(dot(cube_normal, mx), dot(cube_normal, my), dot(cube_normal, mz));

	vInstPosition = vInstPosition + cube_coords * cube_scale;
	vec3 pos = vInstPosition;
	f16vec3 norm = f16vec3(cube_normal);
#else
	int instance_idx = SYS_VertexIndex;
	vec3 pos = prt_get_position(instance_idx);
	f16vec3 norm = vec3(0.0, 0.0, 1.0);
#endif

	vtx_output.vLocalPos = pos;

	vec3 vPos1 = pos;
	vec3 vPos = vector_transform_by_mat43(vPos1, transform_params.mModelView);
	vtx_output.vWorldPos = vector_transform_by_mat43(vPos1, transform_params.mModel).xyz;

	vtx_output.vWorldNorm = norm;
	vtx_output.vNorm = norm;

	vtx_output.vCoords = vPos.xyz;
	vtx_output.vColor = f16vec4(vInstColor);
	vtx_output.vUV0 = f16vec2(0.0);

	gl_Position = transform_params.mProjection * vec4(vPos, 1.0);

}