#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryRebuildNormalsParams
{
    uint surfaces_num;
    uint surface_idx;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer GPUOnlyMemoryAllocatorInfoBuffer
{
    uint offset;
    uint num_allocations;
    uint _pad0;
    uint _pad1;
} gpu_allocator_data;

layout(set = 0, binding = 6, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _92;

layout(set = 0, binding = 2, std430) buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 3, std430) buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 7, std140) uniform GeometryRebuildNormalsParamsBuffer
{
    GeometryRebuildNormalsParams geometry_rebuild_normals_params;
} _145;

layout(set = 0, binding = 4, std430) buffer AccumulationBuffer
{
    uint values[];
} accumulation_buffer;

layout(set = 0, binding = 5, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _293;

uint get_idx(inout uint idx)
{
    idx += _92.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

vec3 get_coords(inout uint idx)
{
    idx *= _92.input_geometry_information.attributes[0].stride;
    idx += _92.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

GeometryInformationAttribute GPUMemoryAllocateForGeometryAttribute(inout GeometryInformation geometry_information, inout GeometryInformationAttribute geometry_information_attribute)
{
    uint id = gl_GlobalInvocationID.x;
    uint _58 = atomicAdd(gpu_allocator_data.offset, (geometry_information.vtx_num * geometry_information_attribute.stride) * 4u);
    uint attribute_buffer_offset = _58;
    geometry_information_attribute.offset = attribute_buffer_offset / 4u;
    uint allocation_size = (geometry_information.vtx_num * geometry_information_attribute.stride) * 4u;
    geometry_information.gpu_memory_allocation_size += allocation_size;
    geometry_information.gpu_memory_allocation_size_total = gpu_allocator_data.offset;
    geometry_information.is_gpu_allocated = 1u;
    uint _82 = atomicAdd(gpu_allocator_data.num_allocations, 1u);
    return geometry_information_attribute;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = _145.geometry_rebuild_normals_params.surface_idx;
    uint src_faces_num = _92.input_geometry_information.faces_num_per_surface[surface_idx];
    for (uint src_face_idx = thread_idx; src_face_idx < src_faces_num; src_face_idx += 131072u)
    {
        uint param = (src_face_idx * 3u) + 0u;
        uint _170 = get_idx(param);
        uint i0 = _170;
        uint param_1 = (src_face_idx * 3u) + 1u;
        uint _176 = get_idx(param_1);
        uint i1 = _176;
        uint param_2 = (src_face_idx * 3u) + 2u;
        uint _182 = get_idx(param_2);
        uint i2 = _182;
        uint param_3 = i0;
        vec3 _187 = get_coords(param_3);
        vec3 v0 = _187;
        uint param_4 = i1;
        vec3 _191 = get_coords(param_4);
        vec3 v1 = _191;
        uint param_5 = i2;
        vec3 _195 = get_coords(param_5);
        vec3 v2 = _195;
        vec3 n = normalize(cross(v0 - v1, v0 - v2));
        uint nx = uint(((n.x + 1.0) * 4096.0) + 0.5);
        uint ny = uint(((n.y + 1.0) * 4096.0) + 0.5);
        uint nz = uint(((n.z + 1.0) * 4096.0) + 0.5);
        uint _241 = atomicAdd(accumulation_buffer.values[(i0 * 2u) + 0u], 65536u | nx);
        uint _251 = atomicAdd(accumulation_buffer.values[(i0 * 2u) + 1u], (ny << uint(16)) | nz);
        uint _258 = atomicAdd(accumulation_buffer.values[(i1 * 2u) + 0u], 65536u | nx);
        uint _267 = atomicAdd(accumulation_buffer.values[(i1 * 2u) + 1u], (ny << uint(16)) | nz);
        uint _274 = atomicAdd(accumulation_buffer.values[(i2 * 2u) + 0u], 65536u | nx);
        uint _283 = atomicAdd(accumulation_buffer.values[(i2 * 2u) + 1u], (ny << uint(16)) | nz);
    }
    if (thread_idx == 0u)
    {
        _293.output_geometry_information = _92.input_geometry_information;
    }
    if (thread_idx == 0u)
    {
        if ((_293.output_geometry_information.builtin_attribute_mask & 2u) == 0u)
        {
            _293.output_geometry_information.builtin_attribute_mask |= 2u;
            _293.output_geometry_information.attributes[1].stride = 3u;
            _293.output_geometry_information.attributes[1].offset = 4294967295u;
            GeometryInformation _320;
            _320.vtx_num = _293.output_geometry_information.vtx_num;
            _320.surfaces_num = _293.output_geometry_information.surfaces_num;
            _320.builtin_attribute_mask = _293.output_geometry_information.builtin_attribute_mask;
            _320.flipbook_cards_num = _293.output_geometry_information.flipbook_cards_num;
            _320.idx_buffer_offset = _293.output_geometry_information.idx_buffer_offset;
            _320.is_gpu_allocated = _293.output_geometry_information.is_gpu_allocated;
            _320.gpu_memory_allocation_size = _293.output_geometry_information.gpu_memory_allocation_size;
            _320.gpu_memory_allocation_size_total = _293.output_geometry_information.gpu_memory_allocation_size_total;
            _320.aux_tracking_0 = _293.output_geometry_information.aux_tracking_0;
            _320.aux_tracking_1 = _293.output_geometry_information.aux_tracking_1;
            _320.aux_tracking_2 = _293.output_geometry_information.aux_tracking_2;
            _320.aux_tracking_3 = _293.output_geometry_information.aux_tracking_3;
            _320.attributes[0].offset = _293.output_geometry_information.attributes[0].offset;
            _320.attributes[0].stride = _293.output_geometry_information.attributes[0].stride;
            _320.attributes[0]._pad0 = _293.output_geometry_information.attributes[0]._pad0;
            _320.attributes[0]._pad1 = _293.output_geometry_information.attributes[0]._pad1;
            _320.attributes[1].offset = _293.output_geometry_information.attributes[1].offset;
            _320.attributes[1].stride = _293.output_geometry_information.attributes[1].stride;
            _320.attributes[1]._pad0 = _293.output_geometry_information.attributes[1]._pad0;
            _320.attributes[1]._pad1 = _293.output_geometry_information.attributes[1]._pad1;
            _320.attributes[2].offset = _293.output_geometry_information.attributes[2].offset;
            _320.attributes[2].stride = _293.output_geometry_information.attributes[2].stride;
            _320.attributes[2]._pad0 = _293.output_geometry_information.attributes[2]._pad0;
            _320.attributes[2]._pad1 = _293.output_geometry_information.attributes[2]._pad1;
            _320.attributes[3].offset = _293.output_geometry_information.attributes[3].offset;
            _320.attributes[3].stride = _293.output_geometry_information.attributes[3].stride;
            _320.attributes[3]._pad0 = _293.output_geometry_information.attributes[3]._pad0;
            _320.attributes[3]._pad1 = _293.output_geometry_information.attributes[3]._pad1;
            _320.attributes[4].offset = _293.output_geometry_information.attributes[4].offset;
            _320.attributes[4].stride = _293.output_geometry_information.attributes[4].stride;
            _320.attributes[4]._pad0 = _293.output_geometry_information.attributes[4]._pad0;
            _320.attributes[4]._pad1 = _293.output_geometry_information.attributes[4]._pad1;
            _320.attributes[5].offset = _293.output_geometry_information.attributes[5].offset;
            _320.attributes[5].stride = _293.output_geometry_information.attributes[5].stride;
            _320.attributes[5]._pad0 = _293.output_geometry_information.attributes[5]._pad0;
            _320.attributes[5]._pad1 = _293.output_geometry_information.attributes[5]._pad1;
            _320.attributes[6].offset = _293.output_geometry_information.attributes[6].offset;
            _320.attributes[6].stride = _293.output_geometry_information.attributes[6].stride;
            _320.attributes[6]._pad0 = _293.output_geometry_information.attributes[6]._pad0;
            _320.attributes[6]._pad1 = _293.output_geometry_information.attributes[6]._pad1;
            _320.attributes[7].offset = _293.output_geometry_information.attributes[7].offset;
            _320.attributes[7].stride = _293.output_geometry_information.attributes[7].stride;
            _320.attributes[7]._pad0 = _293.output_geometry_information.attributes[7]._pad0;
            _320.attributes[7]._pad1 = _293.output_geometry_information.attributes[7]._pad1;
            _320.faces_num_per_surface[0] = _293.output_geometry_information.faces_num_per_surface[0];
            _320.faces_num_per_surface[1] = _293.output_geometry_information.faces_num_per_surface[1];
            _320.faces_num_per_surface[2] = _293.output_geometry_information.faces_num_per_surface[2];
            _320.faces_num_per_surface[3] = _293.output_geometry_information.faces_num_per_surface[3];
            _320.faces_num_per_surface[4] = _293.output_geometry_information.faces_num_per_surface[4];
            _320.faces_num_per_surface[5] = _293.output_geometry_information.faces_num_per_surface[5];
            _320.faces_num_per_surface[6] = _293.output_geometry_information.faces_num_per_surface[6];
            _320.faces_num_per_surface[7] = _293.output_geometry_information.faces_num_per_surface[7];
            _320.faces_num_per_surface[8] = _293.output_geometry_information.faces_num_per_surface[8];
            _320.faces_num_per_surface[9] = _293.output_geometry_information.faces_num_per_surface[9];
            _320.faces_num_per_surface[10] = _293.output_geometry_information.faces_num_per_surface[10];
            _320.faces_num_per_surface[11] = _293.output_geometry_information.faces_num_per_surface[11];
            _320.faces_num_per_surface[12] = _293.output_geometry_information.faces_num_per_surface[12];
            _320.faces_num_per_surface[13] = _293.output_geometry_information.faces_num_per_surface[13];
            _320.faces_num_per_surface[14] = _293.output_geometry_information.faces_num_per_surface[14];
            _320.faces_num_per_surface[15] = _293.output_geometry_information.faces_num_per_surface[15];
            _320.faces_num_per_surface[16] = _293.output_geometry_information.faces_num_per_surface[16];
            _320.faces_num_per_surface[17] = _293.output_geometry_information.faces_num_per_surface[17];
            _320.faces_num_per_surface[18] = _293.output_geometry_information.faces_num_per_surface[18];
            _320.faces_num_per_surface[19] = _293.output_geometry_information.faces_num_per_surface[19];
            _320.faces_num_per_surface[20] = _293.output_geometry_information.faces_num_per_surface[20];
            _320.faces_num_per_surface[21] = _293.output_geometry_information.faces_num_per_surface[21];
            _320.faces_num_per_surface[22] = _293.output_geometry_information.faces_num_per_surface[22];
            _320.faces_num_per_surface[23] = _293.output_geometry_information.faces_num_per_surface[23];
            _320.faces_num_per_surface[24] = _293.output_geometry_information.faces_num_per_surface[24];
            _320.faces_num_per_surface[25] = _293.output_geometry_information.faces_num_per_surface[25];
            _320.faces_num_per_surface[26] = _293.output_geometry_information.faces_num_per_surface[26];
            _320.faces_num_per_surface[27] = _293.output_geometry_information.faces_num_per_surface[27];
            _320.faces_num_per_surface[28] = _293.output_geometry_information.faces_num_per_surface[28];
            _320.faces_num_per_surface[29] = _293.output_geometry_information.faces_num_per_surface[29];
            _320.faces_num_per_surface[30] = _293.output_geometry_information.faces_num_per_surface[30];
            _320.faces_num_per_surface[31] = _293.output_geometry_information.faces_num_per_surface[31];
            _320.faces_num_per_surface[32] = _293.output_geometry_information.faces_num_per_surface[32];
            _320.faces_num_per_surface[33] = _293.output_geometry_information.faces_num_per_surface[33];
            _320.faces_num_per_surface[34] = _293.output_geometry_information.faces_num_per_surface[34];
            _320.faces_num_per_surface[35] = _293.output_geometry_information.faces_num_per_surface[35];
            _320.faces_num_per_surface[36] = _293.output_geometry_information.faces_num_per_surface[36];
            _320.faces_num_per_surface[37] = _293.output_geometry_information.faces_num_per_surface[37];
            _320.faces_num_per_surface[38] = _293.output_geometry_information.faces_num_per_surface[38];
            _320.faces_num_per_surface[39] = _293.output_geometry_information.faces_num_per_surface[39];
            _320.faces_num_per_surface[40] = _293.output_geometry_information.faces_num_per_surface[40];
            _320.faces_num_per_surface[41] = _293.output_geometry_information.faces_num_per_surface[41];
            _320.faces_num_per_surface[42] = _293.output_geometry_information.faces_num_per_surface[42];
            _320.faces_num_per_surface[43] = _293.output_geometry_information.faces_num_per_surface[43];
            _320.faces_num_per_surface[44] = _293.output_geometry_information.faces_num_per_surface[44];
            _320.faces_num_per_surface[45] = _293.output_geometry_information.faces_num_per_surface[45];
            _320.faces_num_per_surface[46] = _293.output_geometry_information.faces_num_per_surface[46];
            _320.faces_num_per_surface[47] = _293.output_geometry_information.faces_num_per_surface[47];
            _320.faces_num_per_surface[48] = _293.output_geometry_information.faces_num_per_surface[48];
            _320.faces_num_per_surface[49] = _293.output_geometry_information.faces_num_per_surface[49];
            _320.faces_num_per_surface[50] = _293.output_geometry_information.faces_num_per_surface[50];
            _320.faces_num_per_surface[51] = _293.output_geometry_information.faces_num_per_surface[51];
            _320.faces_num_per_surface[52] = _293.output_geometry_information.faces_num_per_surface[52];
            _320.faces_num_per_surface[53] = _293.output_geometry_information.faces_num_per_surface[53];
            _320.faces_num_per_surface[54] = _293.output_geometry_information.faces_num_per_surface[54];
            _320.faces_num_per_surface[55] = _293.output_geometry_information.faces_num_per_surface[55];
            _320.faces_num_per_surface[56] = _293.output_geometry_information.faces_num_per_surface[56];
            _320.faces_num_per_surface[57] = _293.output_geometry_information.faces_num_per_surface[57];
            _320.faces_num_per_surface[58] = _293.output_geometry_information.faces_num_per_surface[58];
            _320.faces_num_per_surface[59] = _293.output_geometry_information.faces_num_per_surface[59];
            _320.faces_num_per_surface[60] = _293.output_geometry_information.faces_num_per_surface[60];
            _320.faces_num_per_surface[61] = _293.output_geometry_information.faces_num_per_surface[61];
            _320.faces_num_per_surface[62] = _293.output_geometry_information.faces_num_per_surface[62];
            _320.faces_num_per_surface[63] = _293.output_geometry_information.faces_num_per_surface[63];
            GeometryInformation param_6 = _320;
            GeometryInformationAttribute _325;
            _325.offset = _293.output_geometry_information.attributes[1].offset;
            _325.stride = _293.output_geometry_information.attributes[1].stride;
            _325._pad0 = _293.output_geometry_information.attributes[1]._pad0;
            _325._pad1 = _293.output_geometry_information.attributes[1]._pad1;
            GeometryInformationAttribute param_7 = _325;
            GeometryInformationAttribute _326 = GPUMemoryAllocateForGeometryAttribute(param_6, param_7);
            GeometryInformation _329;
            _329.vtx_num = param_6.vtx_num;
            _329.surfaces_num = param_6.surfaces_num;
            _329.builtin_attribute_mask = param_6.builtin_attribute_mask;
            _329.flipbook_cards_num = param_6.flipbook_cards_num;
            _329.idx_buffer_offset = param_6.idx_buffer_offset;
            _329.is_gpu_allocated = param_6.is_gpu_allocated;
            _329.gpu_memory_allocation_size = param_6.gpu_memory_allocation_size;
            _329.gpu_memory_allocation_size_total = param_6.gpu_memory_allocation_size_total;
            _329.aux_tracking_0 = param_6.aux_tracking_0;
            _329.aux_tracking_1 = param_6.aux_tracking_1;
            _329.aux_tracking_2 = param_6.aux_tracking_2;
            _329.aux_tracking_3 = param_6.aux_tracking_3;
            _329.attributes[0].offset = param_6.attributes[0].offset;
            _329.attributes[0].stride = param_6.attributes[0].stride;
            _329.attributes[0]._pad0 = param_6.attributes[0]._pad0;
            _329.attributes[0]._pad1 = param_6.attributes[0]._pad1;
            _329.attributes[1].offset = param_6.attributes[1].offset;
            _329.attributes[1].stride = param_6.attributes[1].stride;
            _329.attributes[1]._pad0 = param_6.attributes[1]._pad0;
            _329.attributes[1]._pad1 = param_6.attributes[1]._pad1;
            _329.attributes[2].offset = param_6.attributes[2].offset;
            _329.attributes[2].stride = param_6.attributes[2].stride;
            _329.attributes[2]._pad0 = param_6.attributes[2]._pad0;
            _329.attributes[2]._pad1 = param_6.attributes[2]._pad1;
            _329.attributes[3].offset = param_6.attributes[3].offset;
            _329.attributes[3].stride = param_6.attributes[3].stride;
            _329.attributes[3]._pad0 = param_6.attributes[3]._pad0;
            _329.attributes[3]._pad1 = param_6.attributes[3]._pad1;
            _329.attributes[4].offset = param_6.attributes[4].offset;
            _329.attributes[4].stride = param_6.attributes[4].stride;
            _329.attributes[4]._pad0 = param_6.attributes[4]._pad0;
            _329.attributes[4]._pad1 = param_6.attributes[4]._pad1;
            _329.attributes[5].offset = param_6.attributes[5].offset;
            _329.attributes[5].stride = param_6.attributes[5].stride;
            _329.attributes[5]._pad0 = param_6.attributes[5]._pad0;
            _329.attributes[5]._pad1 = param_6.attributes[5]._pad1;
            _329.attributes[6].offset = param_6.attributes[6].offset;
            _329.attributes[6].stride = param_6.attributes[6].stride;
            _329.attributes[6]._pad0 = param_6.attributes[6]._pad0;
            _329.attributes[6]._pad1 = param_6.attributes[6]._pad1;
            _329.attributes[7].offset = param_6.attributes[7].offset;
            _329.attributes[7].stride = param_6.attributes[7].stride;
            _329.attributes[7]._pad0 = param_6.attributes[7]._pad0;
            _329.attributes[7]._pad1 = param_6.attributes[7]._pad1;
            _329.faces_num_per_surface[0] = param_6.faces_num_per_surface[0];
            _329.faces_num_per_surface[1] = param_6.faces_num_per_surface[1];
            _329.faces_num_per_surface[2] = param_6.faces_num_per_surface[2];
            _329.faces_num_per_surface[3] = param_6.faces_num_per_surface[3];
            _329.faces_num_per_surface[4] = param_6.faces_num_per_surface[4];
            _329.faces_num_per_surface[5] = param_6.faces_num_per_surface[5];
            _329.faces_num_per_surface[6] = param_6.faces_num_per_surface[6];
            _329.faces_num_per_surface[7] = param_6.faces_num_per_surface[7];
            _329.faces_num_per_surface[8] = param_6.faces_num_per_surface[8];
            _329.faces_num_per_surface[9] = param_6.faces_num_per_surface[9];
            _329.faces_num_per_surface[10] = param_6.faces_num_per_surface[10];
            _329.faces_num_per_surface[11] = param_6.faces_num_per_surface[11];
            _329.faces_num_per_surface[12] = param_6.faces_num_per_surface[12];
            _329.faces_num_per_surface[13] = param_6.faces_num_per_surface[13];
            _329.faces_num_per_surface[14] = param_6.faces_num_per_surface[14];
            _329.faces_num_per_surface[15] = param_6.faces_num_per_surface[15];
            _329.faces_num_per_surface[16] = param_6.faces_num_per_surface[16];
            _329.faces_num_per_surface[17] = param_6.faces_num_per_surface[17];
            _329.faces_num_per_surface[18] = param_6.faces_num_per_surface[18];
            _329.faces_num_per_surface[19] = param_6.faces_num_per_surface[19];
            _329.faces_num_per_surface[20] = param_6.faces_num_per_surface[20];
            _329.faces_num_per_surface[21] = param_6.faces_num_per_surface[21];
            _329.faces_num_per_surface[22] = param_6.faces_num_per_surface[22];
            _329.faces_num_per_surface[23] = param_6.faces_num_per_surface[23];
            _329.faces_num_per_surface[24] = param_6.faces_num_per_surface[24];
            _329.faces_num_per_surface[25] = param_6.faces_num_per_surface[25];
            _329.faces_num_per_surface[26] = param_6.faces_num_per_surface[26];
            _329.faces_num_per_surface[27] = param_6.faces_num_per_surface[27];
            _329.faces_num_per_surface[28] = param_6.faces_num_per_surface[28];
            _329.faces_num_per_surface[29] = param_6.faces_num_per_surface[29];
            _329.faces_num_per_surface[30] = param_6.faces_num_per_surface[30];
            _329.faces_num_per_surface[31] = param_6.faces_num_per_surface[31];
            _329.faces_num_per_surface[32] = param_6.faces_num_per_surface[32];
            _329.faces_num_per_surface[33] = param_6.faces_num_per_surface[33];
            _329.faces_num_per_surface[34] = param_6.faces_num_per_surface[34];
            _329.faces_num_per_surface[35] = param_6.faces_num_per_surface[35];
            _329.faces_num_per_surface[36] = param_6.faces_num_per_surface[36];
            _329.faces_num_per_surface[37] = param_6.faces_num_per_surface[37];
            _329.faces_num_per_surface[38] = param_6.faces_num_per_surface[38];
            _329.faces_num_per_surface[39] = param_6.faces_num_per_surface[39];
            _329.faces_num_per_surface[40] = param_6.faces_num_per_surface[40];
            _329.faces_num_per_surface[41] = param_6.faces_num_per_surface[41];
            _329.faces_num_per_surface[42] = param_6.faces_num_per_surface[42];
            _329.faces_num_per_surface[43] = param_6.faces_num_per_surface[43];
            _329.faces_num_per_surface[44] = param_6.faces_num_per_surface[44];
            _329.faces_num_per_surface[45] = param_6.faces_num_per_surface[45];
            _329.faces_num_per_surface[46] = param_6.faces_num_per_surface[46];
            _329.faces_num_per_surface[47] = param_6.faces_num_per_surface[47];
            _329.faces_num_per_surface[48] = param_6.faces_num_per_surface[48];
            _329.faces_num_per_surface[49] = param_6.faces_num_per_surface[49];
            _329.faces_num_per_surface[50] = param_6.faces_num_per_surface[50];
            _329.faces_num_per_surface[51] = param_6.faces_num_per_surface[51];
            _329.faces_num_per_surface[52] = param_6.faces_num_per_surface[52];
            _329.faces_num_per_surface[53] = param_6.faces_num_per_surface[53];
            _329.faces_num_per_surface[54] = param_6.faces_num_per_surface[54];
            _329.faces_num_per_surface[55] = param_6.faces_num_per_surface[55];
            _329.faces_num_per_surface[56] = param_6.faces_num_per_surface[56];
            _329.faces_num_per_surface[57] = param_6.faces_num_per_surface[57];
            _329.faces_num_per_surface[58] = param_6.faces_num_per_surface[58];
            _329.faces_num_per_surface[59] = param_6.faces_num_per_surface[59];
            _329.faces_num_per_surface[60] = param_6.faces_num_per_surface[60];
            _329.faces_num_per_surface[61] = param_6.faces_num_per_surface[61];
            _329.faces_num_per_surface[62] = param_6.faces_num_per_surface[62];
            _329.faces_num_per_surface[63] = param_6.faces_num_per_surface[63];
            _293.output_geometry_information = _329;
            GeometryInformationAttribute _331;
            _331.offset = _326.offset;
            _331.stride = _326.stride;
            _331._pad0 = _326._pad0;
            _331._pad1 = _326._pad1;
            _293.output_geometry_information.attributes[1] = _331;
        }
    }
}

 