#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 4, local_size_y = 4, local_size_z = 4) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) readonly buffer OcclusionInputData
{
    uint in_data_occlusion[];
} _322;

layout(set = 0, binding = 2, std430) readonly buffer ColorInputData
{
    uint in_data_color[];
} _530;

layout(set = 0, binding = 3, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 4, r32ui) uniform writeonly uimage3D imTarget0Color;
layout(set = 0, binding = 5, r32ui) uniform writeonly uimage3D imTarget1Color;
layout(set = 0, binding = 6, r8) uniform writeonly image3D imTarget1Occupancy;
layout(set = 0, binding = 7, r32ui) uniform writeonly uimage3D imTarget2Color;
layout(set = 0, binding = 8, r8) uniform writeonly image3D imTarget2Occupancy;

shared vec4 cube_samples_mip1[4][4][4];

uvec2 ThreadGroupTilingX(uvec2 dipatchGridDim, uvec2 ctaDim, uint maxTileWidth, uvec2 groupId)
{
    uint Number_of_CTAs_in_a_perfect_tile = maxTileWidth * dipatchGridDim.y;
    uint Number_of_perfect_tiles = dipatchGridDim.x / maxTileWidth;
    uint Total_CTAs_in_all_perfect_tiles = (Number_of_perfect_tiles * maxTileWidth) * dipatchGridDim.y;
    uint vThreadGroupIDFlattened = (dipatchGridDim.x * groupId.y) + groupId.x;
    uint Tile_ID_of_current_CTA = vThreadGroupIDFlattened / Number_of_CTAs_in_a_perfect_tile;
    uint Local_CTA_ID_within_current_tile = vThreadGroupIDFlattened % Number_of_CTAs_in_a_perfect_tile;
    uint Local_CTA_ID_y_within_current_tile = Local_CTA_ID_within_current_tile / maxTileWidth;
    uint Local_CTA_ID_x_within_current_tile = Local_CTA_ID_within_current_tile % maxTileWidth;
    uint Swizzled_vThreadGroupIDFlattened = ((Tile_ID_of_current_CTA * maxTileWidth) + (Local_CTA_ID_y_within_current_tile * dipatchGridDim.x)) + Local_CTA_ID_x_within_current_tile;
    uvec2 SwizzledvThreadGroupID;
    SwizzledvThreadGroupID.y = Swizzled_vThreadGroupIDFlattened / dipatchGridDim.x;
    SwizzledvThreadGroupID.x = Swizzled_vThreadGroupIDFlattened % dipatchGridDim.x;
    return SwizzledvThreadGroupID;
}

float rt_voxel_occlusion_decode(uint vi)
{
    return float(vi) / 1024.0;
}

uint color_convert_rgb_rgb9e5(inout vec3 rgb)
{
    float kMaxVal = uintBitsToFloat(1199538176u);
    float kMinVal = uintBitsToFloat(931135488u);
    rgb = clamp(rgb, vec3(0.0), vec3(kMaxVal));
    float MaxChannel = max(max(kMinVal, rgb.x), max(rgb.y, rgb.z));
    float Bias = uintBitsToFloat((floatBitsToUint(MaxChannel) + 125845504u) & 2139095040u);
    uvec3 RGB = floatBitsToUint(rgb + vec3(Bias));
    uint E = (floatBitsToUint(Bias) << uint(4)) + 268435456u;
    return ((E | (RGB.z << uint(18))) | (RGB.y << uint(9))) | (RGB.x & 511u);
}

vec4 rt_voxel_color_decode(uint vi)
{
    vec4 v = vec4(0.0);
    if ((vi >> uint(31)) > 0u)
    {
        uint v_mag = (vi >> uint(24)) & 127u;
        float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
        v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
        v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
        v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
        v.w = 1.0;
    }
    return v;
}

vec4 vx_correct_after_downsampling(inout vec4 v)
{
    v *= 2.0;
    v.w = min(1.0, v.w);
    return v;
}

void main()
{
    uvec3 grid_pos_16x16x16 = uvec3(gl_WorkGroupID);
    if (true)
    {
        uvec2 _247 = ThreadGroupTilingX(uvec2(32u), uvec2(4u), 8u, grid_pos_16x16x16.xy);
        grid_pos_16x16x16.x = _247.x;
        grid_pos_16x16x16.y = _247.y;
        grid_pos_16x16x16 = grid_pos_16x16x16.yxz;
    }
    uvec3 grid_pos = (grid_pos_16x16x16 * uvec3(8u)) + (uvec3(gl_LocalInvocationID) * uvec3(2u));
    int grid_size = 256;
    uvec3 store_pos = grid_pos;
    bool all_occlusion_zero = true;
    float a_sum = 0.0;
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                uint source_off = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                uint vi = _322.in_data_occlusion[source_off];
                uint param = vi;
                float a = rt_voxel_occlusion_decode(param);
                all_occlusion_zero = all_occlusion_zero && (a == 0.0);
                a_sum += a;
                imageStore(imTarget0Occupancy, ivec3(store_pos), vec4(a));
                store_pos.x++;
            }
            store_pos.x -= 2u;
            store_pos.y++;
        }
        store_pos.y -= 2u;
        store_pos.z++;
    }
    cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].w = a_sum;
    memoryBarrierShared();
    store_pos = grid_pos;
    SPIRV_CROSS_BRANCH
    if (all_occlusion_zero)
    {
        for (int iz_1 = 0; iz_1 < 2; iz_1++)
        {
            for (int iy_1 = 0; iy_1 < 2; iy_1++)
            {
                for (int ix_1 = 0; ix_1 < 2; ix_1++)
                {
                    uint source_off_1 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                    vec4 v = vec4(0.0);
                    vec3 param_1 = v.xyz;
                    uint _443 = color_convert_rgb_rgb9e5(param_1);
                    imageStore(imTarget0Color, ivec3(store_pos), uvec4(_443));
                    store_pos.x++;
                }
                store_pos.x -= 2u;
                store_pos.y++;
            }
            store_pos.y -= 2u;
            store_pos.z++;
        }
        cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].x = 0.0;
        cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].y = 0.0;
        cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].z = 0.0;
    }
    else
    {
        vec3 v_sum = vec3(0.0);
        for (int iz_2 = 0; iz_2 < 2; iz_2++)
        {
            for (int iy_2 = 0; iy_2 < 2; iy_2++)
            {
                for (int ix_2 = 0; ix_2 < 2; ix_2++)
                {
                    uint source_off_2 = (store_pos.x + (store_pos.y * uint(grid_size))) + ((store_pos.z * uint(grid_size)) * uint(grid_size));
                    uint vi_1 = _530.in_data_color[source_off_2];
                    uint param_2 = vi_1;
                    vec4 v_1 = rt_voxel_color_decode(param_2);
                    vec3 param_3 = v_1.xyz;
                    uint _544 = color_convert_rgb_rgb9e5(param_3);
                    imageStore(imTarget0Color, ivec3(store_pos), uvec4(_544));
                    v_sum += v_1.xyz;
                    store_pos.x++;
                }
                store_pos.x -= 2u;
                store_pos.y++;
            }
            store_pos.y -= 2u;
            store_pos.z++;
        }
        cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].x = v_sum.x;
        cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].y = v_sum.y;
        cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].z = v_sum.z;
    }
    barrier();
    groupMemoryBarrier();
    memoryBarrierShared();
    for (int iz_3 = 0; iz_3 < 1; iz_3++)
    {
        for (int iy_3 = 0; iy_3 < 1; iy_3++)
        {
            for (int ix_3 = 0; ix_3 < 1; ix_3++)
            {
                store_pos = (grid_pos / uvec3(2u)) + uvec3(ivec3(ix_3, iy_3, iz_3));
                vec4 samples_color = vec4(0.0);
                samples_color.w = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].w / 8.0;
                vec3 _643 = cube_samples_mip1[gl_LocalInvocationID.z][gl_LocalInvocationID.y][gl_LocalInvocationID.x].xyz / vec3(8.0);
                samples_color.x = _643.x;
                samples_color.y = _643.y;
                samples_color.z = _643.z;
                vec4 param_4 = samples_color;
                vec4 _652 = vx_correct_after_downsampling(param_4);
                samples_color = _652;
                vec3 param_5 = samples_color.xyz;
                uint _660 = color_convert_rgb_rgb9e5(param_5);
                imageStore(imTarget1Color, ivec3(store_pos), uvec4(_660));
                imageStore(imTarget1Occupancy, ivec3(store_pos), samples_color.wwww);
            }
        }
    }
    bool _677 = (gl_LocalInvocationID.z & 1u) == 0u;
    bool _684;
    if (_677)
    {
        _684 = (gl_LocalInvocationID.y & 1u) == 0u;
    }
    else
    {
        _684 = _677;
    }
    bool _691;
    if (_684)
    {
        _691 = (gl_LocalInvocationID.x & 1u) == 0u;
    }
    else
    {
        _691 = _684;
    }
    if (_691)
    {
        uint _696 = gl_LocalInvocationID.z + 0u;
        uint _699 = gl_LocalInvocationID.y + 0u;
        uint _702 = gl_LocalInvocationID.x + 0u;
        vec4 _785 = (((((cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u] + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 0u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 0u]) + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 1u]) + cube_samples_mip1[gl_LocalInvocationID.z + 1u][gl_LocalInvocationID.y + 1u][gl_LocalInvocationID.x + 1u];
        cube_samples_mip1[_696][_699][_702] += _785;
        uint _792 = gl_LocalInvocationID.z + 0u;
        uint _795 = gl_LocalInvocationID.y + 0u;
        uint _798 = gl_LocalInvocationID.x + 0u;
        cube_samples_mip1[_792][_795][_798] /= vec4(64.0);
        vec4 param_6 = cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u];
        vec4 _826 = vx_correct_after_downsampling(param_6);
        cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u] = _826;
        vec4 param_7 = cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u];
        vec4 _849 = vx_correct_after_downsampling(param_7);
        cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u] = _849;
        vec3 param_8 = cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u].xyz;
        uint _870 = color_convert_rgb_rgb9e5(param_8);
        imageStore(imTarget2Color, ivec3(grid_pos / uvec3(4u)), uvec4(_870));
        imageStore(imTarget2Occupancy, ivec3(grid_pos / uvec3(4u)), cube_samples_mip1[gl_LocalInvocationID.z + 0u][gl_LocalInvocationID.y + 0u][gl_LocalInvocationID.x + 0u].wwww);
    }
}

 