#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
#extension GL_EXT_shader_16bit_storage : require
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
#extension GL_KHR_shader_subgroup_ballot : require
#extension GL_EXT_fragment_shading_rate : require
layout(early_fragment_tests) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
};

struct ray_state_user_data
{
    uint primitiveId;
};

struct ray_traversal_params
{
    float trace_range_primary;
    float trace_range_secondary;
};

struct ray_state
{
    vec3 color;
    vec3 normal;
    vec3 dir;
    vec3 origin;
    float transparency;
    int16_t bounces;
    int16_t material;
    int tests;
    int face_tests;
    uint flags;
    uint active_threads_factor;
    uint active_threads_samples;
    float final_color_factor;
    ray_state_user_data user_data;
};

struct RTSetup
{
    mat4 mat_projection;
    mat4 mat_model;
    vec3 camera_position;
    int screen_sampling_scale;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 frustum_shift;
    vec2 resolution;
    uint64_t buff_grid_markers_ptr;
    float trace_range_primary;
    float trace_range_secondary;
    float roughness_clamp;
    float env_map_intensity;
    int lights_num;
    float initial_face_start_distance;
    uint material_flags;
    int reflect_rays;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _2207
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 1, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _573;

layout(set = 1, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _626;

layout(set = 1, binding = 3, std430) readonly buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _1003;

layout(set = 1, binding = 4, std430) readonly buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint occupied_cell_counter;
    uint _pad0;
    uint _pad1;
    uint _pad2;
    uint _pad3;
    uint _pad4;
    uint _pad5;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 1, binding = 5, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 7, std140) uniform RTSetupBuffer
{
    layout(row_major) RTSetup rt_setup;
} _1804;

layout(set = 1, binding = 8, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1950;

layout(set = 1, binding = 6, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 9, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _2217;

layout(set = 1, binding = 12) uniform usampler3D s_grid_marker;
layout(set = 1, binding = 13) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 10, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 14) uniform sampler2D sTextureDepth;
layout(set = 1, binding = 11, r32ui) uniform readonly uimage2D imNormalMaterial;

layout(location = 0) out vec4 outHitDirectionPrimitiveID;
layout(location = 1) in _2207 vtx_input;
layout(location = 1) out vec4 outDebug;
uint64_t g_buff_grid_markers_ptr;

float asfloat(uint v)
{
    return uintBitsToFloat(v);
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

float linearizeDepth(float d)
{
    return _1804.rt_setup.near_far_plane.z / ((_1804.rt_setup.near_far_plane.y + _1804.rt_setup.near_far_plane.x) - (d * _1804.rt_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _296;
    if (nor.x > 0.0)
    {
        _296 = -t;
    }
    else
    {
        _296 = t;
    }
    nor.x += _296;
    float _311;
    if (nor.y > 0.0)
    {
        _311 = -t;
    }
    else
    {
        _311 = t;
    }
    nor.y += _311;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

uint rt_set_mask(inout uint f, uint m)
{
    uint _743 = f;
    uint _744 = _743 | m;
    f = _744;
    return _744;
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 rt_randomize_dir_for_roughness(inout ivec2 screen_pos, inout vec3 dir, vec3 n, inout float roughness, inout float bounce_throughput)
{
    bounce_throughput = 1.0;
    if (roughness > 0.0)
    {
        roughness = min(_1804.rt_setup.roughness_clamp, roughness);
        roughness = dot(dir, n) * roughness;
        bounce_throughput *= max(0.0, 1.0 - roughness);
        int frame = _1950.globals.monotonic & 127;
        float clamped_roughness = roughness * roughness;
        screen_pos &= ivec2(127);
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, 0), 0).xy;
        vec2 hash = fract(_noise + vec2(float(frame) * 1.61803400516510009765625));
        float param = hash.x * clamped_roughness;
        float param_1 = hash.y;
        vec3 d = CosineSampleHemisphere(param, param_1);
        vec3 param_2 = dir;
        mat3 _1999 = matrixFromVector(param_2);
        mat3 vecSpace = _1999;
        d = vecSpace * d;
        float VdotN = dot(d, n);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * clamped_roughness;
            float param_4 = hash.y;
            d = CosineSampleHemisphere(param_3, param_4);
            d = vecSpace * d;
            VdotN = dot(d, n);
            if (VdotN > 0.0)
            {
                dir = d;
            }
        }
        else
        {
            dir = d;
        }
    }
    return dir;
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(v, n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

uint rt_clear_mask(inout uint f, uint m)
{
    uint _758 = f;
    uint _759 = _758 & (~m);
    f = _759;
    return _759;
}

uint ballot_count(bool v)
{
    uvec4 ballot = subgroupBallot(v);
    uint cnt = uint(bitCount(ballot.x));
    cnt += uint(bitCount(ballot.y));
    return cnt;
}

uint rt_clear_mask_if(inout uint f, uint m, bool v)
{
    if (v)
    {
        f &= (~m);
    }
    return f;
}

bool rt_is_mask_set(uint f, uint mask)
{
    return (f & mask) != 0u;
}

uint rt_set_mask_if(inout uint f, uint m, bool v)
{
    if (v)
    {
        f |= m;
    }
    return f;
}

bool is_pos_inside_grid(ivec3 icell)
{
    int icell_mask = (icell.x | icell.y) | icell.z;
    if ((icell_mask & (-256)) == 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

void rt_pack_grid_marker_to_uint_img(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

bool rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint_img(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u) ? true : false;
}

bool rt_read_grid_marker_low_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint_img(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 2).x & uint(1 << int(bit))) != 0u) ? true : false;
}

bool fetch_grid_marker_for_cell(ivec3 icell, int mip)
{
    if (mip == 0)
    {
        ivec3 param = icell;
        return rt_read_grid_marker_high_res(s_grid_marker, param);
    }
    else
    {
        ivec3 param_1 = icell >> ivec3(2);
        return rt_read_grid_marker_low_res(s_grid_marker, param_1);
    }
}

ivec3 dda_step_from_dir(vec3 dir, vec3 cell_step)
{
    vec3 s;
    s.x = (dir.x > 0.0) ? 1.0 : (-1.0);
    s.y = (dir.y > 0.0) ? 1.0 : (-1.0);
    s.z = (dir.z > 0.0) ? 1.0 : (-1.0);
    vec3 sgn = s * cell_step;
    return ivec3(sgn);
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _626.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _626.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _626.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_573.in_vtx_data[coord_offset + 0u], _573.in_vtx_data[coord_offset + 1u], _573.in_vtx_data[coord_offset + 2u]);
    return p;
}

intersection intersectTriangle3(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        return it;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        return it;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _937 = v < 0.0;
    bool _945;
    if (!_937)
    {
        _945 = (u + v) > 1.0;
    }
    else
    {
        _945 = _937;
    }
    if (_945)
    {
        return it;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = vec3(normalize(cross(e2, e1)));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

void findClosestBucket2(ray_state_user_data user_data, uint list_index, bool bucket_full, uint max_tests, vec3 origin, vec3 dir, int skip_fi, float max_t, inout int closest_fi, inout uint material_flags, inout float closest_it, inout vec3 closest_norm, inout vec2 closest_bc, out int face_tests)
{
    face_tests = 0;
    closest_fi = -1;
    closest_it = max_t;
    uint head = _1003.in_faces_list_tails_data[list_index];
    uint cnt = in_faces_list_data.node_buffer[head];
    if ((max_tests != 4294967295u) && (cnt >= max_tests))
    {
        closest_fi = -1;
        return;
    }
    face_tests = int(cnt);
    for (int fi_idx = 0; uint(fi_idx) < cnt; fi_idx++)
    {
        int fi = int(in_faces_list_data.node_buffer[(head + uint(fi_idx)) + 1u]);
        if (fi == skip_fi)
        {
            continue;
        }
        uint param = uint(fi);
        RTFace rt_face = rt_get_face(param);
        uint param_1 = rt_face.v0;
        vec3 p0 = rt_get_vertex(param_1);
        uint param_2 = rt_face.v1;
        vec3 p1 = rt_get_vertex(param_2);
        uint param_3 = rt_face.v2;
        vec3 p2 = rt_get_vertex(param_3);
        vec3 param_4 = origin;
        vec3 param_5 = dir;
        vec3 param_6 = p2;
        vec3 param_7 = p1;
        vec3 param_8 = p0;
        intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
        bool _1086 = it1.t >= 0.0;
        bool _1093;
        if (_1086)
        {
            _1093 = it1.t <= closest_it;
        }
        else
        {
            _1093 = _1086;
        }
        if (_1093)
        {
            if ((rt_face.material_flags & 64u) == 0u)
            {
                if (dot(dir, it1.normal) >= 0.0)
                {
                    continue;
                }
            }
            closest_fi = fi;
            closest_it = it1.t;
        }
    }
    if (closest_fi != (-1))
    {
        uint param_9 = uint(closest_fi);
        RTFace rt_face_1 = rt_get_face(param_9);
        uint param_10 = rt_face_1.v0;
        vec3 p0_1 = rt_get_vertex(param_10);
        uint param_11 = rt_face_1.v1;
        vec3 p1_1 = rt_get_vertex(param_11);
        uint param_12 = rt_face_1.v2;
        vec3 p2_1 = rt_get_vertex(param_12);
        vec3 param_13 = origin;
        vec3 param_14 = dir;
        vec3 param_15 = p2_1;
        vec3 param_16 = p1_1;
        vec3 param_17 = p0_1;
        intersection it1_1 = intersectTriangle3(param_13, param_14, param_15, param_16, param_17);
        closest_norm = it1_1.normal;
        closest_bc = it1_1.bc;
        material_flags = rt_face_1.material_flags;
    }
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint param = uint(idx);
    RTFace rt_face = rt_get_face(param);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_1 = p0_idx;
    vec3 a = rt_get_vertex(param_1);
    uint param_2 = p1_idx;
    vec3 b = rt_get_vertex(param_2);
    uint param_3 = p2_idx;
    vec3 c = rt_get_vertex(param_3);
    vec3 param_4 = p;
    vec3 param_5 = a;
    vec3 param_6 = b;
    vec3 param_7 = c;
    return vec2(rt_barycentric_yz(param_4, param_5, param_6, param_7));
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _573.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _573.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec3 n0 = vec3(rt_get_vertex_normal(param_1));
    uint param_2 = i1;
    vec3 n1 = vec3(rt_get_vertex_normal(param_2));
    uint param_3 = i2;
    vec3 n2 = vec3(rt_get_vertex_normal(param_3));
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return vec3(normalize(smooth_normal));
}

void evaluate_material(inout ray_state state, vec3 prev_state_origin, int hit_face, uint hit_material_flags, vec2 bc, bool flip_normal_on_glass)
{
    state.user_data.primitiveId = uint(hit_face);
    uint param = state.flags;
    uint param_1 = 32u;
    uint _1919 = rt_clear_mask(param, param_1);
    state.flags = _1919;
    uint param_2 = state.flags;
    uint param_3 = 4u;
    uint _1926 = rt_set_mask(param_2, param_3);
    state.flags = _1926;
}

int findClosestDDAMultibounce(ray_traversal_params traversal_params, inout ray_state state, inout int skip_fi, inout int closest_fi, inout float closest_it, int max_bounces)
{
    closest_fi = -1;
    closest_it = 1000000.0;
    vec3 cellDimension = in_bbox_data.grid_size_raytrace.xyz;
    vec3 cellDimensionRecip = in_bbox_data.grid_size_raytrace_recip.xyz;
    float tmin = 0.0;
    float tmax = traversal_params.trace_range_primary;
    vec3 ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro_cell * cellDimensionRecip));
    vec3 s = step(vec3(0.0), state.dir);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 deltaT = (sgn * cellDimension) / state.dir;
    vec3 nextCrossingT = vec3(tmin) + ((((floor(ro_cell * cellDimensionRecip) + s) * cellDimension) - ro_cell) / state.dir);
    uint traversal_flags = 0u;
    int max_iter = 1024;
    bool param = true;
    int threads_running = int(ballot_count(param));
    int param_42;
    uint param_43;
    float param_44;
    vec3 param_45;
    vec2 param_46;
    int param_47;
    for (;;)
    {
        bool hit = false;
        max_iter--;
        state.tests++;
        float rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
        uint param_1 = state.flags;
        uint param_2 = 32u;
        bool param_3 = rt >= tmax;
        uint _1339 = rt_clear_mask_if(param_1, param_2, param_3);
        state.flags = _1339;
        uint param_4 = state.flags;
        uint param_5 = 32u;
        bool param_6 = max_iter < 0;
        uint _1348 = rt_clear_mask_if(param_4, param_5, param_6);
        state.flags = _1348;
        uint param_7 = state.flags;
        uint param_8 = 32u;
        if (rt_is_mask_set(param_7, param_8) == false)
        {
            break;
        }
        uint param_9 = traversal_flags;
        uint param_10 = 1u;
        uint param_11 = traversal_flags;
        uint param_12 = 2u;
        bool param_13 = rt_is_mask_set(param_9, param_10);
        uint _1367 = rt_set_mask_if(param_11, param_12, param_13);
        traversal_flags = _1367;
        uint param_14 = traversal_flags;
        uint param_15 = 1u;
        uint _1371 = rt_clear_mask(param_14, param_15);
        traversal_flags = _1371;
        bool search_bucket = false;
        bool bucket_full = false;
        ivec3 param_16 = icell;
        if (is_pos_inside_grid(param_16))
        {
            uint param_17 = traversal_flags;
            uint param_18 = 1u;
            uint _1382 = rt_set_mask(param_17, param_18);
            traversal_flags = _1382;
            ivec3 param_19 = icell;
            int param_20 = 0;
            bucket_full = fetch_grid_marker_for_cell(param_19, param_20);
        }
        if (true)
        {
            bool _1403;
            if (!bucket_full)
            {
                bool _1396 = (traversal_flags & 1u) != 0u;
                bool _1402;
                if (_1396)
                {
                    _1402 = (traversal_flags & 2u) == 0u;
                }
                else
                {
                    _1402 = _1396;
                }
                _1403 = _1402;
            }
            else
            {
                _1403 = bucket_full;
            }
            bool done_criteria = _1403;
            bool param_21 = done_criteria;
            uint hit_threads = ballot_count(param_21);
            int ii = 0;
            while ((hit_threads < 16u) && (ii < 4))
            {
                ii++;
                if (done_criteria == false)
                {
                    state.tests++;
                    max_iter--;
                    vec3 mm = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
                    vec3 param_22 = state.dir;
                    vec3 param_23 = mm;
                    icell += dda_step_from_dir(param_22, param_23);
                    nextCrossingT += (mm * deltaT);
                    uint param_24 = traversal_flags;
                    uint param_25 = 1u;
                    uint _1457 = rt_clear_mask(param_24, param_25);
                    traversal_flags = _1457;
                    ivec3 param_26 = icell;
                    if (is_pos_inside_grid(param_26))
                    {
                        uint param_27 = traversal_flags;
                        uint param_28 = 3u;
                        uint _1466 = rt_set_mask(param_27, param_28);
                        traversal_flags = _1466;
                    }
                    uint param_29 = traversal_flags;
                    uint param_30 = 1u;
                    if (rt_is_mask_set(param_29, param_30))
                    {
                        ivec3 param_31 = icell;
                        int param_32 = 0;
                        bucket_full = fetch_grid_marker_for_cell(param_31, param_32);
                    }
                    bool _1490;
                    if (!bucket_full)
                    {
                        bool _1483 = (traversal_flags & 2u) != 0u;
                        bool _1489;
                        if (_1483)
                        {
                            _1489 = (traversal_flags & 1u) == 0u;
                        }
                        else
                        {
                            _1489 = _1483;
                        }
                        _1490 = _1489;
                    }
                    else
                    {
                        _1490 = bucket_full;
                    }
                    done_criteria = _1490;
                }
            }
        }
        if (bucket_full)
        {
            uint icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
            bool param_33 = true;
            state.active_threads_factor += ballot_count(param_33);
            state.active_threads_samples++;
            int face_tests = 0;
            uint max_tests = 4294967295u;
            bool _1523 = closest_fi == (-1);
            bool _1530;
            if (_1523)
            {
                _1530 = state.face_tests > 512;
            }
            else
            {
                _1530 = _1523;
            }
            if (_1530)
            {
                max_tests = 256u;
            }
            float rt_1 = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
            ray_state_user_data param_34 = state.user_data;
            uint param_35 = icell_idx;
            bool param_36 = bucket_full;
            uint param_37 = max_tests;
            vec3 param_38 = state.origin;
            vec3 param_39 = state.dir;
            int param_40 = skip_fi;
            float param_41 = min(tmax, rt_1);
            findClosestBucket2(param_34, param_35, param_36, param_37, param_38, param_39, param_40, param_41, param_42, param_43, param_44, param_45, param_46, param_47);
            state.user_data = param_34;
            closest_fi = param_42;
            uint closest_material_flags = param_43;
            closest_it = param_44;
            vec3 closest_normal = param_45;
            vec2 closest_bc = param_46;
            face_tests = param_47;
            state.face_tests += face_tests;
            if (closest_fi != (-1))
            {
                state.bounces += 1s;
                state.normal = closest_normal;
                hit = true;
                skip_fi = closest_fi;
                bool _1608 = int(state.bounces) >= max_bounces;
                bool _1616;
                if (!_1608)
                {
                    _1616 = (closest_material_flags & 2048u) != 0u;
                }
                else
                {
                    _1616 = _1608;
                }
                if (_1616)
                {
                    uint param_48 = state.flags;
                    uint param_49 = 32u;
                    uint _1623 = rt_clear_mask(param_48, param_49);
                    state.flags = _1623;
                }
                int param_50 = closest_fi;
                vec3 param_51 = state.origin + (state.dir * closest_it);
                vec2 bc = barycentric_for_face_yz(param_50, param_51);
                if ((closest_material_flags & 128u) == 0u)
                {
                    int param_52 = closest_fi;
                    vec2 param_53 = bc;
                    vec3 param_54 = state.normal;
                    state.normal = interpolate_normal_from_bc_yz(param_52, param_53, param_54);
                }
                bool flip_normal_on_glass = false;
                if ((closest_material_flags & 32u) != 0u)
                {
                    flip_normal_on_glass = (dot(state.normal, state.dir) > 0.0) ? true : false;
                }
                vec3 prev_state_origin = state.origin;
                state.origin += (state.dir * closest_it);
                ray_state param_55 = state;
                vec3 param_56 = prev_state_origin;
                int param_57 = closest_fi;
                uint param_58 = closest_material_flags;
                vec2 param_59 = bc;
                bool param_60 = flip_normal_on_glass;
                evaluate_material(param_55, param_56, param_57, param_58, param_59, param_60);
                state = param_55;
                if (max_bounces > 1)
                {
                    vec3 ird = vec3(1.0) / state.dir;
                    ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
                    vec3 s_1 = step(vec3(0.0), state.dir);
                    vec3 sgn_1 = (s_1 * 2.0) - vec3(1.0);
                    deltaT = (sgn_1 * cellDimension) * ird;
                    nextCrossingT = vec3(tmin) + ((((floor(ro_cell * cellDimensionRecip) + s_1) * cellDimension) - ro_cell) * ird);
                    tmax = traversal_params.trace_range_secondary;
                    rt_1 = tmin;
                }
            }
        }
        uint param_61 = traversal_flags;
        uint param_62 = 1u;
        bool _1741 = rt_is_mask_set(param_61, param_62) == false;
        bool _1749;
        if (_1741)
        {
            uint param_63 = traversal_flags;
            uint param_64 = 2u;
            _1749 = rt_is_mask_set(param_63, param_64) == true;
        }
        else
        {
            _1749 = _1741;
        }
        if (_1749)
        {
            uint param_65 = state.flags;
            uint param_66 = 32u;
            uint _1756 = rt_clear_mask(param_65, param_66);
            state.flags = _1756;
            uint param_67 = state.flags;
            uint param_68 = 64u;
            uint _1762 = rt_set_mask(param_67, param_68);
            state.flags = _1762;
            uint param_69 = state.flags;
            uint param_70 = 8u;
            uint _1769 = rt_set_mask(param_69, param_70);
            state.flags = _1769;
        }
        if (!hit)
        {
            vec3 mm_1 = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
            vec3 param_71 = state.dir;
            vec3 param_72 = mm_1;
            icell += dda_step_from_dir(param_71, param_72);
            nextCrossingT += (mm_1 * deltaT);
        }
        continue;
    }
    return 0;
}

vec3 TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void main()
{
    g_buff_grid_markers_ptr = 0ul;
    uint param = 4294967295u;
    outHitDirectionPrimitiveID = vec4(0.0, 0.0, 0.0, asfloat(param));
    g_buff_grid_markers_ptr = _1804.rt_setup.buff_grid_markers_ptr;
    vec2 frag_offset_for_vrs = vec2(0.0);
    bool is_vrs_used_for_a_quad = gl_ShadingRateEXT != 0;
    if (is_vrs_used_for_a_quad)
    {
        ivec2 pos00 = ivec2(gl_FragCoord.xy);
        uvec4 param_1 = imageLoad(imMetalnessRoughnessMaterialTags, pos00);
        MetalnessRoughnessMeterialTags mrmt = decode_metalness_roughness_material_tags(param_1);
        if ((materials.material_properties[mrmt.material_index].flags & _1804.rt_setup.material_flags) == 0u)
        {
            pos00 &= ivec2(-2);
            uvec4 param_2 = imageLoad(imMetalnessRoughnessMaterialTags, ivec2(pos00) + ivec2(0));
            MetalnessRoughnessMeterialTags mrmt00 = decode_metalness_roughness_material_tags(param_2);
            uvec4 param_3 = imageLoad(imMetalnessRoughnessMaterialTags, ivec2(pos00) + ivec2(1, 0));
            MetalnessRoughnessMeterialTags mrmt10 = decode_metalness_roughness_material_tags(param_3);
            uvec4 param_4 = imageLoad(imMetalnessRoughnessMaterialTags, ivec2(pos00) + ivec2(0, 1));
            MetalnessRoughnessMeterialTags mrmt01 = decode_metalness_roughness_material_tags(param_4);
            uvec4 param_5 = imageLoad(imMetalnessRoughnessMaterialTags, ivec2(pos00) + ivec2(1));
            MetalnessRoughnessMeterialTags mrmt11 = decode_metalness_roughness_material_tags(param_5);
            if ((materials.material_properties[mrmt00.material_index].flags & _1804.rt_setup.material_flags) != 0u)
            {
                frag_offset_for_vrs = vec2(-0.5);
            }
            if ((materials.material_properties[mrmt10.material_index].flags & _1804.rt_setup.material_flags) != 0u)
            {
                frag_offset_for_vrs = vec2(0.5, -0.5);
            }
            if ((materials.material_properties[mrmt01.material_index].flags & _1804.rt_setup.material_flags) != 0u)
            {
                frag_offset_for_vrs = vec2(-0.5, 0.5);
            }
            if ((materials.material_properties[mrmt11.material_index].flags & _1804.rt_setup.material_flags) != 0u)
            {
                frag_offset_for_vrs = vec2(0.5);
            }
        }
    }
    ivec2 scaled_sample_pos = ivec2(gl_FragCoord.xy + frag_offset_for_vrs) * ivec2(_1804.rt_setup.screen_sampling_scale);
    ivec2 native_sample_pos = ivec2(gl_FragCoord.xy + frag_offset_for_vrs);
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos;
    vec3 dir = -normalize(_2217.transform_params.vCameraPosition - worldPos);
    vec3 origin = _2217.transform_params.vCameraPosition;
    int closest_fi = -1;
    int16_t material = 0s;
    uvec4 param_6 = imageLoad(imMetalnessRoughnessMaterialTags, scaled_sample_pos);
    MetalnessRoughnessMeterialTags mrmt_1 = decode_metalness_roughness_material_tags(param_6);
    material = int16_t(uint16_t(mrmt_1.material_index));
    vec2 vd_pos = vec2(scaled_sample_pos) - ((_1804.rt_setup.frustum_shift * _1804.rt_setup.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_1804.rt_setup.camera_projection_params.z) + ((_1804.rt_setup.camera_projection_params.x * vd_pos.x) / _1804.rt_setup.resolution.x);
    view_direction.y = (-_1804.rt_setup.camera_projection_params.w) + ((_1804.rt_setup.camera_projection_params.y * vd_pos.y) / _1804.rt_setup.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float param_7 = texelFetch(sTextureDepth, native_sample_pos, 0).x;
    float depth = linearizeDepth(param_7);
    vec3 param_8 = view_direction;
    float param_9 = depth;
    vec3 view_coords = positionFromDepth(param_8, param_9);
    view_coords = (_1804.rt_setup.mat_model * vec4(view_coords, 1.0)).xyz;
    dir = -normalize(_2217.transform_params.vCameraPosition - view_coords);
    float closest_it = length(origin - view_coords);
    uint encoded_normal_material = imageLoad(imNormalMaterial, scaled_sample_pos).x;
    uint param_10 = encoded_normal_material;
    vec3 _2337 = decode_normal(param_10);
    vec3 normal = normalize(_2337);
    vec3 worldNorm = normal;
    vec3 ro = (origin + (dir * closest_it)) - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro * in_bbox_data.grid_size_raytrace_recip.xyz));
    bool _2361 = icell.x >= 0;
    bool _2367;
    if (_2361)
    {
        _2367 = icell.y >= 0;
    }
    else
    {
        _2367 = _2361;
    }
    bool _2373;
    if (_2367)
    {
        _2373 = icell.z >= 0;
    }
    else
    {
        _2373 = _2367;
    }
    bool _2379;
    if (_2373)
    {
        _2379 = icell.x < 256;
    }
    else
    {
        _2379 = _2373;
    }
    bool _2385;
    if (_2379)
    {
        _2385 = icell.y < 256;
    }
    else
    {
        _2385 = _2379;
    }
    bool _2391;
    if (_2385)
    {
        _2391 = icell.z < 256;
    }
    else
    {
        _2391 = _2385;
    }
    if (_2391)
    {
        uint icell_idx = uint(((icell.z * 65536) + (icell.y * 256)) + icell.x);
    }
    origin += (dir * closest_it);
    ray_traversal_params traversal_params;
    traversal_params.trace_range_primary = _1804.rt_setup.trace_range_primary;
    traversal_params.trace_range_secondary = _1804.rt_setup.trace_range_secondary;
    ray_state state;
    state.normal = normal;
    state.material = material;
    state.dir = dir;
    state.origin = origin;
    state.bounces = 1s;
    state.tests = 0;
    state.face_tests = 0;
    state.active_threads_factor = 0u;
    state.active_threads_samples = 0u;
    state.final_color_factor = 1.0;
    state.flags = 0u;
    uint param_11 = state.flags;
    uint param_12 = 32u;
    uint _2439 = rt_set_mask(param_11, param_12);
    state.flags = _2439;
    bool _2446 = int(gl_FragCoord.x) == 547;
    bool _2454;
    if (_2446)
    {
        _2454 = int(gl_FragCoord.y) == 649;
    }
    else
    {
        _2454 = _2446;
    }
    if (_2454)
    {
        uint param_13 = state.flags;
        uint param_14 = 128u;
        uint _2461 = rt_set_mask(param_13, param_14);
        state.flags = _2461;
    }
    bool pre_step_along_ray = false;
    bool pre_step_along_normal = !pre_step_along_ray;
    if (pre_step_along_normal)
    {
        if (_1804.rt_setup.reflect_rays != 0)
        {
            state.origin += (vec3(normal) * _1804.rt_setup.initial_face_start_distance);
        }
        else
        {
            state.origin += (vec3(-normal) * _1804.rt_setup.initial_face_start_distance);
        }
    }
    if (_1804.rt_setup.reflect_rays != 0)
    {
        state.dir = reflect(state.dir, vec3(state.normal));
        ivec2 param_15 = ivec2(native_sample_pos);
        vec3 param_16 = state.dir;
        vec3 param_17 = state.normal;
        float param_18 = mrmt_1.roughness;
        float param_19;
        vec3 _2533 = rt_randomize_dir_for_roughness(param_15, param_16, param_17, param_18, param_19);
        state.final_color_factor = param_19;
        state.dir = _2533;
        if (state.final_color_factor <= 0.0)
        {
            return;
        }
    }
    else
    {
        vec3 param_20 = state.dir;
        vec3 param_21 = -state.normal;
        state.dir = glass_refract(param_20, param_21);
        uint param_22 = state.flags;
        uint param_23 = 16u;
        uint _2557 = rt_set_mask(param_22, param_23);
        state.flags = _2557;
    }
    dir = state.dir;
    if (pre_step_along_ray)
    {
        state.origin += (state.dir * _1804.rt_setup.initial_face_start_distance);
    }
    bool _2575 = gl_HelperInvocation;
    if (_2575)
    {
        uint param_24 = state.flags;
        uint param_25 = 32u;
        uint _2582 = rt_clear_mask(param_24, param_25);
        state.flags = _2582;
    }
    ray_traversal_params param_26 = traversal_params;
    ray_state param_27 = state;
    int param_28 = closest_fi;
    int param_31 = 1;
    int param_29;
    float param_30;
    int _2593 = findClosestDDAMultibounce(param_26, param_27, param_28, param_29, param_30, param_31);
    state = param_27;
    closest_fi = param_29;
    closest_it = param_30;
    outDebug.x = 0.0;
    outDebug.y = 0.0;
    outDebug.z = 0.0;
    outDebug.x = 0.0;
    outDebug.y = 0.0;
    outDebug.z = 0.0;
    if (state.face_tests > 4096)
    {
        float param_32 = min(1.0, float(state.tests - 4096) / 1024.0);
        vec3 _2625 = TurboColormap(param_32);
        outDebug.x = _2625.x;
        outDebug.y = _2625.y;
        outDebug.z = _2625.z;
    }
    uint hitPrimitiveId = 4294967295u;
    uint param_33 = state.flags;
    uint param_34 = 4u;
    if (rt_is_mask_set(param_33, param_34))
    {
        hitPrimitiveId = state.user_data.primitiveId;
        float param_35 = fract(float(state.user_data.primitiveId) / 512.0);
        vec3 _2649 = TurboColormap(param_35);
        outDebug.x = _2649.x;
        outDebug.y = _2649.y;
        outDebug.z = _2649.z;
    }
    uint param_36 = hitPrimitiveId;
    outHitDirectionPrimitiveID = vec4(state.dir, asfloat(param_36));
}

 