#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleRibbonSegmentInfo
{
    uint segments;
    uint first;
    uint previous;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx_;
    int base_segment_;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int segment_subdivisions;
    int export_ribbon_t_as_modifier_factor;
    int export_segment_t_as_modifier_factor;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segment_info;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _247;

layout(set = 0, binding = 4, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _305;

layout(set = 0, binding = 2, std430) restrict readonly buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) restrict readonly buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _657;

ParticleRibbonSegmentInfo ribbon_decode_segment_info(uint segment_info)
{
    ParticleRibbonSegmentInfo si;
    si.segments = segment_info & 65535u;
    si.first = segment_info >> uint(16);
    si.previous = si.first - 1u;
    if (si.first == 0u)
    {
        si.previous = uint(_305.ribbon_render_params.max_segments - 1);
    }
    return si;
}

uint get_ribbon_segments(uint ribbon_id)
{
    uint param = prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param);
    int s = max(0, (min(_305.ribbon_render_params.max_segments, int(ribbon_si.segments)) - 1));
    return uint(max(1, s));
}

bool prt_is_alive(uint id)
{
    return _247.prt_states[id].life_time < _247.prt_states[id].life_span;
}

float compute_t_from_subsegment(int sub_segment_idx)
{
    return float(sub_segment_idx) / float(_305.ribbon_render_params.segment_subdivisions);
}

int calculate_vidx_for_ribbon_segment(uint ribbon_id, inout int ribbon_segment)
{
    uint param = prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param);
    ribbon_segment = int(ribbon_si.first) - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _305.ribbon_render_params.max_segments;
    }
    int vidx = (ribbon_segment * _305.ribbon_render_params.particles_per_segment) + int(ribbon_id);
    return vidx;
}

vec3 ribbon_get_coords_for_vidx(int vidx)
{
    return vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
}

vec3 catmull_rom(vec3 p0, vec3 p1, vec3 p2, vec3 p3, float t)
{
    float t2 = t * t;
    float t3 = t2 * t;
    return ((((p1 * 2.0) + (((-p0) + p2) * t)) + (((((p0 * 2.0) - (p1 * 5.0)) + (p2 * 4.0)) - p3) * t2)) + (((((-p0) + (p1 * 3.0)) - (p2 * 3.0)) + p3) * t3)) * 0.5;
}

vec3 ribbon_get_coords_for_t_spline(uint ribbon_idx, uint segment_idx, float t)
{
    uint param = ribbon_idx;
    int control_points_num = int(get_ribbon_segments(param)) + 1;
    int s1 = int(segment_idx);
    int s2 = min((s1 + 1), (control_points_num - 1));
    int s0 = max((s1 - 1), 0);
    int s3 = min((s2 + 1), (control_points_num - 1));
    uint param_1 = ribbon_idx;
    int param_2 = s0;
    int _473 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx0 = _473;
    uint param_3 = ribbon_idx;
    int param_4 = s1;
    int _479 = calculate_vidx_for_ribbon_segment(param_3, param_4);
    int vidx1 = _479;
    uint param_5 = ribbon_idx;
    int param_6 = s2;
    int _485 = calculate_vidx_for_ribbon_segment(param_5, param_6);
    int vidx2 = _485;
    uint param_7 = ribbon_idx;
    int param_8 = s3;
    int _491 = calculate_vidx_for_ribbon_segment(param_7, param_8);
    int vidx3 = _491;
    int param_9 = vidx0;
    vec3 p0 = ribbon_get_coords_for_vidx(param_9);
    int param_10 = vidx1;
    vec3 p1 = ribbon_get_coords_for_vidx(param_10);
    int param_11 = vidx2;
    vec3 p2 = ribbon_get_coords_for_vidx(param_11);
    int param_12 = vidx3;
    vec3 p3 = ribbon_get_coords_for_vidx(param_12);
    if (s0 == s1)
    {
        p0 = p1 - (p2 - p1);
    }
    if (s3 == s2)
    {
        p3 = p2 + (p2 - p1);
    }
    if (false)
    {
        float d = length(p1 - p0);
        p0 = p1 - (normalize(p1 - p0) * d);
        p3 = p2 + (normalize(p3 - p2) * d);
    }
    vec3 param_13 = p0;
    vec3 param_14 = p1;
    vec3 param_15 = p2;
    vec3 param_16 = p3;
    float param_17 = t;
    return catmull_rom(param_13, param_14, param_15, param_16, param_17);
}

vec3 ribbon_get_coords_for_segment_t(uint ribbon_id, int segment_idx, float t)
{
    uint param = ribbon_id;
    uint param_1 = uint(segment_idx);
    float param_2 = t;
    return ribbon_get_coords_for_t_spline(param, param_1, param_2);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _247.prt_states[id].color;
    vec3 _274 = color_convert_uint_to_float3(param);
    c.x = _274.x;
    c.y = _274.y;
    c.z = _274.z;
    return c;
}

float get_initial_modifier_factor(int ribbon_id, int segment_idx, int sub_segment_idx)
{
    float t = float(segment_idx) + (float(sub_segment_idx) / float(_305.ribbon_render_params.segment_subdivisions));
    if (segment_idx > 0)
    {
        t += (_305.ribbon_render_params.first_segment_time_factor - 1.0);
    }
    if (_305.ribbon_render_params.export_segment_t_as_modifier_factor != 0)
    {
        return t;
    }
    if (_305.ribbon_render_params.export_ribbon_t_as_modifier_factor != 0)
    {
        uint param = uint(ribbon_id);
        return t / float(get_ribbon_segments(param) * uint(_305.ribbon_render_params.segment_subdivisions));
    }
    return 1.0;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 apply_vtx_modifier(inout vec3 pos, vec3 norm, inout vec3 color, uint ribbon_id, float t)
{
    VertexInput vtx_input;
    vtx_input.id = ribbon_id;
    vtx_input.pos = pos;
    vtx_input.norm = norm;
    vtx_input.color = vec4(color, 1.0);
    vtx_input.uv0 = vec2(0.0);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = t;
    modifier_factor.hash = ribbon_id;
    modifier_factor.id = ribbon_id;
    modifier_factor.instance_id = ribbon_id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _657.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _657.transform_params.mModelInv;
    pos = vtx_input.pos;
    color = vtx_input.color.xyz;
    return pos;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _264;
    _264.life_time = _247.prt_states[id].life_time;
    _264.life_span = _247.prt_states[id].life_span;
    _264.generation_id = _247.prt_states[id].generation_id;
    _264.color = _247.prt_states[id].color;
    ParticleState _263 = _264;
    return _263;
}

float get_initial_modifier_factor_t(int ribbon_id, int segment_idx, inout float t)
{
    t = float(segment_idx) + t;
    if (_305.ribbon_render_params.export_segment_t_as_modifier_factor != 0)
    {
        return t;
    }
    if (_305.ribbon_render_params.export_ribbon_t_as_modifier_factor != 0)
    {
        uint param = uint(ribbon_id);
        return t / float(get_ribbon_segments(param) * uint(_305.ribbon_render_params.segment_subdivisions));
    }
    return 1.0;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 get_ribbon_transformed_segment_position_t(int ribbon_id, int segment_idx, float sub_segment_t)
{
    uint param = uint(ribbon_id);
    int param_1 = segment_idx;
    float param_2 = sub_segment_t;
    vec3 p = ribbon_get_coords_for_segment_t(param, param_1, param_2);
    vec3 dummy_normal = vec3(0.0);
    vec3 dummy_color = vec3(0.0);
    int param_3 = ribbon_id;
    int param_4 = segment_idx;
    float param_5 = sub_segment_t;
    float _771 = get_initial_modifier_factor_t(param_3, param_4, param_5);
    vec3 param_6 = p;
    vec3 param_7 = dummy_normal;
    vec3 param_8 = dummy_color;
    uint param_9 = uint(ribbon_id);
    float param_10 = _771;
    vec3 _780 = apply_vtx_modifier(param_6, param_7, param_8, param_9, param_10);
    dummy_color = param_8;
    vec3 modified_p = _780;
    vec3 param_11 = modified_p;
    mat4 param_12 = _657.transform_params.mModelView;
    vec3 _787 = vector_transform_by_mat43(param_11, param_12);
    return _787;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    int ribbon_sub_segment;
    if (_305.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        int n = gl_VertexIndex / 2;
        ribbon_segment = n / _305.ribbon_render_params.segment_subdivisions;
        ribbon_sub_segment = n - (ribbon_segment * _305.ribbon_render_params.segment_subdivisions);
    }
    else
    {
        uint max_segments_uint = uint(((_305.ribbon_render_params.max_segments - 1) * _305.ribbon_render_params.segment_subdivisions) + 1);
        uint n_1 = uint(gl_VertexIndex) / 2u;
        ribbon_id = (gl_InstanceIndex * 64) + int(n_1 / max_segments_uint);
        n_1 %= max_segments_uint;
        ribbon_segment = int(n_1 / uint(_305.ribbon_render_params.segment_subdivisions));
        ribbon_sub_segment = int(n_1 - uint(ribbon_segment * _305.ribbon_render_params.segment_subdivisions));
    }
    uint param = uint(ribbon_id);
    uint ribbon_segments = get_ribbon_segments(param);
    uint param_1 = uint(ribbon_id);
    bool _869 = !prt_is_alive(param_1);
    bool _877;
    if (!_869)
    {
        _877 = uint(ribbon_segment) > ribbon_segments;
    }
    else
    {
        _877 = _869;
    }
    bool _888;
    if (!_877)
    {
        _888 = (uint(ribbon_segment) == ribbon_segments) && (ribbon_sub_segment > 0);
    }
    else
    {
        _888 = _877;
    }
    if (_888 || (ribbon_segments <= 1u))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */));
        return;
    }
    if (ribbon_id == 24019)
    {
    }
    int param_2 = ribbon_sub_segment;
    uint param_3 = uint(ribbon_id);
    int param_4 = ribbon_segment;
    float param_5 = compute_t_from_subsegment(param_2);
    vec3 vInstPosition = ribbon_get_coords_for_segment_t(param_3, param_4, param_5);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_6 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_6);
    int param_7 = ribbon_id;
    int param_8 = ribbon_segment;
    int param_9 = ribbon_sub_segment;
    vec3 param_10 = vInstPosition;
    vec3 param_11 = vInstNormal;
    vec3 param_12 = vInstColor.xyz;
    uint param_13 = uint(ribbon_id);
    float param_14 = get_initial_modifier_factor(param_7, param_8, param_9);
    vec3 _944 = apply_vtx_modifier(param_10, param_11, param_12, param_13, param_14);
    vInstColor.x = param_12.x;
    vInstColor.y = param_12.y;
    vInstColor.z = param_12.z;
    vInstPosition = _944;
    uint param_15 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_15);
    bool is_last = (uint(ribbon_segment) == ribbon_segments) && (ribbon_sub_segment == 0);
    bool is_last_section = uint(ribbon_segment) >= (ribbon_segments - 1u);
    bool is_first_section = ribbon_segment == 0;
    bool _979 = uint(ribbon_segment) == (ribbon_segments - 1u);
    bool _987;
    if (_979)
    {
        _987 = ribbon_sub_segment == (_305.ribbon_render_params.segment_subdivisions - 1);
    }
    else
    {
        _987 = _979;
    }
    bool is_one_before_last = _987;
    bool is_first = (ribbon_segment == 0) && (ribbon_sub_segment == 0);
    bool is_full = ribbon_segments == uint(_305.ribbon_render_params.max_segments - 1);
    vec3 extrusion = vec3(0.0);
    vec3 modelview_cylinder_axis = vec3(0.0, 0.0, 1.0);
    int second_segment_offset = 0;
    int second_subsegment_offset = -1;
    bool swap_second_segment_direction = false;
    if ((ribbon_sub_segment == 0) && (second_subsegment_offset < 0))
    {
        second_segment_offset = -1;
        second_subsegment_offset = 0;
    }
    if ((ribbon_segment == 0) && (second_segment_offset < 0))
    {
        swap_second_segment_direction = true;
        second_subsegment_offset = 1;
        if (second_subsegment_offset >= _305.ribbon_render_params.segment_subdivisions)
        {
            second_subsegment_offset = 0;
            second_segment_offset = 1;
        }
    }
    if (true)
    {
        float ribbon_t;
        if (is_first_section)
        {
            ribbon_t = (float(ribbon_sub_segment) * _305.ribbon_render_params.first_segment_time_factor) / float(_305.ribbon_render_params.segment_subdivisions);
        }
        else
        {
            ribbon_t = float(ribbon_segment) + (float(ribbon_sub_segment) / float(_305.ribbon_render_params.segment_subdivisions));
            ribbon_t -= (1.0 - _305.ribbon_render_params.first_segment_time_factor);
        }
        float curve_mirror_point = ((float(ribbon_segments) - 0.5) + _305.ribbon_render_params.first_segment_time_factor) * 0.449999988079071044921875;
        if ((ribbon_segments > 3u) && (ribbon_t > curve_mirror_point))
        {
            ribbon_t = curve_mirror_point - ((ribbon_t - curve_mirror_point) * 0.75);
        }
        float shrink_factor = 1.0 - exp((-ribbon_t) * 2.0);
        float min_shrink_modifier = 0.0500000007450580596923828125;
        float t_shift = (1.0 / float(_305.ribbon_render_params.segment_subdivisions)) * 0.0500000007450580596923828125;
        int param_16 = ribbon_sub_segment;
        int param_17 = ribbon_id;
        int param_18 = ribbon_segment;
        float param_19 = compute_t_from_subsegment(param_16) - t_shift;
        vec3 currPosition = get_ribbon_transformed_segment_position_t(param_17, param_18, param_19);
        int param_20 = ribbon_sub_segment + second_subsegment_offset;
        int param_21 = ribbon_id;
        int param_22 = ribbon_segment + second_segment_offset;
        float param_23 = compute_t_from_subsegment(param_20) + t_shift;
        vec3 nextPosition = get_ribbon_transformed_segment_position_t(param_21, param_22, param_23);
        modelview_cylinder_axis = currPosition - nextPosition;
        SPIRV_CROSS_BRANCH
        if (length(modelview_cylinder_axis) <= 9.9999997473787516355514526367188e-05)
        {
            if (ribbon_segment > 1)
            {
                int param_24 = ribbon_id;
                int param_25 = ribbon_segment + second_segment_offset;
                float param_26 = float(ribbon_sub_segment + (second_subsegment_offset * 2));
                nextPosition = get_ribbon_transformed_segment_position_t(param_24, param_25, param_26);
                modelview_cylinder_axis = currPosition - nextPosition;
            }
        }
        modelview_cylinder_axis = normalize(modelview_cylinder_axis);
        vec2 dir2d = normalize(currPosition.xy - nextPosition.xy);
        if (swap_second_segment_direction)
        {
            modelview_cylinder_axis *= (-1.0);
            dir2d *= (-1.0);
        }
        dir2d = vec2(-dir2d.y, dir2d.x);
        vec3 dir = vec3(dir2d, 0.0);
        if ((uint(ribbon_segment) == ribbon_segments) && (ribbon_segments > 1u))
        {
        }
        SPIRV_CROSS_BRANCH
        if (is_full && is_last_section)
        {
            float t = _305.ribbon_render_params.first_segment_time_factor;
            uint param_27 = uint(ribbon_id);
            int param_28 = int(ribbon_segments - 1u);
            float param_29 = 0.0;
            vec3 prevInstPosition = ribbon_get_coords_for_segment_t(param_27, param_28, param_29);
            int param_30 = ribbon_id;
            int param_31 = ribbon_segment;
            int param_32 = ribbon_sub_segment;
            vec3 param_33 = prevInstPosition;
            vec3 param_34 = vInstNormal;
            vec3 param_35 = vInstColor.xyz;
            uint param_36 = uint(ribbon_id);
            float param_37 = get_initial_modifier_factor(param_30, param_31, param_32);
            vec3 _1226 = apply_vtx_modifier(param_33, param_34, param_35, param_36, param_37);
            vInstColor.x = param_35.x;
            vInstColor.y = param_35.y;
            vInstColor.z = param_35.z;
            prevInstPosition = _1226;
            vInstPosition = mix(vInstPosition, prevInstPosition, vec3(t));
        }
        dir *= max(min_shrink_modifier, shrink_factor);
        extrusion = dir * _305.ribbon_render_params.thickness;
    }
    if (ribbon_segment == 0)
    {
        modelview_cylinder_axis *= (-1.0);
    }
    uint param_38 = uint(ribbon_id);
    if (!prt_is_alive(param_38))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */), uintBitsToFloat(0x7fc00000u /* nan */), uintBitsToFloat(0x7fc00000u /* nan */), -1.0);
        return;
    }
    vec3 pos = vInstPosition;
    vec3 vPos1 = pos;
    vec3 param_39 = vPos1;
    mat4 param_40 = _657.transform_params.mModelView;
    vec3 _1274 = vector_transform_by_mat43(param_39, param_40);
    vec3 vPos = _1274;
    if (vPos.z > 1.0)
    {
        mat4 projection_no_jitter = _657.transform_params.mProjection;
        projection_no_jitter[2].x = 0.0;
        projection_no_jitter[2].y = 0.0;
        vec3 param_41 = vec3(extrusion.xy, vPos.z);
        mat4 param_42 = projection_no_jitter;
        vec4 _1296 = vector_transform_by_mat_projection(param_41, param_42);
        vec4 projected_extrusion = _1296;
        vec4 _1297 = projected_extrusion;
        float _1300 = projected_extrusion.w;
        vec3 _1302 = _1297.xyz / vec3(_1300);
        projected_extrusion.x = _1302.x;
        projected_extrusion.y = _1302.y;
        projected_extrusion.z = _1302.z;
        float min_extrusion_size = 0.0006500000017695128917694091796875;
        float projected_extrusion_size = length(projected_extrusion.xy);
        if (projected_extrusion_size > 0.0)
        {
            if (projected_extrusion_size < min_extrusion_size)
            {
                float scale = min_extrusion_size / projected_extrusion_size;
                extrusion *= scale;
            }
        }
    }
    float remaining_lifetime_based_extrusion_modifier = 1.0;
    float remaining_lifetime_margin = 0.20000000298023223876953125;
    if (vState.life_time > (vState.life_span - remaining_lifetime_margin))
    {
        remaining_lifetime_based_extrusion_modifier = vState.life_time - (vState.life_span - remaining_lifetime_margin);
        remaining_lifetime_based_extrusion_modifier /= (vState.life_span - remaining_lifetime_margin);
        remaining_lifetime_based_extrusion_modifier = 1.0 - remaining_lifetime_based_extrusion_modifier;
    }
    else
    {
        if (vState.life_time < remaining_lifetime_margin)
        {
            remaining_lifetime_based_extrusion_modifier = vState.life_time;
            remaining_lifetime_based_extrusion_modifier /= remaining_lifetime_margin;
            remaining_lifetime_based_extrusion_modifier = 1.0 - remaining_lifetime_based_extrusion_modifier;
        }
    }
    remaining_lifetime_based_extrusion_modifier = clamp(remaining_lifetime_based_extrusion_modifier, 0.0, 1.0);
    vPos += ((extrusion * remaining_lifetime_based_extrusion_modifier) * float(odd_even));
    vec3 param_43 = vPos;
    mat4 param_44 = _657.transform_params.mProjection;
    vec4 _1387 = vector_transform_by_mat_projection(param_43, param_44);
    gl_Position = _1387;
}

 