#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct PostDepthOfFieldParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    float far_plane;
    float debug_blur_size;
    float focus_depth;
    float focus_range;
    float adaptation_speed;
    int auto_focus;
    float auto_focus_area;
    int auto_focus_points;
    float auto_focus_bias;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct PostDepthOfFieldDynamicParams
{
    float focus_depth;
    float focus_range;
    int initialized;
    int _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform PostDepthOfFieldParamsBuffer
{
    PostDepthOfFieldParams dof_params;
} _25;

layout(set = 1, binding = 2, std140) uniform PostDepthOfFieldDynamicParamsBuffer
{
    PostDepthOfFieldDynamicParams dof_dynamic_params;
} _83;

layout(set = 1, binding = 3) uniform sampler2D sDepth;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

float linearizeDepth(float d)
{
    return _25.dof_params.near_far_plane.z / ((_25.dof_params.near_far_plane.y + _25.dof_params.near_far_plane.x) - (d * _25.dof_params.near_far_plane.w));
}

float getBlurSize(float depth, float focusPoint, float focusScale)
{
    float coc = clamp(((1.0 / focusPoint) - (1.0 / depth)) * focusScale, -1.0, 1.0);
    return abs(coc) * 20.0;
}

void main()
{
    float param = texture(sDepth, vTexcoord0).x;
    float depth = linearizeDepth(param);
    float param_1 = depth;
    float param_2 = _83.dof_dynamic_params.focus_depth;
    float param_3 = _83.dof_dynamic_params.focus_range;
    float coc = getBlurSize(param_1, param_2, param_3);
    outColor = vec4(coc, depth / _25.dof_params.far_plane, 0.0, 1.0);
}

 