#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _130;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _147;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _173;

layout(set = 0, binding = 4, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _244;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_173.prt_prev_positions[(id * 3u) + 0u], _173.prt_prev_positions[(id * 3u) + 1u], _173.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _136;
    _136.life_time = _130.prt_states[id].life_time;
    _136.life_span = _130.prt_states[id].life_span;
    _136.generation_id = _130.prt_states[id].generation_id;
    _136.color = _130.prt_states[id].color;
    ParticleState _135 = _136;
    return _135;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _143;
    _143.life_time = state.life_time;
    _143.life_span = state.life_span;
    _143.generation_id = state.generation_id;
    _143.color = state.color;
    _130.prt_states[id] = _143;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _147.prt_positions[(id * 3u) + 0u] = p.x;
    _147.prt_positions[(id * 3u) + 1u] = p.y;
    _147.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _173.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _173.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _173.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_244.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _244.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _289;
    if (prt_is_alive(param_6))
    {
        _289 = p.pos;
    }
    else
    {
        _289 = vec3(0.0);
    }
    modifier_factor.position = _289;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    float param_8 = _244.lifecycle_params.life_time_step;
    float param_9 = _244.lifecycle_params.max_lifetime;
    prt_advance_life(param_7, param_8, param_9);
    p.state = param_7;
    uint param_10 = id;
    ParticleState param_11 = p.state;
    prt_set_state(param_10, param_11);
    uint param_12 = id;
    vec3 param_13 = p.pos;
    prt_set_position(param_12, param_13);
    bool _335 = _244.lifecycle_params.has_previous != 0u;
    bool _342;
    if (_335)
    {
        _342 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _342 = _335;
    }
    if (_342)
    {
        uint param_14 = id;
        vec3 param_15 = p.pos;
        prt_set_prev_position(param_14, param_15);
    }
}

 