#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct VertexModifierNoiseParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec4 noise_phase;
    vec3 noise_scale;
    int falloff_curve_idx;
    vec3 strength;
    int falloff_inverse;
    vec3 position;
    int noise_relative_to_modifier;
    vec3 radius;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct _2006
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _309;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1624;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1635;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1723;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1915;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1956;

layout(set = 0, binding = 13, std140) uniform VM0
{
    layout(row_major) VertexModifierNoiseParams VM0_params;
} _1973;

layout(set = 0, binding = 14, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1994;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2101;

layout(set = 0, binding = 15) uniform sampler2D s_Curves;
layout(set = 0, binding = 16) uniform sampler2D s_NoiseRGBA;

layout(location = 1) out _2006 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _309.geometry_information.attributes[0].stride;
    idx += _309.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _309.geometry_information.attributes[2].stride;
    idx += _309.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _309.geometry_information.attributes[1].stride;
    idx += _309.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _309.geometry_information.attributes[3].stride;
    idx += _309.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _309.geometry_information.attributes[6].stride;
    idx += _309.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

mat4 mat_mul_affine(mat4 ma, mat4 mb)
{
    return ma * mb;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise_grad(vec3 v, inout vec3 gradient)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.60000002384185791015625) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    vec4 m2 = m * m;
    vec4 m4 = m2 * m2;
    vec4 pdotx = vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3));
    vec4 temp = (m2 * m) * pdotx;
    gradient = ((((x0 * temp.x) + (x1 * temp.y)) + (x2 * temp.z)) + (x3 * temp.w)) * (-8.0);
    gradient += ((((p0 * m4.x) + (p1 * m4.y)) + (p2 * m4.z)) + (p3 * m4.w));
    gradient *= 42.0;
    return 42.0 * dot(m4, pdotx);
}

void vertex_modifier_noise_apply(VertexModifierNoiseParams params, ModifierFactor modifier_factor, inout VertexInput vtx_input, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    mat4 mat_local_to_model = cs_transforms.mat_local_to_model;
    if (params.influence_scope == 1)
    {
        mat4 param = mat_local_to_model;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        mat_local_to_model = mat_mul_affine(param, param_1);
    }
    vec3 param_2 = vtx_input.pos;
    mat4 param_3 = (params.transform_parent_inv * params.transform_local_inv) * mat_local_to_model;
    vec3 _852 = vector_transform_by_mat43(param_2, param_3);
    vec3 influence_pos = _852;
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param_4 = noise_pos;
        mat4 param_5 = params.transform_local;
        vec3 _865 = vector_transform_by_mat43(param_4, param_5);
        noise_pos = _865;
    }
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    SPIRV_CROSS_BRANCH
    if (influence <= 1.0)
    {
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_6 = params.falloff_curve_idx;
        float param_7 = influence;
        influence = clamp(curve_sample(param_6, param_7), 0.0, 1.0);
        influence *= modifier_factor.factor;
        vec3 ni = noise_pos * params.noise_scale;
        vec3 n1_grad = vec3(0.0);
        vec3 n2_grad = vec3(0.0);
        vec3 param_8 = (ni + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.01229999959468841552734375);
        vec3 param_9;
        float _923 = snoise_grad(param_8, param_9);
        n1_grad = param_9;
        float n1 = _923;
        vec3 param_10 = ((ni * 0.5) + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.02170000039041042327880859375);
        vec3 param_11;
        float _941 = snoise_grad(param_10, param_11);
        n2_grad = param_11;
        float n2 = _941;
        n1_grad *= params.noise_scale;
        n2_grad *= (params.noise_scale * 0.5);
        n2 *= 0.5;
        n2_grad *= 0.5;
        float d = 1.0;
        float n = (params.noise_value_base + n1) + n2;
        float n_dx = (((params.noise_value_base + n1) + (n1_grad.x * d)) + n2) + (n2_grad.x * d);
        float n_dy = (((params.noise_value_base + n1) + (n1_grad.y * d)) + n2) + (n2_grad.y * d);
        float n_dz = (((params.noise_value_base + n1) + (n1_grad.z * d)) + n2) + (n2_grad.z * d);
        if (params.noise_value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
            n_dz = abs(n_dz);
        }
        vec3 scale = params.strength;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_12 = modifier_position;
            mat4 param_13 = params.transform_local;
            vec3 _1048 = vector_transform_by_mat43(param_12, param_13);
            local_norm = normalize(base_pos - _1048);
        }
        else
        {
            local_norm = normalize(local_norm);
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + vec3(d, 0.0, 0.0)) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + vec3(0.0, d, 0.0)) + ((local_norm * n_dy) * scale);
        vec3 new_pos_dz = (base_pos + vec3(0.0, 0.0, d)) + ((local_norm * n_dz) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + vec3(d, 0.0, 0.0), new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + vec3(0.0, d, 0.0), new_pos_dy, vec3(influence));
        new_pos_dz = mix(base_pos + vec3(0.0, 0.0, d), new_pos_dz, vec3(influence));
        vec3 dx = new_pos_dx - new_pos;
        vec3 dy = new_pos_dy - new_pos;
        vec3 dz = new_pos_dz - new_pos;
        vec3 new_norm = vec3(1.0);
        bool _1144 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.y);
        bool _1154;
        if (_1144)
        {
            _1154 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.z);
        }
        else
        {
            _1154 = _1144;
        }
        if (_1154)
        {
            dy = normalize(dy);
            dz = normalize(dz);
            dx = cross(dy, dz);
        }
        else
        {
            bool _1171 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.x);
            bool _1181;
            if (_1171)
            {
                _1181 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.z);
            }
            else
            {
                _1181 = _1171;
            }
            if (_1181)
            {
                dx = normalize(dx);
                dz = normalize(dz);
                dy = cross(dz, dx);
            }
            else
            {
                dx = normalize(dx);
                dy = normalize(dy);
                dz = cross(dx, dy);
            }
        }
        new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    for (int k = -1; k <= 1; k++)
    {
        for (int j = -1; j <= 1; j++)
        {
            for (int i = -1; i <= 1; i++)
            {
                vec3 b = vec3(float(i), float(j), float(k));
                vec3 param = p + b;
                vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                float d = dot(r, r);
                if (d < res.x)
                {
                    id = dot(p + b, vec3(1.0, 57.0, 113.0));
                    res = vec2(d, res.x);
                }
                else
                {
                    if (d < res.y)
                    {
                        res.y = d;
                    }
                }
            }
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1360 = vector_transform_by_mat43(param, param_1);
        coords = _1360;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1367 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1367;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_1624.instance_params.stride > 0)
    {
        uint flipbook_card = _1635.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_309.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_309.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _1657 = vtx_coords_load(param);
    vtx_input.pos = _1657;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_309.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1675 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1675.x;
        vtx_input.color.y = _1675.y;
        vtx_input.color.z = _1675.z;
    }
    if ((_309.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1690 = vtx_normals_load(param_2);
        vtx_input.norm = _1690;
    }
    if ((_309.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1701 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1701;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_1624.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1723.instance_transform[(gl_InstanceIndex * _1624.instance_params.stride) + 0];
        vec4 inst_m1 = _1723.instance_transform[(gl_InstanceIndex * _1624.instance_params.stride) + 1];
        vec4 inst_m2 = _1723.instance_transform[(gl_InstanceIndex * _1624.instance_params.stride) + 2];
        vec3 _1754 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1754.x;
        mat_instance_model[0].y = _1754.y;
        mat_instance_model[0].z = _1754.z;
        vec3 _1767 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1767.x;
        mat_instance_model[1].y = _1767.y;
        mat_instance_model[1].z = _1767.z;
        vec3 _1780 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1780.x;
        mat_instance_model[2].y = _1780.y;
        mat_instance_model[2].z = _1780.z;
        vec3 _1793 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1793.x;
        mat_instance_model[3].y = _1793.y;
        mat_instance_model[3].z = _1793.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_1624.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1915.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_309.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1938 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1938;
    }
    if ((_309.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1949 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1949;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1956.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1956.transform_params.mModelInv;
    modifier_factor.factor = abs(modifier_factor.factor);
    VertexModifierNoiseParams _1978;
    _1978.transform_world_to_local = _1973.VM0_params.transform_world_to_local;
    _1978.transform_local_to_world = _1973.VM0_params.transform_local_to_world;
    _1978.transform_local = _1973.VM0_params.transform_local;
    _1978.transform_local_inv = _1973.VM0_params.transform_local_inv;
    _1978.transform_parent = _1973.VM0_params.transform_parent;
    _1978.transform_parent_inv = _1973.VM0_params.transform_parent_inv;
    _1978.noise_phase = _1973.VM0_params.noise_phase;
    _1978.noise_scale = _1973.VM0_params.noise_scale;
    _1978.falloff_curve_idx = _1973.VM0_params.falloff_curve_idx;
    _1978.strength = _1973.VM0_params.strength;
    _1978.falloff_inverse = _1973.VM0_params.falloff_inverse;
    _1978.position = _1973.VM0_params.position;
    _1978.noise_relative_to_modifier = _1973.VM0_params.noise_relative_to_modifier;
    _1978.radius = _1973.VM0_params.radius;
    _1978.displacement_mode = _1973.VM0_params.displacement_mode;
    _1978.noise_value_base = _1973.VM0_params.noise_value_base;
    _1978.noise_value_absolute = _1973.VM0_params.noise_value_absolute;
    _1978.influence_scope = _1973.VM0_params.influence_scope;
    VertexModifierNoiseParams param_7 = _1978;
    ModifierFactor param_8 = modifier_factor;
    VertexInput param_9 = vtx_input;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    vertex_modifier_noise_apply(param_7, param_8, param_9, param_10);
    modifier_factor = param_8;
    vtx_input = param_9;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorNoise_Params _1999;
    _1999.transform_local_to_gizmo = _1994.VM1_params.transform_local_to_gizmo;
    _1999.noise_domain_scale = _1994.VM1_params.noise_domain_scale;
    _1999.modifier_function = _1994.VM1_params.modifier_function;
    _1999.noise_domain_offset = _1994.VM1_params.noise_domain_offset;
    _1999.noise_value_scale = _1994.VM1_params.noise_value_scale;
    _1999.noise_value_offset = _1994.VM1_params.noise_value_offset;
    _1999.influence_scope = _1994.VM1_params.influence_scope;
    _1999._pad0 = _1994.VM1_params._pad0;
    _1999._pad1 = _1994.VM1_params._pad1;
    ModifierFactorNoise_Params param_11 = _1999;
    ModifierFactor param_12 = modifier_factor;
    CoordinateSystemTrasforms param_13 = cs_transforms;
    modifier_factor_noise_voronoi(param_11, param_12, param_13);
    modifier_factor = param_12;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_1624.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1723.instance_transform[(gl_InstanceIndex * _1624.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1723.instance_transform[(gl_InstanceIndex * _1624.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1723.instance_transform[(gl_InstanceIndex * _1624.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_14 = vtx_input.norm;
        mat4 param_15 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_14, param_15));
        vec2 _2107 = unpackHalf2x16(_2101.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _2107.x;
        inst_c.y = _2107.y;
        vec2 _2117 = unpackHalf2x16(_2101.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _2117.x;
        inst_c.w = _2117.y;
        vec4 _2123 = vtx_input.color;
        vec3 _2127 = _2123.xyz * inst_c.xyz;
        vtx_input.color.x = _2127.x;
        vtx_input.color.y = _2127.y;
        vtx_input.color.z = _2127.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_16 = vtx_input.pos;
    mat4 param_17 = _1956.transform_params.mModel;
    vec3 _2147 = vector_transform_by_mat43(param_16, param_17);
    vec3 vPosModel = _2147;
    vec3 param_18 = vtx_input.norm;
    mat4 param_19 = _1956.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_18, param_19);
    vec3 param_20 = vPosModel;
    mat4 param_21 = _1956.transform_params.mView;
    vec3 _2162 = vector_transform_by_mat43(param_20, param_21);
    vec3 vPosModelView = _2162;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1956.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1956.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1956.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1956.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_22 = vtx_output.vCoords;
    mat4 param_23 = _1956.transform_params.mProjection;
    vec4 _2215 = vector_transform_by_mat_projection(param_22, param_23);
    gl_Position = _2215;
}

 