#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct TransformGeometryOutputVertexParams
{
    int coord_stride;
    int normal_stride;
    int uv0_stride;
    int coord_offset;
    int normal_offset;
    int uv0_offset;
    int _pad0;
    int _pad1;
};

struct TransformGeometryParams
{
    TransformGeometryOutputVertexParams output_vtx_params;
    uint instance_idx;
    uint surface_idx;
    uint voxelize;
    uint raytrace;
    uint voxelize_as_emissive;
    uint voxelize_conservative;
    uint material_idx;
    int transform_normals;
    int calculate_bbox_raytrace;
    int calculate_bbox_voxelize;
    uint _instances_num;
    uint initialize_bbox;
    vec4 default_bbox_raytrace_min;
    vec4 default_bbox_raytrace_max;
    vec4 default_bbox_voxelize_min;
    vec4 default_bbox_voxelize_max;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 3, std140) uniform TransformGeometryParamsBuffer
{
    TransformGeometryParams transform_geometry_params;
} _45;

layout(set = 0, binding = 1, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _57;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

void main()
{
    if (gl_LocalInvocationIndex == 0u)
    {
        vec3 bbox_raytrace_min = vec3(-1.0);
        vec3 bbox_raytrace_max = vec3(1.0);
        vec3 bbox_voxelize_min = vec3(-1.0);
        vec3 bbox_voxelize_max = vec3(1.0);
        bool is_raytrace_bbox_present = false;
        bool is_voxelize_bbox_present = false;
        for (uint i = 0u; i < _45.transform_geometry_params.instance_idx; i++)
        {
            if (_57.transformed_data_location[i].raytrace != 0u)
            {
                if (is_raytrace_bbox_present == false)
                {
                    bbox_raytrace_min = vec3(_57.transformed_data_location[i].bbox_min.xyz);
                    bbox_raytrace_max = vec3(_57.transformed_data_location[i].bbox_max.xyz);
                    is_raytrace_bbox_present = true;
                }
                else
                {
                    bbox_raytrace_min = min(bbox_raytrace_min, vec3(_57.transformed_data_location[i].bbox_min.xyz));
                    bbox_raytrace_max = max(bbox_raytrace_max, vec3(_57.transformed_data_location[i].bbox_max.xyz));
                }
            }
            if (_57.transformed_data_location[i].voxelize != 0u)
            {
                if (is_voxelize_bbox_present == false)
                {
                    bbox_voxelize_min = vec3(_57.transformed_data_location[i].bbox_min.xyz);
                    bbox_voxelize_max = vec3(_57.transformed_data_location[i].bbox_max.xyz);
                    is_voxelize_bbox_present = true;
                }
                else
                {
                    bbox_voxelize_min = min(bbox_voxelize_min, vec3(_57.transformed_data_location[i].bbox_min.xyz));
                    bbox_voxelize_max = max(bbox_voxelize_max, vec3(_57.transformed_data_location[i].bbox_max.xyz));
                }
            }
        }
        if (is_raytrace_bbox_present)
        {
            in_bbox_data.bbox_raytrace_min.x = bbox_raytrace_min.x;
            in_bbox_data.bbox_raytrace_min.y = bbox_raytrace_min.y;
            in_bbox_data.bbox_raytrace_min.z = bbox_raytrace_min.z;
            in_bbox_data.bbox_raytrace_max.x = bbox_raytrace_max.x;
            in_bbox_data.bbox_raytrace_max.y = bbox_raytrace_max.y;
            in_bbox_data.bbox_raytrace_max.z = bbox_raytrace_max.z;
        }
        if (_45.transform_geometry_params.calculate_bbox_raytrace == 0)
        {
            in_bbox_data.bbox_raytrace_min.x = _45.transform_geometry_params.default_bbox_raytrace_min.xyz.x;
            in_bbox_data.bbox_raytrace_min.y = _45.transform_geometry_params.default_bbox_raytrace_min.xyz.y;
            in_bbox_data.bbox_raytrace_min.z = _45.transform_geometry_params.default_bbox_raytrace_min.xyz.z;
            in_bbox_data.bbox_raytrace_max.x = _45.transform_geometry_params.default_bbox_raytrace_max.xyz.x;
            in_bbox_data.bbox_raytrace_max.y = _45.transform_geometry_params.default_bbox_raytrace_max.xyz.y;
            in_bbox_data.bbox_raytrace_max.z = _45.transform_geometry_params.default_bbox_raytrace_max.xyz.z;
        }
        if (is_voxelize_bbox_present)
        {
            in_bbox_data.bbox_voxelize_min.x = bbox_voxelize_min.x;
            in_bbox_data.bbox_voxelize_min.y = bbox_voxelize_min.y;
            in_bbox_data.bbox_voxelize_min.z = bbox_voxelize_min.z;
            in_bbox_data.bbox_voxelize_max.x = bbox_voxelize_max.x;
            in_bbox_data.bbox_voxelize_max.y = bbox_voxelize_max.y;
            in_bbox_data.bbox_voxelize_max.z = bbox_voxelize_max.z;
        }
        if (_45.transform_geometry_params.calculate_bbox_voxelize == 0)
        {
            in_bbox_data.bbox_voxelize_min.x = _45.transform_geometry_params.default_bbox_voxelize_min.xyz.x;
            in_bbox_data.bbox_voxelize_min.y = _45.transform_geometry_params.default_bbox_voxelize_min.xyz.y;
            in_bbox_data.bbox_voxelize_min.z = _45.transform_geometry_params.default_bbox_voxelize_min.xyz.z;
            in_bbox_data.bbox_voxelize_max.x = _45.transform_geometry_params.default_bbox_voxelize_max.xyz.x;
            in_bbox_data.bbox_voxelize_max.y = _45.transform_geometry_params.default_bbox_voxelize_max.xyz.y;
            in_bbox_data.bbox_voxelize_max.z = _45.transform_geometry_params.default_bbox_voxelize_max.xyz.z;
        }
        vec3 mi = in_bbox_data.bbox_raytrace_min.xyz;
        vec3 ma = in_bbox_data.bbox_raytrace_max.xyz;
        vec3 mc = (ma + mi) / vec3(2.0);
        vec3 md = ma - mi;
        float max_md = max(md.x, max(md.y, md.z));
        md.x = max(md.x, max_md * 0.25);
        md.y = max(md.y, max_md * 0.25);
        md.z = max(md.z, max_md * 0.25);
        vec3 _285 = mc - (md * 0.50499999523162841796875);
        in_bbox_data.bbox_raytrace_min.x = _285.x;
        in_bbox_data.bbox_raytrace_min.y = _285.y;
        in_bbox_data.bbox_raytrace_min.z = _285.z;
        vec3 _295 = mc + (md * 0.50499999523162841796875);
        in_bbox_data.bbox_raytrace_max.x = _295.x;
        in_bbox_data.bbox_raytrace_max.y = _295.y;
        in_bbox_data.bbox_raytrace_max.z = _295.z;
        mi = in_bbox_data.bbox_raytrace_min.xyz;
        ma = in_bbox_data.bbox_raytrace_max.xyz;
        vec3 cell_size = (ma - mi) / vec3(256.0);
        ivec3 grid_shift = -ivec3(floor(mi / cell_size));
        vec3 _324 = vec3(grid_shift);
        in_bbox_data.grid_shift_raytrace.x = _324.x;
        in_bbox_data.grid_shift_raytrace.y = _324.y;
        in_bbox_data.grid_shift_raytrace.z = _324.z;
        in_bbox_data.grid_size_raytrace.x = cell_size.x;
        in_bbox_data.grid_size_raytrace.y = cell_size.y;
        in_bbox_data.grid_size_raytrace.z = cell_size.z;
        vec3 _339 = vec3(1.0) / cell_size;
        in_bbox_data.grid_size_raytrace_recip.x = _339.x;
        in_bbox_data.grid_size_raytrace_recip.y = _339.y;
        in_bbox_data.grid_size_raytrace_recip.z = _339.z;
        vec3 mi_1 = in_bbox_data.bbox_voxelize_min.xyz;
        vec3 ma_1 = in_bbox_data.bbox_voxelize_max.xyz;
        vec3 mc_1 = (ma_1 + mi_1) / vec3(2.0);
        vec3 md_1 = ma_1 - mi_1;
        vec3 _368 = mc_1 - (md_1 * 0.5);
        in_bbox_data.bbox_voxelize_min.x = _368.x;
        in_bbox_data.bbox_voxelize_min.y = _368.y;
        in_bbox_data.bbox_voxelize_min.z = _368.z;
        vec3 _378 = mc_1 + (md_1 * 0.5);
        in_bbox_data.bbox_voxelize_max.x = _378.x;
        in_bbox_data.bbox_voxelize_max.y = _378.y;
        in_bbox_data.bbox_voxelize_max.z = _378.z;
        vec4 _386 = in_bbox_data.bbox_voxelize_min;
        vec3 _388 = floor(_386.xyz);
        in_bbox_data.bbox_voxelize_min.x = _388.x;
        in_bbox_data.bbox_voxelize_min.y = _388.y;
        in_bbox_data.bbox_voxelize_min.z = _388.z;
        vec4 _396 = in_bbox_data.bbox_voxelize_max;
        vec3 _398 = ceil(_396.xyz);
        in_bbox_data.bbox_voxelize_max.x = _398.x;
        in_bbox_data.bbox_voxelize_max.y = _398.y;
        in_bbox_data.bbox_voxelize_max.z = _398.z;
        mi_1 = in_bbox_data.bbox_voxelize_min.xyz;
        ma_1 = in_bbox_data.bbox_voxelize_max.xyz;
        vec3 cell_size_1 = (ma_1 - mi_1) / vec3(256.0);
        float max_cell_size_edge = max(cell_size_1.x, max(cell_size_1.y, cell_size_1.z));
        cell_size_1 = vec3(max_cell_size_edge);
        ivec3 grid_shift_1 = -ivec3(floor(mi_1 / cell_size_1));
        vec3 _436 = vec3(grid_shift_1);
        in_bbox_data.grid_shift_voxelize.x = _436.x;
        in_bbox_data.grid_shift_voxelize.y = _436.y;
        in_bbox_data.grid_shift_voxelize.z = _436.z;
        in_bbox_data.grid_size_voxelize.x = cell_size_1.x;
        in_bbox_data.grid_size_voxelize.y = cell_size_1.y;
        in_bbox_data.grid_size_voxelize.z = cell_size_1.z;
        vec4 _453 = in_bbox_data.bbox_raytrace_min;
        vec4 _456 = in_bbox_data.bbox_voxelize_min;
        vec3 _458 = min(_453.xyz, _456.xyz);
        in_bbox_data.bbox_combined_min.x = _458.x;
        in_bbox_data.bbox_combined_min.y = _458.y;
        in_bbox_data.bbox_combined_min.z = _458.z;
        vec4 _466 = in_bbox_data.bbox_raytrace_max;
        vec4 _469 = in_bbox_data.bbox_voxelize_max;
        vec3 _471 = max(_466.xyz, _469.xyz);
        in_bbox_data.bbox_combined_max.x = _471.x;
        in_bbox_data.bbox_combined_max.y = _471.y;
        in_bbox_data.bbox_combined_max.z = _471.z;
        mi_1 = in_bbox_data.bbox_combined_min.xyz;
        ma_1 = in_bbox_data.bbox_combined_max.xyz;
        cell_size_1 = (ma_1 - mi_1) / vec3(256.0);
        grid_shift_1 = -ivec3(floor(mi_1 / cell_size_1));
        vec3 _496 = vec3(grid_shift_1);
        in_bbox_data.grid_shift_combined.x = _496.x;
        in_bbox_data.grid_shift_combined.y = _496.y;
        in_bbox_data.grid_shift_combined.z = _496.z;
        in_bbox_data.grid_size_combined.x = cell_size_1.x;
        in_bbox_data.grid_size_combined.y = cell_size_1.y;
        in_bbox_data.grid_size_combined.z = cell_size_1.z;
    }
}

 