#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct DownscaleDepthParams
{
    float source_width_inv;
    float source_height_inv;
    float scale_factor;
    float scale_factor_inv;
    float _pad0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform DownscaleDepthParamsBuffer
{
    DownscaleDepthParams params;
} _19;

layout(set = 1, binding = 2) uniform sampler2D sDepth;

void main()
{
    vec2 p = (gl_FragCoord.xy * _19.params.scale_factor) * vec2(_19.params.source_width_inv, _19.params.source_height_inv);
    float d = 2.0;
    vec4 depth00 = textureGather(sDepth, p + vec2(_19.params.source_width_inv * 0.0, _19.params.source_height_inv * 0.0));
    vec4 depth10 = textureGather(sDepth, p + vec2(_19.params.source_width_inv * d, _19.params.source_height_inv * 0.0));
    vec4 depth01 = textureGather(sDepth, p + vec2(_19.params.source_width_inv * 0.0, _19.params.source_height_inv * d));
    vec4 depth11 = textureGather(sDepth, p + vec2(_19.params.source_width_inv * d, _19.params.source_height_inv * d));
    float min_depth00 = min(depth00.x, min(depth00.y, min(depth00.z, depth00.w)));
    float min_depth10 = min(depth10.x, min(depth10.y, min(depth10.z, depth10.w)));
    float min_depth01 = min(depth01.x, min(depth01.y, min(depth01.z, depth01.w)));
    float min_depth11 = min(depth11.x, min(depth11.y, min(depth11.z, depth11.w)));
    float min_depth = min(min_depth00, min(min_depth10, min(min_depth01, min_depth11)));
    gl_FragDepth = min_depth;
}

 