#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
    vec4 camera_projection_params;
    vec2 frustum_shift;
    vec2 resolution;
    float animation_time;
    float prestep;
    float intersection_density_modifier;
    float density;
    float intensity;
    float opacity;
    float dithering;
    float sampling_mip;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _1995
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 1, binding = 4, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _555;

layout(set = 1, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 5, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1080;

layout(set = 1, binding = 2, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 7, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1164;

layout(set = 1, binding = 8, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1787;

layout(set = 1, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1797;

layout(set = 1, binding = 9) uniform sampler2D s_Gradients;
layout(set = 1, binding = 10) uniform sampler3D s_voxel_colors_filtered;
layout(set = 1, binding = 11) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 1, binding = 12) uniform sampler2D s_NoiseRGBA;
layout(set = 1, binding = 13) uniform sampler2D sImage1;
layout(set = 1, binding = 14) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 30) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 31) uniform sampler2D sDepth;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _1995 vtx_input;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;
layout(location = 3) out vec4 outEmissive;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

float linearizeDepth(float d)
{
    return _555.raymarch_params.near_far_plane.z / ((_555.raymarch_params.near_far_plane.y + _555.raymarch_params.near_far_plane.x) - (d * _555.raymarch_params.near_far_plane.w));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 48; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 20000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 20000.0)
    {
        res = t;
    }
    return res;
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_555.raymarch_params.frustum_shift * _555.raymarch_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_555.raymarch_params.camera_projection_params.z) + ((_555.raymarch_params.camera_projection_params.x * vd_pos.x) / _555.raymarch_params.resolution.x);
    view_direction.y = (-_555.raymarch_params.camera_projection_params.w) + ((_555.raymarch_params.camera_projection_params.y * vd_pos.y) / _555.raymarch_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _271 = v;
    float _275 = v.w;
    vec3 _278 = (_271.xyz * _275) * 128.0;
    v.x = _278.x;
    v.y = _278.y;
    v.z = _278.z;
    return v.xyz * v.xyz;
}

vec4 sample_voxelization_data(vec3 world_position, float color_lod, float occupancy_lod)
{
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (world_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _644 = source_voxel_position.x < 0.0;
    bool _651;
    if (!_644)
    {
        _651 = source_voxel_position.y < 0.0;
    }
    else
    {
        _651 = _644;
    }
    bool _658;
    if (!_651)
    {
        _658 = source_voxel_position.z < 0.0;
    }
    else
    {
        _658 = _651;
    }
    bool _665;
    if (!_658)
    {
        _665 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _665 = _658;
    }
    bool _672;
    if (!_665)
    {
        _672 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _672 = _665;
    }
    bool _679;
    if (!_672)
    {
        _679 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _679 = _672;
    }
    if (_679)
    {
        return vec4(0.0);
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, color_lod);
    vec3 _694 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _694;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, occupancy_lod).x;
    return vec4(voxel_color, voxel_occupancy);
}

float _noise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return mix(rg.x, rg.y, f.z);
}

vec2 density_map(vec3 p, vec3 p_noise)
{
    float t = texture(sImage1, fract((p.xz / _555.raymarch_params.function_scale.xy) + vec2(0.5))).y;
    float b = 1.0 - clamp(abs(0.5 - t) * 2.0, 0.0, 1.0);
    vec3 param = vec3(p_noise * 3.1340999603271484375);
    float n = _noise(param);
    return vec2(t, (b * t) * clamp(n * 4.0, -0.5, 4.0));
}

vec4 map(vec3 p, vec3 world_p)
{
    vec3 param = world_p;
    float param_1 = _555.raymarch_params.sampling_mip;
    float param_2 = _555.raymarch_params.sampling_mip;
    vec4 voxel_color_occupancy = sample_voxelization_data(param, param_1, param_2);
    if (voxel_color_occupancy.w < 0.001000000047497451305389404296875)
    {
        return vec4(0.0);
    }
    float den = -2.0;
    float cloud_time = _555.raymarch_params.animation_time;
    vec3 q = ((p * 0.5) - (vec3(0.0, 0.0, 1.5) * cloud_time)) + ((vec3(-0.4000000059604644775390625, 0.0, 1.5) * cloud_time) * 0.703100025653839111328125);
    vec3 param_3 = p;
    vec3 param_4 = q;
    vec2 texture_base_den = density_map(param_3, param_4);
    vec3 param_5 = q * 13.3127002716064453125;
    float f = 0.25 * _noise(param_5);
    vec3 param_6 = q;
    f += (0.5 * _noise(param_6));
    q = (q * 2.019999980926513671875) - (vec3(0.0, 0.0, 1.39999997615814208984375) * cloud_time);
    vec3 param_7 = q;
    f += (0.25 * _noise(param_7));
    q = (q * 2.0299999713897705078125) - (vec3(0.0, 0.0, 1.60000002384185791015625) * cloud_time);
    vec3 param_8 = q;
    f += (0.125 * _noise(param_8));
    q = (q * 2.0099999904632568359375) - (vec3(0.0, 0.0, 1.7999999523162841796875) * cloud_time);
    vec3 param_9 = q;
    f += (0.0625 * _noise(param_9));
    q = (q * 2.019999980926513671875) - (vec3(0.0, 0.0, 1.0) * cloud_time);
    vec3 param_10 = q;
    f += (0.03125 * _noise(param_10));
    den += (4.0 * f);
    den = clamp(den, 0.0, 1.0);
    vec3 col = mix(vec3(1.0), vec3(0.60000002384185791015625, 0.5, 0.4000000059604644775390625), vec3(den * 0.5));
    vec4 color_density = vec4(col, ((den * 0.699999988079071044921875) * _555.raymarch_params.density) * 0.001000000047497451305389404296875);
    color_density.w *= voxel_color_occupancy.w;
    return color_density;
}

float testshadow(vec3 p, float dither)
{
    float shadow = 1.0;
    float s = 0.0500000007450580596923828125 * dither;
    for (int j = 0; j < 5; j++)
    {
        vec3 shadpos = p + (normalize(lights.light_properties[0].direction) * s);
        vec3 world_pos = shadpos;
        world_pos -= _555.raymarch_params.function_origin;
        world_pos /= _555.raymarch_params.function_scale;
        world_pos = (_1080.transform_params.mModel * vec4(world_pos, 1.0)).xyz;
        vec3 param = shadpos;
        vec3 param_1 = world_pos;
        shadow -= (map(param, param_1).w * shadow);
        s += 0.07500000298023223876953125;
    }
    return shadow;
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _338 = coords.x < (-coords.w);
    bool _347;
    if (!_338)
    {
        _347 = coords.x > coords.w;
    }
    else
    {
        _347 = _338;
    }
    bool _357;
    if (!_347)
    {
        _357 = coords.y < (-coords.w);
    }
    else
    {
        _357 = _347;
    }
    bool _366;
    if (!_357)
    {
        _366 = coords.y > coords.w;
    }
    else
    {
        _366 = _357;
    }
    bool _373;
    if (!_366)
    {
        _373 = coords.z < 0.0;
    }
    else
    {
        _373 = _366;
    }
    if (_373)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _377 = coords;
    float _382 = coords.w;
    vec2 _384 = (_377.xy * vec2(0.5)) + (vec2(0.5) * _382);
    coords.x = _384.x;
    coords.y = _384.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _415 = -sampling_r;
    float y = _415;
    int iy = 0;
    for (; iy < samples; iy++, y += ((2.0 * sampling_r) / float(samples - 1)))
    {
        float _427 = -sampling_r;
        float x = _427;
        int ix = 0;
        for (; ix < samples; ix++, x += ((2.0 * sampling_r) / float(samples - 1)))
        {
            vec4 _453 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
            vec4 _456 = _453;
            _456.z = _453.w;
            float shadow = textureProjLod(smpl, vec4(_456.xy, _453.z, _456.z), 0.0);
            fact += shadow;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float angle_falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _517 = angle_falloff > cutoff;
    bool _524;
    if (_517)
    {
        _524 = light_distance < light.range;
    }
    else
    {
        _524 = _517;
    }
    if (_524)
    {
        attenuation = 1.0 - ((1.0 - angle_falloff) / (1.0 - cutoff));
        attenuation = pow(attenuation, light.angular_falloff_power);
        float distance_attenuation = 1.0 - (light_distance / light.range);
        attenuation *= (distance_attenuation * distance_attenuation);
    }
    return attenuation;
}

float calculate_scene_light(vec3 world)
{
    float total_light = 0.0;
    int lights_num = 1;
    float param_1;
    for (int light_idx = 0; light_idx < lights_num; light_idx++)
    {
        LightProperties _1125;
        _1125.diffuse = lights.light_properties[light_idx].diffuse;
        _1125.direction = lights.light_properties[light_idx].direction;
        _1125.position = lights.light_properties[light_idx].position;
        _1125.up = lights.light_properties[light_idx].up;
        _1125.right = lights.light_properties[light_idx].right;
        _1125.dimensions = lights.light_properties[light_idx].dimensions;
        _1125.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
        _1125.intensity = lights.light_properties[light_idx].intensity;
        _1125.range = lights.light_properties[light_idx].range;
        _1125.cutoff = lights.light_properties[light_idx].cutoff;
        _1125.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _1125.is_area = lights.light_properties[light_idx].is_area;
        _1125.type = lights.light_properties[light_idx].type;
        _1125.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _1125.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _1125.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
        _1125.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _1125.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _1125.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _1125.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _1125.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _1125.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _1125.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _1125.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _1125.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
        _1125.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
        _1125.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _1125.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _1125.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _1125.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _1125.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _1125.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _1125.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _1125.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _1125.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _1125;
        float shadow = 0.0;
        bool calculate_shadows = (light.type & 8) != 0;
        if ((light.type & 3) != 0)
        {
            vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
            float in_frustum = 0.0;
            vec4 param = vShadowCoords;
            int param_2 = 1;
            float param_3 = materials.material_properties[_1164.materialIndex].shadowmap_bias;
            float _1178 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param, param_1, param_2, param_3);
            in_frustum = param_1;
            shadow = _1178;
        }
        shadow = 1.0 - shadow;
        if ((light.type & 130) == 130)
        {
            LightProperties param_4 = light;
            vec3 param_5 = world;
            float attenuation_color = light_calculate_spot_attenuation(param_4, param_5);
            shadow *= length(attenuation_color);
        }
        total_light += (shadow * light.intensity);
    }
    return total_light / float(lights_num);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec4 raymarch(vec3 ro, vec3 rd, float max_t, out float intersection)
{
    vec4 sum = vec4(0.0);
    float t = 0.0;
    intersection = -1.0;
    float t_step = 0.100000001490116119384765625;
    float dither = texelFetch(s_BlueNoise, ivec3(ivec2(uvec2(gl_FragCoord.xy) % uvec2(128u)), 0), 0).x;
    t += (_555.raymarch_params.dithering * dither);
    float total_scene_light = 0.0;
    float shadow = 0.0;
    for (int i = 0; i < 64; i++)
    {
        float trace_t = t + ((0.20000000298023223876953125 * t) * t);
        if (trace_t >= max_t)
        {
            break;
        }
        vec3 pos = ro + (rd * trace_t);
        vec3 world_pos = pos;
        world_pos -= _555.raymarch_params.function_origin;
        world_pos /= _555.raymarch_params.function_scale;
        vec3 param = world_pos;
        mat4 param_1 = _1080.transform_params.mModel;
        vec3 _1294 = vector_transform_by_mat43(param, param_1);
        world_pos = _1294;
        vec3 param_2 = world_pos;
        float param_3 = _555.raymarch_params.sampling_mip;
        float param_4 = _555.raymarch_params.sampling_mip;
        vec4 voxel_color_occupancy = sample_voxelization_data(param_2, param_3, param_4);
        if (voxel_color_occupancy.w > 0.00999999977648258209228515625)
        {
            break;
        }
        t += (t_step * _555.raymarch_params.prestep);
    }
    for (int i_1 = 0; i_1 < 64; i_1++)
    {
        float trace_t_1 = t + ((0.20000000298023223876953125 * t) * t);
        if ((sum.w > 0.9900000095367431640625) || (trace_t_1 >= max_t))
        {
            break;
        }
        vec3 pos_1 = ro + (rd * trace_t_1);
        vec3 world_pos_1 = pos_1;
        world_pos_1 -= _555.raymarch_params.function_origin;
        world_pos_1 /= _555.raymarch_params.function_scale;
        vec3 param_5 = world_pos_1;
        mat4 param_6 = _1080.transform_params.mModel;
        vec3 _1367 = vector_transform_by_mat43(param_5, param_6);
        world_pos_1 = _1367;
        vec3 param_7 = pos_1;
        vec3 param_8 = world_pos_1;
        vec4 col = map(param_7, param_8);
        vec3 param_9 = pos_1;
        float param_10 = dither;
        shadow = testshadow(param_9, param_10);
        float scene_light = 1.0;
        if (true)
        {
            vec3 world_pos_2 = pos_1;
            world_pos_2 -= _555.raymarch_params.function_origin;
            world_pos_2 /= _555.raymarch_params.function_scale;
            vec3 param_11 = world_pos_2 + vec3(dither * 0.0199999995529651641845703125);
            mat4 param_12 = _1080.transform_params.mModel;
            vec3 _1403 = vector_transform_by_mat43(param_11, param_12);
            world_pos_2 = _1403;
            vec3 param_13 = world_pos_2;
            scene_light = calculate_scene_light(param_13) * 0.00999999977648258209228515625;
            total_scene_light += (scene_light * col.w);
        }
        vec3 cloud_color_for_shadow = vec3(1.0);
        if (_555.raymarch_params.gradient_idx != (-1))
        {
            int param_14 = _555.raymarch_params.gradient_idx;
            float param_15 = shadow;
            cloud_color_for_shadow = gradient_sample(param_14, param_15).xyz;
        }
        vec4 _1429 = col;
        vec3 _1431 = _1429.xyz * cloud_color_for_shadow;
        col.x = _1431.x;
        col.y = _1431.y;
        col.z = _1431.z;
        vec4 _1440 = col;
        vec3 _1442 = _1440.xyz * (scene_light + 0.100000001490116119384765625);
        col.x = _1442.x;
        col.y = _1442.y;
        col.z = _1442.z;
        float _1450 = col.w;
        vec4 _1451 = col;
        vec3 _1453 = _1451.xyz * _1450;
        col.x = _1453.x;
        col.y = _1453.y;
        col.z = _1453.z;
        float _1463 = sum.w;
        vec4 _1466 = sum;
        vec3 _1468 = _1466.xyz + (col.xyz * (1.0 - _1463));
        sum.x = _1468.x;
        sum.y = _1468.y;
        sum.z = _1468.z;
        sum.w = min(sum.w + col.w, 1.0);
        t += t_step;
    }
    vec4 bg = mix(vec4(0.300000011920928955078125, 0.4000000059604644775390625, 0.5, 0.0), vec4(0.5, 0.699999988079071044921875, 1.0, 0.0), vec4(smoothstep(-0.4000000059604644775390625, 0.0, rd.y)));
    float _1499 = sum.w;
    vec4 _1505 = sum;
    vec3 _1507 = _1505.xyz + ((bg.xyz * (1.0 - _1499)) * (total_scene_light * 0.0500000007450580596923828125));
    sum.x = _1507.x;
    sum.y = _1507.y;
    sum.z = _1507.z;
    intersection = t + ((0.20000000298023223876953125 * t) * t);
    return vec4(max(vec3(0.0), sum.xyz), sum.w);
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, out vec4 color)
{
    vec3 param = ro;
    vec3 param_1 = rd;
    float param_2 = max_t;
    float param_3;
    vec4 _1540 = raymarch(param, param_1, param_2, param_3);
    float intersection = param_3;
    color = _1540;
    return intersection;
}

vec3 doModelNormal(vec3 p)
{
    return vec3(1.0);
}

uint octahedral_32(inout vec3 nor, uint sh)
{
    nor /= vec3((abs(nor.x) + abs(nor.y)) + abs(nor.z));
    float t = max(-nor.z, 0.0);
    float _180;
    if (nor.x > 0.0)
    {
        _180 = t;
    }
    else
    {
        _180 = -t;
    }
    nor.x += _180;
    float _195;
    if (nor.y > 0.0)
    {
        _195 = t;
    }
    else
    {
        _195 = -t;
    }
    nor.y += _195;
    vec2 v = (nor.xy * 0.5) + vec2(0.5);
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(floor((v * float(mu)) + vec2(0.5)));
    return (d.y << sh) | d.x;
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint param_1 = 15u;
    uint _242 = octahedral_32(param, param_1);
    uint normal_material = _242;
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

void main()
{
    MaterialPropertiesGPU _1774;
    _1774.diffuse = materials.material_properties[_1164.materialIndex].diffuse;
    _1774.transparency = materials.material_properties[_1164.materialIndex].transparency;
    _1774.emissive = materials.material_properties[_1164.materialIndex].emissive;
    _1774.roughness = materials.material_properties[_1164.materialIndex].roughness;
    _1774.triplanar_factor = materials.material_properties[_1164.materialIndex].triplanar_factor;
    _1774.refraction = materials.material_properties[_1164.materialIndex].refraction;
    _1774.normal_factor = materials.material_properties[_1164.materialIndex].normal_factor;
    _1774.emissive_factor = materials.material_properties[_1164.materialIndex].emissive_factor;
    _1774.temporal_accumulation_factor = materials.material_properties[_1164.materialIndex].temporal_accumulation_factor;
    _1774.shadowmap_bias = materials.material_properties[_1164.materialIndex].shadowmap_bias;
    _1774.metalness = materials.material_properties[_1164.materialIndex].metalness;
    _1774.albedo_sampler = materials.material_properties[_1164.materialIndex].albedo_sampler;
    _1774.emissive_sampler = materials.material_properties[_1164.materialIndex].emissive_sampler;
    _1774.normal_sampler = materials.material_properties[_1164.materialIndex].normal_sampler;
    _1774.metalic_roughness_sampler = materials.material_properties[_1164.materialIndex].metalic_roughness_sampler;
    _1774.flags = materials.material_properties[_1164.materialIndex].flags;
    _1774._pad0 = materials.material_properties[_1164.materialIndex]._pad0;
    _1774._pad1 = materials.material_properties[_1164.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1774;
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_1787.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1797.instance_transform[(instanceID * uint(_1787.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1797.instance_transform[(instanceID * uint(_1787.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1797.instance_transform[(instanceID * uint(_1787.instance_params.stride)) + 2u];
        vec3 _1832 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1832.x;
        mat_instance_model[0].y = _1832.y;
        mat_instance_model[0].z = _1832.z;
        vec3 _1845 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1845.x;
        mat_instance_model[1].y = _1845.y;
        mat_instance_model[1].z = _1845.z;
        vec3 _1858 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1858.x;
        mat_instance_model[2].y = _1858.y;
        mat_instance_model[2].z = _1858.z;
        vec3 _1871 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1871.x;
        mat_instance_model[3].y = _1871.y;
        mat_instance_model[3].z = _1871.z;
    }
    vec3 instance_function_origin = _555.raymarch_params.function_origin;
    if (_555.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_555.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _1080.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    float param_1 = material.metalness;
    float param_2 = material.roughness;
    uint param_3 = uint(_1164.materialIndex);
    uvec2 _2016 = encode_metalness_roughness_material(param_1, param_2, param_3);
    outMetalnessRoughnessMeterialTags.x = _2016.x;
    outMetalnessRoughnessMeterialTags.y = _2016.y;
    outEmissive = vec4(0.0);
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vCameraRelativeWorldPos + _1080.transform_params.vCameraPosition, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_1080.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    if (_555.raymarch_params.trace_inside != 0)
    {
        ro = (mat_instance_model_inv * vec4(_1080.transform_params.vCameraPosition, 1.0)).xyz;
    }
    ro *= _555.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    float raw_depth = texelFetch(sDepth, ivec2(gl_FragCoord.xy), 0).x;
    float param_4 = raw_depth;
    float max_depth = linearizeDepth(param_4);
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_555.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_5 = ro_bounding_volume;
        vec3 param_6 = rd;
        vec3 param_7 = _555.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_5, param_6, param_7);
    }
    bounding_volume_intersection = max_depth;
    vec2 param_8 = vec2(gl_FragCoord.xy);
    vec3 view_direction = get_view_direction(param_8);
    vec3 world = (_1080.transform_params.mViewInv * vec4(view_direction * max_depth, 1.0)).xyz;
    float d = length((_1080.transform_params.mModelInv * vec4(world - _1080.transform_params.vCameraPosition, 0.0)).xyz);
    bounding_volume_intersection = d * _555.raymarch_params.function_scale.z;
    vec3 param_9 = ro;
    vec3 param_10 = rd;
    float param_11 = bounding_volume_intersection;
    vec4 param_12;
    float _2153 = calcIntersection(param_9, param_10, param_11, param_12);
    color = param_12;
    float intersection = _2153;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        vec3 param_13 = ri;
        vec3 normal = doModelNormal(param_13);
        vec3 world_normal = (mat_instance_model * vec4(normal, 0.0)).xyz;
        vec3 param_14 = normalize(world_normal);
        int param_15 = _1164.materialId;
        outNormalMaterial = encode_normal_material(param_14, param_15);
        ri -= instance_function_origin;
        ri /= _555.raymarch_params.function_scale;
        ri = ((_1080.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        vec3 _2214 = (color.xyz * vec3(0.0, 50.0, 30.0)) * _555.raymarch_params.intensity;
        outAlbedo.x = _2214.x;
        outAlbedo.y = _2214.y;
        outAlbedo.z = _2214.z;
        outAlbedo.w = clamp(1.0 - (1.0 - (exp(-color.w) * _555.raymarch_params.opacity)), 0.0, 1.0);
        vec2 param_16 = vec2(gl_FragCoord.xy);
        vec3 view_direction_1 = get_view_direction(param_16);
        vec3 world_1 = (_1080.transform_params.mViewInv * vec4(view_direction_1 * max_depth, 1.0)).xyz;
        float d_1 = length(_1080.transform_params.vCameraPosition - world_1);
    }
    else
    {
        if (_555.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _2277 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _2277.x;
            outAlbedo.y = _2277.y;
            outAlbedo.z = _2277.z;
        }
        else
        {
            outAlbedo.w = 1.0;
            discard;
        }
    }
}

 