#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct GlowParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec3 threshold;
    float _pad0;
    vec3 color;
    float _pad1;
    float iteration;
};

layout(set = 1, binding = 1, std140) uniform GlowParamsBuffer
{
    GlowParams glow_params;
} _24;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;
layout(set = 1, binding = 3) uniform sampler2D s_texture1;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 pxl = max(texelFetch(s_texture0, ivec2(vTexcoord0 * _24.glow_params.resolution), 0), vec4(0.0));
    vec4 glow = max(texture(s_texture1, vTexcoord0), vec4(0.0)) * vec4(_24.glow_params.color, 1.0);
    outColor = pxl + glow;
}

 