#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct VtxData
{
    float px;
    float py;
    float pz;
    float nx;
    float ny;
    float nz;
    float cr;
    float cg;
    float cb;
    float ca;
    float pad2_1;
    float pad1_1;
};

struct Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vsColor;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InVertexBuffer
{
    VtxData verts[];
} indata;

layout(set = 0, binding = 2, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _88;

layout(location = 0) out Vertex vtx_output;

void main()
{
    int vidx = gl_VertexIndex / 2;
    float offset_factor = float(gl_VertexIndex & 1);
    vec3 vInstPosition = vec3(indata.verts[vidx].px, indata.verts[vidx].py, indata.verts[vidx].pz);
    vec3 vInstPrevPosition = vec3(indata.verts[vidx].cr, indata.verts[vidx].cg, indata.verts[vidx].cb);
    vInstPosition += (((vInstPrevPosition - vInstPosition) * offset_factor) * 55.0);
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec4 vPos1 = vec4(pos, 1.0);
    vec4 vPos;
    vPos.x = dot(_88.transform_params.mModelView[0], vPos1);
    vPos.y = dot(_88.transform_params.mModelView[1], vPos1);
    vPos.z = dot(_88.transform_params.mModelView[2], vPos1);
    vPos.w = 1.0;
    vtx_output.vWorldPos = (_88.transform_params.mModel * vPos1).xyz;
    vtx_output.vWorldNorm = vec3(1.0);
    vtx_output.vNorm = vec3(1.0);
    vPos = _88.transform_params.mProjection * vPos;
    gl_Position = vPos;
    vtx_output.vCoords = vPos.xyz;
    vtx_output.vsColor = vec4(indata.verts[vidx].ca);
}

 