/**
 * SPRAK - operator digital festival 0117
 * FL YANG 2026
 * Licensed under Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)
 * https://creativecommons.org/licenses/by-nc-sa/4.0/
 */

let sparks = [];
let maxSparks = 3000;

let pg;
let mode = 0;
let emitter;

let lastSwitch = 0;
let switchInterval = 300;

let colors = [];

function setup() {
  createCanvas(windowWidth, windowHeight);
  
  emitter = createVector(width / 2, height / 2);
  
  resetPG();
  initColors();
  
  updateBlendMode();
}

function draw() {
  pg.background(0);

  let t = millis() * 0.0005;
  
  emitter.x = width / 2 + noise(t) * 200 - 100;
  emitter.y = height / 2 + noise(t + 10) * 200 - 100;

  spawnSparks(emitter.x, emitter.y, 10);

  for (let i = sparks.length - 1; i >= 0; i--) {
    let s = sparks[i];
    s.update();
    s.show(pg);
    
    if (s.isDead()) {
      sparks.splice(i, 1);
    }
  }

  image(pg, 0, 0, width, height);

  if (millis() - lastSwitch > switchInterval) {
    mode = (mode + 1) % 2;
    updateBlendMode();
    lastSwitch = millis();
  }
}

function spawnSparks(x, y, amount) {
  for (let i = 0; i < amount; i++) {
    if (sparks.length < maxSparks) {
      sparks.push(new Spark(x, y));
    }
  }
}

class Spark {
  constructor(x, y) {
    this.pos = createVector(x + random(-8, 8), y + random(-8, 8));
    
    let angle = random(TWO_PI);
    let speed = random(10, 30);
    
    this.vel = p5.Vector.fromAngle(angle).mult(speed);
    this.acc = p5.Vector.random2D().mult(0.05);
    
    this.lifespan = mode === 0 ? 600 : 1000;
    this.color = random(colors);
    this.size = random(40);
  }

  update() {
    this.vel.add(this.acc);
    this.vel.mult(0.99);
    this.pos.add(this.vel);
    this.lifespan -= 10;
  }

  show(pg) {
    let a = this.lifespan;
    let r = red(this.color);
    let g = green(this.color);
    let b = blue(this.color);

    if (mode === 0) {
      pg.stroke(r, g, b, a * 0.05);
      pg.strokeWeight(this.size * 0.5);
      pg.line(this.pos.x, this.pos.y, this.pos.x - this.vel.x * 0.5, this.pos.y - this.vel.y * 0.5);

      pg.stroke(r, g, b, a * 0.1);
      pg.strokeWeight(this.size * 1);
      pg.line(this.pos.x, this.pos.y, this.pos.x - this.vel.x * 0.8, this.pos.y - this.vel.y * 0.8);

      pg.stroke(r, g, b, a * 0.25);
      pg.strokeWeight(this.size * 2);
      pg.line(this.pos.x, this.pos.y, this.pos.x - this.vel.x, this.pos.y - this.vel.y);
    } else {
      pg.stroke(r, g, b, a * 0.4);
      pg.strokeWeight(this.size * 2);
      pg.line(this.pos.x, this.pos.y, this.pos.x - this.vel.x, this.pos.y - this.vel.y);
    }
  }

  isDead() {
    return this.lifespan < 0;
  }
}

function updateBlendMode() {
  blendMode(mode === 0 ? DIFFERENCE : OVERLAY);
}

function initColors() {
  colors = [
    color(255), 
    color(255, 240, 160), 
    color(255, 180, 60)
  ];
}

function resetPG() {
  pg = createGraphics(width, height);
  pg.pixelDensity(0.1);
  pg.clear();
}

function windowResized() {
  resizeCanvas(windowWidth, windowHeight);
  resetPG();
}