
type
  recinfo     = record
  text        : string[88]
  cmd1        : string
  cmd2        : string
  cmd3        : string
  cmd4        : string
end

var done 	  : boolean = false
var fp,ini    : file
var ch		  : char
var itext     : string
var xtext     : string

var top,bar   : longint = 1
var len,idata : longint = 1
var loc       : longint = 1

var ilist	  : array [1..500] of string[100]
var iconf     : array [1..4] of longint
var xinfo     : recinfo

function data_keys (tag:string;key:char) : char
begin
  case tag of
	'keys':  if isarrow then begin
			    case key of
				  #71:  begin					// home
						  top := 1
						  bar := 1
						end
				  #72:  begin					// up-arrow
						  if bar > 1 then
						    bar := bar - 1
						  else begin
						    bar := 1
							if top > 1 then
							  top := top - 1
						  end
						end
			  #73,#75:  begin					// pgup and left-arrow
						  if top - len > 0 then begin
						    top := top - len
						  end else begin
						    top := 1
							bar := 1
						  end
						end
			  #77,#81:  begin					// right-arrow and pgdn
						  if idata > len then
						    if top + len < idata - len then begin
							  top := top + len
							end else begin
							  top := idata - len
							  bar := len
							end
						end
				  #79:  begin					// end
						  if idata > len then begin
						    top := idata - len
							bar := len
						  end
						end
				  #80:  begin					// down-arrow
						  if bar + top < idata then begin
						    bar := bar + 1
							if bar > len then begin
							  bar := len
							  top := top + 1
							end
						  end
						end
				end
			  end else begin
			    data_keys := lower(key)
			  end
  end
end

function data_read (fn:string;i:integer) : boolean
begin
  data_read := false
  
  fassign(fp,fn,66)
   freset(fp)
  if ioresult = 0 then begin
    fseek(fp,(i-1)*sizeof(xinfo))
	if not feof(fp) then begin
	  fread(fp,xinfo,sizeof(xinfo))
	  data_read := true
	end
	fclose(fp)
  end
end

function read_conf (tag:string) : boolean
var key,val   : string
begin
  read_conf := false
  
  if fileexist(tag) then begin
	fassign(ini,tag,66)
	 freset(ini)
	
	while not feof(ini) do begin
	  freadln(ini,itext)
	  
	  key := lower  (wordget(1,itext,'='))
	  val := wordget(2,itext,'=')
	  
	  case key of
		'xpos' : iconf[1] := str2int(val)
		'ypos' : iconf[2] := str2int(val)
		'ylen' : iconf[3] := str2int(val)
		'tlen' : iconf[4] := str2int(val)
		'high' : iconf[5] := str2int(val)
		'_low' : iconf[6] := str2int(val)
	  end
	end
	fclose(ini)
	read_conf := true
  end else
    write('|#B#1#12#info# could not find your config file : exiting #')
end

function save_data (tag:string)
var key,val   : string
begin
  if fileexist(tag+'.ini') then begin
    fassign(ini,tag+'.ini',66)
	 freset(ini)
	
	if fileexist(tag+'.tmp') then
	   fileerase(tag+'.tmp')
	
	while not feof(ini) do begin
	  freadln(ini,itext)
	  
	  key := lower  (wordget(1,itext,'='))
	  val := wordget(2,itext,'=')
	  
	  case key of
	    'text':  ilist[1] := val
		'cmd1':  ilist[2] := val
		'cmd2':  ilist[3] := val
		'cmd3':  ilist[4] := val
		'cmd4':  begin
				   ilist[5] := val
				   
				   while data_read(tag+'.tmp',len) do
				     len := len + 1
				   
				   xinfo.text := ilist[1]
				   xinfo.cmd1 := ilist[2]
				   xinfo.cmd2 := ilist[3]
				   xinfo.cmd3 := ilist[4]
				   xinfo.cmd4 := ilist[5]
				   
				   fassign(fp,tag+'.tmp',66)
				    freset(fp)
				   if ioresult <> 0 then
				     frewrite(fp)
				    fseek(fp,(len-1)*sizeof(xinfo))
				   fwrite(fp,xinfo,sizeof(xinfo))
				   fclose(fp)
				 end
	  end
	end
	fclose(ini)
	
	 filecopy(tag+'.tmp',tag+'.dat')
	fileerase(tag+'.tmp')
  end
end
