
//
// Paging Module v1.4 (Linux) [Mystic]
// 
// Includes options for
// - Text Messages
// - Audio Playback
// - Sysop availability status message
// - Login Alert (audio and/or text)
// - Email Notifications
// - Emergency Chat Override
// - Blacklist
// - Customizing Options
//
//
// DEVELOPED / SUPPORT
//
// CLUTCH BBS
// Sysop: niter3
// Telnet: clutch.darktech.org
// URL: http://clutch.darktech.org
// Developer: n3! (niter3)
// Alpha Tester: (caphood-Hawk Hubbard, Necromaster, maddog, Nighthawk, themadtux)
//
// NOTES / TO-DO:
//
// - Update the mail procedure and change "sysop_name" to the name of the sysop.
// - Review and update the CONFIG SECTION to your liking. Out of respect, please leave the version number in place for support
//
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING (Text)
//
// To get a status of the sysop availability, add the following menu item.
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging page_text
// 
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING (Audio)
//
// To use audio paging, set the menu command as follows
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging page_audio
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING (Text & Audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging page_all
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE LOGIN ALERT (Text)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging alert_text
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE LOGIN ALERT (Audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging alert_audio
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE LOGIN ALERT (Text & Audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging alert_all
//
// ------------------------------------------------------------------------------------------------
//
// SYSOP STATUS MESSAGE
//
// To get a status of the sysop availability, add the following menu item.
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging status
// 


Uses USER
Uses CFG

Begin

Var MyFile : file;
Var MyFile2 : file;
Var blfile : file;
Var blfile_tmp : file;
Var user : string;
Var Str : string;
Var time : string;         
Var temp_time : string;
Var cstart : string
Var cend : string
Var cend_real : integer
Var avail : string
Var avail_bl : string
Var tz : string
Var ver : string
Var node : string
Var bbsname : string
Var ip : string
Var email : string
Var ansi : string
Var prbarloc : string
Var prbarlength : string
Var prbarbottom : string
Var prbarcolor : string
Var prtxtcolor : string
Var prbarcur : string
Var prbarclear : string
Var anibarloc : string
Var anibarbg : string
Var anibarfg : string
Var snd_page : string
Var snd_alert : string
Var sysoppage_msg : string
Var sysopout_msg : string
Var sysopinstatus_msg : string
Var sysopoutstatus_msg : string
Var sysopmail_msg : string
Var method_text : string
Var method_audio : string
Var method_all : string
Var Stremerg : string
Var emergpass : string
Var emergyesno_msg : string
Var emergpass_msg : string
Var emergincorrect_msg : string
Var lines : integer
Var counter : integer
Var ar1 : Array[1..15] of String

GetThisUser

cstart := int2str(cfgchatstart)
cend := int2str(cfgchatend)
cend_real := cfgchatend
cend_real := cend_real - 1

//-------------------------------------------------------------------------------$
// CONFIG SECTION

ansi := 'cl_paging.ans'													// Ansi File to Use
snd_page := 'axelf.mp3'													// Paging MP3 to use
snd_alert := 'alert.mp3'												// Alert MP3 to use 
tz := 'est'														// Timezone region ***
email := '0'														// E-mail Notification - 1 = receive an email upon page
avail := '|08|[Y11|[X04|16|08chat reason?|08|[Y11|[X53|16|08availability: |03' + cstart + '-' + cend + '|08 ' + tz + '' // Availability location
avail_bl := '|08|[Y11|[X04|16|08chat reason?|08|[Y11|[X53|16|08availability: |0324-24 |08' + tz + ''			// Availability location - BLACKLIST Time
ver := '|[Y08|[X71|16|08v1.4'												// Version Location and Information
method_text := '|08|[Y08|[X54< |11text|08 / |08audio |08>'								// Page Method String
method_audio := '|08|[Y08|[X54< |08text|08 / |11audio |08>'								// Page Method String
method_all := '|08|[Y08|[X54< |11text|08 / |11audio |08>'								// Page Method String
prbarloc := '|[Y10|[X01|16|08:'												// Prompt Bar Location
prbarcur := '|[Y10|08:|15|19'												// Prompt Bar Cursor location
prbarlength := '|$D75 |16|08:'												// Prompt Bar Length
prbarcolor := '|19'													// Prompt Bar Bar Color
prtxtcolor := '|15'													// Prompt Bar Text Color
prbarclear := '|[Y10|[X02|16|$D75 |15|08:'										// Prompt Bar Clear BG Color
prbarbottom := '|[Y11|[X01|08|16|$D76--'										// Prompt Bar Bottom
anibarloc := '|[Y15|[X25|08[|[X56|08]'											// Animation Bar Location, Bracket Location, and Bracket Color
anibarbg := '|03|[Y15|[X26|$D30'											// Animation Bar Background Color and Ascii
anibarfg := '|11|[Y15|[X26'												// Animation Bar Foreground Color and Animation Location
sysoppage_msg := '|[Y13|[X24|15p|07aging |15t|07he |15s|07ysop, |15p|07lease |15b|07e |15p|07atient'			// Sysop Page Message
sysopmail_msg : = '|CR|07message |15|SN|07?'										// Sysop Mail Message
sysopinstatus_msg := '|07The sysop is currently |19|15 IN |16|07 OUT|CR|CR|PA'						// Sysop IN Status Message
sysopoutstatus_msg := '|07The sysop is currently  IN |19|15 OUT |16|CR|CR|PA'						// Sysop OUT Status Message
sysopout_msg := '|[Y10|[X01|08|16:|15 |SN |07is currently unavailable.  |PA'						// Sysop Out Message
emergpass := 'password'												// Emergency Overide Password
emergyesno_msg := '|[Y13|07emergency page?'										// Emergency Yes/No Message
emergpass_msg := '|[Y15|07password:|19|$D15 |16|[X11|15|19'								// Emergency Prompt Message
emergincorrect_msg := '|CR|12Incorrect!|CR|CR|PA'									// Emergency Incorrect Password Message

//-------------------------------------------------------------------------------

ip := mci2str('UX')
bbsname := mci2str('BN')
node := int2str(Nodenum)
temp_time := timestr(datetime,false);    
time := temp_time;                   

	 If cfgchatend = 00 or cfgchatend = 0 then cfgchatend :=24
		delete(temp_time,3,1); 
		time := copy(temp_time,1,2);


// -----------------------------------------------------------------------------------------------------------
// Mail procedure  *** UPDATE BELOW TO REFLECT YOUR SYSOP NAME ***

procedure mail
begin

If inputny(sysopmail_msg); Then
menucmd('MW','/To:sysop_name /SUBJ:Page_Attempt'); // Update to reflect Sysop Name

end

// -----------------------------------------------------------------------------------------------------------
// Blacklist Availability Check

procedure black_avail
Begin

if user = '' Then
	writeln(avail)
else
	writeln(avail_bl)


End

//-------------------------------------------------------------------------------
// Page Animation

procedure page_anima
begin

writeln(sysoppage_msg)
writeln(anibarloc)
writeln(anibarbg)
writeln(anibarfg + '|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE|DE')

end

//------------------------------------------------------------------------------------------------------------
// Sysop IN status

procedure sysopINstatus
begin
CLRSCR

writeln(sysopinstatus_msg)

end


// ------------------------------------------------------------------------------------------------------------
// Sysop OUT status

procedure sysopOUTstatus
begin
CLRSCR

writeln(sysopoutstatus_msg)

end

// ------------------------------------------------------------------------------------------------------------
// Sysop E-Mail

procedure sysop_email
begin

	if email = '1' then

		fAssign (MyFile2, '/tmp/cl_email.txt', 66);
		frewrite(MyFile2)
                fwriteln(MyFile2, bbsname);	
		fwriteln(MyFile2, UserAlias);
		fwriteln(MyFile2, node);
		fwriteln(MyFile2, ip);
		fwriteln(MyFile2, Str);
		fclose(MyFile2)
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		
end


// -----------------------------------------------------------------------------------------------------------
// Sysop IN all - Audio and Text

procedure sysopINall
begin

CLRSCR
dispfile (ansi)
writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + prbarbottom + ver + avail)
writeln(method_all)

write(prbarcur)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		fAssign (MyFile, '/tmp/cl_temp.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, Str);
		fwriteln(MyFile, node);
                fwriteln(MyFile, bbsname);	
		fwriteln(MyFile, ip);
		fclose(MyFile)
	
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_page + '')
		sysop_email()
		page_anima()
		mail()

end


// -----------------------------------------------------------------------------------------------------------
// Sysop IN Audio

procedure sysopINaudio
begin

CLRSCR
dispfile (ansi)

writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + prbarbottom + ver + avail)
writeln(method_audio)


write(prbarcur)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_page + '')
		sysop_email()
		page_anima()
		mail()
end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop IN text

procedure sysopINtext
begin

CLRSCR
dispfile (ansi)

writeln(prbarloc + prbarcolor + prtxtcolor + prbarlength + prbarbottom + ver + avail)
writeln(method_text)

write(prbarcur)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		fAssign (MyFile, '/tmp/cl_temp.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, Str);
	        fwriteln(MyFile, node);
	        fwriteln(MyFile, bbsname);
		fwriteln(MyFile, ip);
		fclose(MyFile)
			
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		sysop_email()
		page_anima()
		mail()
end

// ------------------------------------------------------------------------------------------------------------------------
// Emergency Page - Select

procedure sysop_emerg_select
begin

Case Upper(ParamStr(1)) of
	'PAGE_TEXT'   : sysopintext;
	'PAGE_AUDIO'  : sysopinaudio;
	'PAGE_ALL'    : sysopinall;
end


end

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Emergency Page

procedure sysop_emerg

begin

write(emergpass_msg)
Stremerg := Input (15, 15, 1, '')

If Stremerg = emergpass Then
	sysop_emerg_select
Else If stremerg <> emergpass Then
	writeln(emergincorrect_msg)
	halt

end


// -----------------------------------------------------------------------------------------------------------------------
// Sysop OUT

procedure sysopOUT
begin

CLRSCR
dispfile (ansi)

writeln(prbarloc + prbarcolor + prtxtcolor + prbarclear + prbarbottom + ver + avail)
black_avail
writeln('|08|[Y08|[X54< |08text|08 / |08audio |08>')
writeln(sysopout_msg)
If inputny(emergyesno_msg); Then
	sysop_emerg

mail()	
end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Audio

Procedure sysop_alert_audio
begin

		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_alert + '')

end

// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert Text

Procedure sysop_alert_text
begin



		fAssign (MyFile, '/tmp/cl_alert.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, bbsname);
		fwriteln(MyFile, node);
		fwriteln(MyFile, ip);
		fclose(MyFile)
		
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')


end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop Alert ALL

Procedure sysop_alert_all
begin


		fAssign (MyFile, '/tmp/cl_alert.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, bbsname);
		fwriteln(MyFile, node);
		fwriteln(MyFile, ip);
		fclose(MyFile)
		
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')

		menucmd('DD','sudo -b mpg123 -q ' + CFGSYSPATH + 'scripts/' + snd_alert + '')


end

// ------------------------------------------------------------------------------------------------------------------------
// Starts Sysop IN text

Procedure sysop_page_text
Begin

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINtext
	Else
		sysopOUT

End


//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN audio

procedure sysop_page_audio
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINaudio
        Else
		sysopOUT

end


//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN all

procedure sysop_page_all
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINall
        Else
		sysopOUT

end


// ------------------------------------------------------------------------------------------------------------
// Starts status message

procedure sysop_status
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cend_real) then
		sysopINstatus
        Else
		sysopOUTstatus

end


// ------------------------------------------------------------------------------------------------------------
// ERROR MESSAGE

procedure error
begin

CLRSCR
writeln('|12ERROR!|CR|CR|07Please configure the following options.|CR|CRPage_Text - Text Message|CRPage_Audio - Audio Playback|CRPage_All - Text Messsage & Audio playback')
writeln('Alert_Text - Text when somebody logs in|CRAlert_Audio - Alert via audio when somebody logs in|CRAlert_All - Alert via text & audio when somebody logs in')
writeln('Status - Sysop Availability Message|CR|CRIn order to receive an email. Set the variable "email" to 1 in cl_paging.mps.')
writeln('|CR|PA')
end


// ------------------------------------------------------------------------------------------------------------
// Blacklist Pass


procedure black_pass
begin

counter := lines

Case Upper(ParamStr(1)) of
	'PAGE_TEXT'   : sysop_page_text;
	'PAGE_AUDIO'  : sysop_page_audio;
	'PAGE_ALL'    : sysop_page_all;
	'STATUS'      : sysop_status;
end

end

// ------------------------------------------------------------------------------------------------------------
// Blacklist Deny

procedure black_deny
begin

counter := lines

Case Upper(ParamStr(1)) of
	'PAGE_TEXT'   : sysopout;
	'PAGE_AUDIO'  : sysopout;
	'PAGE_ALL'    : sysopout;
	'STATUS'      : sysopOUTstatus;
end




end

// ------------------------------------------------------------------------------------------------------------
// Blacklist Checker

procedure check_blacklist
Begin

lines := 100
counter := 0

        fAssign (blfile, CFGSYSPATH + '/data/cl_blacklist.txt', 20);
        freset (blfile)

        While counter < lines Do Begin

                        counter := counter + 1
                        freadln(blfile, ar1[counter])
        end
	fclose(blfile)



        counter := 0
        while counter < lines Do Begin

                        counter := counter + 1
			If UserAlias = ar1[counter] Then
				fAssign (blfile_tmp, CFGSYSPATH + '/data/cl_blacklist_tmp.txt', 20);
				frewrite(blfile_tmp)
				fwriteln(blfile_tmp, UserAlias)
				freset(blfile_tmp)
				freadln(blfile_tmp, user)
				fclose(blfile_tmp)
        end
	
	menucmd('DD','rm -f ' + CFGSYSPATH + '/data/cl_blacklist_tmp.txt')

	If user = UserAlias Then
		black_deny()
	else	
		black_pass()

end

// ------------------------------------------------------------------------------------------------------------
// ::: Main Program :::

Case Upper(ParamStr(1)) of

	'PAGE_TEXT'   : check_blacklist;
	'PAGE_AUDIO'  : check_blacklist;
	'PAGE_ALL'    : check_blacklist;
	'ALERT_AUDIO' : sysop_alert_audio;
	'ALERT_TEXT'  : sysop_alert_text;
	'ALERT_ALL'   : sysop_alert_all;	
	'STATUS'      : check_blacklist;

Else
	error

end





End
