/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <alloc.h>
#include <dos.h>
#include <mem.h>
#include <string.h>

/*

Frontier C SDK routines - maybe not necessary



*/

void genInterrupt(int function, int data1, int data2, int data3)
{
asm mov ax, function
asm mov bx, data1
asm mov cx, data2
asm mov dx, data3
asm int 0x83
}

/*



*/

void frontier_print(char *Str, int To)
{
genInterrupt(0x0001, FP_SEG(Str), FP_OFF(Str), To);
}

/*



*/

long frontier_carrierSpeed(void)
{
long l;
genInterrupt(0x0002, FP_SEG(&l), FP_OFF(&l), 0);
return l;
}

/*



*/

void frontier_runPPE(char *Str)
{
genInterrupt(0x0003, FP_SEG(Str), FP_OFF(Str), 0);
}

/*



*/

void frontier_dispFile(char *Str)
{
genInterrupt(0x0004, FP_SEG(Str), FP_OFF(Str), 0);
}

/*



*/

void frontier_runEXEModule(char *Str)
{
genInterrupt(0x0005, FP_SEG(Str), FP_OFF(Str), 0);
}

/*



*/

void frontier_initModule(void)
{
if (getvect(0x83) == NULL)
	{
    puts("Project: Frontier - Executable Module\n");
    exit(-1);
    }
}

