/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

Multinode & floating nodes functions

*/

#include <dos.h>
#include <time.h>
#include <sys/types.h>
#include <share.h>
#include <stdio.h>

#include "..\com\net.h"
#include "..\com\sharing.h"
#include "..\com\system.h"
#include "..\com\pcbdat.h"

netStruct nodeData;
FILE *nodeFile;

void createNodeFile(void)
{
time_t t;
struct time d_time;
struct date d_date;

nodeFile = fopen_share(nodeFilename, "w+b", SH_DENYRW);
if (nodeFile == NULL)
	return;

getdate(&d_date);
gettime(&d_time);

t = dostounix(&d_date, &d_time);

nodeData.attention=0;
nodeData.mailWaiting=0;
nodeData.pager=0;
nodeData.channel=0;
strcpy(nodeData.userName, user.FullName);
strcpy(nodeData.userCity, user.City);
*nodeData.userOperation = 0;
*nodeData.message = 0;
nodeData.lastPing = t;
nodeData.outToDos = 0;
nodeData.nodeStatus = ' ';

fseek(nodeFile, 0, SEEK_SET);
fwrite(&nodeData, sizeof(nodeData), 1, nodeFile);
fclose(nodeFile);
}

void deleteNodeFile(void)
{
unlink(nodeFilename);
}

void updateNodeFile(void)
{
time_t t;
struct time d_time;
struct date d_date;

nodeFile = fopen_share(nodeFilename, "w+b", SH_DENYRW);

if (nodeFile == NULL)
	return;

fseek(nodeFile, 0, SEEK_SET);
fread(&nodeData, sizeof(nodeData), 1, nodeFile);

getdate(&d_date);
gettime(&d_time);

t = dostounix(&d_date, &d_time);

//nodeData.attention=0;
//nodeData.mailWaiting=0;
//nodeData.pager=0;
//nodeData.channel=0;
strcpy(nodeData.userName, user.FullName);
strcpy(nodeData.userCity, user.City);
nodeData.lastPing = t;
nodeData.outToDos = 0;

fseek(nodeFile, 0, SEEK_SET);
fwrite(&nodeData, sizeof(nodeData), 1, nodeFile);
fclose(nodeFile);
}

void getNetData(int node, netStruct *s)
{
FILE *f;

fnsplit(netFilesPath, tmpDrive, tmpDir, NULL, NULL);
sprintf(tmpExt, ".%03d", node);
fnmerge(tmpStr, tmpDrive, tmpDir, "NODE", tmpExt);

if (access(tmpStr,0) || (f = fopen_share(tmpStr, "rb", SH_DENYWR)) == NULL)
    {
	s->attention=0;
	s->mailWaiting=0;
	s->pager=0;
	s->channel=0;
	strcpy(s->userName, user.FullName);
	strcpy(s->userCity, user.City);
	*s->userOperation = 0;
	*s->message = 0;
	s->nodeStatus = 0;
    return;
    }

fseek(f, 0, SEEK_SET);
fread(s, sizeof(netStruct), 1, f);

fclose(f);
}

void nodeGetUserName(int node, char *buffer)
{
netStruct S;
getNetData(node, &S);
strcpy(buffer, S.userName);
}

void nodeGetUserCity(int node, char *buffer)
{
netStruct S;
getNetData(node, &S);
strcpy(buffer, S.userCity);
}

void nodeGetUserOperation(int node, char *buffer)
{
netStruct S;
getNetData(node, &S);
strcpy(buffer, S.userOperation);
}

char nodeGetStatus(int node)
{
netStruct S;
getNetData(node, &S);
return S.nodeStatus;
}

void nodeWriteData(int n, char *nodeStatus, char *userName, char *userCity, char *userOp, char *message)
{
FILE *f;
netStruct s;

fnsplit(netFilesPath, tmpDrive, tmpDir, NULL, NULL);
sprintf(tmpExt, ".%03d", n);
fnmerge(tmpStr, tmpDrive, tmpDir, "NODE", tmpExt);

if (access(tmpStr,0))
	return;

f = fopen_share(tmpStr, "w+b", SH_DENYRD);
if (f == NULL)
	return;

fseek(f, 0, SEEK_SET);
fread(&s, sizeof(netStruct), 1, f);

s.nodeStatus = *nodeStatus;
strncpy(s.userName, userName, 25);
strncpy(s.userCity, userCity, 25);
strncpy(s.userOperation, userOp, 49);
strncpy(s.message, message, 79);
s.userName[25] = 0;
s.userCity[25] = 0;
s.userOperation[49] = 0;
s.message[79] = 0;

fseek(f, 0, SEEK_SET);
fwrite(&s, sizeof(netStruct), 1, f);
fclose(f);
}

