/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*

PCBOARD.DAT functions

*/

#include <alloc.h>
#include <process.h>
#include <stdio.h>
#include "..\lang\fortify.h"
#include "..\com\system.h"
#include "..\ppc\profile\profile.h"

char *sysopDispName;
char *sysopSystemPass;
bool sysopUseRealName;
bool sysopGraphMode;
int sysopLevel;
char *helpFilesPath;
char *secFilesPath;
char *userIndexFilesPath;
char *usersFile;
char *callersLogFile;
char *downloadTxtFile;
long initialPortSpeed;
long lockPortSpeed;
bool disableCTSRTS;
bool disable3MinScrClear;
bool disableHiAsciiFilter;
bool disableDosPassCheck;
bool allowEscInMsgs;
bool allowCCMsgs;
bool validateTOInMsgs;
bool enforceDailyTime;
int keyboardTimeout;
int node;
int networkTimeoutError;
char *boardName;
char *functionKey1;
char *functionKey2;
char *functionKey3;
char *functionKey4;
char *functionKey5;
char *functionKey6;
char *functionKey7;
char *functionKey8;
char *functionKey9;
char *functionKey10;
char *functionKey11;
char *functionKey12;
bool leaveDTRUpDos;
int scrollBackLines;
bool allowLocalDropDos;
char *tempFilesPath;
int expiredSecurity;
int levelUserAgree;
bool forceNo16550;
bool force16550;
int defaultColor;
char *netFilesPath;
int floatNodes;
int PCBcompat;
int minScrClear;
int disableScrSaveCarrier;
int autoReleaseTime;
int oldIndexes;
char comPort[15];
int comIrq;
int comBase;
int firstWarning;
int secondWarning;
// Frontier.DAT

int far frtDatVersion;
char *systemPPEPath;
char *tpaPath;
char far iniFile[256];
char far setupSection[]="Setup";
char far pathsSection[]="Paths";
char far switchsSection[]="Switches";
char far fkeysSection[]="FunctionKeys";
char far levelsSection[]="Levels";
char far nodeSection[15];

char *getProfileAlloc(char *section, char *entry, char *def, char *file)
{
char *buffer;
getProfileString(section, entry, def, tmpStr, 2048, file);
buffer=(char *)malloc(strlen(tmpStr)+1);
strcpy(buffer, tmpStr);
return buffer;
}

void readPcbDat(void)
{
FILE *dat;
FILE *frt;

if (floatNodes)
	strcpy(nodeSection, "FloatNode");
else
	sprintf(nodeSection, "Node%d", node);

frtDatVersion = getProfileInt( setupSection, "Version", 1, iniFile);
sysopDispName = getProfileAlloc(setupSection, "SysopName", "SYSOP", iniFile);
sysopSystemPass=getProfileAlloc(setupSection, "SysopSystemPwd", "", iniFile);
sysopUseRealName=getProfileInt(switchsSection, "SysopUseRealName", 0, iniFile);
firstWarning=getProfileInt(switchsSection, "FirstAutoOffWarning", 2, iniFile);
secondWarning=getProfileInt(switchsSection, "SecondAutoOffWarning", 1, iniFile);
sysopGraphMode=getProfileInt(switchsSection, "SysopGraphMode", 1, iniFile);
sysopLevel = getProfileInt(switchsSection, "SysopLevel", 200, iniFile);
/*levelReadAllComments=getProfileInt(switchsSection, "LevelReadAllComments", sysopLevel, iniFile);
levelReadAllMail = getProfileInt(switchsSection, "LevelReadAllMail", sysopLevel, iniFile);
levelCopyMoveMsg = getProfileInt(switchsSection, "LevelCopyMoveMsg", sysopLevel, iniFile);*/
/*levelSysFunc1 = getProfileInt(switchsSection, "LevelSysopFunction1", sysopLevel, iniFile);
levelSysFunc2 = getProfileInt(switchsSection, "LevelSysopFunction2", sysopLevel, iniFile);
levelSysFunc3 = getProfileInt(switchsSection, "LevelSysopFunction3", sysopLevel, iniFile);
levelSysFunc4 = getProfileInt(switchsSection, "LevelSysopFunction4", sysopLevel, iniFile);
levelSysFunc5 = getProfileInt(switchsSection, "LevelSysopFunction5", sysopLevel, iniFile);
levelSysFunc6 = getProfileInt(switchsSection, "LevelSysopFunction6", sysopLevel, iniFile);
levelSysFunc7 = getProfileInt(switchsSection, "LevelSysopFunction7", sysopLevel, iniFile);
levelSysFunc8 = getProfileInt(switchsSection, "LevelSysopFunction8", sysopLevel, iniFile);
levelSysFunc9 = getProfileInt(switchsSection, "LevelSysopFunction9", sysopLevel, iniFile);
levelSysFunc10 = getProfileInt(switchsSection, "LevelSysopFunction10", sysopLevel, iniFile);
levelSysFunc11 = getProfileInt(switchsSection, "LevelSysopFunction11", sysopLevel, iniFile);
levelSysFunc12 = getProfileInt(switchsSection, "LevelSysopFunction12", sysopLevel, iniFile);
levelSysFunc13 = getProfileInt(switchsSection, "LevelSysopFunction13", sysopLevel, iniFile);
levelSysFunc14 = getProfileInt(switchsSection, "LevelSysopFunction14", sysopLevel, iniFile);*/
//levelSysFunc15 = readLong(dat);
helpFilesPath=getProfileAlloc(pathsSection, "HelpPath", "HELP\\", iniFile);
secFilesPath=getProfileAlloc(pathsSection, "SecurityPath", "SEC\\", iniFile);
//getProfileAlloc(nodeChatFilesPath, setupSection, "NodeChatPath", "CHAT\\", iniFile);
//getProfileAlloc(pcbTextPath, pathsSection, "PcbTextPath", "TEXT\\", iniFile);
userIndexFilesPath=getProfileAlloc(pathsSection, "UserIndexPath", "USERS\\", iniFile);
usersFile=getProfileAlloc(pathsSection, "UsersFile", "USERS\\USERS", iniFile);

downloadTxtFile=getProfileAlloc(pathsSection, "DownloadTxt", "DOWNLOAD.TXT", iniFile);
initialPortSpeed = getProfileInt(nodeSection, "InitialPortSpeed", 38400, iniFile);
lockPortSpeed = getProfileInt(nodeSection, "LockPortSpeed", 0, iniFile);
disableCTSRTS = getProfileInt(nodeSection, "DisableCTSRTS", 0, iniFile);
disable3MinScrClear = getProfileInt(switchsSection, "DisableScreenSaver", 0, iniFile);
disableHiAsciiFilter = getProfileInt(switchsSection, "DisableHiAsciiFilter", 1, iniFile);
disableDosPassCheck = getProfileInt(switchsSection, "DosPassCheck", 1, iniFile); // a implementer
allowEscInMsgs = getProfileInt(switchsSection, "EscInMsgs", 1, iniFile); // a implementer
allowCCMsgs = getProfileInt(switchsSection, "CCMsgs", 1, iniFile); // a implementer
validateTOInMsgs = getProfileInt(switchsSection, "TOInMsgs", 1, iniFile); // a implementer
enforceDailyTime = getProfileInt(switchsSection, "DailyTimes", 1, iniFile); // a implementer
// disableCTSDropWrite = readBool(dat); // a reflechir
keyboardTimeout = getProfileInt(setupSection, "KeyboardTimeout", 60, iniFile); // a implementer
//node = getProfileInt(setupSection, "Node", 1, iniFile);
//floatNodes = getProfileInt(setupSection, "FloatNodes", 0, iniFile);
networkTimeoutError = getProfileInt(nodeSection, "NetworkTimeoutError", 30, iniFile);
expiredSecurity = getProfileInt(levelsSection, "LevelExpired", 10, iniFile);
levelUserAgree = getProfileInt(levelsSection, "LevelUserAgree", 10, iniFile);
boardName=getProfileAlloc(setupSection, "BBSName", "", iniFile);
functionKey1=getProfileAlloc(fkeysSection, "FunctionKey1", "", iniFile);
functionKey2=getProfileAlloc(fkeysSection, "FunctionKey2", "", iniFile);
functionKey3=getProfileAlloc(fkeysSection, "FunctionKey3", "", iniFile);
functionKey4=getProfileAlloc(fkeysSection, "FunctionKey4", "", iniFile);
functionKey5=getProfileAlloc(fkeysSection, "FunctionKey5", "", iniFile);
functionKey6=getProfileAlloc(fkeysSection, "FunctionKey6", "", iniFile);
functionKey7=getProfileAlloc(fkeysSection, "FunctionKey7", "", iniFile);
functionKey8=getProfileAlloc(fkeysSection, "FunctionKey8", "", iniFile);
functionKey9=getProfileAlloc(fkeysSection, "FunctionKey9", "", iniFile);
functionKey10=getProfileAlloc(fkeysSection, "FunctionKey10", "", iniFile);
functionKey11=getProfileAlloc(fkeysSection, "FunctionKey11", "", iniFile);
functionKey12=getProfileAlloc(fkeysSection, "FunctionKey12", "", iniFile);
// timedEventActive = readBool(dat); // a reflechir - surement un _ppl_S_SSETEVENTTIME
// readString(timeBeginEvent, 6, dat);
// beforeEventMinutes = readLong(dat);
// noUploadBeforeEvent = readBool(dat);
// slideEventTime = readBool(dat);
// beforeEventStopDlMins = readLong(dat);
/*levelAbandon = readLong(dat);
levelBulletin = readLong(dat);
levelComment = readLong(dat);
levelDownload = readLong(dat);
levelEnter = readLong(dat);
levelFile = readLong(dat);
levelHelp = readLong(dat);
levelInit = readLong(dat);
levelJoin = readLong(dat);
levelKill = readLong(dat);
levelLocate = readLong(dat);
levelMode = readLong(dat);
levelNew = readLong(dat);
levelPage = readLong(dat);
levelPageLen = readLong(dat);
levelQScan = readLong(dat);
levelRead = readLong(dat);
levelScript = readLong(dat);
levelTProt = readLong(dat);
levelUpload = readLong(dat);
levelView = readLong(dat);
levelWrite = readLong(dat);
levelExpert = readLong(dat);
levelYourMail = readLong(dat);
levelZippy = readLong(dat);
levelOpen = readLong(dat);
levelChat = readLong(dat);
levelUserAgree = readLong(dat);
levelUserRefuse = readLong(dat);
levelUsers = readLong(dat);
levelWho = readLong(dat);
levelBatchXfer = readLong(dat);
levelAtcode = readLong(dat);
levelEditAny = readLong(dat);
levelEditYour = readLong(dat);
levelReadOnly = readLong(dat);
levelTest = readLong(dat);
levelBoardcast = readLong(dat);
levelViewPrivDir = readLong(dat);
levelGenericMsgs = readLong(dat);
levelEditMsgHdr = readLong(dat);
levelProtectMsg = readLong(dat);
levelOverwriteFiles = readLong(dat);
levelCopyMoveMsg2 = readLong(dat);
levelPackOutDate = readLong(dat);
levelSeeAllReturnReceipt = readLong(dat);*/
leaveDTRUpDos = getProfileInt(nodeSection, "LeaveDTRDos", 0, iniFile); // a implementer
scrollBackLines = getProfileInt(setupSection, "ScrollBackLines", 100, iniFile);
allowLocalDropDos = getProfileInt(setupSection, "LocalDropDos", 1, iniFile);
tempFilesPath = getProfileAlloc(pathsSection, "TempPath", "TEMP\\", iniFile);
netFilesPath = getProfileAlloc(pathsSection, "NetPath", "NET\\", iniFile);
forceNo16550 = getProfileInt(nodeSection, "ForceNo16550", 0, iniFile); // a implementer
force16550 = getProfileInt(nodeSection, "Force16550", 0, iniFile); // a implementer
defaultColor = getProfileInt(setupSection, "DefaultColor", 15, iniFile);
systemPPEPath=getProfileAlloc(pathsSection, "SystemPath", "SYSTEM\\", iniFile);
tpaPath=getProfileAlloc(pathsSection, "TPAPath", "TPA\\", iniFile);
nConfs = getProfileInt( setupSection, "MaxConfs", 1, iniFile);
autoReleaseTime = getProfileInt( switchsSection, "AutoReleaseTime", 0, iniFile);
PCBcompat = getProfileInt( switchsSection, "PCBCompatibility", 0, iniFile);
minScrClear = getProfileInt( setupSection, "ScrClearDelay", 0, iniFile);
disableScrSaveCarrier = getProfileInt( setupSection, "ScrClearDelay", 0, iniFile);
oldIndexes = getProfileInt( switchsSection, "OldIndexes", 0, iniFile);
getProfileString(nodeSection, "ComPort", "", comPort, 14, iniFile);
comIrq = getProfileInt(nodeSection, "ComIrq", 0, iniFile);
getProfileString(nodeSection, "ComBase", "", tmpStr, 2048, iniFile);
comBase = strtol(tmpStr, NULL, 16);

fclose(dat);
}

