/*

  This is a part of the Project Frontier's Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#pragma warn -pin

char far *Predef[0x19] = {
	  "",
	  "U_Expert",//           	 =    0x17;
	  "U_FSE",//           		 =    0x16;
	  "U_FSEP",//          		 =    0x15;
	  "U_Cls",//           	 	 =    0x14;
	  "U_ExpDate",//           	 =    0x13;
	  "U_Sec",//           		 =    0x12;
	  "U_PageLen",//           	 =    0x11;
	  "U_ExpSec",//           	 =    0x10;
	  "U_City",//           	 =    0x0F;
	  "U_BDPhone",//             =    0x0E;
	  "U_HVPhone",//             =    0x0D;
	  "U_Trans",//               =    0x0C;
	  "U_Cmnt1",//               =    0x0B;
	  "U_Cmnt2",//               =    0x0A;
	  "U_Pwd",//               	 =    0x09;
	  "U_Scroll",//              =    0x08;
	  "U_LongHDR",//             =    0x07;
	  "U_Def79",//               =    0x06;
	  "U_Alias",//               =    0x05;
	  "U_Ver",//          		 =    0x04;
	  "U_Addr",//         	     =    0x03;
	  "U_Notes",//               =    0x02;
	  "U_PwdExp",//              =    0x01;
	  "U_Account"//       	     =    0x00;
	  };

struct tFormat{
	char	*name;
	short	argMini;
	short	argMaxi;
	int		argType;
	int		nUsed;
};

struct uFormat{
	char	*name;
	short	argMini;
	short	argMaxi;
	int		nUsed;
};

int HiStatement = 0xE2;
int HiFunction = 0x11E;

char far *Type[18] = {
	  "Boolean",//            =    0x00;
	  "DWord",//              =    0x01;
	  "Date",//               =    0x02;
	  "EDate",//              =    0x03;
	  "Integer",//            =    0x04;
	  "Money",//              =    0x05;
	  "Real",//               =    0x06;
	  "String",//             =    0x07;
	  "Time",//               =    0x08;
	  "Byte",//               =    0x09;
	  "Word",//               =    0x0A;
	  "SByte",//              =    0x0B;
	  "Int",//                =    0x0C;
	  "BigStr",//             =    0x0D;
	  "Double",//             =    0x0E;
	  "Function",//           =    0x0F;
	  "Procedure"//           =    0x10;
      "DDate"//               =    0x11;
	  };

char far *UType[17] = {
	  "BOOLEAN",//            =    0x00;
	  "DWORD",//              =    0x01;
	  "DATE",//               =    0x02;
	  "EDATE",//              =    0x03;
	  "INTEGER",//            =    0x04;
	  "MONEY",//              =    0x05;
	  "REAL",//               =    0x06;
	  "STRING",//             =    0x07;
	  "TIME",//               =    0x08;
	  "BYTE",//               =    0x09;
	  "WORD",//               =    0x0A;
	  "SBYTE",//              =    0x0B;
	  "INT",//                =    0x0C;
	  "BIGSTR",//             =    0x0D;
	  "DOUBLE",//             =    0x0E;
	  "FUNCTION",//           =    0x0F;
	  "PROCEDURE"//           =    0x10;
	  };


tFormat far Statement[] = {

   "",              0,   0,  0,      0,  /* 0x0*/
   "End",           0,   0,  0x734,  0,  /* 0x1*/
   "Cls",           0,   0,  0x734,  0,  /* 0x2*/
   "ClrEol",        0,   0,  0x734,  0,  /* 0x3*/
   "More",          0,   0,  0x734,  0,  /* 0x4*/
   "Wait",          0,   0,  0x734,  0,  /* 0x5*/
   "Color ",        1,   1,  0x734,  0,  /* 0x6*/
   "Goto ",         1,   1,  0x956,  0,  /* 0x7*/
   "Let ",          2,   2,  0x8B7,  0,  /* 0x8*/
   "Print ",        1,   99, 0x734,  0,  /* 0x9*/
   "PrintLn ",      0,   99, 0x734,  0,  /* 0xA*/
   "If ",           1,   1,  0x14CC, 0,  /* 0xB*/ // ?2
   "ConfFlag ",     2,   2,  0x734,  0,  /* 0xC*/
   "ConfUnflag ",   2,   2,  0x734,  0,  /* 0xD*/
   "DispFile ",     2,   2,  0x734,  0,  /* 0xE*/
   "Input ",        2,   2,  0x7B5,  0,  /* 0xF*/
   "FCreate ",      4,   4,  0x734,  0,  /* 0x10*/
   "FOpen ",        4,   4,  0x734,  0,  /* 0x11*/
   "FAppend ",      4,   4,  0x734,  0,  /* 0x12*/
   "FClose ",       1,   1,  0x734,  0,  /* 0x13*/
   "FGet ",         2,   2,  0x7B5,  0,  /* 0x14*/
   "FPut ",         2,   99, 0x734,  0,  /* 0x15*/
   "FPutLn ",       1,   99, 0x734,  0,  /* 0x16*/
   "ResetDisp",     0,   0,  0x734,  0,  /* 0x17*/
   "StartDisp ",    1,   1,  0x734,  0,  /* 0x18*/
   "FPutPad ",      3,   3,  0x734,  0,  /* 0x19*/
   "Hangup",        0,   0,  0x734,  0,  /* 0x1A*/
   "GetUser",       0,   0,  0x734,  0,  /* 0x1B*/
   "PutUser",       0,   0,  0x734,  0,  /* 0x1C*/
   "DefColor",      0,   0,  0x734,  0,  /* 0x1D*/
   "Delete ",       1,   1,  0x734,  0,  /* 0x1E*/
   "DelUser",       0,   0,  0x734,  0,  /* 0x1F*/
   "AdjTime ",      1,   1,  0x734,  0,  /* 0x20*/
   "Log ",          2,   2,  0x734,  0,  /* 0x21*/
   "InputStr ",     6,   6,  0x7B5,  0,  /* 0x22*/
   "InputYN ",      3,   3,  0x7B5,  0,  /* 0x23*/
   "InputMoney ",   3,   3,  0x7B5,  0,  /* 0x24*/
   "InputInt ",     3,   3,  0x7B5,  0,  /* 0x25*/
   "InputCC ",      3,   3,  0x7B5,  0,  /* 0x26*/
   "InputDate ",    3,   3,  0x7B5,  0,  /* 0x27*/
   "InputTime ",    3,   3,  0x7B5,  0,  /* 0x28*/
   "Gosub ",        1,   1,  0x956,  0,  /* 0x29*/
   "Return",        0,   0,  0x734,  0,  /* 0x2A*/
   "PromptStr ",    5,   5,  0x7B5,  0,  /* 0x2B*/
   "DtrOn",         0,   0,  0x734,  0,  /* 0x2C*/
   "DtrOff",        0,   0,  0x734,  0,  /* 0x2D*/
   "CdChkOn",       0,   0,  0x734,  0,  /* 0x2E*/
   "CdChkOff",      0,   0,  0x734,  0,  /* 0x2F*/
   "Delay ",        1,   1,  0x734,  0,  /* 0x30*/
   "SendModem ",    1,   1,  0x734,  0,  /* 0x31*/
   "Inc ",          1,   1,  0x75F,  0,  /* 0x32*/
   "Dec ",          1,   1,  0x75F,  0,  /* 0x33*/
   "Newline",       0,   0,  0x734,  0,  /* 0x34*/
   "Newlines ",     1,   1,  0x734,  0,  /* 0x35*/
   "Tokenize ",     1,   1,  0x734,  0,  /* 0x36*/
   "GetToken ",     1,   1,  0x75F,  0,  /* 0x37*/
   "Shell ",        4,   4,  0x7B5,  0,  /* 0x38*/
   "DispText ",     2,   2,  0x734,  0,  /* 0x39*/
   "Stop",          0,   0,  0x734,  0,  /* 0x3A*/
   "InputText ",    4,   4,  0x7B5,  0,  /* 0x3B*/
   "Beep",          0,   0,  0x734,  0,  /* 0x3C*/
   "Push ",         1,   99, 0x734,  0,  /* 0x3D*/
   "Pop ",          1,   99, 0x75F,  0,  /* 0x3E*/
   "KbdStuff ",     1,   1,  0x734,  0,  /* 0x3F*/
   "Call ",         1,   1,  0x734,  0,  /* 0x40*/
   "Join ",         1,   1,  0x734,  0,  /* 0x41*/
   "Quest ",        1,   1,  0x734,  0,  /* 0x42*/
   "Blt ",          1,   1,  0x734,  0,  /* 0x43*/
   "Dir ",          1,   1,  0x734,  0,  /* 0x44*/
   "KbdFile ",      1,   1,  0x734,  0,  /* 0x45*/
   "Bye",           0,   0,  0x734,  0,  /* 0x46*/
   "Goodbye",       0,   0,  0x734,  0,  /* 0x47*/
   "Broadcast ",    3,   3,  0x734,  0,  /* 0x48*/
   "WaitFor ",      3,   3,  0x7B5,  0,  /* 0x49*/
   "KbdChkOn",      0,   0,  0x734,  0,  /* 0x4A*/
   "KbdChkOff",     0,   0,  0x734,  0,  /* 0x4B*/
   "OpText ",       1,   1,  0x734,  0,  /* 0x4C*/
   "DispStr ",      1,   1,  0x734,  0,  /* 0x4D*/
   "RdUNet ",       1,   1,  0x734,  0,  /* 0x4E*/
   "WrUNet ",       6,   6,  0x734,  0,  /* 0x4F*/
   "DoIntr ",       10,  10, 0x734,  0,  /* 0x50*/
   "VarSeg ",       2,   2,  0x78C,  0,  /* 0x51*/
   "VarOff ",       2,   2,  0x78C,  0,  /* 0x52*/
   "Poke ",         2,   2,  0x734,  0,  /* 0x53*/
   "PokeW ",        2,   2,  0x734,  0,  /* 0x54*/
   "VarAddr ",      2,   2,  0x75B,  0,  /* 0x55*/
   "AnsiPos ",      2,   2,  0x734,  0,  /* 0x56*/
   "Backup ",       1,   1,  0x734,  0,  /* 0x57*/
   "Forward ",      1,   1,  0x734,  0,  /* 0x58*/
   "FreshLine",     0,   0,  0x734,  0,  /* 0x59*/
   "WrUSys",        0,   0,  0x734,  0,  /* 0x5A*/
   "RdUSys",        0,   0,  0x734,  0,  /* 0x5B*/
   "NewPwd ",       2,   2,  0x7B5,  0,  /* 0x5C*/
   "OpenCap ",      2,   2,  0x7B5,  0,  /* 0x5D*/
   "CloseCap ",     0,   0,  0x734,  0,  /* 0x5E*/
   "Message ",      9,   9,  0x734,  0,  /* 0x5F*/
   "SaveScrn",      0,   0,  0x734,  0,  /* 0x60*/
   "RestScrn",      0,   0,  0x734,  0,  /* 0x61*/
   "Sound ",        1,   1,  0x734,  0,  /* 0x62*/
   "Chat",          0,   0,  0x734,  0,  /* 0x63*/
   "SPrint ",       1,   99, 0x734,  0,  /* 0x64*/
   "SPrintLn ",     0,   99, 0x734,  0,  /* 0x65*/
   "MPrint ",       1,   99, 0x734,  0,  /* 0x66*/
   "MPrintLn ",     0,   99, 0x734,  0,  /* 0x67*/
   "Rename ",       2,   2,  0x734,  0,  /* 0x68*/
   "Frewind ",      1,   1,  0x734,  0,  /* 0x69*/
   "PokeDw ",       2,   2,  0x734,  0,  /* 0x6A*/
   "DbgLevel ",     1,   1,  0x734,  0,  /* 0x6B*/
   "ShowOn",        0,   0,  0x734,  0,  /* 0x6C*/
   "ShowOff",       0,   0,  0x734,  0,  /* 0x6D*/
   "PageOn",        0,   0,  0x734,  0,  /* 0x6E*/
   "PageOff",       0,   0,  0x734,  0,  /* 0x6F*/
   "FSeek ",        3,   3,  0x734,  0,  /* 0x70*/
   "FFlush ",       1,   1,  0x734,  0,  /* 0x71*/
   "FRead ",        3,   3,  0x7B5,  0,  /* 0x72*/
   "FWrite ",       3,   3,  0x734,  0,  /* 0x73*/
   "FDefIn ",       1,   1,  0x734,  0,  /* 0x74*/
   "FDefOut ",      1,   1,  0x734,  0,  /* 0x75*/
   "FDGet ",        1,   1,  0x75F,  0,  /* 0x76 8A ?*/
   "FDPut ",        1,   99, 0x734,  0,  /* 0x77*/
   "FDPutLn ",      0,   99, 0x734,  0,  /* 0x78*/
   "FDPutPad ",     2,   2,  0x734,  0,  /* 0x79*/
   "FDRead ",       2,   2,  0x75F,  0,  /* 0x7A*/
   "FDWrite ",      2,   2,  0x734,  0,  /* 0x7B*/
   "AdjBytes ",     1,   1,  0x734,  0,  /* 0x7C*/
   "KbdString ",    1,   1,  0x734,  0,  /* 0x7D*/
   "Alias ",        1,   1,  0x734,  0,  /* 0x7E*/
   "Redim ",        1,   4,  0x836,  0,  /* 0x7F*/
   "Append ",       2,   2,  0x734,  0,  /* 0x80*/
   "Copy ",         2,   2,  0x734,  0,  /* 0x81*/
   "KbdFlush",      0,   0,  0x734,  0,  /* 0x82*/
   "MdmFlush",      0,   0,  0x734,  0,  /* 0x83*/
   "KeyFlush",      0,   0,  0x734,  0,  /* 0x84*/
   "LastIn ",       1,   1,  0x734,  0,  /* 0x85*/
   "Flag ",         1,   1,  0x734,  0,  /* 0x86*/
   "Download ",     1,   1,  0x734,  0,  /* 0x87*/
   "WrUSysDoor ",   1,   1,  0x734,  0,  /* 0x88*/
   "GetAltUser ",   1,   1,  0x734,  0,  /* 0x89*/
   "AdjDBytes ",    1,   1,  0x734,  0,  /* 0x8A*/
   "AdjTBytes ",    1,   1,  0x734,  0,  /* 0x8B*/
   "AdjTFiles ",    1,   1,  0x734,  0,  /* 0x8C*/
   "Lang ",         1,   1,  0x734,  0,  /* 0x8D*/
   "Sort ",         2,   2,  0x88C,  0,  /* 0x8E*/
   "MouseReg ",     10,  10, 0x734,  0,  /* 0x8F*/
   "ScrFile ",      2,   2,  0x75B,  0,  /* 0x90*/
   "SearchInit ",   2,   2,  0x734,  0,  /* 0x91*/
   "SearchFind ",   2,   2,  0x7B5,  0,  /* 0x92*/
   "SearchStop",    0,   0,  0x734,  0,  /* 0x93*/
   "PrFound ",      1,   99, 0x734,  0,  /* 0x94*/
   "PrFoundLn ",    0,   99, 0x734,  0,  /* 0x95*/
   "TpaGet ",       2,   2,  0x7B5,  0,  /* 0x96*/
   "TpaPut ",       2,   2,  0x734,  0,  /* 0x97*/
   "TpaCGet ",      3,   3,  0x7B5,  0,  /* 0x98*/
   "TpaCPut ",      3,   3,  0x734,  0,  /* 0x99*/
   "TpaRead ",      2,   2,  0x7B5,  0,  /* 0x9A*/
   "TpaWrite ",     2,   2,  0x734,  0,  /* 0x9B*/
   "TpaCRead ",     3,   3,  0x7B5,  0,  /* 0x9C*/
   "TpaCWrite ",    3,   3,  0x734,  0,  /* 0x9D*/
   "BitSet ",       2,   2,  0x75F,  0,  /* 0x9E*/
   "BitClear ",     2,   2,  0x75F,  0,  /* 0x9F*/
   "Brag",          0,   0,  0x734,  0,  /* 0xA0*/
   "FReAltUser",    0,   0,  0x734,  0,  /* 0xA1*/
   "SetLmr ",       2,   2,  0x734,  0,  /* 0xA2*/
   "SetEnv ",       1,   1,  0x734,  0,  /* 0xA3*/
   "FCloseAll",     0,   0,  0x734,  0,  /* 0xA4*/
   "Declare ",      2,   2,  0x1CF2, 0,  /* 0xA5*/
   "Function ",     1,   1,  0x1F5B, 0,  /* 0xA6*/
   "Procedure ",    1,   1,  0x1F5B, 0,  /* 0xA7*/
   "" ,             0,   0,  0,      0,  /* 0xA8*/
   "EndProc",       0,   0,  0,      0,  /* 0xA9*/
   "Begin",         0,   0,  0x276D, 0,  /* 0xAA*/
   "EndFunc",       0,   0,  0,      0,  /* 0xAB*/
   "Static",        0,   0,  0x1C24, 0,  /* 0xAC*/
   "StackAbort ",   1,   1,  0x734,  0,  /* 0xAD*/
   "DCreate ",      4,   4,  0x2585, 0,  /* 0xAE*/
   "DOpen ",        3,   3,  0x734,  0,  /* 0xAF*/
   "DClose ",       1,   1,  0x734,  0,  /* 0xB0*/
   "DSetAlias ",    2,   2,  0x734,  0,  /* 0xB1*/
   "DPack ",        1,   1,  0x734,  0,  /* 0xB2*/
   "DCloseAll",     0,   0,  0x734,  0,  /* 0xB3*/
   "DLock ",        1,   1,  0x734,  0,  /* 0xB4*/
   "DLockR ",       2,   2,  0x734,  0,  /* 0xB5*/
   "DLockG ",       3,   3,  0x2585, 0,  /* 0xB6*/
   "DUnlock ",      1,   1,  0x734,  0,  /* 0xB7*/
   "DnCreate ",     3,   3,  0x2585, 0,  /* 0xB8*/
   "DnOpen ",       2,   2,  0x734,  0,  /* 0xB9*/
   "DnClose ",      2,   2,  0x734,  0,  /* 0xBA*/
   "DnCloseAll ",   1,   1,  0x734,  0,  /* 0xBB*/
   "DNew ",         1,   1,  0x734,  0,  /* 0xBC*/
   "DAdd ",         1,   1,  0x734,  0,  /* 0xBD*/
   "DAppend ",      1,   1,  0x734,  0,  /* 0xBE*/
   "DTop ",         1,   1,  0x734,  0,  /* 0xBF*/
   "DGo ",          2,   2,  0x734,  0,  /* 0xC0*/
   "DBottom ",      1,   1,  0x734,  0,  /* 0xC1*/
   "DSkip ",        2,   2,  0x734,  0,  /* 0xC2*/
   "DBlank ",       1,   1,  0x734,  0,  /* 0xC3*/
   "DDelete ",      1,   1,  0x734,  0,  /* 0xC4*/
   "DRecall ",      1,   1,  0x734,  0,  /* 0xC5*/
   "DTag ",         2,   2,  0x734,  0,  /* 0xC6*/
   "DSeek ",        2,   2,  0x734,  0,  /* 0xC7*/
   "DFBlank ",      2,   2,  0x734,  0,  /* 0xC8*/
   "DGet ",         3,   3,  0x7E5,  0,  /* 0xC9   ?2585*/
   "DPut ",         3,   3,  0x734,  0,  /* 0xCA*/
   "DFCopy ",       4,   4,  0x734,  0,  /* 0xCB*/
   "Eval ",         1,   1,  0x734,  0,  /* 0xCC*/
   "Account ",      2,   2,  0x734,  0,  /* 0xCD*/
   "RecordUsage ",  5,   5,  0x734,  0,  /* 0xCE*/
   "MsgToFile ",    3,   3,  0x734,  0,  /* 0xCF*/
   "QwkLimits ",    2,   2,  0x734,  0,  /* 0xD0*/
   "Command ",      2,   2,  0x734,  0,  /* 0xD1*/
   //----3.20 \/
   "UseLMRs ",      1,   1,  0x734,  0,  /* 0xD2*/
   "ConfInfo ",     3,   3,  0x734,  0,  /* 0xD3*/
   "AdjTUBytes ",   1,   1,  0x734,  0,  /* 0xD4*/
   "GrafMode ",     1,   1,  0x734,  0,  /* 0xD5*/
   "AddUser ",      2,   2,  0x734,  0,  /* 0xD6*/
   "KillMsg ",      2,   2,  0x734,  0,  /* 0xD7*/
   "ChDir ",        1,   1,  0x734,  0,  /* 0xD8*/
   "MkDir ",        1,   1,  0x734,  0,  /* 0xD9*/
   "ReDir ",        1,   1,  0x734,  0,  /* 0xDA*/
   "FDOWrAka ",     2,   2,  0x734,  0,  /* 0xDB*/
   "FDOAddAKA ",    3,   3,  0x734,  0,  /* 0xDC*/
   "FDOWrOrg ",     2,   2,  0x734,  0,  /* 0xDD*/
   "FDOAddOrg ",    3,   3,  0x734,  0,  /* 0xDE*/
   "FDOQMod ",      4,   4,  0x734,  0,  /* 0xDF*/
   "FDOqAdd ",      3,   3,  0x734,  0,  /* 0xE0*/
   "FDOqDel ",      1,   1,  0x734,  0,  /* 0xE1*/
   "SoundDelay ",   2,   2,  0x734,  0,  /* 0xE2*/
};






uFormat far Function[] = {
   "",              2,        0,     0,  /* 0x0000*/
   ")",             2,        0,	 0,  /* 0xFFFF*/
   "+",             1,        0,	 0,  /* 0xFFFE*/
   "-",             1,        0,	 0,  /* 0xFFFD*/
   "^",             2,        0,	 0,  /* 0xFFFC*/
   "*",             2,        0,	 0,  /* 0xFFFB*/
   "/",             2,        0,	 0,  /* 0xFFFA*/
   "%",             2,        0,	 0,  /* 0xFFF9*/
   "+",             2,        0,	 0,  /* 0xFFF8*/
   "-",             2,        0,	 0,  /* 0xFFF7*/
   "==",            2,        0,	 0,  /* 0xFFF6*/
   "<>",            2,        0,	 0,  /* 0xFFF5*/
   "<",             2,        0,	 0,  /* 0xFFF4*/
   "<=",            2,        0,	 0,  /* 0xFFF3*/
   ">",             2,        0,	 0,  /* 0xFFF2*/
   ">=",            2,        0,	 0,  /* 0xFFF1*/
   "!",             1,        0,	 0,  /* 0xFFF0*/
   "&&",            2,        0,	 0,  /* 0xFFEF*/
   "||",            2,        0,	 0,  /* 0xFFEE*/
   "(",             2,        0,	 0,  /* 0xFFED*/
   "Len(",          1,        0,	 0,  /* 0xFFEC*/
   "Lower(",        1,        0,	 0,  /* 0xFFEB*/
   "Upper(",        1,        0,     0,  /* 0xFFEA*/
   "Mid(",          3,        0,     0,  /* 0xFFE9*/
   "Left(",         2,        0,     0,  /* 0xFFE8*/
   "Right(",        2,        0,     0,  /* 0xFFE7*/
   "Space(",        1,        0,     0,  /* 0xFFE6*/
   "Ferr(",         1,        0,     0,  /* 0xFFE5*/
   "Chr(",          1,        0,     0,  /* 0xFFE4*/
   "Asc(",          1,        0,     0,  /* 0xFFE3*/
   "InStr(",        2,        0,     0,  /* 0xFFE2*/
   "Abort(",        0,        0,     0,  /* 0xFFE1*/
   "LTrim(",        2,        0,     0,  /* 0xFFE0*/
   "RTrim(",        2,        0,     0,  /* 0xFFDF*/
   "Trim(",         2,        0,     0,  /* 0xFFDE*/
   "Random(",       1,        0,     0,  /* 0xFFDD*/
   "Date(",         0,        0,     0,  /* 0xFFDC*/
   "Time(",         0,        0,     0,  /* 0xFFDB*/
   "U_Name(",       0,        0,     0,  /* 0xFFDA*/
   "U_LDate(",      0,        0,     0,  /* 0xFFD9*/
   "U_LTime(",      0,        0,     0,  /* 0xFFD8*/
   "U_LDir(",       0,        0,     0,  /* 0xFFD7*/
   "U_Logons(",     0,        0,     0,  /* 0xFFD6*/
   "U_Ful(",        0,        0,     0,  /* 0xFFD5*/
   "U_Fdl(",        0,        0,     0,  /* 0xFFD4*/
   "U_BdlDay(",     0,        0,     0,  /* 0xFFD3*/
   "U_TimeOn(",     0,        0,     0,  /* 0xFFD2*/
   "U_Bdl(",        0,        0,     0,  /* 0xFFD1*/
   "U_Bul(",        0,        0,     0,  /* 0xFFD0*/
   "Year(",         1,        0,     0,  /* 0xFFCF*/
   "Month(",        1,        0,     0,  /* 0xFFCE*/
   "Day(",          1,        0,     0,  /* 0xFFCD*/
   "Dow(",          1,        0,     0,  /* 0xFFCC*/
   "Hour(",         1,        0,     0,  /* 0xFFCB*/
   "Min(",          1,        0,     0,  /* 0xFFCA*/
   "Sec(",          1,        0,     0,  /* 0xFFC9*/
   "TimeAp(",       1,        0,     0,  /* 0xFFC8*/
   "Ver(",          0,        0,     0,  /* 0xFFC7*/
   "NoChar(",       0,        0,     0,  /* 0xFFC6*/
   "YesChar(",      0,        0,     0,  /* 0xFFC5*/
   "StripAtx(",     1,        0,     0,  /* 0xFFC4*/
   "Replace(",      3,        0,     0,  /* 0xFFC3*/
   "Strip(",        2,        0,     0,  /* 0xFFC2*/
   "Inkey(",        0,        0,     0,  /* 0xFFC1*/
   "String(",       1,        0,     0,  /* 0xFFC0*/
   "Mask_Pwd(",     0,        0,     0,  /* 0xFFBF*/
   "Mask_Alpha(",   0,        0,     0,  /* 0xFFBE*/
   "Mask_Num(",     0,        0,     0,  /* 0xFFBD*/
   "Mask_AlNum(",   0,        0,     0,  /* 0xFFBC*/
   "Mask_File(",    0,        0,     0,  /* 0xFFBB*/
   "Mask_Path(",    0,        0,     0,  /* 0xFFBA*/
   "Mask_Ascii(",   0,        0,     0,  /* 0xFFB9*/
   "CurConf(",      0,        0,     0,  /* 0xFFB8*/
   "PCBDat(",       0,        0,     0,  /* 0xFFB7*/
   "PPEPath(",      0,        0,     0,  /* 0xFFB6*/
   "ValDate(",      1,        0,     0,  /* 0xFFB5*/
   "ValTime(",      1,        0,     0,  /* 0xFFB4*/
   "U_MsgRd(",      0,        0,     0,  /* 0xFFB3*/
   "U_MsgWr(",      0,        0,     0,  /* 0xFFB2*/
   "PcbNode(",      0,        0,     0,  /* 0xFFB1*/
   "ReadLine(",     2,        0,     0,  /* 0xFFB0*/
   "SysopSec(",     0,        0,     0,  /* 0xFFAF*/
   "OnLocal(",      0,        0,     0,  /* 0xFFAE*/
   "UN_Stat(",      0,        0,     0,  /* 0xFFAD*/
   "UN_Name(",      0,        0,     0,  /* 0xFFAC*/
   "UN_City(",      0,        0,     0,  /* 0xFFAB*/
   "UN_Oper(",      0,        0,     0,  /* 0xFFAA*/
   "CurSec(",       0,        0,     0,  /* 0xFFA9*/
   "GetToken(",     0,        0,     0,  /* 0xFFA8*/
   "MinLeft(",      0,        0,     0,  /* 0xFFA7*/
   "MinOn(",        0,        0,     0,  /* 0xFFA6*/
   "GetEnv(",       1,        0,     0,  /* 0xFFA5*/
   "CallId(",       0,        0,     0,  /* 0xFFA4*/
   "RegAL(",        0,        0,     0,  /* 0xFFA3*/
   "RegAH(",        0,        0,     0,  /* 0xFFA2*/
   "RegBL(",        0,        0,     0,  /* 0xFFA1*/
   "RegBH(",        0,        0,     0,  /* 0xFFA0*/
   "RegCL(",        0,        0,     0,  /* 0xFF9F*/
   "RegCH(",        0,        0,     0,  /* 0xFF9E*/
   "RegDL(",        0,        0,     0,  /* 0xFF9D*/
   "RegDH(",        0,        0,     0,  /* 0xFF9C*/
   "RegAX(",        0,        0,     0,  /* 0xFF9B*/
   "RegBX(",        0,        0,     0,  /* 0xFF9A*/
   "RegCX(",        0,        0,     0,  /* 0xFF99*/
   "RegDX(",        0,        0,     0,  /* 0xFF98*/
   "RegSI(",        0,        0,     0,  /* 0xFF97*/
   "RegDI(",        0,        0,     0,  /* 0xFF96*/
   "RegF(",         0,        0,     0,  /* 0xFF95*/
   "RegCF(",        0,        0,     0,  /* 0xFF94*/
   "RegDS(",        0,        0,     0,  /* 0xFF93*/
   "RegES(",        0,        0,     0,  /* 0xFF92*/
   "B2W(",          2,        0,     0,  /* 0xFF91*/
   "Peek(",         1,        0,     0,  /* 0xFF90*/
   "PeekW(",        1,        0,     0,  /* 0xFF8F*/
   "MkAddr(",       2,        0,     0,  /* 0xFF8E*/
   "Exist(",        1,        0,     0,  /* 0xFF8D*/
   "I2S(",          2,        0,     0,  /* 0xFF8C*/
   "S2I(",          2,        0,     0,  /* 0xFF8B*/
   "Carrier(",      0,        0,     0,  /* 0xFF8A*/
   "TokenStr(",     0,        0,     0,  /* 0xFF89*/
   "CDOn(",         0,        0,     0,  /* 0xFF88*/
   "LangExt(",      0,        0,     0,  /* 0xFF87*/
   "AnsiOn(",       0,        0,     0,  /* 0xFF86*/
   "ValCC(",        1,        0,     0,  /* 0xFF85*/
   "FmtCC(",        1,        0,     0,  /* 0xFF84*/
   "CCType(",       1,        0,     0,  /* 0xFF83*/
   "GetX(",         0,        0,     0,  /* 0xFF82*/
   "GetY(",         0,        0,     0,  /* 0xFF81*/
   "And(",          2,        0,     0,  /* 0xFF80*/
   "Or(",           2,        0,     0,  /* 0xFF7F*/
   "XOr(",          2,        0,     0,  /* 0xFF7E*/
   "Not(",          1,        0,     0,  /* 0xFF7D*/
   "U_PwdHist(",    1,        0,     0,  /* 0xFF7C*/
   "U_PwdLc(",      0,        0,     0,  /* 0xFF7B*/
   "U_PwdTc(",      0,        0,     0,  /* 0xFF7A*/
   "U_Stat(",       1,        0,     0,  /* 0xFF79*/
   "DefColor(",     0,        0,     0,  /* 0xFF78*/
   "Abs(",          1,        0,     0,  /* 0xFF77*/
   "GrafMode(",     0,        0,     0,  /* 0xFF76*/
   "Psa(",          1,        0,     0,  /* 0xFF75*/
   "FileInf(",      2,        0,     0,  /* 0xFF74*/
   "PPEName(",      0,        0,     0,  /* 0xFF73*/
   "MkDate(",       3,        0,     0,  /* 0xFF72*/
   "CurColor(",     0,        0,     0,  /* 0xFF71*/
   "KInkey(",       0,        0,     0,  /* 0xFF70*/
   "MInkey(",       0,        0,     0,  /* 0xFF6F*/
   "MaxNode(",      0,        0,     0,  /* 0xFF6E*/
   "SlPath(",       0,        0,     0,  /* 0xFF6D*/
   "HelpPath(",     0,        0,     0,  /* 0xFF6C*/
   "TempPath(",     0,        0,     0,  /* 0xFF6B*/
   "Modem(",        0,        0,     0,  /* 0xFF6A*/
   "LoggedOn(",     0,        0,     0,  /* 0xFF69*/
   "CallNum(",      0,        0,     0,  /* 0xFF68*/
   "MGetByte(",     0,        0,     0,  /* 0xFF67*/
   "TokCount(",     0,        0,     0,  /* 0xFF66*/
   "U_RecNum(",     1,        0,     0,  /* 0xFF65*/
   "U_InConf(",     2,        0,     0,  /* 0xFF64*/
   "PeekDW(",       1,        0,     0,  /* 0xFF63*/
   "DbgLevel(",     0,        0,     0,  /* 0xFF62*/
   "ScrText(",      4,        0,     0,  /* 0xFF61*/
   "ShowStat(",     0,        0,     0,  /* 0xFF60*/
   "PageStat(",     0,        0,     0,  /* 0xFF5F*/
   "ReplaceStr(",   3,        0,     0,  /* 0xFF5E*/
   "StripStr(",     2,        0,     0,  /* 0xFF5D*/
   "ToBigStr(",     1,        0,     0,  /* 0xFF5C*/
   "ToBoolean(",    1,        0,     0,  /* 0xFF5B*/
   "ToByte(",       1,        0,     0,  /* 0xFF5A*/
   "ToDate(",       1,        0,     0,  /* 0xFF59*/
   "ToDouble(",     1,        0,     0,  /* 0xFF58*/
   "ToEDate(",      1,        0,     0,  /* 0xFF57*/
   "ToInteger(",    1,        0,     0,  /* 0xFF56*/
   "ToMoney(",      1,        0,     0,  /* 0xFF55*/
   "ToReal(",       1,        0,     0,  /* 0xFF54*/
   "ToShort(",      1,        0,     0,  /* 0xFF53*/
   "ToInt(",        1,        0,     0,  /* 0xFF52*/
   "ToTime(",       1,        0,     0,  /* 0xFF51*/
   "ToDWord(",      1,        0,     0,  /* 0xFF50*/
   "ToWord(",       1,        0,     0,  /* 0xFF4F*/
   "Mixed(",        1,        0,     0,  /* 0xFF4E*/
   "Alias(",        0,        0,     0,  /* 0xFF4D*/
   "ConfReg(",      1,        0,     0,  /* 0xFF4C*/
   "ConfExp(",      1,        0,     0,  /* 0xFF4B*/
   "ConfSel(",      1,        0,     0,  /* 0xFF4A*/
   "ConfSys(",      1,        0,     0,  /* 0xFF49*/
   "ConfMW(",       1,        0,     0,  /* 0xFF48*/
   "LPrinted(",     0,        0,     0,  /* 0xFF47*/
   "IsNonStop(",    0,        0,     0,  /* 0xFF46*/
   "ErrCorrect(",   0,        0,     0,  /* 0xFF45*/
   "ConfAlias(",    0,        0,     0,  /* 0xFF44*/
   "UserAlias(",    0,        0,     0,  /* 0xFF43*/
   "CurUser(",      0,        0,     0,  /* 0xFF42*/
   "U_Lmr(",        1,        0,     0,  /* 0xFF41*/
   "ChatStat(",     0,        0,     0,  /* 0xFF40*/
   "DefAns(",       0,        0,     0,  /* 0xFF3F*/
   "LastAns(",      0,        0,     0,  /* 0xFF3E*/
   "MegaNum(",      1,        0,     0,  /* 0xFF3D*/
   "EvtTimeAdj(",   0,        0,     0,  /* 0xFF3C*/
   "IsBitSet(",     2,        0,     0,  /* 0xFF3B*/
   "FmtReal(",      3,        0,     0,  /* 0xFF3A*/
   "FlagCnt(",      0,        0,     0,  /* 0xFF39*/
   "KbdBufSize(",   0,        0,     0,  /* 0xFF38*/
   "PPLBufSize(",   0,        0,     0,  /* 0xFF37*/
   "KbdFilUsed(",   0,        0,     0,  /* 0xFF36*/
   "LoMsgNum(",     0,        0,     0,  /* 0xFF35*/
   "HiMsgNum(",     0,        0,     0,  /* 0xFF34*/
   "DriveSpace(",   1,        0,     0,  /* 0xFF33*/
   "OutBytes(",     0,        0,     0,  /* 0xFF32*/
   "HiConfNum(",    0,        0,     0,  /* 0xFF31*/
   "InBytes(",      0,        0,     0,  /* 0xFF30*/
   "Crc32(",        2,        0,     0,  /* 0xFF2F*/
   "PCBMac(",       1,        0,     0,  /* 0xFF2E*/
   "ActMsgNum(",    0,        0,     0,  /* 0xFF2D*/
   "StackLeft(",    0,        0,     0,  /* 0xFF2C*/
   "StackErr(",     0,        0,     0,  /* 0xFF2B*/
   "DGetAlias(",    1,        0,     0,  /* 0xFF2A*/
   "DBof(",         1,        0,     0,  /* 0xFF29*/
   "DChanged(",     1,        0,     0,  /* 0xFF28*/
   "DDecimals(",    2,        0,     0,  /* 0xFF27*/
   "DDeleted(",     1,        0,     0,  /* 0xFF26*/
   "DEof(",         1,        0,     0,  /* 0xFF25*/
   "DErr(",         1,        0,     0,  /* 0xFF24*/
   "DFields(",      1,        0,     0,  /* 0xFF23*/
   "DLength(",      2,        0,     0,  /* 0xFF22*/
   "DName(",        2,        0,     0,  /* 0xFF21*/
   "DRecCount(",    1,        0,     0,  /* 0xFF20*/
   "DRecNo(",       1,        0,     0,  /* 0xFF1F*/
   "DType(",        2,        0,     0,  /* 0xFF1E*/
   "FNext(",        0,        0,     0,  /* 0xFF1D*/
   "DNext(",        0,        0,     0,  /* 0xFF1C*/
   "ToDDate(",      1,        0,     0,  /* 0xFF1B*/
   "DCloseAll(",    0,        0,     0,  /* 0xFF1A*/
   "DOpen(",        3,        0,     0,  /* 0xFF19*/
   "DClose(",       1,        0,     0,  /* 0xFF18*/
   "DSetAlias(",    2,        0,     0,  /* 0xFF17*/
   "DPack(",        1,        0,     0,  /* 0xFF16*/
   "DLockF(",       1,        0,     0,  /* 0xFF15*/
   "DLock(",        1,        0,     0,  /* 0xFF14*/
   "DLockR(",       2,        0,     0,  /* 0xFF13*/
   "DUnlock(",      1,        0,     0,  /* 0xFF12*/
   "DNOpen(",       2,        0,     0,  /* 0xFF11*/
   "DNClose(",      2,        0,     0,  /* 0xFF10*/
   "DNCloseAll(",   1,        0,     0,  /* 0xFF0F*/
   "DNew(",         1,        0,     0,  /* 0xFF0E*/
   "DAdd(",         1,        0,     0,  /* 0xFF0D*/
   "DAppend(",      1,        0,     0,  /* 0xFF0C*/
   "DTop(",         1,        0,     0,  /* 0xFF0B*/
   "DGo(",          2,        0,     0,  /* 0xFF0A*/
   "DBottom(",      1,        0,     0,  /* 0xFF09*/
   "DSkip(",        2,        0,     0,  /* 0xFF08*/
   "DBlank(",       1,        0,     0,  /* 0xFF07*/
   "DDelete(",      1,        0,     0,  /* 0xFF06*/
   "DRecall(",      1,        0,     0,  /* 0xFF05*/
   "DTag(",         2,        0,     0,  /* 0xFF04*/
   "DSeek(",        2,        0,     0,  /* 0xFF03*/
   "DFBlank(",      2,        0,     0,  /* 0xFF02*/
   "DGet(",         2,        0,     0,  /* 0xFF01*/
   "DPut(",         3,        0,     0,  /* 0xFF00*/
   "DFCopy(",       4,        0,     0,  /* 0xFEFF*/
   "DSelect(",      1,        0,     0,  /* 0xFEFE*/
   "DChkStat(",     1,        0,     0,  /* 0xFEFD*/
   "PCBAccount(",   1,        0,     0,  /* 0xFEFC*/
   "PCBAccStat(",   1,        0,     0,  /* 0xFEFB*/
   "DErrMsg(",      1,        0,     0,  /* 0xFEFA*/
   "Account(",      1,        0,     0,  /* 0xFEF9*/
   "ScanMsgHdr(",   4,        0,     0,  /* 0xFEF8*/
   "CheckRip(",     0,        0,     0,  /* 0xFEF7*/
   "RipVer(",       0,        0,     0,  /* 0xFEF6*/
   "QwkLimits(",    1,        0,     0,  /* 0xFEF5*/
   "FindFirst(",    1,        0,     0,  /* 0xFEF4*/
   "FindNext(",     0,        0,     0,  /* 0xFEF3*/
   // -------- 3.20 \/
   "UseLMRs(",      0,   	  0,  	 0,  /* 0xFEF2*/
   "ConfInfo(",     2,   	  0,  	 0,  /* 0xFEF1*/
   "TInkey(",       1,   	  0,  	 0,  /* 0xFEF0*/
   "Cwd(",          0,   	  0,  	 0,  /* 0xFEEF*/
   "InStrR(",       2,   	  0,  	 0,  /* 0xFEEE*/
   "FDORdAka(",     1,   	  0,  	 0,  /* 0xFEED*/
   "FDORdOrg(",     1, 	  	  0,  	 0,  /* 0xFEEC*/
   "FDORdArea(",    1,   	  0,  	 0,  /* 0xFEEB*/
   "FDOQrd(",       6,   	  0,  	 0,  /* 0xFEEA*/
   "GetDrive(",     0,   	  0,  	 0,  /* 0xFEE9*/
   "SetDrive(",     1,   	  0,  	 0,  /* 0xFEE8*/
   "Bs2I(",         1,   	  0,  	 0,  /* 0xFEE7*/
   "Bd2I(",         1,   	  0,  	 0,  /* 0xFEE6*/
   "I2Bs(",         1,   	  0,  	 0,  /* 0xFEE5*/
   "I2Bd(",         1,   	  0,  	 0,  /* 0xFEE4*/
   "FTell(",        1,   	  0,  	 0,  /* 0xFEE3*/
   "Os(",           0,   	  0,  	 0,  /* 0xFEE2*/
};
#pragma warn .pin

