/*
                           + Project Frontier +


 PPL BINARY IPN GRAMMAR FILE 

*/

%{
#include "ppl.h"
#define YYSTYPE pplvar*
#include <math.h>
%}

%token OP_ADD OP_SUB OP_POW OP_MUL OP_DIV OP_MOD
%token UNEGATIVE UPOSITIVE UNOT
%token CM_EQU CM_NEQ CM_BEL CM_BOE CM_ABO CM_AOE
%token BOOL_AND BOOL_OR

/* PPL Functions */
%token F_LEN F_LOWER F_UPPER F_MID F_LEFT F_RIGHT F_SPACE F_FERR F_CHR F_ASC
%token F_INSTR F_ABORT F_LTRIM F_RTRIM F_TRIM F_RANDOM F_DATE F_TIME F_U_NAME
%token F_U_LDATE F_U_LTIME F_U_LDIR F_U_LOGONS F_U_FUL F_U_FDL F_U_BDLDAY
%token F_U_TIMEON F_U_BDL F_U_BUL F_YEAR F_MONTH F_DAY F_DOW F_HOUR F_MIN
%token F_SEC F_TIMEAP F_VER F_NOCHAR F_YESCHAR F_STRIPATX F_REPLACE F_STRIP
%token F_INKEY F_STRING F_MASK_PWD F_MASK_ALPHA F_MASK_NUM F_MASK_ALNUM
%token F_MASK_FILE F_MASK_PATH F_MASK_ASCII F_CURCONF F_PCBDAT F_PPEPATH
%token F_VALDATE F_VALTIME F_U_MSGRD F_U_MSGWR F_PCBNODE F_READLINE
%token F_SYSOPSEC F_ONLOCAL F_UN_STAT F_UN_NAME F_UN_CITY F_UN_OPER F_CURSEC
%token F_GETTOKEN F_MINLEFT F_MINON F_GETENV F_CALLID F_REGAL F_REGAH F_REGBL
%token F_REGBH F_REGCL F_REGCH F_REGDL F_REGDH F_REGAX F_REGBX F_REGCX
%token F_REGDX F_REGSI F_REGDI F_REGF F_REGCF F_REGDS F_REGES F_B2W F_PEEK
%token F_PEEKW F_MKADDR F_EXIST F_I2S F_S2I F_CARRIER F_TOKENSTR F_CDON
%token F_LANGEXT F_ANSION F_VALCC F_FMTCC F_CCTYPE F_GETX F_GETY F_AND F_OR
%token F_XOR F_NOT F_U_PWDHIST F_U_PWDLC F_U_PWDTC F_U_STAT F_DEFCOLOR F_ABS
%token F_GRAFMODE F_PSA F_FILEINF F_PPENAME F_MKDATE F_CURCOLOR F_KINKEY
%token F_MINKEY F_MAXNODE F_SLPATH F_HELPPATH F_TEMPPATH F_MODEM F_LOGGEDON
%token F_CALLNUM F_MGETBYTE F_TOKCOUNT F_U_RECNUM F_U_INCONF F_PEEKDW
%token F_DBGLEVEL F_SCRTEXT F_SHOWSTAT F_PAGESTAT F_REPLACESTR F_STRIPSTR
%token F_TOBIGSTR F_TOBOOLEAN F_TOBYTE F_TODATE F_TODOUBLE F_TOEDATE
%token F_TOINTEGER F_TOMONEY F_TOREAL F_TOSHORT F_TOINT F_TOTIME F_TODWORD
%token F_TOWORD F_MIXED F_ALIAS F_CONFREG F_CONFEXP F_CONFSEL F_CONFSYS
%token F_CONFMW F_LPRINTED F_ISNONSTOP F_ERRCORRECT F_CONFALIAS F_USERALIAS
%token F_CURUSER F_U_LMR F_CHATSTAT F_DEFANS F_LASTANS F_MEGANUM F_EVTTIMEADJ
%token F_ISBITSET F_FMTREAL F_FLAGCNT F_KBDBUFSIZE F_PPLBUFSIZE F_BBDFILUSED
%token F_LOMSGNUM F_HIMSGNUM F_DRIVESPACE F_OUTBYTES F_HICONFNUM F_INBYTES
%token F_CRC32 F_PCBMAC F_ACTMSGNUM F_STACKLEFT F_STACKERR F_DGETALIAS F_DBOF
%token F_DCHANGED F_DDECIMALS F_DDELETED F_DEOF F_DERR F_DFIELDS F_DLENGTH
%token F_DNAME F_DRECCOUNT F_DRECNO F_DTYPE F_FNEXT F_DNEXT F_TODDATE
%token F_DCLOSEALL F_DOPEN F_DCLOSE F_DSETALIAS F_DPACK F_DLOCKF F_DLOCK
%token F_DLOCKR F_DUNLOCK F_DNOPEN F_DNCLOSE F_DNCLOSEALL F_DNEW F_DADD
%token F_DAPPEND F_DTOP F_DGO F_DBOTTOM F_DSKIP F_DBLANK F_DDELETE F_DRECALL
%token F_DTAG F_DSEEK F_DFBLANK F_DGET F_DPUT F_DFCOPY F_DSELECT F_DCHKSTAT
%token F_PCBACCOUNT F_PCBACCSTAT F_DERRMSG F_ACCOUNT F_SCANMSGHDR F_CHECKRIP
%token F_RIPVER F_QWKLIMITS F_FINDFIRST F_FINDNEXT F_USELMRS F_CONFINFO
%token F_TINKEY F_CWD F_INSTRR F_FDORDAKA F_FDORDORG F_FDORDAREA F_FDOQRD
%token F_GETDRIVE F_SETDRIVE F_BS2I F_BD2I F_I2BS F_I2BD F_FTELL F_OS

%token VAR

     %% /* Grammar rules and actions follow */

STATEMENT
    :
    exp_list { pushvar($1); }
    ;

exp_list
    :
    exp
    | exp exp { pushvar($2); $$ = $1; }
    ;


exp
    :
    VAR       		  { $$ = copyvar($1); }
    | exp exp OP_ADD  { $$ = addvar($1, $2);     }
    | exp exp OP_SUB  { $$ = subvar($1, $2);     }
    | exp exp OP_MUL  { $$ = mulvar($1, $2);     }
    | exp exp OP_DIV  { $$ = divvar($1, $2);     }
    | exp exp OP_POW  { $$ = powvar($1, $2);     }
    | exp exp OP_MOD  { $$ = modvar($1, $2);     }
    /* Unary operators    */
    | exp UNEGATIVE   { $$ = negvar($1);         }
    | exp UPOSITIVE   { $$ = posvar($1);         }
    | exp UNOT        { $$ = notvar($1);         }
    ;

    %%

/*
                           + Project Frontier +


 RUNTIME MODULE 

*/

     #include <ctype.h>
     #include <stdio.h>
     #include <alloc.h>

/*

 GLOBAL VARS 

*/
     FILE *script;
     pplvar far *vars[4096];
     pplvar far *allocated[4096];
     pplvar far *argument[99];
     int nalloc;
     int narg;
     int nVars;
     long codesize;
     long codestart;


/*

 MAIN 

*/
     main ()
     {
     int c,d;

     loadPPE("TEST.PPE");

       while (!feof(script))
	       {
		   fread(&c, 1, 2, script);
           if (feof(script)) break;
           printf("%s", stat[c].name);
           if (stat[c].maxArg != stat[c].minArg)
			   fread(&d, 1, 2, script);
           else
           	   d = stat[c].maxArg;
           if (d>0)
           	    {
                nalloc = 0;
                narg = 0;
	       	    yyparse();
                for (d=narg-1;d>=0;d--)
                    printf("%d ", getValue(argument[d]));
                unallocvars();
                }
           printf("\n");
           }
     }

/*

 LEXICAL ANALYZER 

*/
     yylex ()
     {
     int c,d;

     if (feof(script)) return 0;

     fread(&c, 1, 2, script);
	 if (c == 0)
        return 0;
     if (c < 0)
	 	return funcToken[~c+1];
     if (c > 0)
		  	{
	    	fread(&d, 1, 2, script);
	        yylval = vars[c];
    	 	return VAR;
        	}
	 }

/*

 PARSER ERROR MESSAGE 

*/

     yyerror (s)  /* Called by yyparse on error */
          char *s;
     {
       printf ("%s\n", s);
     }

/*

 LOAD A SCRIPT 

*/

int loadPPE(char *ppename)
{
char *buffer,*temp;
unsigned int a,b,l;
char l1;

nVars=0;

buffer = (char *)malloc(4096);
script = fopen(ppename, "rb");
fread(buffer, 1, 45, script);
if (strncmp("PCBoard Programming Language Executable  ", buffer, 41))
	{
    free(buffer);
    fclose(script);
	return 1;
    }
fseek(script, 0x30, SEEK_SET);
fread(&a, 2, 1, script);

nVars = a;

for (b=0;b<a;b++)
	{
	fread(buffer, 0x0B, 1, script);
//	decrypt(buffer, 0x0B);
	l1 = buffer[9];
    vars[nVars-b] = newvar(l1);
	if (l1 != 7)
		{
		fread(buffer, 0x0C, 1, script);
        setValue(vars[nVars-b], *(long *)&buffer[4]);
		}
	else
		{
		fread(&l, 2, 1, script);
        temp = (char *)malloc(l);
        fread(temp, l, 1, script);
        vars[nVars-b]->value = (void *)temp;
		}
	}
codestart = ftell(script);
fread(&l, 1, 2, script);
codesize = l;
}


/*

 DE-ALLOCATE COMPUTATION VARS 

*/

void unallocvars(void)
{
int a;

for (a=0;a<nalloc;a++)
	{
    free(allocated[a]->value);
    free(allocated[a]);
	}
}

/*

 CREATE A NEW VAR 

*/

pplvar *newvar(int type)
{
pplvar *s;

s = (pplvar *)malloc(sizeof(pplvar));
s->type=type;
allocValue(s);
allocated[nalloc++] = s;
return s;
}

/*

 COPY A VAR INTO A NEW ONE 

*/

pplvar *copyvar(pplvar *v)
{
pplvar *s;

s = newvar(v->type);
setValue(s, getValue(v));
return s;
}

/*

 ALLOCATE A VAR CONTENTS 

*/

void allocValue(pplvar *s)
{
switch (s->type)
	{
    case 0 : // Boolean
    case 9 :  // Byte
	case 0xB : // SByte
    	s->value = (pplvar *)malloc(1);
    	break;
    case 1 : // DWord
    case 6 : // Real
    case 8 : // Time
    case 4 : // Integer
    case 0x11 : // DDate
    case 5 : // Money
		s->value = (pplvar *)malloc(4);
        break;
	case 0xE : // Double
		s->value = (pplvar *)malloc(8);
        break;
    case 7 : // String
		s->value = (pplvar *)malloc(256);
        break;
    case 0xD : // BigStr
		s->value = (pplvar *)malloc(2048);
        break;
    case 0xA : // Word
	case 0xC : // Int
    case 2 : // Date
    case 3 : // EDate
    	s->value = (pplvar *)malloc(2);
        break;
	}

}

/*

 RETURN LVALUE OF A VAR 

*/

unsigned long getValue(pplvar *s)
{
switch (s->type)
	{
    case 0 :   // Boolean
    case 9 :   // Byte
    	return *(unsigned char *)s->value;
	case 0xB : // SByte
    	return *(signed char *)s->value;
    case 1 : // DWord
    	return *(unsigned long *)s->value;
    case 6 : // Real
    	return *(float *)s->value;
    case 8 : // Time
    case 4 : // Integer
    case 0x11 : // DDate
    case 5 : // Money
    	return *(signed long *)s->value;
	case 0xE : // Double
    	return *(double *)s->value;
    case 7 : // String
    case 0xD : // BigStr
		return atoi(s->value);
    case 0xA : // Word
    case 2 : // Date
    case 3 : // EDate
    	return *(unsigned int *)s->value;
	case 0xC : // Int
    	return *(signed int *)s->value;
	}
}

/*

 SET LVALUE OF A VAR 

*/

void setValue(pplvar *s, unsigned long value)
{
switch (s->type)
	{
    case 0 :   // Boolean
    case 9 :   // Byte
    	*(unsigned char *)s->value = (unsigned char)value;
        break;
	case 0xB : // SByte
    	*(signed char *)s->value = (signed char)value;
        break;
    case 1 : // DWord
    	*(unsigned long *)s->value = (unsigned long)value;
        break;
    case 6 : // Real
    	*(float *)s->value = (float)value;
        break;
    case 8 : // Time
    case 4 : // Integer
    case 0x11 : // DDate
    case 5 : // Money
    	*(signed long *)s->value = (signed long)value;
        break;
	case 0xE : // Double
    	*(double *)s->value = (double)value;
        break;
    case 7 : // String
    case 0xD : // BigStr
		itoa(value, s->value, 10);
        break;
    case 0xA : // Word
    case 2 : // Date
    case 3 : // EDate
    	*(unsigned int *)s->value = (unsigned int)value;
        break;
	case 0xC : // Int
    	*(signed int *)s->value = (signed int)value;
        break;
	}
}

/*

 OPERATOR ADD 

*/

pplvar *addvar(pplvar *v1, pplvar *v2)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, getValue(v1)+getValue(v2));
return s;
}

/*

 OPERATOR SUB 

*/

pplvar *subvar(pplvar *v1, pplvar *v2)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, getValue(v1)-getValue(v2));
return s;
}

/*

 OPERATOR MUL 

*/

pplvar *mulvar(pplvar *v1, pplvar *v2)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, getValue(v1)*getValue(v2));
return s;
}

/*

 OPERATOR DIV 

*/

pplvar *divvar(pplvar *v1, pplvar *v2)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, getValue(v1)/getValue(v2));
return s;
}

/*

 OPERATOR POW 

*/

pplvar *powvar(pplvar *v1, pplvar *v2)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, pow(getValue(v1), getValue(v2)));
return s;
}

/*

 OPERATOR MOD 

*/

pplvar *modvar(pplvar *v1, pplvar *v2)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, getValue(v1) % getValue(v2));
return s;
}

/*

 OPERATOR UNEGATIVE 

*/

pplvar *negvar(pplvar *v1)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, -getValue(v1));
return s;
}

/*

 OPERATOR UPOSITIVE 

*/

pplvar *posvar(pplvar *v1)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, +getValue(v1));
return s;
}

/*

 OPERATOR UNOT 

*/

pplvar *notvar(pplvar *v1)
{
pplvar *s;

s = newvar(v1->type);
setValue(s, !getValue(v1));
return s;
}

/*

 PUSH TERMINAL ARGUMENT IN ARG STACK 

*/

void pushvar(pplvar *v1)
{
argument[narg++] = v1;
}


