/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision -  Version 1.0                             */
/*                                                            */
/*                                                            */
/*    Copyright (c) 1991 by Borland International             */
/*    All Rights Reserved.                                    */
/*                                                            */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/* Modified by Francis Gastellu for PowerPPL
/*                                                            */
/*------------------------------------------------------------*/

#define Uses_MsgBox
#define Uses_TKeys
#define Uses_TScroller
#define Uses_TDrawBuffer
#define Uses_TRect
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TStreamableClass
#define Uses_TListBox
#define Uses_TKeys
#include <tv.h>
__link(RScroller)
__link(RScrollBar)

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include <fstream.h>

#include "tvcmds.h"
#include "fileview.h"
#include "message.h"
#include <string.h>
#include <alloc.h>

#pragma warn -ias
const char * const TMessageViewer::name = "TMessageViewer";
#pragma warn .ias

char errorMessage[128];
int lastfocused=-1;
extern char errorFichier[128];
extern int errorLineNumber;
extern int inMacro;
extern int inMacro2;
extern TMessageViewer *messageViewer;
extern int viewerType;

TMessageViewer::TMessageViewer( const TRect& bounds,
			  ushort aNumCols,
			  TScrollBar *aVScrollBar,
			  const char *aFileName) :
    TListBox( bounds, aNumCols, aVScrollBar )
{
    growMode = gfGrowHiX | gfGrowHiY;
    isValid = True;
    fileName = 0;
    readFile( aFileName );
    newList( fileLines );
}

TPalette& TMessageViewer::getPalette() const
{
	static TPalette palette( cMessageViewer, sizeof(cMessageViewer)-1 );
	return palette;
}


void TMessageViewer::update( const char *aFileName )
{
delete fileName;
isValid = True;
fileName = 0;
readFile( aFileName);
newList( fileLines );
}

void TMessageViewer::removeAll()
{
     delete fileName;
     isValid = True;
     fileName = 0;
     newList( 0 );
}

TMessageViewer::~TMessageViewer()
{
     delete fileName;
     destroy (fileLines);
}

void TMessageViewer::readFile( const char *fName )
{
    fileLines = new TLineCollection(5, 5);
    delete fileName;

    fileName = newStr( fName );
    ifstream fileToView( fName );
    if( !fileToView )
	{
	messageBox( "Invalid drive or directory", mfError | mfOKButton );
	isValid = False;
	}
    else
	{
	char line[256+1];
	char str[256+1];
	char filename[13];
	char x[2]="X";
	char linenumber[7];
	int ln;
	while( !lowMemory() &&
	       !fileToView.eof() &&
	       fileToView.get( line, sizeof line ) != 0
	     )
	    {
	    char c;
	    fileToView.get(c);      // grab trailing newline
	    if (!strnicmp(line, "Error in file", 13))
		{
		filename[0] = 0;
		for (int i=14;line[i] != ',';i++)
			{
			x[0] = line[i];
			strcat(filename,x);
			}
		linenumber[0] = 0;
		for (i+=7;;i++)
			{
			if (line[i] < '0' || line[i] > '9') break;
			x[0] = line[i];
			strcat(linenumber,x);
			}
		ln = atoi(linenumber);
		fileToView.get( line, sizeof line );
		fileToView.get(c);
		sprintf(str,"Error %s %d : %s", filename, ln, line);
		fileLines->insert( newStr( str ) );
		goto handled;
		}
	    if (!strnicmp(line, "Warning", 7))
		{
		filename[0] = 0;
		for (int i=16;line[i] != ',';i++)
			{
			x[0] = line[i];
			strcat(filename,x);
			}
		linenumber[0] = 0;
		for (i+=7;;i++)
			{
			if (line[i] < '0' || line[i] > '9') break;
			x[0] = line[i];
			strcat(linenumber,x);
			}
		ln = atoi(linenumber);
		fileToView.get( line, sizeof line );
		fileToView.get(c);
		sprintf(str,"Warning %s %d : %s", filename, ln, line);
		fileLines->insert( newStr( str ) );
		goto handled;
		}
		if ((strnicmp(line, "Pass ", 5))
		   && (strnicmp(line, "PPLC Version", 12))
		   && (strnicmp(line, "Copyright (C)", 13))
		   && (strnicmp(line, "PowerPPL Compiler", 17))
		   && (strnicmp(line, "(C)199", 6))
		   && (strcmp(line, ""))
		   && (strcmp(line, "")))
			fileLines->insert( newStr( line ) );

handled:
	    }
	isValid = True;
	}
}

Boolean TMessageViewer::valid( ushort )
{
    return isValid;
}

TStreamable *TMessageViewer::build()
{
    return new TMessageViewer( streamableInit );
}

void TMessageViewer::trackError( int makeFocused )
{
char ligne[255];
char fichier[20] = "";
char linenum[8] = "";
char x[2] = "X";
int i=0;
int j=0;
int ln;
viewerType=1;
TEvent event;
if (range == 0) return;
getText(ligne, focused, 254);
errorMessage[0] = 0;
errorFichier[0] = 0;
if (!strncmp(ligne, "Error ", 6))
	{
	for (i=6;i < 20; i++)
		{
		if (ligne[i] == ' ')
			{
			fichier[i] = 0;
			break;
			}
		fichier[i-6] = ligne[i];
		}
	j = ++i;
	for (i = j; i< j+7;i++)
		{
		if (ligne[i] < '0' || ligne[i] > '9') break;
		x[0] = ligne[i];
		strcat(linenum,x);
		}
	}
if (!strncmp(ligne, "Warning ", 8))
	{
	for (i=8;i < 22; i++)
		{
		if (ligne[i] == ' ')
			{
			fichier[i] = 0;
			break;
			}
		fichier[i-8] = ligne[i];
		}
	j = ++i;
	for (i = j; i< j+7;i++)
		{
		if (ligne[i] < '0' || ligne[i] > '9') break;
		x[0] = ligne[i];
		strcat(linenum,x);
		}
	}
j = i+3;
for (i = j; i < j + 80; i++)
	{
	if (ligne[i] == 0) break;
	x[0] = ligne[i];
	strcat(errorMessage, x);
	}
x[0] = ' ';
for (i=strlen(errorMessage);i<80;i++)
	strcat(errorMessage,x);
ln = atoi(linenum);
if (fichier[0] == 0) return;
if (ln == 0) return;
strcpy(errorFichier,fichier);
errorLineNumber = ln;
event.what = evBroadcast;
event.message.command = 1530;
event.message.infoInt = makeFocused;
putEvent(event);
}

void TMessageViewer::handleEvent(TEvent& event)
{
if (event.what == evKeyDown)
    {
    TListViewer::handleEvent( event );
    switch( event.message.command )
	    {
	    case kbEnter:
		trackError(True);
		break;

	    case kbUp:
	    case kbDown:
	    case kbHome:
	    case kbEnd:
	    case kbPgUp:
	    case kbPgDn:
		trackError(False);
		break;

	    default:
		return;
	    }
    clearEvent(event);
    }
if (event.what == evBroadcast)
    {
    TListViewer::handleEvent( event );
    switch( event.message.command )
	    {
	    case cmReceivedFocus:
		if (event.message.infoPtr != this) return;
		if (!inMacro)
			{
			inMacro2 = True;
			trackError(False);
			inMacro = False;
			}
		else
			inMacro = False;
		break;

	    default:
		return;
	    }
    clearEvent( event );
    }
}

TMessageWindow::TMessageWindow( const char *fileName , const int winnum) :
	TWindow( TProgram::deskTop->getExtent(), "Message", winnum ),
	TWindowInit( &TMessageWindow::initFrame )
{

	palette = wpCyanWindow;
	options |= ofTileable;
//	number = winnum;
	flags |= wfMove | wfGrow | wfClose | wfZoom;
	growMode = gfGrowHiX | gfGrowHiY;
	TRect r( getExtent() );
	r.grow(-1, -1);

	messageViewer = new TMessageViewer( r,
					1,
					standardScrollBar(sbVertical),
					fileName);
	insert( messageViewer );
}

