program Dos_Door;

{ note: xdoor and xfileio can be found in the xDoor library }

uses crt, crtutil, dos, xdoor, xfileio;

{$M $4000,0,0}

var cmdbuf : array[1..15] of string[255];

function GetToken(aString, SepChar: String; TokenNum: Byte):String;
var
   Token     : String;
   StrLen    : Byte;
   TNum      : Byte;
   TEnd      : Byte;

begin
     StrLen := Length(aString);
     TNum   := 1;
     TEnd   := StrLen;
     while ((TNum <= TokenNum) and (TEnd <> 0)) do
     begin
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               Token := Copy(aString,1,TEnd-1);
               Delete(aString,1,TEnd);
               Inc(TNum);
          end
          else
          begin
               Token := aString;
          end;
     end;
     if TNum >= TokenNum then
     begin
          GetToken := Token;
     end
     else
     begin
          GetToken := '';
     end;
end;

function NumToken(aString, SepChar: String):Byte;
var
   RChar     : Char;
   StrLen    : Byte;
   TNum      : Byte;
   TEnd      : Byte;

begin
     if SepChar = '#' then
     begin
          RChar := '*'
     end
     else
     begin
         RChar := '#'
     end;
     StrLen := Length(aString);
     TNum   := 0;
     TEnd   := StrLen;
     while TEnd <> 0 do
     begin
          Inc(TNum);
          TEnd := Pos(SepChar,aString);
          if TEnd <> 0 then
          begin
               aString[TEnd] := RChar;
          end;
     end;
     NumToken := TNum;
end;

procedure updatebuf(s : string);
  var i : byte;
  begin
    if s <> '' then begin
      for i := 2 to 15 do cmdbuf[i-1] := cmdbuf[i];
      cmdbuf[15] := s;
    end;
  end;

procedure sm(s : string);
  var i : byte;
  begin
    for i := 1 to length(s) do if s[i] = '~' then begin
      if (isNum(s[i+1])) and (isNum(s[i+2])) then fg(stoi(s[i+1]+s[i+2]))
      else if upstring(s[i+1]+s[i+2]) = 'CR' then nl
      else cout(s[i]);
    end
    else if (upstring(s[i]) = '') and (isNum(s[i+1])) and (isNum(s[i+2])) then cgotoxy(stoi(s[i+1]+s[i+2]), wherey)
    else if (s[i-1] <> '~') and (s[i-1] <> '') and (s[i-2] <> '~') and (s[i-2] <> '') then cout(s[i])
  end;

procedure prompt;
  var dir : string;
  begin
    getdir(0, dir);
    sm('~07' + dir + '>');
  end;

procedure copyfile(s : string);
  var f1, f2: file;
      numread, numwritten: word;
      buf: array[1..2048] of char;
  begin
    assign(f1, getToken(s, #32, 2)); { Open input file }
    reset(f1, 1);  { Record size = 1 }
    assign(f2, getToken(s, #32, 3)); { Open output file }
    rewrite(f2, 1);  { Record size = 1 }
    repeat
      blockread(f1, buf, sizeof(buf), numread);
      blockwrite(f2, buf, numread, numwritten);
    until (numread = 0) or (numwritten <> numread);
    close(f1);
    close(f2);
  end;

procedure del(s : string);
  var f : file;
  begin
    delete(s, 1, 4);
    assign(f, s);
    {$I-} erase(f);
    {$I+} if ioresult <> 0 then sm('~07File not found~CR');
    sm('~CR');
  end;

procedure deltree(s : string);
  begin
    delete(s, 1, 8);
    {$I-} rmdir(s);
    {$I+} if ioresult <> 0 then sm('~07~CR');
    sm('~CR');
  end;

procedure ex(s : string);
  begin
    delete(s, 1, 3);
    shell(s);
  end;

procedure md(s : string);
  begin
    delete(s, 1, 3);
    {$I-} mkdir(s);
    {$I+} if ioresult <> 0 then sm('~07Error creating directory ' + s + '~CR');
    sm('~CR');
  end;

procedure dir(s : string);
  var f, f1 : text;
      t : string;
      prec : boolean;
  begin
    assign(f, 'dosdoor.tmp');
    assign(f1, 'dosdoor.tm1');
    if pos('/P', upstring(s)) <> 0 then prec := true
    else prec := false;
    if prec = true then delete(s, pos('/P', upstring(s)), 2);
    if pos('/', s) <> 0 then repeat
      delete(s, pos('/', s), 1);
    until pos('/', s) = 0;
    delete(s, 1, 3);
    s := trim(s);
    shell('dir ' + s + ' > dosdoor.tmp');
    reset(f);
    rewrite(f1);
    repeat
      readln(f, t);
      if pos('DOSDOOR  TMP', t) = 0 then writeln(f1, t);
    until eof(f);
    close(f);
    close(f1);
    morestr := 'Press enter to continue...';
    showfile('dosdoor.tm1', prec);
    sm('~CR');
    erase(f);
    erase(f1);
  end;

procedure typefile(s : string);
  var p : boolean;
  begin
    delete(s, 1, 5);
    if pos('/P', upstring(s)) <> 0 then begin
      delete(s, pos('/P', upstring(s)), 2);
      p := true;
      morestr := chr(13) + 'Press enter to continue...';
    end
    else p := false;
    s := trim(s);
    if fileexists(s) then begin
      nl;
      showfile(s, p);
      nl;
    end
    else begin
      coutln('|07File does not exist.');
      nl;
    end;
  end;

procedure readinfo(var s : string; len : byte);
  var xpos, buf : byte;
      done : boolean;
      key : char;
  begin
    xpos := wherex;
    buf := 16;
    done := false;
    s := '';
    repeat
      cgotoxy(xpos, wherey);
      cclreol;
      cout(s);
      key := inkey;
      case key of
        #32..#126: if length(s) <= len then s := s + key
          else s[length(s)] := key;
        #13: done := true;
        #8: if wherex > xpos then dec(s[0]);
        #0: begin
          key := inkey;
          case key of
            #72: if buf > 1 then begin                  { up }
              dec(buf);
              if cmdbuf[buf] <> '' then s := cmdbuf[buf]
              else inc(buf);
            end;
            #80: if buf < 15 then begin
              inc(buf);
              s := cmdbuf[buf];
            end
            else s := '';
          end;
          if s = '' then buf := 16;
        end;
      end;
    until done = true;
    nl;
  end;

procedure cdir(s : string);
  var dirRec : searchrec;
      dir : string;
  begin
    delete(s, 1, 2);
    s := trim(s);
    if s = '' then begin
      getdir(0, dir);
      sm('~07' + dir + '~CR~CR');
    end
    else if pos(#32, s) <> 0 then sm('~07Too many parameters~CR~CR')
    else if s = '\' then chdir('\')
    else if s[1] = '\' then begin
      delete(s, 1, 1);
      findfirst('\' + s, directory, dirRec);
      if dosError = 0 then chdir('\' + s)
      else sm('~07Invalid directory~CR~CR');
    end
    else begin
      findfirst(s, directory, dirRec);
      if dosError = 0 then chdir(s)
      else sm('~07Invalid directory~CR~CR');
    end;
  end;

procedure intro;
  begin
    cclrscr;
    nl;
    nl;
    coutln(doorName);
    coutln('   (C)Copyright 1997-98 Stoned Militia');
    nl;
  end;

function piece(s : string; b : byte) : string;
  var t : string;
      i : byte;
  begin
    t := '';
    for i := 1 to b do t := t + s[i];
    piece := t;
  end;

procedure main;
  var command : string;
      done : boolean;
  begin
    done := false;
    repeat
      prompt;
      readinfo(command, 255);
      updatebuf(command);
      command := trim(upstring(command));
      if command = 'EXIT' then done := true
      else if command = 'CLS' then cclrscr
      else if (piece(command, 2) = 'CD') then cdir(command)
      else if (piece(command, 5) = 'COPY ') then copyfile(command)
      else if (piece(command, 3) = 'DIR') or (command = 'DIR') then dir(command)
      else if (piece(command, 4) = 'DEL ') then del(command)
      else if (piece(command, 8) = 'DELTREE ') then deltree(command)
      else if (piece(command, 3) = 'EX ') then ex(command)
      else if (piece(command, 3) = 'MD ') then md(command)
      else if (piece(command, 5) = 'TYPE ') then typefile(command)
      else if command = 'VER' then intro
      else if (command[1] in ['A'..'Z']) and (command[2] = ':') then begin
        {$I-} chdir(command);
        {$I+} if ioResult <> 0 then sm('~07Invalid drive specification~CR~CR');
      end
      else if length(command) <> 0 then sm('~07Bad command or filename~CR~CR');
    until done = true;
  end;

procedure init;
  var i : byte;
  begin
    cfgname := 'dosdoor.cfg';
    doorName := 'DosDoor v1.1a';
    for i := 1 to 15 do cmdbuf[i] := '';
    useStatus := true;
    statusBg := 4;
    statusDark := 12;
    statusNormal := 12;
    statusBright := 12;
    initDoor;
  end;

begin
  init;
  intro;
  main;
end.