/*****************************************************************************/
/* Drunken Rumours Displayer v1.0 - (c) Cleaner/Drunken, November 2001       */
/* Code: Cleaner - Artwork: Dipswitch                                        */
/* Developing environment: FreeBSD 4.3 + Daydream 2.14                       */
/*****************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <dd.h>
#include <ddlib.h>

struct dif *d;
FILE *file;
int file_verify;

char color_01[16] = {  0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 };
char color_02[16] = { 30,34,32,36,31,35,33,37,30,34,32,36,31,35,33,37 };
char color_03[8]  = { 40,44,42,46,41,45,43,47 };     

char *buffer_rumour_file;
char *buffer_config_file;
char buffer_01[80];
char buffer_02[80];
char buffer_03[80];
char rumour_left;
char rumour_right;

int i;
int color_foreground;
int color_background;
int rumour_length;
int rumour_position_x;
int rumour_position_y;
int rumour_left_color_foreground;
int rumour_right_color_foreground;
int rumour_left_color_background;
int rumour_right_color_background;
int menu_prompt_position_y;
int display_left_and_right_characters;
int file_size;

struct stat stat_p;


/******************************************************************************/
/* DIE PROCEDURE                                                              */
/******************************************************************************/

void die(void)
{
   dd_close(d);
}


/******************************************************************************/
/* SET COLOR PROCEDURE                                                        */
/******************************************************************************/

void set_color(int color_foreground, int color_background)
{
   char color_string[10];
   sprintf(color_string,"\e[%i;%i;%im",color_01[color_foreground],color_02[color_foreground],color_03[color_background]);
   dd_sendstring(d,color_string);
}


/******************************************************************************/
/* SET CURSOR POSITION PROCEDURE                                              */
/******************************************************************************/

void set_position(int x, int y)
{
   sprintf(buffer_02,"\e[%i;%iH",y,x);
   dd_sendstring(d,buffer_02);
}    





/******************************************************************************/
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/******************************************************************************/

int main(int argc, char *argv[])
{
   srand((unsigned int)time((time_t *)NULL));

   if (argc==1)
   {
      printf("\n");
      printf("Drunken Rumours Displayer v1.0 - (c) Cleaner/Drunken, November 2001\n");
      printf("This program must be run from Daydream BBS software.\n");
      printf("\n");
      exit(1);
   }

   d=dd_initdoor(argv[1]);
   if (d==0)
   {
      printf("\n");
      printf("Drunken Rumours Displayer v1.0 - (c) Cleaner/Drunken, November 2001\n");
      printf("Couldn't find socket.\n");
      printf("\n");
   }
   atexit(die);

   sprintf(buffer_03,"%s/configs/dkn-rumours.cfg",getenv("DAYDREAM"));
   if ( (file_verify=open(buffer_03,O_RDONLY)) == -1)
   {
      printf("Can't open config file: dkn-rumours.cfg\n");
      exit(0);
   }
   close(file_verify);
   
   sprintf(buffer_03,"%s/data/dkn-rumours.dat",getenv("DAYDREAM"));
   if ( (file_verify=open(buffer_03,O_RDONLY)) == -1)
   {
      printf("Can't open data file: dkn-rumours.dat\n");
      exit(0);
   }
   close(file_verify);
   
   sprintf(buffer_03,"%s/configs/dkn-rumours.cfg",getenv("DAYDREAM"));
   stat(buffer_03, &stat_p);
   file_size=stat_p.st_size;
   buffer_config_file=(char *)malloc(file_size);   
   file=fopen(buffer_03,"r");
   fgets(buffer_01,80,file);
   rumour_length=atoi(buffer_01);
   fgets(buffer_01,80,file);
   fgets(buffer_01,80,file);
   display_left_and_right_characters=atoi(buffer_01); 
   fgets(buffer_01,80,file);
   rumour_position_x=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_position_y=atoi(buffer_01);
   fgets(buffer_01,80,file);   
   menu_prompt_position_y=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_left_color_foreground=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_left_color_background=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_right_color_foreground=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_right_color_background=atoi(buffer_01);
   for (i=0;i<11;i++)
   {
      fgets(buffer_01,80,file);
   }
   rumour_left=fgetc(file);
   fgets(buffer_01,80,file);
   rumour_right=fgetc(file);   
   fclose(file); 

   sprintf(buffer_03,"%s/data/dkn-rumours.dat",getenv("DAYDREAM"));
   stat(buffer_03, &stat_p);
   file_size=stat_p.st_size;
   buffer_rumour_file=(char *)malloc(file_size);   
   file=fopen(buffer_03,"r");
   fread(buffer_rumour_file,file_size,1,file);
   fclose(file);

   if (display_left_and_right_characters==1)
   {
      set_color(rumour_left_color_foreground,rumour_left_color_background);
      set_position(rumour_position_x,rumour_position_y);
      sprintf(buffer_02,"%c",rumour_left);
      dd_sendstring(d,buffer_02);

      set_color(rumour_right_color_foreground,rumour_right_color_background);
      set_position(rumour_position_x+rumour_length+1,rumour_position_y);
      sprintf(buffer_02,"%c",rumour_right);
      dd_sendstring(d,buffer_02);
   }

   i=(rand()%(file_size/(rumour_length+2)));   

   memcpy(buffer_01,buffer_rumour_file+((i)*(rumour_length+2)),rumour_length);
   color_foreground=buffer_rumour_file[rumour_length+((i)*(rumour_length+2))];
   color_background=buffer_rumour_file[(rumour_length+1)+((i)*(rumour_length+2))];
   set_color(color_foreground,color_background);
   if (display_left_and_right_characters==1)
   {
      set_position(rumour_position_x+1,rumour_position_y);
   }
   if (display_left_and_right_characters==0)
   {
      set_position(rumour_position_x,rumour_position_y);
   }   
   dd_sendstring(d,buffer_01);

   set_position(1,(menu_prompt_position_y-1));
   free(buffer_config_file);
   free(buffer_rumour_file);
   dd_close(d);
   return(0);
}

