/*****************************************************************************/ 
/* Drunken Rumours Editor v1.0 - (c) Cleaner/Drunken, November 2001          */
/* Code: Cleaner - Artwork: Dipswitch                                        */
/* Developing environment: FreeBSD 4.3 + Daydream 2.14                       */
/*****************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <dd.h>
#include <ddlib.h>
#include <string.h>


struct dif *d;
FILE *file;
int file_verify;

char color_01[16] = {  0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1 };
char color_02[16] = { 30,34,32,36,31,35,33,37,30,34,32,36,31,35,33,37 };
char color_03[8]  = { 40,44,42,46,41,45,43,47 };     

char *buffer_rumour_file;
char *buffer_config_file;
char buffer_01[80];
char buffer_02[80];
char buffer_03[80];
char rumour_left;
char rumour_right;
char door_text_01[1024];
char door_text_02[1024];
char door_text_03[1024];
char door_text_04[1024];
char door_text_05[1024];
char door_text_06[1024];

int i;
int j;
int color_foreground;
int color_background;
int door_text_position_x;
int door_text_position_y;
int rumour_length;
int rumour_page_position_x;
int rumour_page_position_y;
int rumour_left_color_foreground;
int rumour_right_color_foreground;
int rumour_left_color_background;
int rumour_right_color_background;
int rumour_prompt_position_x;
int rumour_prompt_position_y;
int rumour_page_length;
int allow_background_colors;
int offset;
int length;
int getkey;
int file_size;

struct stat stat_p;
time_t now;


/******************************************************************************/
/* DIE PROCEDURE                                                              */
/******************************************************************************/

void die(void)
{
   dd_close(d);
}


/******************************************************************************/
/* SET COLOR PROCEDURE                                                        */
/******************************************************************************/

void set_color(int color_foreground, int color_background)
{
   char color_string[10];
   sprintf(color_string,"\e[%i;%i;%im",color_01[color_foreground],color_02[color_foreground],color_03[color_background]);
   dd_sendstring(d,color_string);
}


/******************************************************************************/
/* SET CURSOR POSITION PROCEDURE                                              */
/******************************************************************************/

void set_position(int x, int y)
{
   sprintf(buffer_02,"\e[%i;%iH",y,x);
   dd_sendstring(d,buffer_02);
}    


/******************************************************************************/
/* CLEAR SCREEN PROCEDURE                                                     */
/******************************************************************************/

void clear_screen()
{
   dd_sendstring(d,"\e[2J");
}


/******************************************************************************/
/* DISPLAY A RUMOUR PAGE PROCEDURE                                            */
/******************************************************************************/

void display_page()
{
   length=((file_size/(rumour_length+2))-offset);
   if (length>rumour_page_length)
   {
      length=rumour_page_length;
   }
   
   for (i=0;i<length;i++)
   {  
      memcpy(buffer_01,buffer_rumour_file+((i+offset)*(rumour_length+2)),rumour_length);
      color_foreground=buffer_rumour_file[rumour_length+((i+offset)*(rumour_length+2))];
      color_background=buffer_rumour_file[rumour_length+1+((i+offset)*(rumour_length+2))];
      set_color(color_foreground,color_background);
      set_position(rumour_page_position_x+1,rumour_page_position_y+i);
      dd_sendstring(d,buffer_01);
   }

   if (length<rumour_page_length)
   {
      set_color(6,0);
      for (i=length;i<rumour_page_length;i++)
      {
         set_position(rumour_page_position_x+1,rumour_page_position_y+i);
         for (j=0;j<rumour_length;j++)
	 {
           buffer_02[j]=' ';
         }
         dd_sendstring(d,buffer_02);
      }   
   }
}


/******************************************************************************/
/* VIEW RUMOURS PROCEDURE                                                     */
/******************************************************************************/

void view_rumours()
{
   sprintf(buffer_03,"%s/data/dkn-rumours.dat",getenv("DAYDREAM"));
   if ( (file_verify=open(buffer_03,O_RDONLY)) == -1) 
   {
      printf("Can't open data file: dkn-rumours.dat\n");      
      exit(0);
   }
   close(file_verify);
   
   sprintf(buffer_03,"%s/data/dkn-rumours.dat",getenv("DAYDREAM"));
   stat(buffer_03, &stat_p);
   file_size=stat_p.st_size;
   buffer_rumour_file=(char *)malloc(file_size);
   file=fopen(buffer_03,"r");
   fread(buffer_rumour_file,file_size,1,file);
   fclose(file);

   for (i=0;i<rumour_page_length;i++)
   {
      set_position(rumour_page_position_x,rumour_page_position_y+i);
      set_color(rumour_left_color_foreground,rumour_left_color_background);
      sprintf(buffer_02,"%c",rumour_left);
      dd_sendstring(d,buffer_02);
      set_position(rumour_page_position_x+rumour_length+1,rumour_page_position_y+i);
      set_color(rumour_right_color_foreground,rumour_right_color_background);
      sprintf(buffer_02,"%c",rumour_right);
      dd_sendstring(d,buffer_02);
   }

   set_color(6,0);
   set_position(1,door_text_position_y);
   dd_sendstring(d,"                                                                               ");
   set_position(door_text_position_x,door_text_position_y);
   dd_sendstring(d,door_text_02);   
   
   offset=0;
   display_page();

   while( (getkey!='q') & (getkey!='Q') )
   {
      getkey = dd_hotkey(d,HOT_CURSOR);
      switch(getkey)
      {
         case 250:
	 if (offset>0)
         {
            offset=offset-rumour_page_length;
            display_page();
         }      
         break;

         case 251:
	 if (offset<((file_size/(rumour_length+2))-rumour_page_length))
         {     
            offset=offset+rumour_page_length;
            display_page();
         }
         break;            
      }
   }

   set_color(6,0);
   for (i=0;i<rumour_page_length;i++) 
   {
      set_position(1,rumour_page_position_y+i);
      dd_sendstring(d,"                                                                                ");
   }
}


/******************************************************************************/
/* EDIT RUMOURS PROCEDURE                                                     */
/******************************************************************************/

void edit_rumours()
{
   set_position(1,door_text_position_y);
   dd_sendstring(d,"                                                                               ");
   set_position(door_text_position_x,door_text_position_y);
   dd_sendstring(d,door_text_03);

   set_position(rumour_prompt_position_x,rumour_prompt_position_y);
   color_foreground=1;
   color_background=0;
   set_color(color_foreground,color_background);

   for (i=0;i<rumour_length;i++)
   {
      buffer_01[i]=0;
   }

   dd_prompt(d,buffer_01,rumour_length,PROMPT_NOCRLF);

   for (i=0;i<rumour_length;i++)
   {
      if (buffer_01[i]==0)
      {
         buffer_01[i]=32;
      }
   }
     
   set_position(1,door_text_position_y);
   dd_sendstring(d,"                                                                               ");
   set_position(door_text_position_x,door_text_position_y);

   if (allow_background_colors==1)
   {
      dd_sendstring(d,door_text_04);
   }
   if (allow_background_colors==0)
   {
      dd_sendstring(d,door_text_05);
   }

   while(getkey!=13)
   {
      getkey = dd_hotkey(d,HOT_CURSOR);
      switch(getkey)
      {
         case 250: 
         if (color_foreground<15)   
         {
            color_foreground++;
            set_color(color_foreground,color_background); 
            set_position(rumour_prompt_position_x,rumour_prompt_position_y);
            dd_sendstring(d,buffer_01);
         }
         break;

         case 251:   
         if (color_foreground>0)   
         {
            color_foreground--;
            set_color(color_foreground,color_background); 
            set_position(rumour_prompt_position_x,rumour_prompt_position_y);  
            dd_sendstring(d,buffer_01);
         }
         break;
	
         case 252:   
         if (allow_background_colors==1)
         { 
            if (color_background<7)   
            {
               color_background++;
               set_color(color_foreground,color_background);  
               set_position(rumour_prompt_position_x,rumour_prompt_position_y);
               dd_sendstring(d,buffer_01);
            }
         }
         break;

         case 253:
         if (allow_background_colors==1)
         {
            if (color_background>0)   
            {
               color_background--;
       	       set_color(color_foreground,color_background);   
               set_position(rumour_prompt_position_x,rumour_prompt_position_y);  
               dd_sendstring(d,buffer_01);
            }
         }
         break;      
      }
   }

   set_color(6,0); 
   set_position(1,door_text_position_y);
   dd_sendstring(d,"                                                                               ");
   set_position(door_text_position_x,door_text_position_y);
   dd_sendstring(d,door_text_06);

   i=0;

   while(i==0)
   {
      getkey = dd_hotkey(d,HOT_CURSOR);
      switch(getkey)
      {
         case 'y': 
         case 'Y':
         sprintf(buffer_03,"%s/data/dkn-rumours.dat",getenv("DAYDREAM"));
         file=fopen(buffer_03,"a");
         fputs(buffer_01,file);
         fputc(color_foreground,file);
         fputc(color_background,file);
         fclose(file);

         sprintf(buffer_03,"%s/logfiles/dkn-rumours.log",getenv("DAYDREAM"));
         file=fopen(buffer_03,"a");
         fputs(buffer_01,file);
         fputs("\n",file);   
         fputs("Entered By: ",file);
         dd_getstrval(d, buffer_01, USER_HANDLE);
         fputs(buffer_01,file);
         fputs(" (",file);
         dd_getstrval(d, buffer_01, USER_ORGANIZATION);
         fputs(buffer_01,file);
         sprintf(buffer_02,") - %s",ctime(&now));
         fputs(buffer_02,file);
         fputs("-------------------------------------------------------------------------------\n",file);
         fclose(file);
	 i=1;
	 break;

         case 'n': 
         case 'N':
	 i=1;
	 break;
      }
   }   

   set_position(rumour_prompt_position_x,rumour_prompt_position_y);
   for (j=0;j<rumour_length;j++)
   {
      buffer_02[j]=' ';
   }
   dd_sendstring(d,buffer_02);
   
   set_position(1,door_text_position_y);
   dd_sendstring(d,"                                                                               ");
}





/******************************************************************************/
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/* MAIN PROCEDURE                                                             */
/******************************************************************************/

int main(int argc, char *argv[])
{
   now = time((time_t *)NULL);

   if (argc==1)
   {
      printf("\n");
      printf("Drunken Rumours Editor v1.0 - (c) Cleaner/Drunken, November 2001\n");
      printf("This program must be run from Daydream BBS software.\n");
      printf("\n");
      exit(1);
   }

   d=dd_initdoor(argv[1]);
   if (d==0)
   {
      printf("\n");
      printf("Drunken Rumours Editor v1.0 - (c) Cleaner/Drunken, November 2001\n");
      printf("Couldn't find socket.\n");
      printf("\n");
   }
   atexit(die);

   sprintf(buffer_03,"%s/configs/dkn-rumours.cfg",getenv("DAYDREAM"));
   if ( (file_verify=open(buffer_03,O_RDONLY)) == -1) 
   {
      printf("Can't open config file: dkn-rumours.cfg\n");      
      exit(0);
   }
   close(file_verify);
   
   sprintf(buffer_03,"%s/configs/dkn-rumours.cfg",getenv("DAYDREAM"));
   stat(buffer_03, &stat_p);
   file_size=stat_p.st_size;
   buffer_config_file=(char *)malloc(file_size);
   file=fopen(buffer_03,"r");
   fgets(buffer_01,80,file);
   rumour_length=atoi(buffer_01);
   fgets(buffer_01,80,file);
   allow_background_colors=atoi(buffer_01);
   for (i=0;i<9;i++)
   {
      fgets(buffer_01,80,file);
   }
   rumour_left_color_foreground=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_left_color_background=atoi(buffer_01);
   fgets(buffer_01,80,file);   
   rumour_right_color_foreground=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_right_color_background=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_page_position_x=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_page_position_y=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_page_length=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_prompt_position_x=atoi(buffer_01);
   fgets(buffer_01,80,file);
   rumour_prompt_position_y=atoi(buffer_01);
   fgets(buffer_01,80,file);
   door_text_position_x=atoi(buffer_01);
   fgets(buffer_01,80,file);
   door_text_position_y=atoi(buffer_01);
   rumour_left=fgetc(file);
   fgets(buffer_01,80,file);
   rumour_right=fgetc(file);
   fgets(buffer_01,80,file);
   fgets(door_text_01,1024,file);   	 
   fgets(door_text_02,1024,file);   	     
   fgets(door_text_03,1024,file);
   fgets(door_text_04,1024,file);
   fgets(door_text_05,1024,file);
   fgets(door_text_06,1024,file);
   fclose(file);     

   clear_screen();
   set_position(1,1);
   dd_typefile(d,"dkn-rumours", TYPE_MAKE|TYPE_WARN);

   set_position(1,door_text_position_y);
   dd_sendstring(d,"                                                                               ");
   set_position(door_text_position_x,door_text_position_y);
   dd_sendstring(d,door_text_01);
            
   while( (getkey!='q') & (getkey!='Q') )
   {
      getkey = dd_hotkey(d,HOT_CURSOR);
      switch(getkey)
      {
         case 'v':
         case 'V':	 
         view_rumours();
         getkey=0;
         set_color(6,0);
         set_position(1,door_text_position_y);
         dd_sendstring(d,"                                                                               ");
         set_position(door_text_position_x,door_text_position_y);
         dd_sendstring(d,door_text_01);
         break;
         
	 case 'e':
	 case 'E':
         edit_rumours();
         getkey=0;
         set_color(6,0);
         set_position(1,door_text_position_y);
         dd_sendstring(d,"                                                                               ");
         set_position(door_text_position_x,door_text_position_y);
         dd_sendstring(d,door_text_01);
         break;
      }
   }   

   set_position(1,24);   
   free(buffer_config_file);   
   free(buffer_rumour_file);
   return(0);
}

