#include <daydream.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#ifdef UNIX
#include <unistd.h>
#endif
#include <string.h>

int joinconf(int confn, int flags)
{
	int newconfnum;
	int bcnt;
	struct DayDream_Conference *tconf;
	struct DayDream_MsgBase *tbase;
	char jbuffer[100];
	
	newconfnum=confn;

	changenodestatus("Changing conference");
	
	if ((flags & JC_LIST) && newconfnum==0) {
		TypeFile("joinconference",TYPE_WARN|TYPE_MAKE);
	}

	while (newconfnum==0)
	{
		jbuffer[0]=0;
		DDPut(sd[jcpromptstr]);
		if (!(Prompt(jbuffer,3,0))) return 0;
		if ((!strcasecmp(jbuffer,"l")) || jbuffer[0]=='?')
			TypeFile("joinconference",TYPE_WARN|TYPE_MAKE);
		else if (jbuffer[0]==0)
			return 0;
		else
			newconfnum=atoi(jbuffer);
	}

	if (!checkconfaccess(newconfnum,&user)) {
		if (!(flags & JC_SHUTUP)) {
			DDPut(sd[jcnoaccessstr]);
		}
		return 0;
	}
	
	tconf=confs;
	while (1)
	{
		if(tconf->CONF_NUMBER==255) {
			if (!(flags & JC_SHUTUP)) {
				DDPut(sd[jcnoconfstr]);
			}
			return 0;
		}

		if (tconf->CONF_NUMBER==newconfnum) {
			if (*tconf->CONF_PASSWD && !(flags & JC_SHUTUP) && !(flags & JC_QUICK)) {
				struct DayDream_Conference *oc;
				oc=conf;
				conf=tconf;
				TypeFile("conferencepw",TYPE_CONF|TYPE_MAKE);
				conf=oc;
				DDPut("[36mConference password: [0m");
				*jbuffer=0;
				if (!(Prompt(jbuffer,16,PROMPT_SECRET))) return 0;
				if (strcasecmp(jbuffer,tconf->CONF_PASSWD)) return 0;
			}
			user.user_joinconference=newconfnum;
			conf=tconf;
			(struct DayDream_Conference *)base=conf+1;
			if (!(flags & JC_QUICK)) { 
				TypeFile("conferencejoined",TYPE_MAKE|TYPE_CONF);
			}
			if (flags & JC_QUICK) {
				changemsgbase(base->MSGBASE_NUMBER, MC_QUICK|MC_NOSTAT);
			} else {
				changemsgbase(base->MSGBASE_NUMBER, MC_QUICK);
			}
			return 1;
		}
		(struct DayDream_Conference *)tbase=tconf+1;    
		bcnt=tconf->CONF_MSGBASES;
		while(bcnt)
		{
			tbase++;
			bcnt--;
		}
		tconf=(struct DayDream_Conference *)tbase;
	}
}

int checkconfaccess(int confn, struct userbase *usa)
{
	int newcn=confn-1;
	
	if (newcn < 32) {
		if (usa->user_conferenceacc1 & (1L<<newcn)) return 1;
	} else {
		newcn-=32;
		if (usa->user_conferenceacc2 & (1L<<newcn)) return 1;
	}
	return 0;
}

int nextconf(void)
{
	int bcnt;
	struct DayDream_Conference *tconf;
	struct DayDream_MsgBase *tbase;

	tconf=conf;
	
	while (1)
	{
		(struct DayDream_Conference *)tbase=tconf+1;    
		bcnt=tconf->CONF_MSGBASES;
		while(bcnt)
		{
			tbase++;
			bcnt--;
		}
		tconf=(struct DayDream_Conference *)tbase;

		if(tconf->CONF_NUMBER==255) {
			return joinconf(0,JC_LIST);
		}

		if (checkconfaccess(tconf->CONF_NUMBER,&user)) {
			return joinconf(tconf->CONF_NUMBER,0);
		}
	}       
}

int prevconf(void)
{
	int cconf;
	
	cconf=conf->CONF_NUMBER;
	
	if (cconf==1) return joinconf(0,JC_LIST);
	
	for (cconf=conf->CONF_NUMBER-1;cconf;cconf--)
	{
		if (joinconf(cconf,0)) return 1;
	}
	return 0;
}

int joinconfmenu(char *jcparams)
{
	if (!jcparams) return joinconf(0,JC_LIST);
	if (jcparams[0]=='l' || jcparams[0]=='L' || jcparams[0]=='?') return joinconf(0,JC_LIST);
	return joinconf(atoi(jcparams),JC_LIST);
}

int cmbmenu(char *cmbparams)
{
	if (!cmbparams) return changemsgbase(0,0);
	return changemsgbase(atoi(cmbparams),0);

}

int nextbase(void)
{
	return changemsgbase(base->MSGBASE_NUMBER+1,0);
}

int prevbase(void)
{
	return changemsgbase(base->MSGBASE_NUMBER-1,0);
}

int changemsgbase(int newb, int flags)
{
	char cbuffer[500];
	int basen;
	struct DayDream_MsgBase *cb;
	int i;
	
	basen=newb;     
	if ((basen==0) && (!(flags & MC_QUICK))) {
		if (conf->CONF_MSGBASES==1) {
			DDPut(sd[cmbonlymsgsstr]);
			return 0;
		}               
		TypeFile("messagebases",TYPE_WARN|TYPE_CONF|TYPE_MAKE);
	}

	while (!basen)
	{
		DDPut(sd[cmbselectstr]);
		cbuffer[0]=0;
		if (!(Prompt(cbuffer,3,0))) return 0;
		if (!strcasecmp(cbuffer,"?") || (!strcasecmp(cbuffer,"l"))) {
			TypeFile("messagebases",TYPE_WARN|TYPE_CONF|TYPE_MAKE);
		} else if (cbuffer[0]==0) {
			return 0;
		} else basen=atoi(cbuffer);
	}
	(struct DayDream_Conference *)cb=(struct DayDream_Conference *)conf+1;
	for (i=conf->CONF_MSGBASES;i;i--)
	{
		if (cb->MSGBASE_NUMBER==basen) {

			struct DayDream_LRP lrpd;
			int lrpfd;

			base=cb;
			getmsgptrs();
			if (lrpdatname[0] && (oldlrp!=lrp || oldlsp!=lsp)) {
				struct DayDream_LRP lrpd;
				int lrpfd;
				struct stat st;
				
				lrpfd=open(lrpdatname,O_WRONLY|O_CREAT,0664);
				if (lrpfd==-1) {
					DDPut(sd[cmberrlrpstr]);
					return 0;
				}
				fstat(lrpfd,&st);
				if ((int)(user.user_account_id * sizeof(struct DayDream_LRP)) > (int)st.st_size) {
					char *cmem;
					char *s;
					int sta,p;
					
					sta=user.user_account_id*sizeof(struct DayDream_LRP) - st.st_size;
					cmem=(char *)malloc(sta);
					s=cmem;
					for (p=0;p!=sta;p++) *s++=0;
					lseek(lrpfd,0,SEEK_END);
					write(lrpfd,cmem,sta);                                  
					free(cmem);
				}
				lrpd.lrp_read=lrp;
				lrpd.lrp_scan=lsp;
				lseek(lrpfd,sizeof(struct DayDream_LRP)*user.user_account_id,SEEK_SET);
				write(lrpfd,&lrpd,sizeof(struct DayDream_LRP));
				close(lrpfd);
			}
			sprintf(lrpdatname,"%smessages/base%3.3d/msgbase.lrp",conf->CONF_PATH,cb->MSGBASE_NUMBER);
			lrpfd=open(lrpdatname,O_RDONLY);

			lrp=0;
			lsp=0;
			oldlrp=0;
			oldlsp=0;

			if (lrpfd!=-1) {
				if ((lseek(lrpfd,sizeof(struct DayDream_LRP)*user.user_account_id,SEEK_SET)) != -1) {
					if (read(lrpfd,&lrpd,sizeof(struct DayDream_LRP))) {
						oldlrp=lrp=lrpd.lrp_read;
						oldlsp=lsp=lrpd.lrp_scan;
					}
				}
				close(lrpfd);
			}
			base=cb;
			getmsgptrs();
			
			if ((flags & MC_NOSTAT)==0) {
				sprintf(cbuffer,sd[cmbstat1str],base->MSGBASE_NAME,highest-lowest);
				DDPut(cbuffer);
				sprintf(cbuffer,sd[cmbstat2str],lrp,lsp);
				DDPut(cbuffer);
				sprintf(cbuffer,sd[cmbstat3str],lowest,highest);
				DDPut(cbuffer);
			}
			return 1;
		}
		cb++;
	}
	DDPut(sd[cmbunkbasestr]);
	return 0;               
}

struct DayDream_Conference *findconf(int cnum)
{
	struct DayDream_MsgBase *tbase;
	int bcnt;
	struct DayDream_Conference *tconf=confs;
	
	while (1)
	{
		if(tconf->CONF_NUMBER==255 || !tconf->CONF_NUMBER) {
			return 0;
		}

		if (tconf->CONF_NUMBER==cnum) {
			return tconf;
		}
		(struct DayDream_Conference *)tbase=tconf+1;    
		bcnt=tconf->CONF_MSGBASES;
		while(bcnt)
		{
			tbase++;
			bcnt--;
		}
		tconf=(struct DayDream_Conference *)tbase;
	}
}
