#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "daydream.h"
#include <fcntl.h> 
#ifdef UNIX
#include <unistd.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>

#ifndef UTMP_FILE
#define UTMP_FILE _PATH_UTMP
#endif

int node;
int bpsrate;

/*
char *sd[wildverstr]=" [0;32m([33m%s[32m/[33m%s[32m)[36m? [32m([33mY[32m/[33mn[32m)[36m:[0m ";
char *sd[uberrstr]="[0mCan not open data/userbase.dat\n";
char *sd[ubrerrstr]="\n[35mReading userbase failed!\n";
*/

int isonline(int);
int isonck(struct DayDream_Multinode *, int, int );

int mktempdir(void)
{
#ifdef UNIX
	return mkdir(currnode->MULTI_TEMPORARY,0755);
#else
	return mkdir(currnode->MULTI_TEMPORARY,0755);
#endif
}

int runlogoffbatch(void)
{
	char buf[512];
	sprintf(buf,"batch/batch%d.logoff %d",node,node);
	runstdio(buf,0,3);
	return 1;
}

void removespaces(char *strh)
{
	char *s;
	s=strh;
	if (!*s) return;
	while(*s) s++;
	s--;
	while (*s==' ') s--;
	*(s+1)=0;
}

void changenodestatus(char *newstatus)
{
	struct DayDream_NodeInfo ddn;
	char infoname[80];
	int myfd;
		
	if (bgmode) return; 
	
	ddn.ddn_pid=getpid();
	ddn.ddn_flags=0;
	if (onlinestat) {
		ddn.ddn_userslot=user.user_account_id;
		if ( (user.user_toggles & (1L<<9))==0) {
			ddn.ddn_flags |= (1L<<0);
		}
	} else 
	  ddn.ddn_userslot=-1;
	strcpy(ddn.ddn_activity,newstatus);
	ddn.ddn_bpsrate=bpsrate;
	strncpy(ddn.ddn_pagereason,reason,79);
	strncpy(ddn.ddn_path,origdir,79);
	ddn.ddn_timeleft=timeleft;
	
	sprintf(infoname,"%snodeinfo%d.data",DDTMP,node);	
	myfd=open(infoname,O_WRONLY|O_CREAT,0644);
	if (myfd!=-1) {
		write(myfd,&ddn,sizeof(struct DayDream_NodeInfo));
		close(myfd);
	}
}

char *currt(void)
{
	time_t tt;
	
	tt=time(0);
	return ctime(&tt);
}

void writelog(char *strh)
{
	char buffer[80];
	int  logfd;
		
	
	sprintf(buffer,"%s/logfiles/daydream%d.log",origdir,node);
	logfd = open(buffer,O_WRONLY|O_CREAT,0660);
	if (logfd < 0) return;
	
	lseek(logfd,0,SEEK_END);
	write(logfd,strh,strlen(strh));
	close(logfd);
}


char *nextword(char *strh)
{
	for (;;)
	{
		if (*strh==' ') {
			while (*strh==' ') strh++;
			return strh;
		}		
		if (*strh==0) return strh;
		strh++;
	}
}

int wildcmp (char *nam, char *pat)
{
	register char *p;              /* Thu Jan 16 14:50:30 1992 */

	for (;;)
	{
		if (tolower(*nam) == tolower(*pat)) {
			if(*nam++ == '\0')  return(1);
			pat++;
		} else if (*pat == '?' && *nam != 0) {
		    	nam++;
		    	pat++;
		} else	break;
	}

	if (*pat != '*') return(0);

	while (*pat == '*') {
		if (*++pat == '\0')  return(1);
	}

	for (p=nam+strlen(nam)-1;p>=nam;p--) {
		if (tolower(*p) == tolower(*pat))
			if (wildcmp(p,pat) == 1) return(1);
	}
	return(0);
}


void strcupr (char *dest, char *strh)
{
	while (*strh)
	{
		*dest++=toupper(*strh++);
	}
	*dest=0;
}


int iswilds (char *strh)
{
	while (*strh) 
	{
		if (*strh=='*' || *strh=='?') return 1;
		strh++;
	}
	return 0;
}

int findusername(char *name, int mode)
{
	int base;
	int cnt=0;
	struct userbase ub;
	char bp[200];
	
	if (!strcasecmp(name,"sysop")) return 0;
	
	sprintf(bp,"%s/data/userbase.dat",origdir);

	base=open(bp,O_RDWR,0);
	if (base!=-1) {
		while(read(base,&ub,sizeof(struct userbase))) {
			if ((ub.user_toggles & (1L<<30)) && ((ub.user_toggles & (1L<<31)) == 0)) {						
				cnt++;
				continue;
			}

			if (iswilds(name) && mode==0) {
				if (wildcmp(ub.user_realname,name) || wildcmp(ub.user_handle,name)) {
					sprintf(bp,sd[wildverstr],ub.user_realname,ub.user_handle);
					DDPut(bp);
					close(base);
					if (HotKey(HOT_YESNO)==1) {
						return(cnt);
					} else return -2;
				}
			} else {
				if (!strcmpi(ub.user_realname,name) || !strcmpi(ub.user_handle,name)) {
					close(base);
					return(cnt);
				}
			}
			cnt++;
		} 
		close(base);
		return(-1);
	} else {
		if (!mode) DDPut(sd[uberrstr]);
		return(-1);
	}
}

int checklogon(char *name)
{
	int userpos;
	int base;

	userpos=findusername(name,0);
	if (userpos==-1) return(0);
	if (userpos==-2) return -1;
	if ( (maincfg.CFG_FLAGS & (1L<<8))==0 && isonline(userpos)) return 2;
	base=open("data/userbase.dat",O_RDONLY);
	if (base!=-1) {
		lseek(base,userpos*sizeof(struct userbase),SEEK_SET);
		if (read(base,&user,sizeof(struct userbase))==0) {
			DDPut(sd[ubrerrstr]);
			close(base);
			return 0;
		} else {
			clog.cl_userid=user.user_account_id;
			clog.cl_firstcall=user.user_firstcall;
			clog.cl_logon=time(0);
			if (user.user_connections==0) clog.cl_flags |= CL_NEWUSER;
			clog.cl_bpsrate=bpsrate;
			close(base);
			return 1;
		}
	}
	return 0;
}

int cmppasswds(char *passwd, unsigned char *thepw)
{
	MD_CTX context;
	unsigned char digest[16];
	char newpw[30];
	int i;

	for (i=0;i<16;i++) {
		if (thepw[i]) {
			i=100;
			break;
		}
	}
	if (i!=100) return 1;
	
	strcpy(newpw,passwd);
	strupr(newpw);

        MDInit (&context);
        MDUpdate (&context, newpw, strlen(newpw));
        MDFinal (digest, &context);

	for (i=0;i<16;i++) {
		if(thepw[i]!=digest[i]) return(0);
	}
	return(1);
}


int isonline(int id)
{
	struct DayDream_Multinode *cn;
	
	cn=nodes;
	
	while(cn->MULTI_NODE)
	{
		if (cn->MULTI_NODE == 253) {
			int j;
			int i=maincfg.CFG_TELNET1ST;
			j=maincfg.CFG_TELNETMAX;
			
			while(j) {
				j--;
				if (isonck(cn,i,id)) return i+1;
				i++;
			}
		} else if (cn->MULTI_NODE == 254) {
			int j;
			int i=maincfg.CFG_LOCAL1ST;
			j=maincfg.CFG_LOCALMAX;
			
			while(j) {
				j--;
				if (isonck(cn,i,id)) return i+1;
				i++;
			}
		} else if (cn->MULTI_NODE!=252) {
			if (isonck(cn,cn->MULTI_NODE,id)) return cn->MULTI_NODE+1;
		}
		cn++;
	}
	return 0;
}

int isonck(struct DayDream_Multinode *cn, int num, int id)
{
	struct DayDream_NodeInfo myn;
	
	if (isnode(num,&myn)) {
		if (myn.ddn_userslot==id) return 1;
	}
	return 0;
}

