/* SplitScreen Chatter for DayDream
 * version 0.5
 * 
 * Copyright (C) 1997 Wedge
 * 
 */

#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <stdarg.h>
#include "daydream.h"
#include "dd.h"
#include "spc.h"

#define helpfilename "./display/spc-help.txt"

#define cls(dest) (ssputs((dest), "\033[2J"))

#define SYSCOLORDEFAULT 35
#define USRCOLORDEFAULT 32

#define bordercolor "\033[0;37m"
#define crightcolor "\033[0;41;33;1m"
#define cursorcolor "\033[0;41;1m"

#define wndusr 0
#define wndsys 1 

#define attrusr 1
#define attrsys 2
#define attrcur 3
#define attrbrd 4
#define attrcop 5
#define attrcusr 6
#define attrcsys 7

#define showcursor 1
#define hidecursor 0

#define SCROLLAMOUNT 3

#define BLIT 1
#define NOBLIT 0

#ifndef min
#define min(a, b) (((a)<(b))?(a):(b))
#endif

#define outcu(ch) (wputc(0, (ch)), wputc(2, (ch)))
#define outcs(ch) (wputc(1, (ch)), wputc(3, (ch)))
#define lfu() (linefeed(0, 1, BLIT), linefeed(2, 1, BLIT))
#define lfs() (linefeed(1, 1, BLIT), linefeed(3, 1, BLIT))
#define cdu() (linefeed(0, 0, BLIT), linefeed(2, 0, BLIT))
#define cds() (linefeed(1, 0, BLIT), linefeed(3, 0, BLIT))
#define goto_bol(n) ((pseudogotoxy((n)&1, 0, windows[(n)&1].cursory)),\
                     (pseudogotoxy((n)|2, 0, windows[(n)|2].cursory)))

#define ssputs(a, b) (SDPut((b), (a)))
#define invdevcoords(n) (*wcursorx[(n)]=-1)
#define validup(n) (min(windows[(n)&1].cursory, windows[2|((n)&1)].cursory))

#define DEBUG
#define SYSOPQUITONLY

char *sysstr="Coded by Wedge - press ESC twice to quit, Ctrl-I for more information";
char *usrstr="Coded by Wedge - press Ctrl-I for more information";

typedef struct {
	int cursorstate;
	int cornery;
	int cursorx;
	int cursory;
	int height;
	char *contents;
} twindow;

twindow windows[4];
int spcprogress=0;
int remoteattr;
int localattr;
int remotecursorx;
int remotecursory;
int localcursorx;
int localcursory;
int refresh_needed;
int brokenwords[4];
char wprintbuffer[512];
int *wcursorx[4]={&localcursorx, &localcursorx, &remotecursorx, &remotecursorx};
int *wcursory[4]={&localcursory, &localcursory, &remotecursory, &remotecursory};
int *pcursorx[3]={NULL, &localcursorx, &remotecursorx};
int *pcursory[3]={NULL, &localcursory, &remotecursory};
int outdevs[4]={DDPutLocal, DDPutLocal, DDPutRemote, DDPutRemote};
int txtattrs[4]={attrusr, attrsys, attrusr, attrsys};
int curattrs[4]={attrcusr, attrcsys, attrcusr, attrcsys};
int *attrlocs[3]={NULL, &localattr, &remoteattr};
char *attrtab[8]={NULL, NULL, NULL, 
                  cursorcolor, bordercolor, crightcolor,
                  NULL, NULL};

void ssputc(int outdev, char ch)
{
	char temp[2]={ch, 0};
	SDPut(temp, outdev);
}

void gotoxy(int outdev, int x, int y)
{
	char temp[256];
	if (*pcursorx[outdev]==x&&*pcursory[outdev]==y)
		return;
	sprintf(temp, "\033[%d;%dH", y+1, x+1); 
	SDPut(temp, outdev);
	*pcursorx[outdev]=x;
	*pcursory[outdev]=y;
}

void blit_row(int number, int row)
{
	char temp[79];
	twindow *win=&windows[number];
	setattr(outdevs[number], txtattrs[number]);
	temp[78]=0;
	memcpy(temp, &win->contents[78*row], 78);       
	gotoxy(outdevs[number], 1, 1+win->cornery+row);
	ssputs(outdevs[number], temp);
}
	
void blit_window(int number)
{
	int i;
	for (i=0; i<windows[number].height; i++) 
		blit_row(number, i);
	invdevcoords(number);
}

void delete_char(int number)
{
	char *src;
	twindow *win;
	int cursorstate, i, j;
	for (j=0; j<2; j++) {
		number=(number&1)|(j<<1);
		win=&windows[number];
		cursorstate=win->cursorstate;
		src=&win->contents[win->cursory*78+win->cursorx];
		for (i=win->cursorx; i<77; i++) {
			src[0]=src[1];
			src++;
		}
		win->contents[win->cursory*78+77]=32;
		pseudocursor(number, hidecursor);
		blit_row(number, win->cursory);
		invdevcoords(number);
		pseudocursor(number, cursorstate);
	}
}

void scrollwindow(int number, int blit)
{
	twindow *win=&windows[number];
	memcpy(win->contents, &win->contents[SCROLLAMOUNT*78], 
	       (win->height-SCROLLAMOUNT)*78);
	memset(&win->contents[(win->height-SCROLLAMOUNT)*78], 32, 
	       SCROLLAMOUNT*78);
	if (blit)
		blit_window(number);
	windows[number].cursory-=SCROLLAMOUNT;
}

void clearwindow(int number)
{
	memset(windows[number].contents, 32, windows[number].height*78);
}

void setattr(int outdev, int attrneeded)
{
	if (*attrlocs[outdev]!=attrneeded) {
		ssputs(outdev, attrtab[attrneeded]);
		*attrlocs[outdev]=attrneeded;
	}
}

void linefeed(int number, int resetcursorx, int blit)
{
	int cursorstate;
	twindow *win=&windows[number];
	cursorstate=win->cursorstate;
	pseudocursor(number, hidecursor);
	if (resetcursorx)
		win->cursorx=0;
	if (++win->cursory>=win->height) 
		scrollwindow(number, blit);
        pseudocursor(number, cursorstate);
}

#define wgetch(w, x, y) ((w)->contents[(x)+(y)*78])

void wputc(int number, int ch)
{
	twindow *win=&windows[number];
	int cursorstate=win->cursorstate;
	pseudocursor(number, hidecursor);
	if (brokenwords[number]) {
		if (isgraph(ch) && win->cursory) {
			int i=77, y=win->cursory-1;
			
			for (; i>=0; i--) {
				if ((!isgraph(wgetch(win, i, y))))
					break;
			}
			
			if (i>50) {
				int j, k;
				for (j=i+1, k=0; j<78; j++, k++) {
					win->contents[y*78+k+78]=
					wgetch(win, j, y);
					win->contents[y*78+j]=32;
				}
				win->cursorx=k;
				invdevcoords(number);
			}
		}
		blit_row(number, win->cursory);
		blit_row(number, win->cursory-1);
		invdevcoords(number);
		brokenwords[number]=0;
	}
	setattr(outdevs[number], txtattrs[number]);
	gotoxy(outdevs[number], win->cursorx+1, win->cursory+1+win->cornery);
	ssputc(outdevs[number], ch);
	win->contents[win->cursorx+win->cursory*78]=ch;
	if (++win->cursorx>=78) {
		linefeed(number, 1, BLIT);
		brokenwords[number]=1;
	}	
	pseudocursor(number, cursorstate);
}

void delc(int number)
{
	int tempx, tempy;
	twindow *win=&windows[number];
	int cursorstate=win->cursorstate;
	pseudocursor(number, hidecursor);
	if (--win->cursorx<0) {
		win->cursorx=77;
		win->cursory--;
	}
	tempx=win->cursorx;
	tempy=win->cursory;
	wputc(number, 32);
	win->cursorx=tempx;
	win->cursory=tempy;
	invdevcoords(number);
	pseudocursor(number, cursorstate);
}

void backspace(int number)
{
	int bn1=number&1;
	int bn2=bn1|2;
	twindow *win1=&windows[bn1];
	twindow *win2=&windows[bn2];
	if (win1->cursorx || validup(number)) {		
		if (win1->cursorx) {
			pseudogotoxy(bn1, win1->cursorx-1, win1->cursory);
			pseudogotoxy(bn2, win2->cursorx-1, win2->cursory);
		} else {
			pseudogotoxy(bn1, 77, win1->cursory-1);
			pseudogotoxy(bn2, 77, win2->cursory-1);
		}
		delete_char(number);
	}
}

void pseudogotoxy(int number, int x, int y)
{
	twindow *win=&windows[number];
	int cursorstate=win->cursorstate;
	pseudocursor(number, hidecursor);
	win->cursorx=x;
	win->cursory=y;
	invdevcoords(number);
	pseudocursor(number, cursorstate);
}

void moveup(int src)
{
	int bn1=(src==1)?wndusr:wndsys, bn2=bn1|2;
	twindow *win1=&windows[bn1];
	twindow *win2=&windows[bn2];
	if (validup(bn1)) {
		pseudogotoxy(bn1, win1->cursorx, win1->cursory-1);
		pseudogotoxy(bn2, win2->cursorx, win2->cursory-1);
	}
}

void moveleft(int src)
{
	int bn1=(src==1)?wndusr:wndsys, bn2=bn1|2;
	twindow *win1=&windows[bn1];
	twindow *win2=&windows[bn2];
#ifdef DEBUG
	if (windows[bn1].cursorx!=windows[bn2].cursorx) {
		SDPut("Debug Alert! cursorx\'s do not match", DDPutBoth);
	}
#endif   
	if (win1->cursorx>0) {
		pseudogotoxy(bn1, win1->cursorx-1, win1->cursory);
		pseudogotoxy(bn2, win2->cursorx-1, win2->cursory);
	} else if (validup(bn1)) {
		pseudogotoxy(bn1, 77, win1->cursory-1);
		pseudogotoxy(bn2, 77, win2->cursory-1);
	}
}

void moveright(int src)
{
	int bn1=(src==1)?wndusr:wndsys, bn2=bn1|2;
	twindow *win1=&windows[bn1];
	twindow *win2=&windows[bn2];
#ifdef DEBUG
	if (windows[bn1].cursorx!=windows[bn2].cursorx) {
		SDPut("Debug Alert! cursorx\'s do not match", DDPutBoth);
	}
#endif   
	if (win1->cursorx<77) {
		pseudogotoxy(bn1, win1->cursorx+1, win1->cursory);
		pseudogotoxy(bn2, win2->cursorx+1, win2->cursory);
	} else (src==1) ? lfu() : lfs();
}
	      
void pseudocursor(int number, int state)
{
	twindow *win=&windows[number];
	if (win->cursorstate==state)
		return;
	win->cursorstate=state;
	gotoxy(outdevs[number], win->cursorx+1, win->cornery+win->cursory+1);
	switch (state) {
	 case showcursor:
		setattr(outdevs[number], curattrs[number]);
		break;
	 case hidecursor:
		setattr(outdevs[number], txtattrs[number]);
		break;
	 default:
		return;
		break;
	}
	ssputc(outdevs[number], win->contents[win->cursorx+win->cursory*78]);
	invdevcoords(number);
}

void drawborders(int dest)
{
	int i, j;
	char temp[81];
	twindow *win1, *win2;
	char **bottomstr;
	
	win1=&windows[(dest==DDPutLocal)?0:2];
	win2=&windows[(dest==DDPutLocal)?1:3];
	setattr(dest, attrbrd);
	
	/* uppermost line */
	gotoxy(dest, 0, win1->cornery);
	ssputc(dest, '+');
	for (i=0; i<78; i++) 
		ssputc(dest, '-');
	ssputc(dest, '+');
	
	/* box walls */
	for (i=win1->cornery+1; i<=win1->cornery+win1->height; i++) {
		gotoxy(dest, 0, i);
		ssputc(dest, '|');
		gotoxy(dest, 79, i);
		ssputc(dest, '|');
	}
   
	/* midline */
	gotoxy(dest, 0, win1->cornery+win1->height+1);
	ssputc(dest, '+');
	for (i=0; i<78; i++) 
		ssputc(dest, '-');
	ssputc(dest, '+');
   
	/* box walls */
	for (i=win2->cornery+1; i<=win2->cornery+win2->height; i++) {
		gotoxy(dest, 0, i);
		ssputc(dest, '|');
		gotoxy(dest, 79, i);
		ssputc(dest, '|');
	}
   
	/* bottom line */
	gotoxy(dest, 0, win2->cornery+win2->height+1);
	ssputc(dest, '+');
	for (i=0; i<78; i++) 
		ssputc(dest, '-');
	ssputc(dest, '+');
   
	/* status bar */
#ifdef SYSOPQUITONLY
	bottomstr=(dest==DDPutLocal)?&sysstr:&usrstr;
#else
	bottomstr=&sysstr;
#endif	
	i=0;
	temp[80]=0;
	for (j=0; j<80; j++)
		temp[j]=32;
	for (j=0; j<strlen(*bottomstr); j++) 
		temp[j+(80-strlen(*bottomstr))/2]=(*bottomstr)[j];
	setattr(dest, attrcop);
	gotoxy(dest, 0, win2->cornery+win2->height+2);
	SDPut(temp, dest);
}

void refresh(int src)
{
	int bn1=(src==1)?wndusr:wndsys, bn2=bn1|2;
	pseudocursor(bn1, hidecursor);
	pseudocursor(bn2, hidecursor);
	drawborders((src==1)?DDPutRemote:DDPutLocal);
	blit_window(bn1);
	blit_window(bn2);
	pseudocursor(bn1, showcursor);
	pseudocursor(bn2, showcursor);
}

int getcolor(char *s)
{
	if (strncasecmp("^[[", s, 3)||s[5]!='m'||
	    !(isdigit(s[3])&&isdigit(s[4])))
		return -1;
	return (s[3]-'0')*10+s[4]-'0';
}
	
void initialize(void)
{
	int i;
	int usrscrlen;
	int sysscrlen;

	{
		char buffer[80];
		int a;
		
		if ((a=getcolor(maincfg.CFG_COLORSYSOP))==-1)
			a=SYSCOLORDEFAULT;
		sprintf(buffer, "\033[0;%d;30m", a+10);
		attrtab[attrcsys]=strdup(buffer);
		sprintf(buffer, "\033[0;%d;1m", a);
		attrtab[attrsys]=strdup(buffer);
		
		if ((a=getcolor(maincfg.CFG_COLORUSER))==-1)
			a=USRCOLORDEFAULT;
		sprintf(buffer, "\033[0;%d;30m", a+10);
		attrtab[attrcusr]=strdup(buffer);
		sprintf(buffer, "\033[0;%d;1m", a);
		attrtab[attrusr]=strdup(buffer);
	}
	
	sysscrlen=maincfg.CFG_LOCALSCREEN;
	usrscrlen=user.user_screenlength;
   
	windows[0].height=(sysscrlen-4)/2;
	windows[1].height=(sysscrlen-4)/2;
	windows[2].height=(usrscrlen-4)/2;
	windows[3].height=(usrscrlen-4)/2;
	windows[0].cornery=0;
	windows[1].cornery=1+windows[0].height;
	windows[2].cornery=0;
	windows[3].cornery=1+windows[2].height;
	
	localcursorx=-1;
	localcursory=-1;
	remotecursorx=-1;
	remotecursory=-1;
   
	localattr=-1;
	remoteattr=-1;

	for (i=0; i<4; i++) {
		brokenwords[i]=0;
		windows[i].contents=(char *)malloc(78*windows[i].height);
		windows[i].cursorx=0;
		windows[i].cursory=0;
		windows[i].cursorstate=hidecursor;
		clearwindow(i);
	}

	cls(DDPutRemote);
	cls(DDPutLocal);
	
	drawborders(DDPutRemote);
	drawborders(DDPutLocal);
	
	for (i=0; i<4; i++)
		pseudocursor(i, showcursor);
}

void done(void)
{
	int i;
	for (i=0; i<4; i++)
		free(windows[i].contents);
	free(attrtab[attrusr]);
	free(attrtab[attrsys]);
	free(attrtab[attrcusr]);
	free(attrtab[attrcsys]);
	ssputs(DDPutRemote, "\033[0m\033[2J\033[1;1H");
	ssputs(DDPutLocal, "\033[0m\033[2J\033[1;1H");
}

void wprintf(int number, const char *fmt, ...)
{
	int cstat1, cstat2;
	va_list args;
	char *bptr;
	va_start(args, fmt);
	vsprintf(wprintbuffer, fmt, args);
	bptr=wprintbuffer;
	cstat1=windows[number&1].cursorstate;
	cstat2=windows[number|2].cursorstate;
	pseudocursor(number&1, hidecursor);
	pseudocursor(number|2, hidecursor);
	while (*bptr) {
		if (*bptr=='\n')
			(number&1) ? lfs() : lfu();
		else (number&1) ? outcs(*bptr) : outcu(*bptr);
		bptr++;
	}
	pseudocursor(number&1, cstat1);
	pseudocursor(number|2, cstat2);
	va_end(args);
}

void show_helps(int number)
{	
	FILE *fp;
	char buffer[256];
	char *bptr;
	if (windows[number].cursorx) 
		(number&1) ? lfs() : lfu();
	if ((fp=fopen(helpfilename, "rt"))==NULL) {
		wprintf(number, "Couldn\'t open help file.\n");
		return;
	}
	while (!feof(fp)) {	
		if (fgets(buffer, 255, fp)==NULL)
			break;
		for (bptr=buffer; *bptr!=0x0a&&*bptr!=0; bptr++);
		*bptr=0;
		wprintf(number, "%s\n", buffer);
	}
	fclose(fp);
	invdevcoords(number);
}

void SplitChat(void)
{
	time_t timenow;
	int autorz=0;
	int savetimeleft;
	unsigned char currentchar;  

      	if (spcprogress)
		return;
	
	if (!(onlinestat&&ansi)) {		
		LineChat();
		return;
	}

	pageflag=1;
	clog.cl_flags|=CL_CHAT;
	changenodestatus("Chatting with SysOp");
	savetimeleft=timeleft;
	
	spcprogress=1;
	initialize();

	for (;;) {		
		currentchar=HotKey(HOT_CURSOR);
		if (!checkcarrier())
			break;
		
#ifdef SYSOPQUITONLY
		if (currentchar==27 && keysrc==2)
			break;
		if (currentchar==27)
			continue;
#else
		if (currentchat==27)
			break;
#endif		
		if (currentchar=='r' && keysrc==1 && autorz==0) {
			autorz++;
		} else if (currentchar=='z' && keysrc==1 && autorz==1) {
			autorz++;
		} else if ((currentchar==13 || currentchar==10) &&
			   keysrc==1 && autorz==2) {
			recfiles(maincfg.CFG_CHATDLPATH,0);
			autorz=0;
			refresh(1);
		} else autorz=0;
		
		switch (currentchar) {
		 case 9:
			show_helps((keysrc==1) ? wndusr : wndsys);
			break;
		 case 7:
			continue;
		 case 250:
			moveup(keysrc);
			break;
		 case 251:
			(keysrc==1) ? cdu() : cds();
			break;
		 case 252:
			moveright(keysrc);
			break;
		 case 253:
			moveleft(keysrc);
			break;
		 case 13:
			(keysrc==1) ? lfu() : lfs();
			break;
		 case 1:
			goto_bol((keysrc==1) ? wndusr : wndsys);
			break;
		 case 4:
			delete_char((keysrc==1) ? wndusr : wndsys);
			break;
		 case 12:
			refresh(keysrc);
			break;
		 case 8:
		 case 127:
			backspace((keysrc==1) ? wndusr : wndsys);
			break;
		 default:
			(keysrc==1) ? outcu(currentchar) : outcs(currentchar);
			break;
		}
	}
   
	timenow=time(NULL);
	timeleft=savetimeleft;
	endtime=timenow+timeleft;
	
	done();
	spcprogress=0;
}
