/*
 cdemo1.c - A C TriLZ demo program

 Use as:

 cdemo1 infile

 Where:

 infile    is the name of the file to be compressed and uncompressed.

 This program must be compiled using the large memory model!
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <dir.h>
#include "compress.h"


int InFile, OutFile;

unsigned pascal ReadBuffer(unsigned char *buff, unsigned size)
{
	unsigned read = 0;

	_dos_read(InFile, buff, size, &read);
	return read;
}

unsigned pascal WriteBuffer(unsigned char *buff, unsigned size)
{
	unsigned wrote = 0;

	_dos_write(OutFile, buff, size, &wrote);
	return wrote;
}

void main(int argc, char *argv[])
{
	long originalsize, result;
	unsigned char *buffer;
	char filename[MAXPATH], tlzfile[MAXPATH], bakfile[MAXPATH], temp[MAXPATH];

	printf("TriLZ Demo Program (C Version)\n\n");
	if (argc == 1) {
		printf("Use as:\n\n");
		printf("CDEMO1 infile\n\n");
		printf("Where:\n\n");
		printf("infile    is the name of the file to be compressed.\n\n");
		exit(1);
	}

	buffer = (unsigned char *)malloc(40000U);

	strcpy(filename, argv[1]);

	strupr(filename);

	if (strchr(argv[1], '.') == NULL) {
		sprintf(tlzfile, "%s.TLZ", filename);
		sprintf(bakfile, "%s.BAK", filename);
	}
	else {
		strcpy(temp, filename);
		*strchr(temp, '.') = 0;
		sprintf(tlzfile, "%s.TLZ", temp);
		sprintf(bakfile, "%s.BAK", temp);
	}

	printf("Compressing: %s\n", filename);

	if (_dos_open(filename, O_RDONLY, &InFile) != 0) {
		printf("Unable to open %s!", filename);
		exit(1);
	}

	originalsize = filelength(InFile);

	_dos_creat(tlzfile, 0, &OutFile);

	result = Compress(buffer);

	_dos_close(InFile);
	_dos_close(OutFile);

	printf("\n");
	printf("Original File Size  : %ld\n", originalsize);
	printf("Compressed File Size: %ld\n", result);
	printf("Percent Compression : %5.1f\n", 100.0 - ((float)result / (float)originalsize * 100.0));
	printf("\n");

	printf("Uncompressing: %s\n", tlzfile);

	if (_dos_open(tlzfile, O_RDONLY, &InFile) != 0) {
		printf("Unable to open %s!", tlzfile);
		exit(0);
	}
	_dos_creat(bakfile, 0, &OutFile);

	Uncompress(buffer);

	_dos_close(InFile);
	_dos_close(OutFile);

	printf("\n");

	exit(0);
}
