#!/bin/sh
#
#
#
#
## script to config/view iptables configuration 
# (c)ode by Monday
# 
## contact: monday@efnet/linknet/ircnet
# or
## yadnom@efnet/gatnom@efnet/montag@efnet
#
#
## greetz to my beta testers: 
# Prof-hawk, wezley, axess, TrAnCer and so on...
#
#
#
## changelog
#
# v.1 done at -> Sun Oct 19 19:56:06 GMT 2003
# - add/del/list-Groups / menu-styl  
# v.1.1 done at -> Mon Oct 20 13:26:10 GMT 2003
# - bugfixed GroupAdd() function ( function styl ) 
# v.2 done at -> Mon Oct 20 16:05:49 GMT 2003
# - add RuleAdd() function ( added rules to groups ) 
# v.3 done at -> Tue Oct 21 19:45:26 GMT 2003
# - add ListRulesPerGroup() function ( view rules & subgroups per group ) 
# v.3.1 done at -> Tue Oct 21 19:59:28 GMT 2003
# - bugfixed RuleAdd() function ( u can add ip-ranges 1.1.0.0/16 as source or destination )  
# v.3.2 done at -> Tue Oct 21 20:14:35 GMT 2003
# - new function ListRules() - u can call all rules per group more as once at script 
# v.4 done at -> Tue Oct 21 22:00:10 GMT 2003
# - new function DeleteRuleOnGroup() - for delete rules/subgroups on any group/chain in iptables
# - modified ListRules() - when in $2 = 1 then print digits for any entrys in group/chain ( to delete these ) 
# ( triggy triggy :) i think, thats not the last word about these 'hotfix' ) 
# v.4.1 done at -> Tue Oct 21 22:19:42 GMT 2003
# - bugfixed DeleteRuleOnGroup() & ListRulesPerGroup() - regex "_" to GetData call added 
# v.4.2 done at -> Fri Oct 24 21:52:33 GMT 2003
# - bugfixed multiport -> show v.4
# v.4.3 done at -> Sat Oct 25 13:48:32 GMT 2003
# - add to function RuleAdd , cancel any time as option
# v.4.4 done at -> Sat Oct 25 14:08:57 GMT 2003
# - add new option in ListGroups(), when in $1=1 and in $2=groupname then don't display them
# v.5 done at -> Sat Oct 25 15:54:58 GMT 2003
# - new function SubGroupAdd(), to add group in group
# - new option in ListRules(), if $2 = 2 then dont print '|-[ LIST RULES PER GROUP END ]--- --- -- -  -'
# - new option in ListRules(), if $2 = 3 then print rules for subgroups
# v.5.1 done at -> Sat Oct 25 16:13:44 GMT 2003
# - modified ListRules() - output subgroups
# v1 done at -> Sat Oct 25 18:19:47 GMT 2003
# - added cmd arguments (-gui | -list group/rule | -add group/sgroup/rule | -del group/rule)
# v1.1 done at -> Mon Oct 27 18:43:05 GMT 2003
# - added function GetHotKey(), don't press enter in menu structur ;) 
# v1.1.1 done at -> Sun Nov 23 18:28:53 GMT 2003
# - added "dont display pressed keys" in function GetHotKey()
# v1.1.2 done at -> Sun Nov 23 19:07:31 GMT 2003
# - removed function PressEnter(), this will work with GetHotKey() 
# -- function call : GetHotKey "enterdummy" "| Press Enter" "enter" (need bugfix(space is the same how enter, atm)) 
# - removed option "Enable Group" in function ListOptions(), is not longer needed ( concept )
#
##
#
#

## main options
#
IpTablesOptions="-n -L"
ExcludeGroups="tet"
#
##

StrUp()
{
 # in $1 string to upper
 echo $1 | tr '[a-z]' '[A-Z]'
}

SetGroups()
{
# get groups from iptables use ExcludeGroups 
 SetGroups=""
 GetGroups=`iptables $IpTablesOptions | grep -i chain | awk '{print $2}'`
 for Group in $GetGroups; do 
  for exGroup in $ExcludeGroups; do
   if [ "`echo $Group | grep $exGroup`" ]; then 
    OverFlow=1
    break
   else 
    OverFlow=0
   fi
  done 
  if [ "$OverFlow" -eq "0" ]; then 
   SetGroups="$SetGroups `echo $Group | awk -F - '{print $1}'`"
  fi
 done
}

ListGroups()
{
 # in $1 disable readkey if $1=1 then disabled
 # in $2 groupname done display them 
 SetGroups
 printf "|-[ LIST GROUPS ]---------------- --- -- -  -\n"
 for Group in $SetGroups; do 
  if [ "$2" != "$Group" ]; then 
   printf "|-[GRP]-> %30s \n" $Group
  fi
 done | sort -k2 -ibm
 if [ -z  "$SetGroups" ]; then 
  echo "| _NO_ Groups on current iptables configuration"
 fi 
 printf "|-[ LIST GROUPS END ]------------ --- -- -  -\n"
 if [ -z "$1" ]; then
  GetHotKey "enterdummy" "| Press Enter" "enter" 
 fi
}

CheckGroup()
{
 # in $1 groupname
 SetGroups
 for Group in $SetGroups; do
  if [ "$1" = "$Group" ]; then 
   OverFlow=1
   break
  else 
   OverFlow=0
  fi 
 done
 echo $OverFlow
}

Check4BadCharacters()
{
 # in $1 string
 # in $2 req expr
 if [ "`echo -n $1 | sed 's/ //g' | tr -d $2 | wc -c`" -gt "0" ] || [ -z "$1" ];then
  echo "1"
 else
  echo "0"
 fi
} 

GetData()
{
 # in $1 varname
 # in $2 msg
 # in $3 reg. expressions for bad-characters

 CheckInput=1
 while [ "$CheckInput" -eq "1" ]; do
  printf "$2" 
  read user_input
  CheckInput=`Check4BadCharacters "$user_input" "$3"`
  if [ "$CheckInput" -eq "1" ]; then
   echo "| BadCharacter(s) - try again"
  fi
 done
  eval ${1}='${user_input}'
}

GetHotKey()
{
 # in $1 varname
 # in $2 msg
 # in $3 valid keys
 printf "$2"
 stty raw -echo
 while true; do
  Key=`dd bs=1 count=1 2>/dev/null | head -1 | cut -c 1`
  enter=`echo -e $Key | sed 's/ //g' |  tr -d "\r" | wc -c`
  if [ "$3" = "enter" ]; then 
   if [ "$enter" -eq "1" ]; then 
    break
   fi
  else
   for keys in $3;do
    if [ "$Key" = "$keys" ]; then
     OverFlow=1
     break
    else
     OverFlow=0
    fi
   done
  if [ "$OverFlow" = "1" ]; then
   break
  fi
 fi # if [ "$3" = "enter"... end
 done
 stty -raw echo
 eval ${1}='${Key}'
 printf "\n"
}

GroupAdd()
{
 GroupAddCheck=1
 while [ "$GroupAddCheck" -eq "1" ]; do
  clear
  printf "|-[ GROUP ADD ]------------------ --- -- -  -\n"
  ListGroups "1"
  printf "| %30s - C\n" "Cancel"
  printf "| %30s - H\n|\n" "Help"
  GetData "AddGroup" "|- Enter GroupName : " "_[a-z][A-Z]" 
  case "`StrUp "$AddGroup"`" in 
	C)
	AddGroup="H"
	GroupAddCheck=0
 	;;
	H)
	AddGroup="H"
	;;
	*)
	if [ "`echo $AddGroup | wc -c`" -le "4" ]; then 
         printf "| min. 4 chars\n"
	 AddGroup="H"
	 GetHotKey "enterdummy" "| Press Enter" "enter"
        else
         if [ "`CheckGroup "$AddGroup"`" = "1" ]; then 
	  printf "| Group already exists \n"
	  GetHotKey "enterdummy" "| Press Enter" "enter"
         else
          GetHotKey "yesno" "| Add Group '$AddGroup'(y/n): " "y Y n N"
          if [ "`StrUp "$yesno"`" = "Y" ]; then	
	   iptables -N $AddGroup
	   printf "| Group '$AddGroup' added\n"
	   GetHotKey "enterdummy" "| Press Enter" "enter"
	  else
           printf "| Group '$AddGroup' _not_ added\n"
	   GetHotKey "enterdummy" "| Press Enter" "enter"
	  fi
	 fi
        fi 
	;;
  esac
 done
}

RuleAdd()
{
 RuleAddCheck=1
 while [ "$RuleAddCheck" -eq "1" ]; do
  clear
  printf "|-[ RULE TO GROUP ]-------------- --- -- -  -\n"
  ListGroups "1"
  printf "| %30s - C\n" "Cancel"
  printf "| %30s - H\n|\n" "Help"
  GetData "AddRule" "|- Enter GroupName for Rule : " "_[a-z][A-Z]"
  case "`StrUp "$AddRule"`" in
	C)
	 RuleAddCheck=0
	 AddRule="H"
	;;
	H)
	 AddRule="H"
        ;;
	*)
         if [ "`CheckGroup "$AddRule"`" = "1" ]; then
          printf "| Add Rule to Group '$AddRule' \n"
          GetHotKey "enterdummy" "| Press Enter" "enter"
	  clear
  	  printf "|-[ RULE TO GROUP ]-------------- --- -- -  -\n"
	  ListRules "$AddRule" 
	  printf "|-[ RULE TO GROUP: %12s ] --- -- -  -\n" $AddRule
	  printf "| Type C to cancel any time \n"
	  GetData "Source"      "| Enter Source ip                  : " "[0-9]./cC"
	  if [ "`StrUp "$Source"`" = "C" ]; then 
           printf "| CANCELED \n"
	   GetHotKey "enterdummy" "| Press Enter" "enter"
          else
	   GetData "Destination" "| Enter Destination ip             : " "[0-9]./cC"
           if [ "`StrUp "$Destination"`" = "C" ]; then
            printf "| CANCELED \n"
            GetHotKey "enterdummy" "| Press Enter" "enter"
           else
	    GetData "Port"        "| Enter Port                       : " "[0-9]:cC"
            if [ "`StrUp "$Port"`" = "C" ]; then
             printf "| CANCELED \n"
             GetHotKey "enterdummy" "| Press Enter" "enter"
            else
	     GetData "Protocol"    "| Enter Protocol Type (tcp/udp/both(tcp/udp))    : " "tcpTCPudpUDPcC"
             if [ "`StrUp "$Protocol"`" = "C" ]; then
              printf "| CANCELED \n"
              GetHotKey "enterdummy" "| Press Enter" "enter"
             else
              clear
  	      printf "|-[ RULE TO GROUP ]-------------- --- -- -  -\n"
	      printf "|-[ RULE TO GROUP: %12s-] --- -- -  -\n" $AddRule
	      printf "| $Source -> $Destination : $Port - $Protocol \n"
              GetHotKey "yesno" "| Add these Settings to Group '$AddRule' (y/n): " "y Y n N"
              if [ "`StrUp "$yesno"`" = "Y" ]; then
	       iptables -A $AddRule -s $Source -p $Protocol --destination $Destination --dport $Port -j ACCEPT
	       printf "| $Source -> $Destination : $Port - $Protocol added to '$AddRule'\n"
	      else
	       printf "| $Source -> $Destination : $Port - $Protocol _not_ added to '$AddRule'\n"
              fi 
	      GetHotKey "enterdummy" "| Press Enter" "enter"
	     fi # Protocol cancel
	    fi # Port cancel
	   fi # destination cancel
          fi # source cancel
	 else 
          printf "| Group '$AddRule' not exists on current iptables configuration \n"
	  GetHotKey "enterdummy" "| Press Enter" "enter"
	 fi
	;;
  esac
done
}

SubGroupAdd()
{
 SubGroupCheck=1
 while [ "$SubGroupCheck" -eq "1" ]; do
  clear
  printf "|-[ ADD Group to Group ]--------- --- -- -  -\n"
  ListGroups "1"
  GetData "sGroup" "| Enter Groupname or C to cancel: " "[a-z][A-Z]_"
  case "`StrUp "$sGroup"`" in
	C)
	 SubGroupCheck=0
	;;
	*)
	if [ "`CheckGroup "$sGroup"`" = "1" ]; then
	 sGroupCheck=1
	 while [ "$sGroupCheck" -eq "1" ]; do
 	  printf "|-[ LIST RULES PER GROUP ]------- --- -- -  -\n"
          ListRules "$sGroup"
	  GetData "SubGroup" "| Enter Groupname to add in '$sGroup' or C to cancel: " "[a-z][A-Z]_" 
	  case "`StrUp "$SubGroup"`" in
 	    	C)
		 sGroupCheck=0
	 	 printf "| CANCELED\n"
	 	;;
	 	*)
	 	 if [ "`CheckGroup "$SubGroup"`" = "1" ]; then
	          already=`ListRules "$sGroup" | grep SUBGROUP | awk -F : '{print $2}' | grep $SubGroup |sed 's/ //g'`
		  if [ -z "$already" ]; then 
 	           printf "|-[ LIST RULES PER GROUP ]------- --- -- -  -\n"
		   ListRules "$SubGroup"
		   GetHotKey "yesno" "| do u want to add group '$SubGroup' to '$sGroup' ? (y/n): " "y Y n N"
                   if [ "`StrUp "$yesno"`" = "Y" ]; then
		    HierachyCheck=`iptables -A $sGroup -j $SubGroup 2>&1 | grep "symbolic"` 
		    if [ -z "$HierachyCheck" ]; then
                     printf "| group '$SubGroup' added in '$sGroup'\n"
		     clear
		     printf "|-[ ADD Group to Group ]--------- --- -- -  -\n"
 		     printf "|-[ LIST RULES PER GROUP ]------- --- -- -  -\n"
		     ListRules "$sGroup" 
		     sGroupCheck=0
	            else
                     printf "| u can not add groups thats call them self in hierachy\n" 
		     ListRules "$SubGroup" "3"
                     printf "| u can not add groups thats call them self in hierachy\n" 
		     GetHotKey "enterdummy" "| Press Enter" "enter"
		    fi
                   else
                    printf "| group '$SubGroup' _not_ added in '$sGroup'\n"
		    GetHotKey "enterdummy" "| Press Enter" "enter"
                   fi
		  else
		   printf "| group '$SubGroup' already added in '$sGroup'\n"	
		   GetHotKey "enterdummy" "| Press Enter" "enter"
		  fi
	 	 else
                  printf "| Group '$SubGroup' not exists on current iptables configuration \n"
		  GetHotKey "enterdummy" "| Press Enter" "enter"
	 	 fi
		;;
          esac
	 done
	else
	 printf "| Group '$sGroup' not exists on current iptables configuration \n"
        fi
	;; 
  esac
  GetHotKey "enterdummy" "| Press Enter" "enter"
 done

}

Add()
{
 AddCheck=1
 while [ "$AddCheck" -eq "1" ]; do
  clear
  printf "|-[ ADD ]------------------------ --- -- -  -\n"
  printf "| %30s - G\n" "Group"
  printf "| %30s - R\n" "Rule to Group"
  printf "| %30s - S\n" "sGroup to Group"
  printf "| %30s - C\n" "Cancel"
  printf "| %30s - H\n|\n" "Help"
  GetHotKey "AddChoise" "|- Ur Choise : " "r R G g s S h H c C"  
  case "`StrUp "$AddChoise"`" in 
        R)
	RuleAdd
        ;;
        G)
 	GroupAdd
        ;;
	S)
	SubGroupAdd
	;;
	H)
	Add
 	;;
	C)
	AddCheck=0
	printf "|-[ ADD CANCEL ]----------------- --- -- -  -\n"
	;;
  esac
 done
}

DeleteGroup()
{
 clear
 printf "|-[ DELETE GROUP ]--------------- --- -- -  -\n" 
 ListGroups "1"
 printf "| %30s - C\n" "Cancel"
 printf "| %30s - H\n" "Help"
 GetData "DeleteGroup" "| Enter GroupName: " "[a-z][A-Z]"
 case "`StrUp "$DeleteGroup"`" in
	C)
	 printf "|-[ DELETE GROUP CANCEL ]-------- --- -- -  -\n"
	 DeleteChoise="H"
	;;
	H)
	 DeleteGroup
	;;
	*)
	 if [ "`CheckGroup "$DeleteGroup"`" = "1" ]; then
	  GetHotKey "yesno" "| Delete '$DeleteGroup'(y/n): " "y Y n N"
	  if [ "`StrUp "$yesno"`" = "Y" ]; then
	   iptables -X $DeleteGroup
 	   printf "| Group '$DeleteGroup' deleted\n"
	  else
           printf "| Group '$DeleteGroup' not deleted\n"
 	  fi
         else 
	  printf "| no group '$DeleteGroup' found on iptables\n"
         fi
	 GetHotKey "enterdummy" "| Press Enter" "enter"
	 DeleteGroup
	;;
 esac
}

DeleteRuleOnGroup()
{
 DeleteRuleCheck=1
 while [ "$DeleteRuleCheck" -eq "1" ]; do
  clear 
  printf "|-[ DELETE R/sG ON GROUP ]------- --- -- -  -\n"
  ListGroups "1"
  printf "| %30s - C\n" "Cancel"
  printf "| %30s - H\n" "Help"
  GetData "DeleteRuleOnGroup" "| Enter GroupName: " "[a-z][A-Z]_"
  case "`StrUp "$DeleteRuleOnGroup"`" in
        C)
	 DeleteRuleCheck=0
         printf "|-[ DELETE R/sG ON GROUP CANCEL ] --- -- -  -\n"
        ;;
        H)
         DeleteRuleOnGroup
        ;;
        *)
	 if [ "`CheckGroup "$DeleteRuleOnGroup"`" = "1" ]; then
	  printf "|-[ LIST RULES PER GROUP ]------- --- -- -  -\n"
          ListRules "$DeleteRuleOnGroup" "1"	
	  CheckifZero=`iptables -n -L $DeleteRuleOnGroup | grep -iv target | grep -iv chain`
	  if [ ! -z "$CheckifZero" ]; then 
	   GetData "whichentry" "| Enter Number for Entry or C for cancel: " "[0-9]cC"
	   if [ "`StrUp "$whichentry"`" != "C" ]; then
            GetHotKey "yesno" "| Delete entry '$whichentry'(y/n): " "y Y n N"
            if [ "`StrUp "$yesno"`" = "Y" ]; then
             iptables -D $DeleteRuleOnGroup $whichentry
             printf "| Entry $whichentry in Group '$DeleteRuleOnGroup' deleted\n"
            else
             printf "| Entry $whichentry _not_ deleted on Group '$DeleteRuleOnGroup' \n"
            fi
	   else
	    printf "| CANCELED \n"
           fi
          fi
	  else
           printf "| no group '$DeleteRuleOnGroup' found on iptables\n"
         fi
	GetHotKey "enterdummy" "| Press Enter" "enter"
	;;
  esac       
 done
}

Delete()
{
 CheckDel=1
 while [ "$CheckDel" -eq "1" ]; do
  clear
  printf "|-[ DELETE OPTIONS ]------------- --- -- -  -\n"
  printf "| %30s - G\n" "Delete Group"
  printf "| %30s - R\n" "Delete Rule/SubGroup on Group"
  printf "| %30s - C\n" "Cancel"
  printf "| %30s - H\n|\n" "Help"
  GetHotKey "DeleteChoise" "|- Ur Choise : " "g G r R c C h H"
  case "`StrUp  "$DeleteChoise"`" in
	G)
	 DeleteGroup
	;;
	R)
	 DeleteRuleOnGroup
	;;
	C)
	 printf "|-[ DELETE CANCEL ]-------------- --- -- -  -\n"
	 CheckDel=0
	 ListOptions
	;;
	H)
	 Delete
	;;
  esac
 done
}

ListRules()
{
 # in $1 chain/group
 # in $2 = 1 then will print digits to some rules ( for delete rules/subgroups on group )
 # in $2 = 2 or 3 then dont print '|-[ LIST RULES PER GROUP END ]--- --- -- -  -'
 # in $2 = 3 then print rules in subgroups
 # in $3 = ---- for tabs 

          OverFlow1=""
          Rules=`iptables -n -L $1 | grep -iv chain | grep -iv target | grep -i accept`
          CountDummy=0
	  if [ -z "$3" ]; then 
           printf "|-[GRP]-> $1\n"
	  fi
          for Entry in $Rules; do
          CountDummy=`expr $CountDummy + 1`
          case "$CountDummy" in
                4)
                Source=$Entry
                ;;
                5)
                Destination=$Entry
                ;;
                6)
                Protocol=`echo $Entry |  awk -F: '{print $1}'`
                ;;
                7)
                Port=`echo $Entry |  awk -F: '{ if ($3 != "") {print $2":"$3} else { print $2 }}'`
                ;;
         esac
         if [ "$CountDummy" -eq "7" ]; then
          CountDummy=0
          OverFlow1=0
          if [ "$2" = "1" ]; then 
           multiportfix=`echo $Port | tr -d '[0-9]' | wc -c | sed 's/ //g'`
	   multiportfix=`expr $multiportfix + 1`
           if [ "$multiportfix" = "3" ]; then 
            Port1=`echo $Port | awk -F : '{print $2}'`
	   else 
            Port1=$Port
	   fi
           digit=`iptables -n -L $1 | grep -iv target | grep -iv chain | awk -v var1=$Source -v var2=$Destination -v var3=$Port1 -v multiport=$multiportfix '{count++;split ($7,prot,":"); if (( $4==var1) && ( $5==var2)&& ( prot[multiport] == var3)) {print count}}'`
           printf "|-[%2s]--[RULE]-> [ SRC: %17s | DST: %17s | PORT: %11s | PROT: %5s \n" $digit $Source $Destination $Port $Protocol
          else
	   if [ -z "$3" ]; then 
            printf "|---[RULE]-> [ SRC: %17s | DST: %17s | PORT: %11s | PROT: %5s \n" $Source $Destination $Port $Protocol
	   else
            printf "|$3---[RULE]-> [ SRC: %17s | DST: %17s | PORT: %11s | PROT: %5s \n" $Source $Destination $Port $Protocol
	   fi
          fi
         fi
        done
        CountDummy1=0
        Rules=`iptables -n -L $1 | grep -iv chain | grep -iv target | grep -iv accept`
        for Entry in $Rules; do
         CountDummy1=`expr $CountDummy1 + 1`
         case "$CountDummy1" in
           1)
            SubGroupName=$Entry
          ;;
         esac
          if [ "$CountDummy1" -eq "5" ]; then
           CountDummy1=0
           OverFlow1=0
	   if [ "$2" = "1" ]; then 
             digit=`iptables -n -L $1 | grep -iv target | grep -iv chain | awk -v var1=$SubGroupName '{count++; if ( $1 == var1) {print count}}'`
            printf "|-[%2s]--[SUBGROUP]-> [ NAME: $SubGroupName \n" $digit
	   else
	    if [ -z "$3" ]; then 
             printf "|---[SUBGROUP]-> [ NAME: $SubGroupName \n"
	    else 
             printf "|$3---[SUBGROUP]-> [ NAME: $SubGroupName \n"
            fi 
	    if [ "$2" = "3" ]; then 
	     ListRules "$SubGroupName" "3" "`echo "$3-[$SubGroupName]" | tr '[a-z]' '[A-Z]'`"
	    fi
	   fi
          fi
         done
          if [ "$CountDummy" -eq "0" ] && [ "$CountDummy1" -eq "0" ] && [ -z "$OverFlow1" ]; then
	   if [ -z "$2" ] || [ "$2" = "1" ]; then
            printf "|-[ LIST RULES PER GROUP END ]--- --- -- -  -\n"
	   fi
	  else 
	   if [ -z "$2" ] || [ "$2" = "1" ]; then
            printf "|-[ LIST RULES PER GROUP END ]--- --- -- -  -\n"
	   fi
          fi
}

ListRulesPerGroup()
{
 ListRulesCheck=1
 while [ "$ListRulesCheck" -eq "1" ]; do
  clear
  printf "|-[ LIST RULES PER GROUP ]------- --- -- -  -\n" 
  ListGroups "1"
  GetData "RulesPerGroup" "| Enter Groupname or C to cancel: " "[a-z][A-Z]_"
  case "`StrUp "$RulesPerGroup"`" in 
	C)
	 ListRulesCheck=0
	;;
	*)
        if [ "`CheckGroup "$RulesPerGroup"`" = "1" ]; then
	 ListRules "$RulesPerGroup" "3"
	else
 	 printf "| no group '$RulesPerGroup' found on iptables\n"
        fi
	GetHotKey "enterdummy" "| Press Enter" "enter"
	;;
  esac
 done
}

ViewList()
{
 ListCheck=1
 while [ "$ListCheck" -eq "1" ]; do
  clear
  printf "|-[ LIST OPTIONS ]--------------- --- -- -  -\n"
  printf "| %30s - G\n" "List Groups"
  printf "| %30s - R\n" "List Rules for Group"
  printf "| %30s - A\n" "List All"
  printf "| %30s - C\n" "Cancel"
  printf "| %30s - H\n|\n" "Help"
  GetHotKey "ViewChoise" "|- Ur Choise : " "g G r R a A c C h H"  
  case "`StrUp "$ViewChoise"`" in
 	G)
	 ListGroups
	;;
	R)
	 ListRulesPerGroup
	;;
	A)
	;;
	C)
	 ListCheck=0
	 printf "|-[ LIST CANCEL ]---------------- --- -- -  -\n"
	;;
	H)
	 ViewList
	;;
  esac
 done
}

ListOptions()
{
 clear
 printf "|-[ OPTIONS ]-------------------- --- -- -  -\n"
 printf "| %30s - A\n" "ADD    Group &| Rule"
 printf "| %30s - L\n" "LIST   Group &| Rule"
 printf "| %30s - D\n" "DELETE Group &| Rule"
 printf "| %30s - Q\n" "Quit"
 printf "| %30s - H\n|\n" "Help"
 GetHotKey "OptionChoise" "|- Ur Choise : " "a A l L d D q Q h H"
 case "`StrUp "$OptionChoise"`" in
 	A)
	Add
	ListOptions
	;;
	L)
	ViewList
	ListOptions
	;;
	D)
	Delete
	;;
	Q)
 	printf "|-[ QUIT ]----------------------- --- -- -  -\n"
 	printf "| (c)ode by Monday \n"
	printf "|-------------------------------- --- -- -  -    -      -\n"
	exit 0	
	;;
	H)
	ListOptions	
	;;
 esac 
}

 
main()
{
 case "$1" in 
	-gui)
  	    ListOptions
	;;
 	-list)
	if [ -z "$2" ]; then 
          echo "Second Argument is needed by option: -list"
         else 
	case "$2" in 
		group)
	         ListGroups 	
		;;
		rule)
		if [ -z "$3" ]; then 
		 echo "usage: `basename $0` -list rule groupname hierachy"
		 echo "or"
		 echo "usage: `basename $0` -list rule groupname"
		else
		 if [ -z "$4" ]; then 
		  ListRules "$3"
	         else
 		  ListRules "$3" "3"
	         fi
	        fi
	esac
	fi
	;;
	-add)
        if [ -z "$2" ]; then
         echo "Second Argument is needed by option: -add"
        else
         case "$2" in 
		rule)
		RuleAdd		
		;;
		group)
		GroupAdd
		;;	
		sgroup)
		SubGroupAdd		
		;;
	 esac
	fi
	;;
	-del)
	if [ -z "$2" ]; then
         echo "Second Argument is needed by option: -del"
        else
         case "$2" in
                rule)
                DeleteRuleOnGroup 
                ;;
                group)
                DeleteGroup
                ;;
         esac
        fi
	;;
	*)
 	echo "Usage: `basename $0` -gui | -list group/rule | -add group/sgroup/rule | -del group/rule"
	;;
 esac
}

main "$@"

