﻿using RandM.RMLib;
using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Threading;

namespace Gen2FA
{
    class Program
    {
        static string _userName = "";
        static readonly Random rng = new Random();
        const string chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        static RMDoor Door;

        private static void Main(string[] args)
        {
            try
            {
                using (Door = new RMDoor())
                {
                    Door.OnTimeOut = new RMDoor.OnTimeOutCallback(DefaultOnTimeOut);
                    Door.OnHangUp = new RMDoor.OnHangUpCallback(DefaultOnHangUp);

                    Door.Session.MaxIdle = 300;

                    _userName = Door.DropInfo.Alias.ToString();

                    ToggleTwoFactorAuth(_userName);

                    Door.ClearBuffers();
                    Door.Dispose();
                }
            }
            catch (Exception ex)
            {
                var st = new StackTrace(ex, true);
                var frame = st.GetFrame(0);
                var line = frame.GetFileLineNumber();

                File.AppendAllText("gen2fa.txt", DateTime.Now + " - Line: " + line.ToString() + Environment.NewLine + ex.ToString() + Environment.NewLine + Environment.NewLine);
            }
        }

        static void ToggleTwoFactorAuth(string userName)
        {
            DisplayAnsi("gen2fa");

            Door.GotoXY(16, 7);
            Door.Write("Please wait...");

            if (!File.Exists(AppDomain.CurrentDomain.BaseDirectory + @"\users\" + userName + ".ini"))
            {
                string[] lines = { "[USER]", "TwoFactorAuth=False", "TwoFactorAuthCode=0000000000000000" };
                System.IO.File.WriteAllLines(AppDomain.CurrentDomain.BaseDirectory + @"\users\" + userName + ".ini", lines);
            }

            IniFile Ini = new IniFile(AppDomain.CurrentDomain.BaseDirectory + @"\users\" + userName + ".ini");
            string twoFactorAuthentication = Ini.ReadString("USER", "TwoFactorAuth", "False");

            BitArray ba = new BitArray(Encoding.UTF8.GetBytes(RandomString(10)));
            string twoFactorAuthCode = GenerateStringFromKey(ba);

            if (twoFactorAuthentication.Equals("False"))
            {
                Ini.DeleteKey("USER", "TwoFactorAuth");
                Ini.DeleteKey("USER", "TwoFactorAuthCode");
                Ini.WriteString("USER", "TwoFactorAuth", "True");
                Ini.WriteString("USER", "TwoFactorAuthCode", twoFactorAuthCode);
                Ini.Save();

                Door.GotoXY(16, 9);
                Door.Write("Your account is now only accessable via two");
                Door.GotoXY(16, 10);
                Door.Write("factor authentication. Keep your key safe!");
                Door.GotoXY(16, 12);
                Door.Write("2FA Key: " + twoFactorAuthCode);
                Door.GotoXY(16, 14);
                Door.Write("Use Authy, Google Authenticator, or");
                Door.GotoXY(16, 15);
                Door.Write("other TOTP generator.");

                Door.GotoXY(38, 19);
                Door.Write(Ansi.TextColor(Crt.White) + "OK" + Ansi.TextColor(Crt.LightGray) + " ");
                Door.ReadKey();
            }
            else
            {
                Ini.DeleteKey("USER", "TwoFactorAuth");
                Ini.WriteString("USER", "TwoFactorAuth", "False");
                Ini.Save();

                Door.GotoXY(16, 7);
                Door.Write("Your account is now accessable without two");
                Door.GotoXY(16, 8);
                Door.Write("factor authentication. Re-run to enable.");

                Door.GotoXY(38, 19);
                Door.Write(Ansi.TextColor(Crt.White) + "OK" + Ansi.TextColor(Crt.LightGray) + " ");
                Door.ReadKey();
            }
        }

        private static string RandomString(int size)
        {
            char[] buffer = new char[size];

            for (int i = 0; i < size; i++)
            {
                buffer[i] = chars[rng.Next(chars.Length)];
            }
            return new string(buffer);
        }

        static bool DisplayAnsi(string fileName)
        {
            if (string.IsNullOrEmpty(fileName))
            {
                return false;
            }
            else
            {
                Door.DisplayFile(AppDomain.CurrentDomain.BaseDirectory + @"\" + fileName.ToLower() + ".ans", 0);
            }

            return false;
        }

        static string GenerateStringFromKey(BitArray ba)
        {
            try
            {
                char[] cProdKeyPoss = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".ToCharArray();
                StringBuilder finalstring = new StringBuilder();
                ba.Length = ba.Length - (ba.Length % 5);

                for (int i = 0; i < ba.Length; i = i + 5)
                {
                    int[] bitvalue = { 0, 0, 0, 0, 0 };

                    if (ba.Get(i) == true)
                        bitvalue[0] = 1;

                    if (ba.Get(i + 1) == true)
                        bitvalue[1] = 1;

                    if (ba.Get(i + 2) == true)
                        bitvalue[2] = 1;

                    if (ba.Get(i + 3) == true)
                        bitvalue[3] = 1;

                    if (ba.Get(i + 4) == true)
                        bitvalue[4] = 1;

                    int temp = (16 * bitvalue[0]) + (8 * bitvalue[1]) + (4 * bitvalue[2]) + (2 * bitvalue[3]) + (bitvalue[4]);
                    finalstring.Append(cProdKeyPoss[temp].ToString());
                }
                
                return finalstring.ToString();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                return null;
            }
        }

        private static void DefaultOnTimeOut()
        {
            Door.Dispose();
        }

        private static void DefaultOnHangUp()
        {
            Door.Dispose();
        }
    }
}
