<?php

error_reporting(E_ERROR | E_WARNING | E_PARSE);

// ****** EDIT BELOW ******

$html = 0; //output for HTML rendering? 0 = no, 1 = yes
$thumbnail = 0; //use thumbnail for output? 0 = no (full sized), 1 = 1/8 scale, 2 = 1/4 scale, 3 = 1/2 scale

// **** ANSI only options
$caldir = '/mystic/calendar'; //calendar header dir
$textDir = '/mystic/text'; //calendar ANSI output dir

// **** HTML rendering only options
$ftp = 0; //use FTP to upload calendar.ans? 0 = no, 1 = yes

$ftpUser = 'username';
$ftpPass = 'password';
$ftpServer = 'website address';
$ftpDir = '/path/to/remote/dir/to/upload';

$localDir = ''; //local dir to copy ANSI and HTML files to for HTML rendering if not using FTP, usually used for local web server; ignores if $ftp = 1

// ****** DO NOT EDIT BELOW ******

$curMon = date('n'); //numerical without leading zero
$curDayNum = date('N'); //numerical representation of week (0=Sun, 1=Mon, etc)

function numWeeks($month, $year){
        $firstday = date("w", mktime(0, 0, 0, $month, 1, $year)); 
        $lastday = date("t", mktime(0, 0, 0, $month, 1, $year));
        $count_weeks = 1 + ceil(($lastday-8+$firstday)/7);
        return $count_weeks;
}
$weeks = numWeeks($curMon, date('Y'));

// for each day in the month
for($i = 1; $i <= date('t'); $i++)
{
   // add the date to the dates array
   $dates[$i] = date("w", mktime(0, 0, 0, $curMon, $i, date('Y')));
}

//assign days of weeks to each array with corresponding dates
$start=0;
$search = array_search("6", $dates);
	
for($n=1; $n <= $weeks; $n++)
{
	${"week_result".$n} = array_slice($dates, $start, $search, TRUE);

	if ($search < 7)
	{
		$start=$search;
	}

	if ($search == 7)
	{
		$start=$start+7;
	}
	
	$search=7;	
}

//zero padded numbers array
$num_pad = array("01", "02", "03", "04", "05", "06", "07", "08", "09");
$num_old = array("1", "2", "3", "4", "5", "6", "7", "8", "9");

//flip first week key and data, implode to string
if ($week_result1[1] == 0)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}
elseif ($week_result1[1] == 1)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}
elseif ($week_result1[1] == 2)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}
elseif ($week_result1[1] == 3)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}
elseif ($week_result1[1] == 4)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}
elseif ($week_result1[1] == 5)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}
elseif ($week_result1[1] == 6)
{
	$week_result1 = str_replace($num_old, $num_pad, ($week_result1 = implode("  ", array_flip($week_result1))));
}

//Total days in last week
$endweeknum = count(${"week_result".$weeks});

//flip key and data on last week, implode to string
if ($endweeknum == 1)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}))."[24C";
}
elseif ($endweeknum == 2)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}))."[20C";
}
elseif ($endweeknum == 3)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}))."[16C";
}
elseif ($endweeknum == 4)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}))."[12C";
}
elseif ($endweeknum == 5)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}))."[8C";
}
elseif ($endweeknum == 6)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}))."[4C";
}
elseif ($endweeknum == 7)
{
	${"week_result".$weeks} = ${"week_result".$weeks} = implode("  ", array_flip(${"week_result".$weeks}));
}

//add leading zeros to single digit days	
for ($a=2; $a < $weeks; $a++)
{
	${"week_result".$a} = array_flip(${"week_result".$a});
	
	for ($b=0; $b <=9; $b++)
	{
		if (${"week_result".$a}[$b] <= 9)
			{
				${"week_result".$a}[$b] = str_replace($num_old, $num_pad, ${"week_result".$a}[$b]);
			}
	}
	
	//right trim trailing whitespace from calendar rows
	${"week_result".$a} = rtrim(implode("  ", (${"week_result".$a})));
}

//add colored background to current day
for ($c=1; $c <= $weeks; $c++)
{
	$today = strpos(${"week_result".$c}, date('d'));
	if ($today !== false)
	{
		//add color code to beginning of current day
		${"week_result".$c} = substr_replace(${"week_result".$c}, "[45m", $today, 0);
		//add color code to end of current day
		${"week_result".$c} = substr_replace(${"week_result".$c}, "[40m", $today+7, 0);
	}
}

//open current month's calendar heading, append calendar, write to calendar.ans
$cal_read = ($caldir.'/'.date('m')."_".date('Y').".ans");
$cal_write = ($textDir.'/calendar.ans');

$fp = file_get_contents($cal_read);

$fp .= "[0m[1m".PHP_EOL.str_pad(("[0m[1m  [0m[21C[1;42;36m".iconv("UTF-8", "CP437", "█▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀")."[45m".iconv("UTF-8", "CP437", "█")."[0m"), 68, " ", STR_PAD_BOTH).PHP_EOL;
$fp .= "[23C[1;42;36m".iconv("UTF-8", "CP437", "█").str_pad((str_pad("[0;42;30m     [1;37m *   [0;42;30m[1;37m".(date('F')." ".date('Y')."   *[0;42;30m      [1;45;36m").iconv("UTF-8", "CP437", "█")."[0m", 30, " ", STR_PAD_BOTH)), 60, " ", STR_PAD_LEFT).PHP_EOL;
$fp .= str_pad(("[1;32m[7C[0;36m".iconv("UTF-8", "CP437", "▄▄▄")."[1;32m[13C[42;36m".iconv("UTF-8", "CP437", "█")."[0;42;30m                                [1;45;36m".iconv("UTF-8", "CP437", "█")."[40;32m[13C[0;36m".iconv("UTF-8", "CP437", "▄▄▄")), 30, " ", STR_PAD_BOTH).PHP_EOL;
$fp .= str_pad(("[1;32m  [0m  [36m".iconv("UTF-8", "CP437", "▄")."[1;46;35m".iconv("UTF-8", "CP437", "▄▄▀▀▀")."[0;36m".iconv("UTF-8", "CP437", "█")."[35m  [36m".iconv("UTF-8", "CP437", "▄")."[35m[9C[1;42;36m".iconv("UTF-8", "CP437", "█")."  [0;42;30mSun Mon Tue Wed Thu Fri Sat   [1;45;36m").iconv("UTF-8", "CP437", "█")."[0;35m[9C[36m".iconv("UTF-8", "CP437", "▄")."[35m  [36m".iconv("UTF-8", "CP437", "█")."[1;46;35m".iconv("UTF-8", "CP437", "▀▀▀▄▄")."[0;36m".iconv("UTF-8", "CP437", "▄"), 78, " ", STR_PAD_BOTH).PHP_EOL;
$fp .= str_pad((iconv("UTF-8", "CP437", "[37m    [1;46;35m░▓[0;36m▀[37m   [36m▀ █[1;46;35m▄[0;36m█[37m  [32m▄[36m██▄[37m  [1;42;36m█[0;35m█▀▀▀▀▓▀▀▀▓▀▀▀▓▀▀▀▓▀▀▀▓▀▀▀▓▀▀▀▀▀█[1;45;36m█[0m  [36m▄██[32m▄[37m  [36m█[1;46;35m▄[0;36m█ ▀[37m   [36m▀[1;46;35m▓░[0m")), 78, " ", STR_PAD_BOTH).PHP_EOL;

//add color and ANSI to middle rows, excluding first and last rows
for ($w=1; $w <= $weeks-1; $w++)
{
	if ($w == 1)
	{
		$fp .= iconv("UTF-8", "CP437", "[5C[36m▀▄[37m [35m░░[37m [32m▀[1;46;35m▀▓[0m [36m▄[1;46;35m▄▀[0;36m▀[37m  [32m▀[37m [1;42;36m█[0;35m█[37m    [35m [37m[5C[1m").${"week_result".$w}.iconv("UTF-8", "CP437", "[0;35m  █[1;45;36m█[0m [32m▀[37m  [36m▀[1;46;35m▀▄[0;36m▄[37m [1;46;35m▒▀[0;32m▀[37m [35m░░[37m [36m▄▀").PHP_EOL;
	}
	elseif ($w == 2)
	{
		$fp .= iconv("UTF-8", "CP437", "[37m[14C[36m▀[32m▄▀[37m   [35m░░[37m [1;42;36m█[0;35m█  [1;37m").${"week_result".$w}.iconv("UTF-8", "CP437", "[0;35m  █[1;45;36m█[0m [35m░░[37m   [32m▀▄[36m▀").PHP_EOL;
	}
	elseif ($w == 3)
	{
		$fp .= iconv("UTF-8", "CP437", "[37m[23C[1;42;36m█[0;35m█  [1;37m").${"week_result".$w}.iconv("UTF-8", "CP437", "[0;35m  █[1;45;36m█[0m").PHP_EOL;
	}
	elseif ($w == 4)
	{
		$fp .= iconv("UTF-8", "CP437", "[23C[1;42;36m█[0;35m█  [1;37m").${"week_result".$w}.iconv("UTF-8", "CP437", "[0;35m  █[1;45;36m█[0m").PHP_EOL;
	}
}

$fp .= iconv("UTF-8", "CP437", "[35m[16C[37m[7C[1;42;36m█[0;35m█[37m  [1m").${"week_result".$weeks}."[0m[35m".iconv("UTF-8", "CP437", "[0m[35m  █[1;45;36m█[0m").PHP_EOL;
$fp .= iconv("UTF-8", "CP437", "[23C[1;42;36m█[0;35m█▄▄▄▄▓▄▄▄▓▄▄▄▓▄▄▄▓▄▄▄▓▄▄▄▓▄▄▄▄▄█[1;45;36m█[0m").PHP_EOL;
$fp .= iconv("UTF-8", "CP437", "[23C[1;42;36m█[0;35m█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄█▄[1;45;36m█[0m").PHP_EOL;
$fp .= str_pad((iconv("UTF-8", "CP437", "[11C[1;45;36m█▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄█[0m")), 78, " ", STR_PAD_BOTH).PHP_EOL.PHP_EOL;
file_put_contents($cal_write, $fp);

if ($html == 1)
{
	$fp = fopen($textDir.'/calendar.html', 'w');
	$fp = file_get_contents($textDir.'/calendar.html');
	
	$fp = '<html>'.PHP_EOL;
	$fp .= '<head>'.PHP_EOL;
	$fp .= '	<meta http-equiv="Content-type" content="text/html; charset=utf-8">'.PHP_EOL;
	$fp .= '	<title>ansilove.js</title>';
	$fp .= '	<script src="ansilove.js" type="text/javascript" charset="utf-8"></script>'.PHP_EOL;
	$fp .= '	<style type="text/css" media="screen">'.PHP_EOL;
	$fp .= '	body {'.PHP_EOL;
	$fp .= '		background: black;'.PHP_EOL;
	$fp .= '	}'.PHP_EOL;
	$fp .= '	.center {'.PHP_EOL;
	$fp .= '		margin: 0 auto;'.PHP_EOL;
	$fp .= '		background-color: black;'.PHP_EOL;
	$fp .= '		padding: 16px;'.PHP_EOL;
	$fp .= '	}'.PHP_EOL;
	$fp .= '	#header {'.PHP_EOL;
	$fp .= '		width: 720px;'.PHP_EOL;
	$fp .= '		height: 464px;'.PHP_EOL;
	$fp .= '	}'.PHP_EOL;
	$fp .= '	#example {'.PHP_EOL;
	$fp .= '		width: 720px;'.PHP_EOL;
	$fp .= '		height: 384px;'.PHP_EOL;
	$fp .= '		overflow: hidden;'.PHP_EOL;
	$fp .= '	}'.PHP_EOL;
	$fp .= '		</style>'.PHP_EOL;
	$fp .= '</head>'.PHP_EOL;
	$fp .= '	<body>'.PHP_EOL;
	$fp .= '		<div id="header" class="center"></div>'.PHP_EOL.PHP_EOL;
		
	$fp .= '		<div id="example" class="center"></div>'.PHP_EOL.PHP_EOL;
        
	$fp .= '<script type="text/javascript">;'.PHP_EOL;
	$fp .= 'var controller, retina;'.PHP_EOL.PHP_EOL;

	$fp .= 'retina = window.devicePixelRatio > 1;'.PHP_EOL.PHP_EOL;

	$fp .= 'AnsiLove.render("calendar.ans", function (canvas, sauce) {'.PHP_EOL;
	$fp .= '	document.getElementById("header").appendChild(canvas);'.PHP_EOL;
	$fp .= '}, {"bits": "9", "thumbnail": '.$thumbnail.', "2x": (retina ? 1 : 0)});'.PHP_EOL;
	$fp .= '</script>'.PHP_EOL.PHP_EOL;
        
	$fp .= '	</body>'.PHP_EOL;
	$fp .= '</html>'.PHP_EOL;

	file_put_contents($textDir.'/calendar.html', $fp);
	
	if ($ftp == 1)
	{
		// set up basic connection
		$conn_id = ftp_connect($ftpServer);

		// login with username and password
		$login_result = ftp_login($conn_id, $ftpUser, $ftpPass);

		// upload a file
		if (ftp_put($conn_id, $ftpDir."/calendar.ans", $textDir."/calendar.ans", FTP_ASCII) && ftp_put($conn_id, $ftpDir."/calendar.html", $textDir."/calendar.html", FTP_ASCII)) {
			echo "Successfully uploaded calendar.ans & calendar.html\n";
			
			unlink($textDir.'/calendar.html');
		} else {
			echo "There was a problem while uploading calendar.ans & calendar.html\n";
		}

		// close the connection
		ftp_close($conn_id);
	}
	elseif ($ftp == 0)
	{
		if (!copy($textDir.'/calendar.html', $localDir.'/calendar.html') || !copy($textDir.'/calendar.ans', $localDir.'/calendar.ans')) {
			echo "Failed to copy calendar.ans & calendar.html\n";
		} else {
			unlink($textDir.'/calendar.html');
		}
	}
}

?>