/* infamous muggifilelistcreator for dd/linux (c) flower/project-deedee */

#include <dirent.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define	unzippath	"/usr/bin/unzip"
#define	nodizline	"No File_ID.Diz in this file!\n"
#define unzipline	"%s -qqLC %s/%s file_id.diz"

struct dizlist {
  char line[100];
  struct dizlist *next;
};

struct pathname {
  char name[255];
  struct pathname *next;
};

typedef struct dizlist dizlist_t;
typedef struct pathname pathname_t;

/* wildcmp routine gently borrowed from hydra's misc.c			*/

int wildcmp (char *nam, char *pat) {
  register char *p;

  for (;;) {
    if (tolower(*nam) == tolower(*pat)) {
      if(*nam++ == '\0')  return(1);
      pat++;
    } else if (*pat == '?' && *nam != 0) {
      nam++;
      pat++;
    } else  break;
  }
  if (*pat != '*') return(0);
  while (*pat == '*') {
    if (*++pat == '\0')  return(1);
  }
  for (p=nam+strlen(nam)-1;p>=nam;p--) {
    if (tolower(*p) == tolower(*pat))
      if (wildcmp(p,pat) == 1) return(1);
  }
  return(0);
}

/* fgetsnolfs routine gently borrowed from hydra and modded		*/

char *fgetsnolfs(char *buf, int n, FILE *fh) {
  char *in;
  char *tmp;
  
  in=fgets(buf,n,fh);
  if (!in) return 0;
  tmp=buf;
  while (*tmp) {
    if ((*tmp==10)||(*tmp==13)) {
      *tmp=0;
      break;
    }
    tmp++;
  }
  return in;
}


int boring(char *str) {
  int ok=1,i,j=strlen(str);

  for (i=0;i<j;i++)
    if ((str[i]!=' ') || (str[i]!='\0'))
      ok=0;
  return ok;
}

dizlist_t *getdiz() {
  FILE *diz;
  char buf[100];
  dizlist_t *tmp, *e=NULL, *h=NULL;
		
  if ((diz = fopen("file_id.diz", "r"))) {
    while (fgetsnolfs(buf, 100, diz) != 0) {

      // spaces or empty string
      if (boring(buf))
	continue;

      tmp = (dizlist_t*) malloc(sizeof(dizlist_t));
      strcpy(tmp->line, buf);
      tmp->next=NULL;
      if (h==NULL) {
	e = h = tmp;
      } else {
	e = e->next = tmp;
      }
    }
    fclose(diz);

  } else {
    h = (dizlist_t*) malloc(sizeof(dizlist_t));
    strcpy(h->line, nodizline);
    h->next = NULL;
  }

  return h;
}

int makedate(char *tmp, int len) {
  time_t *t;
  struct tm *tid;
	
  time(t);
  tid = localtime(t);
  snprintf(tmp, len, "%2.2d.%2.2d.%2.2d", tid->tm_mday, tid->tm_mon, (tid->tm_year > 99 ? tid->tm_year - 100 : tid->tm_year));

  return 0;
}

int makelongdate(char *tmp, int len) {
  time_t* t;
  
  time(t);
  ctime_r(t, tmp);

  return 0;
}

void processfile(char *fil,char *path,int shortlist) {
  dizlist_t *dl,*t;
  char *args[10];
  int cp,i=1;
  struct stat s;
  char datestr[80];
  char tmpstr[1000];
  char *tmp;
  
  remove("file_id.diz");
  sprintf(tmpstr, unzipline, unzippath, path, fil);
  args[0] = tmpstr;

  // split tmpstr into commandline args.
  tmp = (char*) &tmpstr;
  while (*tmp) {
    if (*tmp==' ') {
      *tmp=0;
      tmp++;
      args[i]=tmp;
      i++;
    } 
    else
      tmp++;
  }
  args[i]=0;
  
  cp=fork();
  if (cp==-1) {
    printf("*unf* her findes ingen gaffel :)\n");
    exit(1);
  } else if (cp==0) {
    execvp(args[0],&args[0]);
    kill(getpid(), SIGKILL); /* hvis nu execvp fejler */
  } else {
    waitpid(-1,0,0);
  }
  
  dl = getdiz();
  sprintf(tmpstr, "%s/%s", path, fil);
  stat(tmpstr, &s);
  
  if (shortlist) {
    // make the short date
    makedate(datestr, 80);
    // create tmpstr
    printf("%-12.12s P--- %7.7ld %s %s\n", fil, s.st_size, datestr, dl->line);
    t = dl; 
    dl = dl->next; 
    free(t);
  } else {
    makelongdate(datestr, 80);
    printf("%-34.34s P--- %7.7ld %s", fil, s.st_size, datestr);
  }
  
  while (dl != NULL) {
    printf("                                   %s\n", dl->line);
    t = dl; 
    dl = dl->next; 
    free(t);
  }
}

pathname_t* add_sorted(pathname_t* list, pathname_t* item) {
  pathname_t* tmp;
  pathname_t* prev = NULL;

  if (list == NULL) {
    item->next = NULL;
    return item;
  }

  tmp = list;
  while (tmp != NULL && strcasecmp(tmp->name, item->name) < 0) {
    prev = tmp;
    tmp = tmp->next;
  }

  if (tmp == NULL) {
    prev->next = item;
    item->next = NULL;
  }
  else {
    if (prev == NULL) {
      list = item;
      list->next = tmp;
    }
    else {
      prev->next = item;
      item->next = tmp;
    }
  }

  // return (new) head
  return list;
}


void processpath(char *path, int shortlist) {
  DIR *lupdir;
  struct dirent *deent;
  pathname_t* sorted_files = NULL;
  pathname_t* add = NULL;
	
  if ((lupdir=opendir(path))) {
    while ((deent=readdir(lupdir))) {
      if (!strcmp(deent->d_name,".")||(!strcmp(deent->d_name,".."))) continue; 
      if (wildcmp(deent->d_name,"*.zip")) {
	
	add = (pathname_t*) malloc(sizeof(pathname_t));
	strcpy(add->name, deent->d_name);

	sorted_files = add_sorted(sorted_files, add);
      }
    }
    closedir(lupdir);

    // traverse list in order.
    while (sorted_files != NULL) {
      processfile(sorted_files->name, path, shortlist);
      add = sorted_files;
      sorted_files = sorted_files->next;
      free(add);
    }
  }
}

int main(int argc,char *argv[]) {
  int shortlist = 1;
  char *path = ".";
  char c;

  fprintf(stderr,".________________________________________.\n");
  fprintf(stderr,"|                             _____      |\n");
  fprintf(stderr,"|     P R O J E C T         _/.  . \\_/*  |\n");
  fprintf(stderr,"|                         */ \\__,__/ \\/_/|\n");
  fprintf(stderr,"|      D E E D E E         _____/____/   |\n");
  fprintf(stderr,"|                        _/_ /____\\      |\n");
  fprintf(stderr,"|       presents:       / \\  /    \\  /\\  |\n");
  fprintf(stderr,"|                            \\     \\/ _\\ |\n");
  fprintf(stderr,"| muggi filelist creator   \\__\\          |\n");
  fprintf(stderr,"|        v1.1                            |\n");
  fprintf(stderr,"|________________________________________|\n");

  while ((c = getopt(argc, argv, "lp:")) != -1) {
    switch (c) {
    case 'l':
      shortlist = 0;
      break;
    case 'p':
      path = optarg;
      break;
    case '?':
      fprintf(stderr,"syntax: %s [-p <path>] [-l]\n\n", argv[0]);
      fprintf(stderr,"  -p /space/files  specifies to look for files in /space/files\n");
      fprintf(stderr,"  -l               uses long dir format (default short)\n\n");
      fprintf(stderr,"output will goto stdout, so be sure to redirect.\n");
      exit(2);
    }
  }
  
  fprintf(stderr,"Uploading-> Please hold..\n");
  processpath(path, shortlist);
  remove("file_id.diz");
  fprintf(stderr,"Done-> Thank you for choosing project-deedee :)\n");
  
  return 0;
}
