/* infamous muggifilelistcreator for dd/linux (c) flower/project-deedee */

#include <dirent.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <zip.h>

#define	nodizline	"No File_ID.Diz in this file :-("

struct dizlist {
  time_t *date;
  struct dizlist_item *head;
  struct dizlist_item *tail;
};

struct dizlist_item {
  int len;
  char *line;
  struct dizlist_item *next;
};

struct pathname {
  char name[255];
  struct pathname *next;
};

typedef struct dizlist dizlist_t;
typedef struct dizlist_item dizlist_item_t;
typedef struct pathname pathname_t;

/* wildcmp routine gently borrowed from hydra's misc.c			*/

int wildcmp (char *nam, char *pat) {
  register char *p;

  for (;;) {
    if (tolower(*nam) == tolower(*pat)) {
      if(*nam++ == '\0')  return(1);
      pat++;
    } else if (*pat == '?' && *nam != 0) {
      nam++;
      pat++;
    } else  break;
  }
  if (*pat != '*') return(0);
  while (*pat == '*') {
    if (*++pat == '\0')  return(1);
  }
  for (p=nam+strlen(nam)-1;p>=nam;p--) {
    if (tolower(*p) == tolower(*pat))
      if (wildcmp(p,pat) == 1) return(1);
  }
  return(0);
}

void dizlist_close(dizlist_t *l) {
  dizlist_item_t *t, *p = NULL;

  for (t = l->head; t != NULL; t = t->next) {
	if (p != NULL) {
	  free(p->line);
	  free(p);
	}
	p = t;
  }

  if (p != NULL) {
	free(p->line);
	free(p);
  }
}

void dizlist_add(dizlist_t *l, char *buf, int len) {
  dizlist_item_t *item;

  if (len < 0)
	len = strlen(buf) + 1;

  // prepare item
  item = malloc(sizeof(dizlist_item_t));
  item->line = malloc(len);
  memcpy(item->line, buf, len);
  item->len = len;
  item->next = NULL;

  // add item to list
  if (l->head == NULL) {
	l->head = l->tail = item;
  }
  else {
	l->tail->next = item;
	l->tail = item;
  }
}

int dizlist_buflen(dizlist_t *l) {
  int i = 0;
  dizlist_item_t *t;

  for (t = l->head; t != NULL; t = t->next) {
	i += t->len;
  }

  return i;
}

int boring(char *str) {
  int ok=1,i,j=strlen(str);

  for (i=0;i<j;i++)
    if ((str[i]!=' ') || (str[i]!='\0'))
      ok=0;
  return ok;
}

void dizlist_debug(dizlist_t* l) {
  dizlist_item_t *i;
  char *t;

  for (i = l->head; i != NULL; i = i->next) {
	t = malloc(i->len + 1);
	memcpy(t, i->line, i->len);
	*(t + i->len) = 0;
	fprintf(stderr, "DEBUG; %s\n", t);
  }
}

void dizlist_splitlines(dizlist_t *from, dizlist_t *to, int noempty) {
  int rc;
  char *line_s, *line_tmp;
  char *tbuf;
  dizlist_item_t *tmp;

  // dizlist_debug(from);

  // construct combined buffer.
  rc = dizlist_buflen(from);

  tbuf = malloc(rc + 1);
  rc = 0;
  for (tmp = from->head; tmp != NULL; tmp = tmp->next) {
	memcpy(tbuf + rc, tmp->line, tmp->len);
	rc += tmp->len;
  }

  *(tbuf + rc) = 0;

  rc = sizeof(tbuf);
  line_s = line_tmp = tbuf;
  while (*line_tmp) {

	if (*line_tmp == 0 || *line_tmp == '\r' || *line_tmp == '\n') {
	  *line_tmp = 0;
	  if (noempty && !boring(line_s))
		dizlist_add(to, line_s, -1);
	  else if (!noempty)
		dizlist_add(to, line_s, -1);
	  line_s = line_tmp + 1;
	}

	line_tmp++;
  }

  if (line_s != line_tmp)
	dizlist_add(to, line_s, strlen(line_s) + 1);

  // dizlist_debug(to);
}


dizlist_t *getdiz(char *file, int noempty) {
  int idx;
  int rc;
  struct zip *zf;
  struct zip_file *zd;
  struct zip_stat sb;
  char buf[1024];
  dizlist_t tmp;
  dizlist_t *r;

  tmp.head = tmp.tail = NULL;
  r = malloc(sizeof(dizlist_t));
  r->head = r->tail = NULL;
  r->date = NULL;

  zf = zip_open(file, 0, NULL);
  if (zf == NULL) {
	dizlist_add(r, nodizline, -1);
	return r;
  }

  idx = zip_name_locate(zf, "file_id.diz", ZIP_FL_NOCASE | ZIP_FL_NODIR);

  if (idx < 0) {
	zip_close(zf);
	dizlist_add(r, nodizline, -1);
	return r;
  }

  zip_stat_index(zf, idx, 0, &sb);
  r->date = malloc(sizeof(time_t));
  memcpy(r->date, &sb.mtime, sizeof(time_t));

  zd = zip_fopen_index(zf, idx, 0);

  if (zd == NULL) {
	zip_close(zf);
	dizlist_add(r, nodizline, -1);
	return r;
  }

  // read diz into buffer
  while ((rc = zip_fread(zd, buf, 1024)) > 0) {
	dizlist_add(&tmp, buf, rc);
  }

  zip_fclose(zd);
  zip_close(zf);

  dizlist_splitlines(&tmp, r, noempty);

  dizlist_close(&tmp);

  return r;
}

int makedate(time_t *o, char *tmp, int len) {
  time_t t;
  struct tm *tid;

  if (o == NULL)
	time(&t);
  else
	memcpy(&t, o, sizeof(time_t));

  tid = localtime(&t);
  snprintf(tmp, len, "%2.2d.%2.2d.%2.2d", tid->tm_mday, tid->tm_mon + 1, (tid->tm_year > 99 ? tid->tm_year - 100 : tid->tm_year));

  return 0;
}

int makelongdate(time_t *o, char *tmp, int len) {
  time_t t;

  if (o == NULL)
	time(&t);
  else
	memcpy(&t, o, sizeof(time_t));

  ctime_r(&t, tmp);

  return 0;
}

void processfile(char *fil,char *path,int shortlist, int cutdiz, int noempty) {
  dizlist_t *dl;
  dizlist_item_t *t;
  struct stat s;
  char datestr[80];
  char *tmpstr;
  
  tmpstr = malloc(strlen(path) + strlen(fil) + 2);
  sprintf(tmpstr, "%s/%s", path, fil);

  dl = getdiz(tmpstr, noempty);
  stat(tmpstr, &s);

  free(tmpstr);
  
  t = dl->head;

  if (shortlist) {
    // make the short date
    makedate(dl->date, datestr, 80);
    printf("%-12.12s P--- %7.7ld %s ", fil, s.st_size, datestr);
	if (cutdiz)
	  printf("%-45.45s\n", t->line);
	else
	  printf("%s\n", t->line);
	t = t->next;
  } else {
    makelongdate(dl->date, datestr, 80);
    printf("%-34.34s P--- %7.7ld %s", fil, s.st_size, datestr);
  }
  
  while (t != NULL) {
	if (cutdiz)
	  printf("                                   %-45.45s\n", t->line);
	else
	  printf("                                   %s\n", t->line);
    t = t->next;
  }

  dizlist_close(dl);
  free(dl);
}

pathname_t* add_sorted(pathname_t* list, pathname_t* item) {
  pathname_t* tmp;
  pathname_t* prev = NULL;

  if (list == NULL) {
    item->next = NULL;
    return item;
  }

  tmp = list;
  while (tmp != NULL && strcasecmp(tmp->name, item->name) < 0) {
    prev = tmp;
    tmp = tmp->next;
  }

  if (tmp == NULL) {
    prev->next = item;
    item->next = NULL;
  }
  else {
    if (prev == NULL) {
      list = item;
      list->next = tmp;
    }
    else {
      prev->next = item;
      item->next = tmp;
    }
  }

  // return (new) head
  return list;
}


void processpath(char *path, int shortlist, int cutdiz, int noempty) {
  DIR *lupdir;
  struct dirent *deent;
  pathname_t* sorted_files = NULL;
  pathname_t* add = NULL;
	
  if ((lupdir=opendir(path))) {
    while ((deent=readdir(lupdir))) {
      if (!strcmp(deent->d_name,".")||(!strcmp(deent->d_name,".."))) continue; 
      if (wildcmp(deent->d_name,"*.zip")) {
	
		add = (pathname_t*) malloc(sizeof(pathname_t));
		strcpy(add->name, deent->d_name);

		sorted_files = add_sorted(sorted_files, add);
      }
    }
    closedir(lupdir);

    // traverse list in order.
    while (sorted_files != NULL) {
      processfile(sorted_files->name, path, shortlist, cutdiz, noempty);
      add = sorted_files;
      sorted_files = sorted_files->next;
      free(add);
    }
  }
}

int main(int argc,char *argv[]) {
  int shortlist = 1;
  int cutdiz = 0;
  int noempty = 0;
  char *path = ".";
  char c;

  fprintf(stderr,".________________________________________.\n");
  fprintf(stderr,"|                             _____      |\n");
  fprintf(stderr,"|     P R O J E C T         _/.  . \\_/*  |\n");
  fprintf(stderr,"|                         */ \\__,__/ \\/_/|\n");
  fprintf(stderr,"|      D E E D E E         _____/____/   |\n");
  fprintf(stderr,"|                        _/_ /____\\      |\n");
  fprintf(stderr,"|       presents:       / \\  /    \\  /\\  |\n");
  fprintf(stderr,"|                            \\     \\/ _\\ |\n");
  fprintf(stderr,"| muggi filelist creator   \\__\\          |\n");
  fprintf(stderr,"|        v2009.2                         |\n");
  fprintf(stderr,"|________________________________________|\n");

  while ((c = getopt(argc, argv, "celp:")) != -1) {
    switch (c) {
	case 'c':
	  cutdiz = 1;
	  break;
    case 'l':
      shortlist = 0;
      break;
	case 'e':
	  noempty = 1;
	  break;
    case 'p':
      path = optarg;
      break;
    case '?':
      fprintf(stderr,"syntax: %s [-p <path>] [-c] [-l]\n\n", argv[0]);
      fprintf(stderr,"  -p /space/files  specifies to look for files in /space/files\n");
      fprintf(stderr,"  -l               uses long dir format (def: short)\n");
      fprintf(stderr,"  -c               cut file_id to 45 chars (def: leave)\n");
	  fprintf(stderr,"  -e               keep empty lines from file_id (def: remove)\n\n");
      fprintf(stderr,"output will goto stdout, so be sure to redirect.\n");
      exit(2);
    }
  }
  
  fprintf(stderr,"Uploading-> Please hold..\n");
  processpath(path, shortlist, cutdiz, noempty);
  fprintf(stderr,"Done-> Thank you for choosing project-deedee :)\n");
  
  return 0;
}
