#!/usr/bin/python3
'''
   ---------------------------------------------------------------------------
   bbs mail post                                                          xqtr
   --------------------------------------------------------------------------- 

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
   
   _            _   _              ___          _    _       
  /_\  _ _  ___| |_| |_  ___ _ _  |   \ _ _ ___(_)__| |               8888
 / _ \| ' \/ _ \  _| ' \/ -_) '_| | |) | '_/ _ \ / _` |            8 888888 8
/_/ \_\_||_\___/\__|_||_\___|_|   |___/|_| \___/_\__,_|            8888888888
                                                                   8888888888
         DoNt Be aNoTHeR DrOiD fOR tHe SySteM                      88 8888 88
                                                                   8888888888
    .o HaM RaDiO    .o ANSi ARt!       .o MySTiC MoDS              "88||||88"
    .o NeWS         .o WeATheR         .o FiLEs                     ""8888""
    .o GaMeS        .o TeXtFiLeS       .o PrEPardNeSS                  88
    .o TuTors       .o bOOkS/PdFs      .o SuRVaViLiSM          8 8 88888888888
    .o FsxNet       .o SurvNet         .o More...            888 8888][][][888
                                                               8 888888##88888
   TeLNeT : andr01d.zapto.org:9999                             8 8888.####.888
   SySoP  : xqtr                   eMAiL: xqtr@gmx.com         8 8888##88##888
'''   

from datetime import datetime
import subprocess
import imaplib
import email
import struct
import os
import smtplib, ssl
import sys

mysticpath = '/home/pi/mystic'
datadir = mysticpath+os.sep+'data'+os.sep
appdir = os.path.dirname(sys.argv[0])

counter=0
mbases = []
sendto = []

#settings for outgoing mail. 
smtp_server = "your_smtp_server"
sender_email = "your_email"
send_password = 'password'

#email address that will receive responses
response_email = 'email_address'

#these are the settings for the email account to check for incoming
#commands/msgs
imap_server = 'imap.server.com'
check_email = 'the_bbs_email@email.com'
check_email_password = 'password'
mail_header = 'header'

def byte2str(v):
    s=''.join(str(v))
    return s[2:-1]
    
def oneliners():
    f = open(datadir+"oneliner.dat","rb") # open the file
    sf = '@b79sb30s'
    s = struct.calcsize (sf)
    size = struct.calcsize(sf)
    i = 0
    d = 0
    out = ""
    while True:
        line = f.read(s) # read n bytes as the record size
        if len(line) < s:
            break
        i,onel,d,name = struct.unpack(sf,line)  # assign values to variables
        out +=byte2str(name[0:d]).ljust(20)+byte2str(onel[0:i]).ljust(20)+'\n'
    out = 'Subject: OneLiners\n'+out   
    return out
      
  
def unpackdt(t):
    year = 1980 + (t >> 25)
    month = (t & 0b00000001111000000000000000000000) >> 21
    day = (t & 0b00000000000111110000000000000000) >> 16
    hour = (t & 0b00000000000000001111100000000000) >> 11
    minute = (t & 0b00000000000000000000011111100000) >> 5
    second = (t & 0b00000000000000000000000000011111) * 2
    return datetime(year, month, day, hour, minute, second)
  
def lastcallers():
    f = open(datadir+"callers.dat","rb")
    sf = '<L?b15sb50sBIb30sb25sb30scb35sb30s663c'
    s = struct.calcsize (sf)
    size = struct.calcsize(sf)
    i = 0
    d = 0
    out = ""
    while True:
        line = f.read(s)
        if len(line) < s:
            break
        res = struct.unpack(sf,line)
        date = str(unpackdt(res[0])) #date
        name = ''.join(str(res[9][0:res[8]])).strip("b'") #username
        city = ''.join(str(res[11][0:res[10]])).strip("b'") #city
        address = ''.join(str(res[13][0:res[12]])).strip("b'") #address
        gender = ''.join(str(res[14]).strip("b'"))  # gender
        email =''.join(str(res[16][0:res[15]])).strip("b'") #email
        out += name.ljust(20)+date+' '+gender+' '+city.ljust(20)+address.ljust(30)+email+'\n'
    out = 'Subject: Last Callers\n'+out
    return out
    
def readmsgbase(i,filename):
    
  if os.path.exists(filename) == False:
    return [-1,None]
  size = os.path.getsize(filename)
  fbaserec = "<Hx60sx13sx60sx40sx80sBBBx30sx30sx30sx30sx30sx30sBBBBBBx50sBBIHx20sx20sx20sIIx40sIH136B"
  sf = struct.calcsize(fbaserec)
  items = size // sf
  if i > items:
    return [-3,None]
  f = open(filename, 'rb')
  try:
    f.seek((i-1)*sf,1)
  except:
    return [-2,None]
  fbaseb = f.read(sf)
  s = struct.unpack(fbaserec,fbaseb)
  f.close()
  res = {}
  res['index'] = s[0]
  res['name'] = byte2str(s[1]).replace('\\x00','')
  res['filename'] = byte2str(s[4]).replace('\\x00','')
  res['listacs']  = byte2str(s[9]).replace('\\x00','')
  res['readacs']  = byte2str(s[10]).replace('\\x00','')
  res['echotag']  = byte2str(s[31]).replace('\\x00','')
  return [0,res]
    
def sendmail(user,text):
    global smtp_server
    global sender_email
    global send_password
    port = 587  # For SSL
    smtp_server = "your_smtp_server"
    sender_email = "your_email"
    receiver_email = user
    password = '78xq#3.$'
    message = text
    context = ssl.create_default_context()
    context = ssl.create_default_context()
    with smtplib.SMTP(smtp_server, port) as server:
        server.ehlo()  # Can be omitted
        server.starttls(context=context)
        server.ehlo()  # Can be omitted
        server.login(sender_email, send_password)
        server.sendmail(sender_email, receiver_email, message)


def createlist():
    global mbases
    i = 1
    r = readmsgbase(i,mysticpath+os.sep+'data'+os.sep+'mbases.dat')
    while r[0] == 0:
        if r[1]['echotag'] != "":
            item = [r[1]['echotag'],r[1]['index']]
            mbases.append(item)
        i += 1
        r = readmsgbase(i,mysticpath+os.sep+'data'+os.sep+'mbases.dat')
        
def findbasebyname(name):
    global mbases
    for i in range(len(mbases)):
        if name.lower().strip()==mbases[i][0].lower():
            return mbases[i][1]
    return -1
  
def sendlist():
    global response_email
    bases = "Subject: Msg.Bases List\n"
    for d in range(len(mbases)):
        bases += mbases[d][0]+'\n'
    sendmail(response_email,bases)

def bbspost(idlist,afrom,ato,asubject,text):
  print('in bbspost')
  global counter
  for i in range(len(idlist)):
    s = ""
    s += '[General]\n'
    s += 'PostTextFiles = true\n'
    s += 'logfile = mutil.log\n'
    s += 'loglevel = 3\n'
    s += 'logtype = 1\n'
    s += 'maxlogfiles = 31\n'
    s += 'maxlogsize = 1500\n'

    s += '[PostTextFiles]\n'
    s += 'totalfiles = 1\n'
    s += 'file1_name    = '+mysticpath+os.sep+'mbbspost'+str(counter)+'.tmp\n'
    s += 'file1_baseidx = '+str(idlist[i])+'\n'
    s += 'file1_from    = '+afrom+'\n'
    s += 'file1_to      = '+ato+'\n'
    s += 'file1_subj    = '+asubject+'\n'
    s += 'file1_addr    = 21:1/111\n'
    s += 'file1_delfile = false\n'
    f = open(mysticpath+os.sep+'mbbspost'+str(counter)+'.ini', 'w', encoding='ascii')
    f.write(s)
    f.close
    f = open(mysticpath+os.sep+'mbbspost'+str(counter)+'.tmp', 'w', encoding='ascii')
    f.write(text)
    f.close
    print('sending post / Counter: '+str(counter))
    counter += 1
 

mail = imaplib.IMAP4_SSL(imap_server)
mail.login(check_email, check_email_password)
mail.list() 
mail.select('inbox') 
result, data = mail.uid('search', None, '(HEADER Subject "'+mail_header+'")')
if str(data)=="[b'']":
    print('No data')
    exit()
a=None
   

createlist()

i = len(data[0].split()) 
for x in range(i):
    counter+=1
    latest_email_uid = data[0].split()[x] 
    result, email_data = mail.uid('fetch', latest_email_uid, '(RFC822)')
    raw_email = email_data[0][1]
    raw_email_string = raw_email.decode('utf-8')
    email_message = email.message_from_string(raw_email_string)
    #print(email_message)
    a=email_message
    for part in a.walk():
        if part.get_content_type() == "text/plain": 
            body = part.get_payload(decode=True)
            t = body.splitlines()
            for k in range(len(t)):
                t[k]=byte2str(t[k])
            #print(t)
            j = 0
            while j<len(t):
                s = t[j]
                s = s.upper()
                if s == '=LIST':
                    print('Sending list...')
                    sendlist()
                elif s == '=ONELINERS' or s == '=ONELINER' or s == '=1L':
                    print('Sending Oneliners')
                    sendmail(response_email,oneliners())
                elif s == '=LASTCALLERS' or s == '=LASTCALL' or s == '=LAST':
                    print('Sending Lastcallers')
                    sendmail(response_email,lastcallers())
                elif s == '=POST':
                    print('making post')
                    j += 1
                    s = t[j]
                    while s[0]=='+':
                        if s[0] == '+':
                            mb = findbasebyname(s[1:])
                            print('BASE : '+str(mb))
                            if mb >=0:
                                sendto.append(mb)
                        j += 1
                        s = t[j]

                    tfrom = t[j]
                    j += 1
                    tto = t[j]
                    j += 1
                    tsubject = t[j]
                    body = ''
                    j += 1
                    while j<len(t):
                        body += t[j]+'\n'
                        j+=1
                    if tfrom !='' and tto != '' and tsubject != '':
                        print(tfrom+' '+tto+' '+tsubject)
                        bbspost(sendto,tfrom,tto,tsubject,body)
                    else:
                        res = 'Subject : Error pasing message\n'
                        res += 'Could not find msg parameters\n'
                        sendmail(response_email,res)
                    
                    
                j += 1
            
    mail.uid('STORE', latest_email_uid, '+FLAGS', '\\Deleted')

mail.expunge()
mail.close()
mail.logout()


