STEREOMODE	equ 0				;0 => compile RMTplayer for mono 4 tracks
 icl "rmtplayr.a65"			;include RMT player routine
 
  org $4000
MODUL
 ins "Intro 16k v. 0.7 opt.rmt",6 ; skip header

 icl "utils.inc"
 icl "decrunch.s"

SYSVBV   equ   $E45F

dliv
 php
 pha
 txa
 pha
 tya
 pha

 jsr RASTERMUSICTRACKER+3
;-----------counter--
countl ;low adr
 ldy #$00
 iny
 bne save_cl
counth ;high adr
 ldx #$00
 inx
 stx counth+1
 stx 89
save_cl
 sty countl+1
 sty 88
;-------------------
;vbi_part jsr stub
 pla
 tay
 pla
 tax
 pla
 plp
 JMP SYSVBV

webdl
	dta 112,112,112
	dta $44
webdla
	dta a(web_a)
:23	dta 4
	dta $41
	dta a(webdl)
	
startd
; BASIC OFF
; https://www.wudsn.com/index.php/productions-atari800/tutorials/tips
	LDA $d301   ;Disable BASIC bit in PORTB for MMU
	ORA #$02
	STA $d301
	LDA #$01    ;Set BASICF for OS, so BASIC remains OFF after RESET
	STA $3f8
; **************
	jsr clear20
	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl

	lda #0
	sta 710
	lda #$0F
	sta 709
;	jmp *
	jsr clear_ab

	ldx >plmap ; skip 2 first bytes
	ldy <plmap
	jsr __decruncher

; p_song;$D1
;;;;;;;;;;;;;; init RMT ;;;;;;;;;;;;;;
	ldx #<MODUL				;low byte of RMT module to X reg
	ldy #>MODUL				;hi byte of RMT module to Y reg
	lda #0					;starting song line 0-255 to A reg
	jsr RASTERMUSICTRACKER		;Init

SETVBV      equ $E45C
	ldx #dliv/256
	ldy #dliv&255
	lda #$06
	jsr SETVBV

	jsr title
	
	jsr clear20
	lda #0
	jsr setno9
	
	jsr hexg
	jsr plasm
	jsr dotty
	jsr twister

	lda #$0
	sta 709
	sta $d017

	lda #$40
	STA NMIEN

	jsr greet
	jsr rings
	
	jsr wavy

;	jmp *
	jsr picshow
	jmp *

;-----------------------------------------------------------------------------------
title
lmpl equ $2C00

;	mwa gr0a #$2000

;	ldx >plmap ; skip 2 first bytes
;	ldy <plmap
;	jsr __decruncher

;	ldx #<dlgr0
;	ldy #>dlgr0
;	jsr setdl

; copy lightmap
	mwa #$A000 $EB
colm1 ldx #0
	ldy #0
colm2 lda lmpl,x
	sta ($EB),y
	iny
	inx
	cpx #32
	bne colm2
	inc $EC
	lda colm2+1
	clc
	adc #32
	sta colm2+1
	bcc colm3
	inc colm2+2
colm3
	lda $EC
	cmp #$C0
	bne colm1

; mirror part
colm6
	ldx #$1F
	ldy #0
colm4 lda $A000,x
colm5 sta $A020,y
	iny
	dex
	bne colm4
	inc colm4+2
	inc colm5+2
	lda colm4+2
	cmp #$C0
	bne colm6

; copy 4 parts
	ldy #32
colm7 ldx #0
colma lda $A000,x
colmb sta $A040,x
colmc sta $A080,x
colmd sta $A0C0,x
	inx
	cpx #$40
	bne colma
	inc colma+2
	inc colmb+2
	inc colmc+2
	inc colmd+2
	dey
	bne colm7

; genfont
	ldy #0
	sta $F0
gf1
	lda $F0
	sta $2800,y
	iny
	tya
	and #15
	bne gf1
	lda $F0
	clc
	adc #$11
	sta $F0
	bcc gf1

	jsr set9
	lda #$28
	jsr setfont
; draw map
lmi
	jsr wait_frame
	lda p_song
	cmp #$AC+4
	bne lmv3
	rts
lmv3 lda #$20
	sta lmv4+1
	eor #4
	sta lmv3+1
	sta gr0a+1

;	mwa #$2000 $EB
	lda #0
	sta $EB
lmv4 lda #$20
	sta $EC

; X
lmv1 lda #0
	clc
	adc #1
	sta lmv1+1
	tax
	lda lmx,x
	sta drm1+1

; Y
lmv2 lda #0
	clc
	adc #3
	sta lmv2+1
	tax
	lda lmy,x
	sta $F0

	lda #24
	sta $EF
drm1
	ldx #$BF
	ldy #$0 ;     FIX, 10x for JAC!
	lda $F0
	bpl drm3
	eor #$FF
	clc
	adc #1
drm3
	cmp #32
	bcc drm4
	eor #$FF
drm4
	and #31
	ora #$A0
	sta drm2+2
drm2
	lda $A000,x
	sta ($EB),y
	inx
	iny
	cpy #40
	bne drm2
	tya
	jsr ebecplusa
	inc $F0
	;inc drm2+2
	dec $EF
	bne drm1

	jsr outlogo
	jmp lmi
outlogo
	lda p_song
	cmp #$A8
	beq drawl
	rts
drawl
	lda #$40
	sta $EB
	lda lmv3+1
	eor #4
	sta $EC
	inc $EC
	ldx #5
oly
	lda #5
	sta $EE
	ldy #0
olx
	lda logo16,x
	inx
	sta $ED
olxx
	asl $ED
	bcc no_ol
	lda #$1A
	sta ($EB),y
no_ol
	iny
	tya
	and #7
	bne olxx
	dec $EE
	bne olx
	lda #40
	jsr ebecplusa
	cpx #41-5
	bcc oly
	rts

logo16 ins "logo16.bin"
lmx ins "lx.bin"
lmy ins "ly.bin"
plmap
	dta a(lmpl)
	ins "light.bin.pck",2

dlgr0
	dta 112,112,112
	dta $42
gr0a dta a($2400)
:23	dta $2
	dta $41
	dta a(dlgr0)
;-----------------------------------------------------------------------------------
hexpl equ $2800

hexg
	jsr clear_ab

	lda #$24
	jsr setfont

	mwa #hexpl $EB ;$1000 >$EB,EC

;build data
	ldx #0
by
	ldy #0
	sty $EF
bx
	txa
	and #3
	sta $EE
	
	lda $EF
	clc
	adc $EE
	sta ($EB),y
	lda $EF
	clc
	adc #4
	cmp #24
	bne bra1
	lda #0
bra1
	sta $EF
	iny
	cpy #40
	bne bx
	tya
	jsr ebecplusa
	inx
	cpx #24
	bne by

	lda #hexpl&255
	sta gr0a

	lda #hexpl/256
	sta gr0a+1

	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl

;roll sprite
	mwa #$A000 $EB ;$1000 >$EB,EC
ro1
	ldy #0
ro2
	lda hexdata,y
	sta ($EB),y
	iny
	cpy #$C0
	bne ro2
;scroll
	ldy #0
	ldx #0
ro3
	clc
	ror hexdata,x
	inx
	ror hexdata,x
	inx
	ror hexdata,x
	inx
	ror hexdata,x
	inx
	ror hexdata,x
	inx
	ror hexdata,x
	inx

	bcc norl7
	lda hexdata,y
	ora #$80
	sta hexdata,y
norl7
	iny
	iny
	iny
	iny
	iny
	iny
	cpx #$C0
	bne ro3
	inc $EC
	lda $EC
	cmp #$C0
	bne ro1

;copy data
lp
	lda p_song
	cmp #$C0
	bne zerohg
	jmp clear20 ; rts
zerohg
;zero space
	lda #0
	tay
cd6	sta $2000,y
	iny
	bne cd6
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
hv1
	ldy #0
	tya
	clc
hv_11	adc #7
	tay
	sty hv1+1
	lda hexsin,y
	lsr @
	lsr @
	lsr @
	clc
	adc #$A0
	sta cd3+2
	tya
	clc
	adc #$40
	tay
	lda hexsin,y
	lsr @
	lsr @
	lsr @
	sta cd2+1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;1
	jsr hexor
;2
hgpo	jsr checkg
	jsr hexor
; switch fonts
hv2	lda #$20
	jsr setfont
	eor #04
	sta cd4+2
	sta cd41+2
	sta cd6+2
	sta hv2+1

	jmp lp

hexor

	ldy #0
	sty cd4+1
	sty cd41+1
cd1
	tya
	pha
cd2 ldx #31
	lda #32
	sta $EE
cd3 lda $A000,y
cd4	ora $2000,x
cd41 sta $2000,x
	iny
	iny
	iny
	iny
	iny
	iny
	inx
	cpx #32
	bcc nolpx
cd5	ldx #0
nolpx
	dec $EE
	bne cd3
	pla
	tay
	iny
	lda cd4+1
	clc
	adc #32
	sta cd4+1
	sta cd41+1
	cpy #7
	bne cd1
	rts

checkg
	lda p_song
	cmp #$B4
	bcs hpd
	rts
hpd
	lda #hv_2&255
	sta hgpo+1
	lda #hv_2/256
	sta hgpo+2

	lda hv1+1
	sta hv_2+1
	clc
	adc #16
	sta hv1+1
	lda #4
	sta hv_11+1
	rts

hv_2
	ldy #0
	tya
	clc
	adc #5
	tay
	sty hv_2+1
	lda hexsin,y
	lsr @
	lsr @
	lsr @
	clc
	adc #$A0
	sta cd3+2
	tya
	clc
	adc #$40
	tay
	lda hexsin,y
	lsr @
	lsr @
	lsr @
	sta cd2+1
	rts
;dlgr0
;	dta 112,112,112
;;:16 dta l(dither+8*#),h(dither+8*#) ; #-repeater
;	dta $42
;	dta a(hexpl)
;:23	dta $2
;	dta $41
;	dta a(dlgr0)

hexsin ins "hexsin.bin"
hexdata ins "hg3.bin"

;-----------------------------------------------------------------------------------
plasm
	jsr clear_ab


	ldx #<webdl
	ldy #>webdl
	jsr setdl
; colors
	lda #$0F
	sta 708
	lda #$1F
	sta 709
	lda #$36
	sta 710

;gen font
web_f	equ $1000
	ldx >plasfont ; mb_tab+$02      ; skip 2 first bytes
	ldy <plasfont ; mb_tab+$02
	jsr __decruncher

	lda #>web_f
	jsr setfont
;	sta 756

web_a	equ $A000

	lda $0
	sta $ED
	sta $EE
	sta $F0
	sta $F1

; colors
	lda #$0F
	sta 708
	lda #$1F
	sta 709
	lda #$36
	sta 710

weblp
	jsr wait_frame
	lda p_song
	cmp #$CC
	bne webv5
	rts
webv5
	lda #[4+web_a/256]
	sta $EC
	EOR #4
	sta webdla+1
	sta webv5+1
	lda #0
	sta $EB
; ($EB,$EC)->screen
; $ED,$EE - cx
; $F0,F1 - dx
; ********************************************
	lda #24
	sta $F2
	
	lda $EE
	pha
	lda $ED
	pha
web_y
	ldy #$00
	ldx $ED
	lda plsin,x
	ldx $EE
	adc plsin,x
	sta pla1+1

	lda $F0
	pha
	lda $F1
	pha

web_x
pla1 lda #0
	ldx $F0
	adc plsin,x
	ldx $F1
	adc plsin,x
	
	and #$7F
	sta ($EB),y
	
	lda $F0
	clc
	adc #$FF
	sta $F0
	lda $F1
	adc #3
	sta $F1
	iny
	cpy #40
	bne web_x

	pla
	sta $F1
	pla
	sta $F0

	tya ; lda #40
	jsr ebecplusa
	
	lda $ED
	clc
	adc #1
	sta $ED

	lda $EE
	clc
	adc #2
	sta $EE

	dec $F2
	bne web_y

; dx+$FD04
	lda $F0
	clc
	adc #$04
	sta $F0
	lda $F1
	adc #$FD
	sta $F1
; cx=cx1+$FE01
	pla
	clc
	adc #$03
	sta $ED
	pla
	adc #$FE
	sta $EE
; ********************************************
	jmp weblp

plsin
	ins "plasmsin.bin"

;webdl
;	dta 112,112,112
;	dta $44
;webdla
;	dta a(web_a)
;:23	dta 4
;	dta $41
;	dta a(webdl)

plasfont
	dta a(web_f)
	ins "plasmfnt.pck",2
;-----------------------------------------------------------------------------------
dotty
	jsr clear_ab
	ldx #<sd_dl
	ldy #>sd_dl
	jsr setdl

; plot LUT
plut	equ $2000
stab	equ plut+1024
	mwa #$A002 $EB ;$A000 >$EB,EC
	ldx #0
	lda #$80
	sta $ED
	ldy #0
sdl2
	lda $EB
	sta plut,y
	lda $EC
	sta plut+256,y
	txa
	sta plut+512,y
	lda $ED
	sta plut+768,y
	lsr @
	bcc noxp
	inx
	lda #$80
noxp
	sta $ED

	lda #10
	jsr ebecplusa
	iny
	bne sdl2

; copy table
sdcp
	lda sd_tab,y
	sta stab,y
	iny
	bne sdcp


	lda #$0F
	sta 708

	jsr tunep

do_sd
	jsr wait_frame
	lda p_song
	cmp #$E8
	bne sdp1
	rts
sdp1 lda #$A0
	eor #2
	sta sdp1+1
	sta sdp+1 ; display list

	lda #0
	tay
zero
sdp2	sta $A000,y
sdp3	sta $A100,y
	iny
	bne zero

	lda sdp2+2
	eor #2
	sta sdp2+2

	lda sdp3+2
	eor #2
	sta sdp3+2

cnt	lda #0
	sta $EF

a0	lda #0 ; a0.a=0
	sta $F0 ; va+1 ; a.a=a0
b0	lda #$40 ; b0.a=64
	sta $F1 ; vb+1 ; b.a=b0
c0	lda #0 ; c0.a=0
	sta $F2 ; vc+1 ; c.a=c0
d0	lda #$40 ; d0.a=64
	sta $F3 ; vd+1 ; d.a=d0

dotp
;      x=s(a)+s(b)
	ldx $F0
va lda stab,x
	ldx $F1
	clc
vb adc stab,x ; +64
	tax

;      y=s(c)+s(d)
	ldy $F2
vc lda stab,y
	ldy $F3
	clc
vd adc stab,y ; +64
	tay

;	jsr sdplot
	lda plut,y
	sta $EB
	lda plut+256,y
sdp4 ora #0
	sta $EC
	lda plut+512,x
	tay
	lda plut+768,x
	ora ($EB),y
	sta ($EB),y

	lda $F0 ; va+1
	clc
da adc #$0c
	sta $F0 ; va+1

	lda $F1 ; vb+1
	clc
db adc #$f5
	sta $F1 ; vb+1

	lda $F2 ; vc+1
	clc
dc adc #$f5
	sta $F2 ; vc+1

	lda $F3 ; vd+1
	clc
dd adc #$0c
	sta $F3 ; vd+1

	lda $EF
	beq ex_plot
	dec $EF
	bne dotp
ex_plot
	lda a0+1
	clc
da0 adc #1
	sta a0+1

	lda b0+1
	clc
db0 adc #1
	sta b0+1

	lda c0+1
	clc
dc0 adc #1
	sta c0+1

	lda d0+1
	clc
dd0 adc #1
	sta d0+1

	lda cnt+1
opc cmp #0
	adc #0
	sta cnt+1
	bne nopar
	jsr tunep
nopar
; eor for plot
	lda sdp4+1
	eor #2
	sta sdp4+1

	jmp do_sd

tunep
	lda #0
	sta a0+1
	sta c0+1
	lda #$40
	sta b0+1
	sta d0+1
tp lda #$1F
	clc
	adc #1
	and #$1F
	sta tp+1
	asl @
	asl @
	asl @
	tax
;      da=p(t)
	lda pars,x
	inx
	sta da+1
;      db=p(t)
	lda pars,x
	inx
	sta db+1
;      dc=p(t)
	lda pars,x
	inx
	sta dc+1
;      dd=p(t)
	lda pars,x
	inx
	sta dd+1
;
;      da0=p(t)
	lda pars,x
	inx
	sta da0+1
;      db0=p(t)
	lda pars,x
	inx
	sta db0+1
;      dc0=p(t)
	lda pars,x
	inx
	sta dc0+1
;      dd0=p(t)
	lda pars,x
	inx
	sta dd0+1

	rts
sd_tab ins "8000.bin"
pars ins "8100.bin"
sd_dl
	dta 112,112,112
	dta $49
sdp	dta a($A000)
:47	dta $9
	dta $41
	dta a(sd_dl)
;-----------------------------------------------------------------------------------
;mydli
; dta 112
; dta 112
; dta 112+128
;; dta 112
; dta $01
;realadr
; dta a($2000)

nibble
	lda #0
	jsr rol
	jsr rol
	jsr rol
	jsr rol
	rts
rol
	asl $EF
	php
	rol @
	plp
	rol @
	rts

twister

	jsr clear20

	lda #$E0
	jsr setfont
	lda #0
	sta 710
	sta $d018
	lda #$0F
	sta 709
	sta $d017

	lda #$0
	sta gr0a
	lda #$2C
	sta gr0a+1

	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl

;	jmp *
	jsr clear_ab

;unroll twist 4x64
	mwa #$A000 $EB
	ldx #0
twunry
	ldy #28 ; +10 ; +8  +16+4
twunrx
	lda tws,x
;	sta ($EB),y
	sta $EF
	jsr nibble
	sta ($EB),y
	iny
	jsr nibble
	sta ($EB),y

	inx
	iny
	cpy #28+4+4
	bne twunrx
	lda $EB
	clc
	adc #$80
	sta $EB
	bne notwbra1
	inc $EC
notwbra1
	lda $EC
	cmp #$C0
	bne twunry

;build lookup
	lda #$0C
	sta $EB
twlut equ $2800
	ldy #0

builp

	tya
	and #3
	eor #3
	sta twlut,y

	tya
;	lsr @
	lsr @
	lsr @
	sta twlut+256,y ; X/4

	tya
	and #63
	lsr @
	clc
	adc #$A0
	sta twlut+512,y ; msb

	tya
	and #1
	beq lutput
	lda #$80
lutput
	sta twlut+768,y ; lsb

	iny
	bne builp


;---------------setup DLI-------
NMIEN  equ $D40E    ; NMI Enable
VDSLST equ $0200    ; DLI Vector

; -------------
; Enable DLIs
; -------------
 LDA #<DLIRTN
 STA VDSLST
 LDA #>DLIRTN
 STA VDSLST+1



; start twister
twlp
	lda p_song
	bne noex
	rts
noex

;	jsr wait_frame
	lda #0
	sta twpb+1
;	sta $D01A
ru	lda #$20
	sta twpb+2

twv4	lda #20
	sta $EB
	clc
	adc #2
	sta twv4+1

twv5	lda #0
	sta $EC
	clc
	adc #$F8
	sta twv5+1

twv6	lda #0
	sta $ED
	clc
	adc #15
	sta twv6+1


	ldx #0

 lda #$C0 ; !$C0
 STA NMIEN



twlp1
	lda #$40+$10+$0F
	jsr twpb
	ldy $EB
	lda twsin,y
	ldy $EC
	clc
	adc twsin,y

	lsr @

	tay
	lda twlut,y ; x&3

ku	sta twlut+1024+2,x ; hscrol

	txa
	pha
	
	ldx $EC
	lda twsin,x
	ldx $ED
	clc
	adc twsin,x
	tax

	lda twlut+768,x ; lsb

	clc
	adc twlut+256,y ;X/4

	jsr twpb
	lda twlut+512,x ; msb line
	jsr twpb

	pla
	tax


	dec $EB
	inc $EC
;	inc $EC

;	dec $ED
	dec $ED
	dec $ED

	inx
	cpx #$C0-8
	bne twlp1

;	stx $D01A

	lda #$42
	jsr twpb

	lda #nadpis&255
	jsr twpb

	lda #nadpis/256
	jsr twpb



	lda #$41
	jsr twpb

	lda #mydli&255
	jsr twpb

ru3	lda #mydli/256
	jsr twpb

	jsr wait_frame

	lda #mydli&255
	sta $230
	sta $D402
	lda #mydli/256
	sta $231
	sta $D403

	jmp twlp

;twpb2 lda #112
twpb sta $2000
	inc twpb+1
	bne endtwpb
	inc twpb+2
endtwpb
	rts


;------------DLI vector ---------------------
DLIRTN
	php
 pha
 txa
 pha
	ldx #0
mu
	lda twlut+1024,x
	sta $d404
	sta $d40a
	inx
	cpx #$C0-8
	bne mu
;	stx $D018
 pla
 tax
 pla
 plp
 rti

mydli
 dta 112
 dta 112
 dta 112+128
 dta $01
realadr
 dta a($2000)

nadpis dta d" remember: $5f,lo,hi-this is Ataaaari :) "
tws ins "twspr.bin"
twsin ins "twsinYY.bin"
;-----------------------------------------------------------------------------------
greet
	lda #0
	sta gr0a
	lda #$24
	sta gr0a+1
	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl

	jsr clear20

	ldy #0
;copy font
copyf
	lda trifnt,y
	sta $1000,y ; $8020
	iny
	bne copyf


; generate tables
tab1	equ	$1400
	ldx #0
gt1
	txa
	clc
	adc #1
	sta tab1,X
	txa
	and #$1F
	cmp #$0f
	bcc nocha
	eor #$1F
nocha
	sta tab1+256,x
	inx
	bne gt1

;depack table
; from
	ldx >ptrimap ; mb_tab+$02      ; skip 2 first bytes
	ldy <ptrimap ; mb_tab+$02
	jsr __decruncher

;copy map
	ldx #24
	lda #00 ; from
	sta $EB
	lda #$20
	sta $EC
	
	lda #$A0
	sta $EE



coy
	ldy #$0
	sty $ED
cox
	lda ($EB),y
	sta ($ED),y
	iny
	cpy #40
	bne cox
	inc $EE
	tya
	jsr ebecplusa
	dex
	bne coy

	lda #$10
	jsr setfont ; sta 756

	lda #$0F
	sta 709
	sta $d017

;	lda #0
	jsr tunedir

	lda #$0F
	jsr showt
	
	lda #8
t2
	pha

	jsr prg
	lda #$28
	sta gr0a+1
	
	ldx #32
wt3 jsr wait_frame
	dex
	bne wt3

	jsr tunedir
	lda #$1F
	jsr showt

	pla
	sec
	sbc #1
	bne t2
	rts ; jmp *

showt
t1
	pha
	jsr wait_frame
	jsr switch
	jsr rotri
	pla
	sec
	sbc #1
	bne t1
	rts
;	inc $EE E6
;	dec $EE C6
directn
	dta $A0,0,$E6,$E6
; $A0-down,0 to right
	dta $A0,39,$c6,$E6
	dta $b7,0,$E6,$C6
	
	dta $b7,39,$C6,$C6

tunedir ;A=number
	lda #$FF
	clc
	adc #1
	and #3
	sta tunedir+1
	asl @
	asl @
	tax
	lda directn,x
	inx
	sta rov1+1

	lda directn,x
	inx
	sta rov2+1

	lda directn,x
	inx
	sta rov3

	lda directn,x
	inx
	sta rov4

	rts

switch	lda #$24
	sta gr0a+1
	eor #4
	sta rop1+1
	sta switch+1
	rts

rotri

; counter
	lda #24
	sta $EF

; to screen
	lda #0 ; 88
	sta $EB
rop1	lda #$20 ; 89
	sta $EC

;to table
rov1	lda #$A0
	sta $EE

roty
	ldy #0
rov2 lda #0
	sta $ED
rotx
	ldx #0
	lda ($ED,x)
	tax
	lda tab1+256,x
	sta ($EB),y
	lda tab1,x
	ldx #0
	sta ($ED,x)
rov3	inc $ED
	iny
	cpy #40
	bne rotx
rov4	inc $EE
	tya
	jsr ebecplusa
	dec $EF
	bne roty
	rts ; jmp rotri
; -=+=+=-
prg
	lda #$40 ; 88
;	clc
;	adc #$40
	sta $EB
	
;	lda 89
;	adc $1
	lda #$29
	sta $EC

	lda #8
	sta $F0
pgy
	ldy #0
	ldx #0
pgx
	lda gtext,x
	sta $F2
pgl1
	lda #0
	asl $F2
	ror @
;	bcc pgput
;	lda #8
;pgput
	sta ($EB),y
	iny
	tya
	and #7
	bne pgl1
	inx
	cpx #5
	bne pgx
	
	
	lda #40
	jsr ebecplusa

	lda pgx+1
	clc
	adc #5
	sta pgx+1
	bcc no256

	inc pgx+2

no256

	dec $F0
	bne pgy
	rts
gtext
	ins "gr8.bin"

trifnt
	dta 0,0,0,0,0,0,0,0
	ins "tri.fnt"
ptrimap
	dta a($2000)
	ins "tri.dat.pck",2

;-----------------------------------------------------------------------------------
picshow
	jsr clear_ab
	lda #0
	sta gr0a
	lda #$A0
	sta gr0a+1
	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl
	jsr clear20

	lda #$20
	sta gr0a+1

;	jmp *
; copy font
	ldy #0
cf lda bpfnt,y
	sta $B000,y
	iny
	bne cf
	
	lda #$B0
	jsr setfont

 	lda #0
 	sta 710
 	lda #$0F
 	sta 709

;	lda #$21
;	sta 559
;	sta $D400

;precalc
adra equ $1000
	ldy #0
	sty $EB
	lda #$20
	sta $EC
prelut
	lda $EC
	sta adra+256,y
	lda $EB
	sta adra,y
	lda #40
	jsr ebecplusa
	iny
	bne prelut

slideshow
	lda #$ff
	sta $F0

	lda #24+8
	sta $F2

spic
	jsr wait_frame
	lda $F0
	sta $F1

	ldy #0

lpic2
	ldx $F1
	lda adra,x
	sta $EB
	lda adra+256,x
	sta $EC

lpic
	lda $F1
	bmi nxty ; nospic

;	lda ($EB),y
;	ora #$80
	lda #$80
	sta ($EB),y
nxty
	iny
	tya
	and #3
	bne lpic

	dec $F1
	cpy #40
	bne lpic2
;-----------------------------------------------
; 2
	lda $F2
	sta $F3
	ldy #0
lpic3
	ldx $F3
	lda adra,x
	sta $EB
	lda adra+256,x
	sta $EC

lpic4
	lda $F3
	cmp #24
	bcs nxty2

;	lda ($EB),y
;	ora #$80
	lda #$80
	sta ($EB),y
nxty2
	iny
	tya
	and #3
	bne lpic4

	dec $F3
	cpy #40
	bne lpic3

 ; nxt frame
	dec $F2
	inc $F0
	lda $F0
	cmp #14+2
	bne spic
	
	lda #8+6
	sta $F0
	sta $F1

; decrunch pic @$2400
picn ldx #0
	lda picad,x
	tay
	inx
	lda picad,x
	tax
;	ldx >pic1
;	ldy <pic1
	jsr __decruncher

; fill $80
	lda #$80
	ldy #0
f80
	sta $2400,y
	sta $2500,y
	sta $2600,y
	sta $2700,y
	iny
	bne f80
; copy to $2400
	lda #4
	sta $EB
	lda #0
	sta $ED
	lda #$24
	sta $EC
	lda #$A0
	sta $EE

	ldx #24
pcpy
	ldy #0
pcpx
	lda ($ED),y
	ora #$80
	sta ($EB),y
	iny
	cpy #32
	bne pcpx
	lda #40
	jsr ebecplusa
	lda $ED
	clc
	adc #32
	sta $ED
	bcc noinced
	inc $EE
noinced
	dex
	bne pcpy

shto
	jsr wait_frame
	ldx $F0
	jsr picrow
	ldx $F1
	jsr picrow
	dec $F0
	inc $F1
	lda $F0
	cmp #$FB
	bne shto
; wait
	ldy #50
wdl jsr wait_frame
	dey
	bne wdl

	lda picn+1
	clc
	adc #2
	sta picn+1
	cmp #10+2
	bne contss
	jmp *
contss
	jmp slideshow
	jmp *
picrow
	ldy #0
pr0 lda adra,x
	sta $EB
	sta $ED
	lda adra+256,x
	sta $EC
	clc
	adc #4
	sta $EE
pr1
	txa
	bmi nxtpr
	cmp #24
	bcs nxtpr
	lda ($ED),y
	sta ($EB),y
nxtpr
	iny
	tya
	and #3
	bne pr1
	dex
	cpy #40
	bne pr0
	rts

picad dta a(pic1),a(pic2),a(pic3),a(pic4),a(pic5),a(pic6)
bpfnt ins "tiles.data"
pic1 
	dta a($A000)
	ins "lisa.bpaint.pck",2
pic2
	dta a($A000)
	ins "dalton.bpaint.pck",2
pic3
	dta a($A000)
	ins "bart.bpaint.pck",2
pic4 
	dta a($A000)
	ins "sonic.bpaint.pck",2
pic5 
	dta a($A000)
	ins "timon.bpaint.pck",2

pic6
	dta a($A000)
	ins "title.bpaint.pck",2
;-----------------------------------------------------------------------------------
rings
	jsr clear20

	lda #0
	sta gr0a
	lda #$24
	sta gr0a+1
	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl

	lda #224
	jsr setfont

hl equ $F0
de equ $F2
	ldy #1
	ldx #0
	sty de
	dey
	sty de+1

	sty hl
	sty hl+1

sqtab	equ $1000
sq_lp
	lda hl+1
	sta sqtab+256,y
	sta sqtab+256,x

	lda hl
	sta sqtab,y
	sta sqtab,x

	clc
	adc de
	sta hl
	lda hl+1
	adc de+1
	sta hl+1
	
	lda de
	clc
	adc #2
	sta de
	bcc no_inc_de
	inc de+1
no_inc_de
	dex
	iny
	cpy #129
	bne sq_lp

;build shifts $1200,$1300
	ldy #0
	ldx #0
bslp
	tya
	lsr @
	lsr @
	lsr @
	lsr @
	lsr @
	lsr @
	lsr @
	sta $1200,y
	tya
	and #1
	beq bspu
	lda #128
bspu
	sta $1300,y
	lda char,x
	sta $1400,y
	inx
	cpx #10
	bne nocl10
	ldx #0
nocl10
	iny
	bne bslp

ringu
	jsr wait_frame
	lda $D1
	cmp #$24
	bne ri
	rts
ri lda #$24
	sta gr0a+1
	eor #4
	sta ri+1
	sta $EC ; 89

	lda #0 ; 88
	sta $EB
;	lda 89
;	sta $EC

	lda #24
	sta $ED
ry
	ldy #0
rx
; r.u=((x-x1)*(x-x1)+(y-y1)*(y-y1))!((x-x2)*(x-x2)+(y-y2)*(y-y2))
; (r>>7)%9

;(x-x1)*(x-x1)+(y-y1)*(y-y1)
	tya
	sec
	sbc X0 ; X1
	tax
	
	lda sqtab,X
	sta $F0

	lda sqtab+256,X
	sta $F1

	lda $ED
	sec
	sbc X0+3 ; Y1
	tax

	lda sqtab,X
	clc
	adc $F0
	sta $F0
	lda sqtab+256,X
	adc $F1
	sta $F1

;(x-x2)*(x-x2)+(y-y2)*(y-y2)
	tya
	sec
	sbc X0+6 ; X2
	tax
	
	lda sqtab,X
	sta $F2
	lda sqtab+256,X
	sta $F3

	lda $ED
	sec
	sbc X0+9 ; Y2
	tax

	lda sqtab,X
	clc
	adc $F2
	sta $F2
	lda sqtab+256,X
	adc $F3
	sta $F3

	eor $F1
	sta $F1
	lda $F0
	eor $F2
	sta $F0

	ldx $F0
	lda $1200,x
	ldx $F1
	ora $1300,x
	tax
	lda $1400,x

	sta ($EB),Y
	iny
	cpy #40
	bne rx
	tya
	clc
	adc $EB
	sta $EB
	bcc noicc
	inc $EC
noicc
	dec $ED
	beq ex
	jmp ry
ex
	ldx #0
	jsr movexy
	jsr movexy
	jsr movexy
	ldx #3
	jsr movexy
	jsr movexy
	jsr movexy

	ldx #6
	jsr movexy
	ldx #9
	jsr movexy

	jmp ringu
movexy
	lda X0,x
	clc
	adc X0+1,x
	sta X0,x
	beq chs
	cmp X0+2,x
	beq chs
	rts
chs
	lda X0+1,x
	eor #$FF
	clc
	adc #1
	sta X0+1,x
	rts
X0
	dta 10,1,40 ; X,dX, Xe +0
	dta 05,1,24 ; Y +3
	dta 25,1,40 ; X1 +6
	dta 22,1,24 ; Y1 +9
char  dta d".:!*oe&#%@"
;-----------------------------------------------------------------------------------
wavy
	ldx #<dlgr0
	ldy #>dlgr0
	jsr setdl

	jsr clear_ab

; build sprite
	ldy #0
	sty $F0
	sty $F1
	lda #$80
	sta $F2
	sty $F3
wbs
	ldx #0
wb1
	lda $F0,x
	sta $1000,y
	iny
	inx
	cpx #4
	bne wb1
	
	sec
	rol $F1
	rol $F0

	sec
	ror $F2
	ror $F3

	cpy #64
	bne wbs
;copy to memory
wb2
	ldx #0
	stx wbp1+1
	ldy #0
wbp1	lda $1000,x
wbp2	sta $8000,y
	inx
	iny
	txa
	and #3
	tax
	tya
	and #$7F
	tay
	bne wbp1

	inc wbp2+2
	lda wbp1+1
	clc
	adc #4
	sta wbp1+1
	cmp #$40
	bne wbp1
; roll sprite
	ldy #0
	sty $F0
	lda #$10
	sta $F1
rols
;0
	lda ($F0),y
	lsr @
	sta ($F0),y
	iny
;1
	lda ($F0),y
	ror @
	sta ($F0),y
	iny
;2
	lda ($F0),y
	ror @
	sta ($F0),y
	iny
;3
	lda ($F0),y
	ror @
	sta ($F0),y

	ldy #0
	bcc noro128
	lda ($F0),y
	ora #$80
	sta ($F0),y
noro128
	lda $F0
	clc
	adc #4
	sta $F0
	cmp #64
	bne rols

	lda wbp2+2
	sec
	sbc #$10
	sta wbp2+2

	lda wbp2+1
	eor #$80
	sta wbp2+1
	bne no2plu
	lda wbp2+2
	clc
	adc #$10
	sta wbp2+2
no2plu
	lda wbp2+2
	cmp #$C0
	bne wb2
;build lookups
wavyh equ $1000
	ldy #0
blu1
	tya
	and #$1F
	cmp #$10
	bcc noinverse
	eor #$FF
noinverse
	and #$1F
	sta wavyh,y
; disp X
	ldx #0
	tya
;	and #15
;	cmp #8
;	bcc blu22
;	eor #$FF
;blu22
	and #7
	lsr @
	bcc blu2
	ldx #$80
blu2
	asl @
	asl @
	asl @
	asl @
	clc
	adc #$80
	sta wavyh+256,y
	txa
	sta wavyh+512,y
	iny
	bne blu1

	sty $ED
; show
wavydo
	inc vy5+1
vy5 lda #0
	sta $F2

vy4 lda #0
	sta $F0
	clc
	adc #4
	sta vy4+1

vy6 lda #0
	clc
	adc #3
	sta $F1
	sta vy6+1

	lda #0
	sta twpb+1
vy1	lda #$20
	sta twpb+2

	lda #112
	jsr twpb
	lda #112
	jsr twpb
	lda #112
	jsr twpb
	lda #$C0
	sta $EB
xlp
	lda #$4F
	jsr twpb

	ldx $F2
	lda wsint2,x
	ldx $F0
	clc
	adc wsint1,x

	tay
	lsr @
	lsr @
	lsr @
	eor #1
	ora wavyh+512,y ;lsb
	jsr twpb

	ldx $F0
	lda wsint1,x
	ldx $F1
	adc wsint1,x
	tax
;	ldx $F0
	lda wavyh,x
;vy5	ora #$80
	ora wavyh+256,y ; msb
;	sta vy5+1
	jsr twpb

; 1,$82,2
	lda $F0
	clc
	adc #$1
	sta $F0

	lda $F1
	clc
vyy	adc #$2 ; 82 is good solution
	sta $F1

	lda $F2
	clc
	adc #$2
	sta $F2

	dec $EB
	bne xlp

	lda #$41
	jsr twpb
	lda #0
	jsr twpb
vy2	lda #$20
	jsr twpb

	jsr wait_frame
	ldx #0
vy3	ldy #$20
	jsr setdl

	lda vy1+1
	eor #4
	sta vy1+1
	sta vy2+1
	sta vy3+1

	inc $ED
	lda $ED
	and #127
	bne cunt
	lda vyy+1
	eor #128
	sta vyy+1
	bmi cunt
	rts
cunt
	jmp wavydo

;twpb sta $2000
;	inc twpb+1
;	bne endtwpb
;	inc twpb+2
;endtwpb
;	rts

wsint1 ins "wavysin1.bin"
wsint2 ins "wavysin2.bin"

;-----------------------------------------------------------------------------------
	run startd
