

; modulo per la visualizzazione di bitmap planari (4 piani)
; a 256 colori

; 1 nudget     = 4  pixel (plane aligned, one pixel for every plane)
; 1 big nudget = 16 pixel (plane aligned, four nudgets)

; PIC format:
;            offset     size       name   description
;              0          1        WX     Width  of picture in BIG NUDGETS
;              1          1        WY     Height of picture in PIXELS
;              2       WX*WY*4     ----   First plane
;          2+WX*WY*4   WX*WY*4     ----   Second plane
;          2+WX*WY*8   WX*WY*4     ----   Third plane
;          2+WX*WY*12  WX*WY*4     ----   Fourth plane

        extrn _GetPic:near

;_GetPic  fills a PIC structure with the bitmap rectangle
;         located in the display page ESI
;         at position (EAX,EDX)
;         with width ECX and height EBX
        ; in:
        ; edi = pic dest
        ; esi = scr source
        ; eax = x in nudgets
        ; edx = y in pixels
        ; ecx = x width in big-nudgets
        ; ebx = y height in pixels
        ; out:
        ; edi = ptr to end of picture

        extrn _PutPic:near

; _PutPic  blits a picture to screen
        ; edi = scr dest
        ; esi = pic ptr
        ; eax =  x in pixels
        ; edx =  y in pixels
        ; bl  =  blit mode flag    1= left-rigth reversed blit

; Un Spt (encoded SPriTe)
; ha una word di intestazione come una PICture
; offset size  significato
;      0    1  ampiezza immagine in nudgets
;      1    1  altezza immagine in pixels
; Ma poi i 4 piani di bytes sono descritti da "pacchetti"
; con colore trasparente codificato in RLE

; formato di un RLE packet:   [..] == .. e' opzionale
; RLE_HEADER, [INCR 1byte ], [DATA_HEAD 0..3 byte ],[DATA_DWORD 0..n dwords]


; RLE_HEADER  bit 0..1 = data_head lenght (0..3 BYTES)
;             bit    2 = dword data present
;             bit    3 = new line after this blit
;             bit 4..7 = dword counter n  (0..15 DWORDS)

        extrn _PutSpt:near
        
;_PutSpt blits a TRLE encoded SPT data struct
        ; edi = scr dest
        ; esi = encoded sprite pic ptr
        ; eax =  x in pixels
        ; edx =  y in pixels
        ; bl  =  drawing flags (1 = reverse left-right)
        
        extrn _Pic2Spt:near
;_Pic2Spt  translates from PIC bitmap format to SPT bitmap format        
        ; 
        ; ESI = pointer to PIC data
        ; EDI = pointer to buffer for SPT data
        ; returns:
        ;  ESI = end of PIC data
        ;  EDI = pointer to end of SPT bitmap data
        ;        If PIC data is too big, EDI is equal to its initial value

