
// lgfxdibm.cpp 
// 
// Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved. 
 
#include "stdgfx.h" 
#include "lgfxdib.h" 
 
LONG  U; 
LONG  V; 
LONG  Du; 
LONG  Dv; 
LONG  SrcAdd; 
 
// VOID WaitForRetraceMany ( LONG Count ) 
// 
// EAX = Count 
 
VOID WaitForRetraceMany ( LONG Count ) 
{ 
__asm { 
  pushad  
   
  mov  EAX, Count 
 
  mov  ECX, EAX 
  mov  EDX, 03DAh 
   
  WFRLoop : 
    WaitManyEnd : 
      in   al, dx 
      test al, 08h 
      jnz   WaitManyEnd  
       
    WaitManyStart : 
      in   al, dx 
      test al, 08h 
      jz   WaitManyStart 
         
    cmp ECX, 0 
    jle EndWaitMany 
    dec ECX 
    jmp WFRLoop   
     
  EndWaitMany : 
         
  popad 
} // End asm 
} // End of WaitForRetrace 
 
 
// VOID WaitForRetraceOnce () 
 
VOID WaitForRetraceOnce () 
{ 
__asm { 
  pushad 
 
  mov  EDX, 03DAh 
   
  WaitOnceEnd : 
    in   al, dx 
    test al, 08h 
    jnz   WaitOnceEnd  
       
  WaitOnceStart : 
    in   al, dx 
    test al, 08h 
    jz   WaitOnceStart 
         
  popad 
} // End asm 
} // End of WaitForRetrace 
 
 
// VOID WaitForRetraceTerminate () 
 
VOID WaitForRetraceTerminate () 
{ 
__asm { 
  pushad 
  mov  EDX, 03DAh 
   
  WaitTerminate : 
    in   al, dx 
    test al, 08h 
    jnz   WaitTerminate  
       
  popad 
} // End asm 
} // End of WaitForRetrace 
 
 
// VOID TransBlt256To256 ( BYTE *Dest, BYTE *Src, LONG Wd, BYTE TransColor ) 
// 
// EAX = Dest, EDX = Src, EBX = Wd, ECX = TransColor 
 
VOID TransBlt256To256 ( BYTE *Dest, BYTE *Src,  
                                            LONG dWd, BYTE TransColor ) 
{ 
__asm { 
   
  pushad 
 
  mov  EAX, Dest 
  mov  EDX, Src 
  mov  EBX, dWd 
  mov  CL, TransColor 
 
  mov  EDI, EAX 
  mov  ESI, EDX 
  mov  AH, CL 
  mov  ECX, EBX 
  cld 
 
  TransLoop : 
    mov AL, [ESI] 
    inc ESI 
    cmp AH, AL 
    je  Skip 
      mov [EDI], AL 
 
    Skip : 
      inc EDI 
      dec ECX 
    jnz TransLoop 
 
  popad 
} // End asm 
} // End of TransBlt256To256 
 
 
// VOID ScaleBlt256To256 ( BYTE *Dest, BYTE *Src, LONG Wd, DWORD Error, DWORD AddError ) 
// 
// EAX = Dest, EDX = Src, EBX = Wd, ECX = Error 
 
VOID ScaleBlt256To256 ( BYTE *Dest, BYTE *Src,  
                                            LONG dWd, LONG Error, DWORD AddError ) 
{ 
__asm { 
  pushad 
 
  mov  EAX, Dest 
  mov  EDX, Src 
  mov  EBX, dWd 
  mov  ECX, Error 
   
  mov  EDI, EAX 
  mov  ESI, EDX 
   
  xchg EBX, ECX  // ECX is the loop count, EBX is the Error   
  mov  EDX, AddError 
  mov  EBP, 0 
  cld  
  //InitClockCycle 
 
  ScaleLoop : 
    mov AL, [ESI+EBP]  
    add EBX, EDX 
    mov EBP, EBX 
    mov [EDI], AL 
    shr EBP, 16 
    inc EDI 
    dec ECX 
    jnz ScaleLoop 
     
  //GetElapsedClock 
 
  popad 
} // End asm 
} // End of _ScaleBlt256To256 
 
 
// VOID SetSrcAdd ( LONG Add1, LONG Add2 ) 
// 
// EAX = U, EDX = V, EBX = Du, ECX = Dv 
 
// VOID SetAffineUV ( LONG U, LONG V, LONG Du, LONG Dv ) 
// 
// EAX = U, EDX = V, EBX = Du, ECX = Dv 
 
VOID SetAffineUV ( LONG U, LONG V, LONG Du, LONG Dv ) 
{ 
  if (U&V&Du&Dv) 
  {} 
} // End of SetAffineUV 
   
 
// VOID Affine256To256 ( BYTE *Dest, BYTE *Src, LONG Wd ) 
//   
// EAX = Dest, EDX = Src, EBX = Wd 
 
VOID Affine256To256 ( BYTE *Dest, BYTE *Src, LONG dWd ) 
{ 
__asm { 
  pushad 
   
  mov  EDI, EAX 
  mov  ESI, EDX 
   
  LoopAffine256 : 
   
    loop LoopAffine256 
   
  popad 
} // End asm 
} // End of Affin256To256 
 
 
 
