
// lgfxvgam.cpp
//
// Copyright (c) 1995 by Toshiaki Tsuji, all rights reserved.

#include "stdgfx.h"
#include "lgfxvga.h"

LONG  vgaSrcWd;
LONG  vgaSrcHt;

// VOID SetVGASelector ( SHORT Selector )
// EAX = Selector

VOID SetVGASelector ( SHORT Selector )
{
  if (Selector)
    {}
} // End of SetVGASelector

// VOID VGACopy256To256 ( BYTE *Src, LONG AddSrc, LONG vgaSrcWd, LONg vgaSrcHt,
//                        LONG DestCx, LONG DestCy )
//
// EAX = Src, EDX = AddSrc, EBX = vgaSrcWd, ECX = vgaSrcHt

VOID VGACopy256To256 ( BYTE *Src, LONG AddSrc, LONG SrcWidth, LONG SrcHeight,
                       LONG DestCx, LONG DestCy )
{
__asm {
  pushad

  mov  EAX, Src
  mov  EDX, AddSrc
  mov  EBX, SrcWidth
  mov  ECX, SrcHeight 

  mov  ESI, EAX   // ESI = Src
  mov  vgaSrcWd, EBX
  mov  vgaSrcHt, ECX

  sub  EDX, EBX
  mov  EBX, EDX   // EBX = AddSrc - vgaSrcWd

  mov  EDI, 0A0000h
  mov  EAX, DestCy
  mov  EDX, 320

  mul  EDX  

  add  EAX, DestCx
  add  EDI, EAX

  mov  EDX, 320
  sub  EDX, vgaSrcWd
  cld

  Copy256OutLoop :
    mov ECX, vgaSrcWd
    mov EAX, ECX
    and EAX, 03h
    shr ECX, 2
    rep movsd
    mov ECX, EAX
    rep movsb
    add ESI, EBX
    add EDI, EDX
    dec vgaSrcHt
    jnz Copy256OutLoop

  popad
} // End asm
} // End of VGACopy256To256



