#ifndef __MUSICFX

#define __MUSICFX

#include "bass.h"

#define SM_MUSIC_DATASAMPLES 1024

class MusicFX : public SM_DemoEffect
{
public:              
  enum eFlags
  {
    E_MP3     =1,
    E_TRACK   =2,
    E_PLAYING =16,
  };
  
                    MusicFX       (char const* pcName);
  virtual           ~MusicFX      ();
  int               Init          (const char* pcCommand);
                                  
                                  
  int               Shutdown      ();
                                  
  int               Start         (float fTime);
  int               Stop          ();
                                  
  int               Reset         ();
  int               Run           (float fTime);
  int               LoadData      (const char* pcMP3Name);

  int               ShutdownData  ();  
  int               Command       (float fTime, const char* pcCommand); 

  static void       SetNoMusic    (bool bNoMusic);
  float*            MP3GetChannelData(float fTime);


  virtual int       LoadArgumentsHelp     (Helper*& pHelpers);
  virtual int       CommandArgumentsHelp  (Helper*& pHelpers);

  DWORD             GetStream()
  {
    if (m_hMP3)
    {
      return m_hMP3;
    }
    else
    {
      return 0;
    }
  }

  bool DoPrecache        ()
  {
    return false;
  }


protected:
  static bool       m_bNoMusic;
  int               m_iLength;
  char*             m_pcBuffer; 
  int               m_iFlags;
  HSTREAM           m_hMP3;
  bool              m_bPlaying;
  float             m_fData[SM_MUSIC_DATASAMPLES];
  float             m_fTime;

};


#endif