#include "SM_CommonFXPCH.h"
#include <math.h>
#include "FXVertexShaders.h"


#define NUMOFFSETS 64

float g_fNoiseOffset[NUMOFFSETS];

class  NoiseShader : public VertexShader
{  
public:
  int   Init()
  {
    int i;
    for (i=0 ; i<NUMOFFSETS ; i++)
    {
      g_fNoiseOffset[i]=float(rand())/float(RAND_MAX);
    }

    return 0;
  };

  int   Shutdown()
  {
    return 0;
  }

  void  ProcessVertices(FVF_PosNormalDiffuseTex1* pDst, FVF_PosNormalDiffuseTex1* pSrc, unsigned uVertices)
  {
    unsigned i;

    float fTime=Timer::GetTime();

    for (i=0 ; i<uVertices ; i++)
    {
      float fScale=sinf(fTime+g_fNoiseOffset[i&(NUMOFFSETS-1)]);
      pDst[i].x      = pSrc[i].x+pSrc[i].nx*fScale;
      pDst[i].y      = pSrc[i].y+pSrc[i].ny*fScale;
      pDst[i].z      = pSrc[i].z+pSrc[i].nz*fScale;
      pDst[i].nx     = pSrc[i].nx;
      pDst[i].ny     = pSrc[i].ny;
      pDst[i].nz     = pSrc[i].nz;
      pDst[i].diffuse= pSrc[i].diffuse;
      pDst[i].u      = pSrc[i].u;
      pDst[i].v      = pSrc[i].v;
    }
  }
};



NoiseShader TheNoiseShader;

int   InitVertexShaders    ()
{
  TheNoiseShader.Init();

  return 0;
}

int   ShutdownVertexShaders()
{
  TheNoiseShader.Shutdown();

  return 0;
}
