#ifndef __SM_COMMONVF

#define __SM_COMMONVF

#define FVF_POSNORMAL                (D3DFVF_XYZ|D3DFVF_NORMAL)

#define FVF_POSDIFFUSETEX1           (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_TEX1)
#define FVF_POSNORMALDIFFUSETEX1     (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_DIFFUSE|D3DFVF_TEX1)
#define FVF_POSDIFFUSESPECULARTEX1   (D3DFVF_XYZ|D3DFVF_DIFFUSE|D3DFVF_SPECULAR|D3DFVF_TEX1)
#define FVF_POSRHWDIFFUSETEX1        (D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1)
#define FVF_POSRHWDIFFUSETEX2        (D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX2)
#define FVF_POSNORMALDIFFUSETEX1_3   (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_DIFFUSE|D3DFVF_TEX1| D3DFVF_TEXCOORDSIZE3(0))

 

struct FVF_PosNormal
{
  float     x,y,z;
  float     nx,ny,nz;  
};

struct FVF_PosDiffuseTex1
{
  float     x,y,z;
  unsigned  diffuse;
  float     u,v;
};


struct FVF_PosNormalDiffuseTex1
{
  float     x,y,z;
  float     nx,ny,nz;
  unsigned  diffuse;
  float     u,v;
};

struct FVF_PosDiffuseSpecularTex1
{
  float     x,y,z;
  unsigned  diffuse;
  unsigned  specular;
  float     u,v;
};


struct FVF_PosNormalDiffuseTex1_3
{
  float     x,y,z;
  float     nx,ny,nz;
  unsigned  diffuse;
  float     u,v, w;
};

struct FVF_Bumpmap
{
  float     x,y,z;
  float     nx,ny,nz;
  unsigned  diffuse;
  float     u,v;
  float     s,t;
  float     m11, m12, m13;
  float     m21, m22, m23;
  float     m31, m32, m33;
};



struct FVF_PosRhwDiffuseTex1
{
  float     x,y,z,oow;
  unsigned  diffuse;
  float     u,v;
};

struct FVF_PosRhwDiffuseTex2
{
  float     x,y,z,oow;
  unsigned  diffuse;
  float     u,v;
  float     s,t;
};

#endif