//-----------------------------------------------------------------------------
//                  common vertex structures and fvf's
//-----------------------------------------------------------------------------
#pragma once
#include "sm_vector3d.h"

/*--------------------------------
	c   - colored
	n   - has normal
	tr  - transformed
	tx  - 1 set tex coords
	tx2 - 2 sets of tex coords

--------------------------------*/


#define cvertex_fvf		(D3DFVF_XYZ | D3DFVF_DIFFUSE)
#define ctrvertex_fvf	(D3DFVF_XYZRHW | D3DFVF_DIFFUSE)
#define cnvertex_fvf	(D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE)
#define trvertex_fvf	(D3DFVF_XYZRHW)
#define txvertex_fvf	(D3DFVF_XYZ | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0))
#define trtxvertex_fvf	(D3DFVF_XYZRHW | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0))
#define ctrtxvertex_fvf	(D3DFVF_XYZRHW | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0) | D3DFVF_DIFFUSE)
#define ctxvertex_fvf	(D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0))
#define ctx2vertex_fvf	(D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX2 | D3DFVF_TEXCOORDSIZE2(0) | D3DFVF_TEXCOORDSIZE2(1))
#define nvertex_fvf		(D3DFVF_XYZ | D3DFVF_NORMAL)
#define ntxvertex_fvf	(D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0))
#define cntxvertex_fvf	(D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1 | D3DFVF_TEXCOORDSIZE2(0) | D3DFVF_DIFFUSE)
#define tx2vertex_fvf	(D3DFVF_XYZ | D3DFVF_TEX2 | D3DFVF_TEXCOORDSIZE2(0) | D3DFVF_TEXCOORDSIZE2(1))

#pragma pack(4)


// transformed vertex
struct trvertex
{
	Vector3D p;
	float rhw;
	trvertex() {}
	trvertex(const Vector3D& P) : p(P), rhw(1) {}
};

// transformed and colored vertex
struct ctrvertex
{
	Vector3D p;
	float rhw;
	DWORD c;
	ctrvertex() {}
	ctrvertex(const Vector3D& P, DWORD C) : p(P), c(C), rhw(1) {}
};

// colored vertex
struct cvertex
{
	Vector3D p;
	DWORD c;
	cvertex() {}
	cvertex(const Vector3D& P, DWORD C) : p(P), c(C) {}
};

// colored vertex w/ normal
struct cnvertex
{
	Vector3D p;
	Vector3D n;
	DWORD c;
	
	cnvertex(const Vector3D& P, DWORD C) : p(P), c(C), n(0,0,0) {}
	cnvertex(const Vector3D& P, const Vector3D& N, DWORD C) : p(P), c(C), n(N) {}
};

// vertex w/ normal
struct nvertex
{
	Vector3D p;
	Vector3D n;
	
	nvertex() {}
	nvertex(const Vector3D& P, const Vector3D& N) : p(P), n(N) {}
};


// textured vertex
struct txvertex
{
	Vector3D p;
	float u,v;
	txvertex() {}
	txvertex(const Vector3D& P, float U, float V) : p(P), u(U), v(V) {}
};

// transformed textured vertex
struct trtxvertex
{
	Vector3D p;
	float rhw;
	float u,v;
	trtxvertex() {}
	trtxvertex(const Vector3D& P, float U, float V) : p(P), u(U), v(V), rhw(1) {}
};

// transformed colored textured vertex
struct ctrtxvertex
{
	Vector3D p;
	float rhw;
	DWORD c;
	float u,v;
	ctrtxvertex() {}
	ctrtxvertex(const Vector3D& P, DWORD C, float U, float V) : p(P), c(C), u(U), v(V), rhw(1) {}
};

// textured vertex with normal
struct ntxvertex
{
	Vector3D p;
	Vector3D n;
	float u,v;
	ntxvertex() {}
	ntxvertex(const Vector3D& P, const Vector3D& N, float U, float V) 
		: p(P), n(N), u(U), v(V) {}
};

// textured vertex with normal and color
struct cntxvertex
{
	Vector3D p;
	Vector3D n;
	DWORD c;
	float u,v;
	cntxvertex() {}
	cntxvertex(const Vector3D& P, const Vector3D& N, DWORD C,float U, float V) 
		: p(P), n(N), u(U), v(V), c(C) {}
};

// colored textured vertex
struct ctxvertex
{
	Vector3D p;
	DWORD c;
	float u,v;
	ctxvertex() {}
	ctxvertex(const Vector3D& P, DWORD C, float U, float V) : p(P), c(C), u(U), v(V) {}
};

// colored multitextured vertex
struct ctx2vertex
{
	Vector3D p;
	DWORD c;
	float u1,v1;
	float u2,v2;
	ctx2vertex() {}
	ctx2vertex(const Vector3D& P, DWORD C, float U1, float V1, float U2, float V2) 
		: p(P), c(C), u1(U1), v1(V1), u2(U2), v2(V2) {}
};

// multitextured vertex
struct tx2vertex
{
	Vector3D p;
	float u1,v1;
	float u2,v2;
	
	tx2vertex() {}
	tx2vertex(const Vector3D& P, float U1, float V1, float U2, float V2)
		: p(P), u1(U1), v1(V1), u2(U2), v2(V2) {}
};

