#ifndef _SM_MAIN

#define _SM_MAIN

#define WIN32_LEAN_AND_MEAN 

#include <windows.h>


#include "SM_Leaks.h"

extern int SmAppPreInit();
extern int SmAppInit(); // Devuelve 0 si todo bien ; -1: en caso contrario
extern int SmAppEnd (); // Devuelve 0 si todo bien ; -1: en caso error
extern int SmAppRun (); // Devuelve 1 si queremos que continue. 0 en caso contrario
extern int SmWantMainWindow(); // Devuelve 1 si queremos ventana principal y bucle
extern int SmIgnoreClears();

namespace SM_Main
{  
  class IKeyboard
  {
  public:
    virtual void  OnKeyDown(int iVirtKey, bool bAlt)=0;
    virtual void  OnKeyUp  (int iVirtKey, bool bAlt)=0;
  };

  class IMouse
  {
  public:
    enum eButton
    {
      LEFT_BUTTON   ,
      MIDDLE_BUTTON ,
      RIGHT_BUTTON  ,
      NUMBER_BUTTONS,
    };

    virtual void OnMouseButtonDown(eButton Button)        =0;
    virtual void OnMouseButtonUp  (eButton Button)        =0;
    virtual void OnMouseMove      (int x, int y)          =0;
  };

  class INotifier
  {
  public:
    virtual void OnActivate(bool bActive)=0;
    virtual void OnDisplayChange()       =0;
  };

  HWND            Hwnd              ();             // Devuelve ventana de aplicacion
  HINSTANCE       HInstance         ();
  const char*     CommandLine       ();             // Devuelve linea de comando
  bool            IsActive          ();
  void            SetWindowText     ( const char* pcText);

  void _cdecl     OutputConsole     (char* pcFormat, ...);
  void _cdecl     OutputDebug       (char* pcFormat, ...);
  void _cdecl     OutputError       (char* pcFormat, ...);
  
  void            SetCursorPos      (int* x, int* y);
  void            GetCursorPos      (int* x, int* y);

  void            SetKeyboardHandler(IKeyboard*     pIKeyBoard);
  void            SetMouseHandler   (IMouse*        pIMouse);
  void            SetNotifyHandler  (INotifier*     pINotifier);
}

#endif