#include "DemoIDEPch.h"
#include "StatusWindow.h"

int StatusWindow::Init(Window* pParent)
{
  if (Window::InitPrivate("Status Bar", 0, WS_CHILDWINDOW | WS_BORDER | SBS_SIZEGRIP, pParent, STATUSCLASSNAME) == -1)
  {
    return -1;
  }

  m_bIsOK = true;

  Show();    

  int iWidth[2] = { -1, -1 };
  SendMessage(Hwnd(), SB_SETPARTS, (WPARAM) 2, (LPARAM)iWidth);
  SetText(E_LEFT, "threepixels");
  SetText(E_DESCRIPTOR, "Test");


  return 0;
}

void StatusWindow::UpdateWidth(int w)
{
  int iWidth[2] = { w/2, -1 };
  SendMessage(Hwnd(), SB_SETPARTS, (WPARAM) 2, (LPARAM)iWidth);
}

int StatusWindow::ProcessMessage  (const UINT message, const WPARAM wParam, const LPARAM lParam)
{
  return Window::ProcessMessage(message, wParam, lParam);
}

void StatusWindow::SetText(eText Slot, const char* pcText)
{
  SendMessage(Hwnd(), SB_SETTEXT, (WPARAM) Slot, (LPARAM)pcText);
}
