;cdd.asm  version 1 date march 27 1996
;
;opens a file called cdd.txt and appends data from the modem to the end of it.
;written by randy turner  emailto: 74040.1375@compuserve.com
;you can also reach me at my bbs number 915-762-3299
;
;I give this program to the public with the wish that it be freely passed on
;not sold for anything. By accepting this program you accept all risks that
;come with it
;
;tasm cdd
;tlink/t cdd
;

code            segment
                assume cs:code
                org 100h
begin:
                assume ds:code
                mov     bx,01h
                mov     dx,offset startmes
                mov     cx,offset startmeslen
                mov     ah,40h
                int     21h
assume ds:nothing
.386
                jmp     init            ;goto initialization code

modem_state     dw 03feh                ;com1=03EFh com2=02FEh com3=03EEh
timecount       dw 0
unload_flag     db 0
carrieron_flag  db 0
connectstr      db 'connected at ',00
dropstr         db 'disconnected at ',00
carrieroff_flag db 0
startmes        db 'do not run backup or any diagnostic utilities while'
                db 'this is resident',13,10
                db 'writes the time when carrier detect',13,10
                db 'turns off or on',13,10
                db 'opens a file called cdd.txt',13,10
                db 'sounds a tone when disk is active',13,10
                db 'hit control r to remove it',13,10,36

startmeslen equ $-startmes
sec             db 0
min             db 0
hou             db 0
num             dw 0
lf              db 13,10,00
lcount          dw 0
decbuf          db 100 dup(0)
path            db 'cdd.txt',00
hand            dw 0
dos_segment     dw ?                    ;DOS segment
busy_flag          dw ?                 ;offset of DOS BUSY_FLAG
remove_flag     db 0
program_status  db 0                    ;program processing status
dta             db 128h dup(0)
old_dta_segment dw ?
old_dta_offset  dw ?
flag_9h         db 00
preves          dw 0
flag_13h        db 0                    ;status of interrupt 13h
request_flag    db 0                    ;status of processing request
keyboard_int label dword
old9h           dw 2 dup (?)
timer_int       label dword             ;old interrupt 1Ch vector
old1ch          dw 2 dup (?)
bdisk_int       label dword             ;old interrupt 13h vector
old13h          dw 2 dup (?)
bp_int          label dword             ;old interrupt 28h vector
old28h          dw 2 dup (?)

uninstall proc near
                push    ds
                push    es
                assume ds:nothing
                assume es:nothing
                mov     ah,25h
                mov     al,13h
                lds     dx,cs:bdisk_int
                int     21h
                mov     ah,25h
                mov     al,09
                lds     dx,cs:keyboard_int
                int     21h
                lds     dx,cs:bp_int
                mov     ah,25h
                mov     al,28h
                int     21h
                lds     dx,cs:timer_int
                mov     al,1ch
                mov     ah,25h
                int     21h
                mov     es,cs:preves
                mov     ah,49h
                int     21h
                mov     ah,4ch
                int     21h
                pop     es
                pop     ds
                pop     ax
                iret
uninstall endp

kb_reset proc near
              in        al,61h          ;get current control value
              mov       ah,al           ;save it in AH
              or        al,80h          ;set the high bit
              out       61h,al          ;send it to the control port
              mov       al,ah           ;recover original value
              out       61h,al          ;send it out
              mov       al,20h          ;load EOI value
              out       20h,al          ;send it to the 8259
              sti                       ;restore interrupts
              ret
kb_reset endp

;Execution comes here thru interrupt 9 every time a key is pressed or released.
keyboard proc near
                sti
                push    ax
                in      al,60h
                cmp     al,19
                jne     check32
                mov     ah,02h
                int     16h
                test    al,04
                je      check32
                cmp     unload_flag,00
                je      check32
                call    kb_reset
                jmp     uninstall
        check32:
                cmp     al,32
                jne     kb2
                mov     ah,02
                int     16h
                test    al,04
                je      kb2
                cmp     program_status,00
                jne     kb2
        waspressed:
                mov     al,20h
                out     20h,al
                call    kb_reset
                mov     request_flag,01
                pop     ax
                iret
        kb2:
                pop     ax
                jmp     cs:keyboard_int
keyboard endp

;Interrupt 1Ch handling routine.
timer proc near
                pushf                   ;call original routine
                call    cs:timer_int
                mov     unload_flag,00
                push    es              ;save ES and DI
                push    di
                mov     es,dos_segment      ;get DOS segment in ES
                mov     di,busy_flag        ;address of DOS BUSY_FLAG in DI
                cmp     byte ptr es:[di],0  ;DOS service currently active?
                pop     di                  ;clean up the stack
                pop     es
                jne     timer1          ;yes, then we must wait
                cmp     flag_13h,0      ;BIOS disk service active?
                jne     timer1          ;yes, then don't interrupt it
                inc     timecount
                cmp     timecount,19*5
                jb      timer1
                mov     timecount,00
                cmp     carrieron_flag,01
                je      noc
                call    carrieron
        noc:    call    carrieroff
                mov     al,20h
                out     20h,al
        timer1: iret                    ;done - exit
timer endp

;Interrupt 13h handling routine.
;this routine monitors drive activity
bdisk proc far
                inc     flag_13h        ;drive is now active
                pushf
                cli
                call    bdisk_int
                sti
                pushf
                dec flag_13h            ;now drive is not active
                popf
                ret 2
bdisk endp

;Interrupt 28h handling routine.
;int 28h is the idle interrupt
;dos calls it in the dos prompt or in some input functions
;if your handler is not using it it just has a iret
backproc proc near
                pushf                   ;call original routine
                call    bp_int
                mov     unload_flag,01
        bp1:    iret                    ;done - exit
backproc endp

wrfile proc near
                mov     ah,40h
                int     21h
                ret
wrfile endp

eof proc near
                mov     ah,42h
                mov     cx,00
                mov     dx,00
                mov     al,02
                int     21h
                ret
eof endp

clfile proc near
                mov     ah,3eh
                int     21h
                ret
clfile endp

crfile proc near
                mov     cx,00
                mov     ah,3ch
                int     21h
                mov     bx,ax
                ret
crfile endp

opfile proc near
                mov     al,00000010b
                mov     ah,3dh
                int     21h
                mov     bx,ax
                ret
opfile endp

wrdec proc near
                mov     ax,dx
                mov     si,10
                xor     cx,cx
        nonzero:
                xor     dx,dx
                div     si
                push    dx
                inc     cx
                or      ax,ax
                jne     nonzero
                mov     si,offset decbuf
                add     si,lcount
        writedigitloop:
                pop     dx
                add     dl,"0"
                mov     [si],dl
                inc     si
                inc     lcount
                loop    writedigitloop
                ret
wrdec endp

carrieroff proc near
                push    ax
                push    dx
                push    ds
                push    cs
                pop     ds
                cmp     cs:carrieroff_flag,01
                je      exitoff
 
                mov     dx,cs:modem_state
                in      al,dx
                test    al,10001000b
                jne     exitoff
                mov     carrieroff_flag,01
                mov     carrieron_flag,00
                call    program
        exitoff:
                pop     ds
                pop     dx
                pop     ax
                ret
carrieroff endp

carrieron proc near
                push    ax
                push    dx
                push    ds
                push    cs
                pop     ds
                cmp     cs:carrieron_flag,01
                je      exiton
                mov     dx,cs:modem_state
                in      al,dx
                test    al,10001000b
                je      exiton
                mov     carrieron_flag,01
                mov     carrieroff_flag,00
                call    program
        exiton:
                pop     ds
                pop     dx
                pop     ax
                ret
carrieron endp

;this is the program
program proc near
                mov     program_status,1        ;set program active flag
                mov     request_flag,00
                sti                     ;enable interrupts
                push    ax              ;save registers
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    ds
                push    es
                push    cs              ;set DS to the code segment
                pop     ds
                assume ds:code
                push    cs              ;set ES to the code segment
                pop     es
                mov     bx,1000
                mov     cx,1000
                call    tone
                mov     lcount,0
                mov     di,offset decbuf
                cmp     carrieroff_flag,01
                je      noconnectstr
                mov     si,offset connectstr
                jmp     copycon
        noconnectstr:
                mov     si,offset dropstr
        copycon:
                mov     al,byte ptr[si]
                mov     byte ptr [di],al
                inc     si
                inc     di
                inc     lcount
                cmp     al,00
                jne     copycon
                dec     lcount
                mov     ah,2ch
                int     21h
                mov     hou,ch
                mov     min,cl
                mov     sec,dh
                mov     dh,00
                mov     dl,hou
                call    wrdec
                mov     byte ptr [si],':'
                inc     lcount
                mov     dl,min
                mov     dh,00
                call    wrdec
                mov     byte ptr [si],':'
                inc     lcount
                mov     dl,sec
                mov     dh,00
                call    wrdec
                add     lcount,02
                mov     byte ptr [si],13
                inc     si
                mov     byte ptr [si],10
                inc     si
                mov     dx,offset path
                call    opfile
                jnc     nocrfile
                mov     dx,offset path
                call    crfile
                mov     hand,ax
        nocrfile:
                mov     hand,ax
                mov     bx,ax
                call    eof
                mov     dx,offset decbuf
                mov     bx,hand
                mov     cx,lcount
                call    wrfile
                mov     bx,hand
                call    clfile
                mov     program_status,0        ;clear status flag
                pop     es                      ;restore registers and exit
                pop     ds
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                ret
program endp

;IOSET saves the current DTA address and interrupt 24h vector, then replaces
;them with pointers to program routines.  IORESET restores the original values.
ioset   proc near
                push    es              ;save ES
                mov     ah,2Fh          ;get current DTA address
                int     21h
                mov     old_dta_segment,es      ;save it
                mov     old_dta_offset,bx
                mov     ah,1Ah                  ;set new DTA address
                mov     dx,offset dta
                int     21h
                pop     es                      ;restore ES
                ret
ioset   endp
;
ioreset proc near
                push    ds
                assume  ds:nothing
                mov     ah,1Ah          ;restore original DTA address
                mov     dx,old_dta_offset
                mov     ds,old_dta_segment
                int     21h
                pop     ds
                assume ds:code
                ret
ioreset endp

count dw 0000
frequency dw 0000

tone    proc near
                mov     frequency,bx
                mov     count,cx
                mov     bx,frequency
                mov     cx,count
                mov     ax,34DDh
                mov     dx,0012h
                cmp     dx,bx
                jnb     stop
                div     bx
                mov     bx,ax
                in      al,61h
                test    al,3
                jne     j1
                or      al,3
                out     61h,al
                mov     al,0B6h
                out     43h,al
        j1:
                mov     al,bl
                out     42h,al
                mov     al,bh
                out     42h,al
        stop:

; ROUTINE TO DELAY SPECIFIED NUMBER OF MILLISECONDS
                mov     cx,count
                push    cx              ; save registers
        delay1:
                push    cx              ; save counter
                mov     cx,260          ; timing constant
        delay2:
                loop    delay2          ; small loop
                pop     cx              ; restore counter
                loop    delay1          ; loop to count milliseconds
                pop     cx              ; restore registers
        nosound:
                in      al,61h
                and     al,0fch
                out     61h,al
                ret
tone    endp

        proend:

;INITIALIZE prepares the program for residency.
init    proc near
                mov     cs:preves,es
        ;Get and save the address of the DOS BUSY_FLAG.
                mov     ah,34h          ;function 34h
                int     21h             ;get address
                mov     dos_segment,es  ;save segment
                mov     busy_flag,bx    ;save offset
        ;Save and replace all required interrupt vectors.
                mov     ah,35h          ;get interrupt 9 vector
                mov     al,9
                int     21h
                mov     old9h,bx        ;save it
                mov     old9h[2],es
                mov     ah,25h          ;point it to KEYBOARD routine
                lea     dx,keyboard
                int     21h
                mov     ah,35h          ;get interrupt 1Ch vector
                mov     al,1ch
                int     21h
                mov     old1ch,bx       ;save it
                mov     old1ch[2],es
                mov     ah,25h          ;then point it to TIMER
                lea     dx,timer
                int     21h
                mov     ah,35h          ;get interrupt 13h vector
                mov     al,13h
                int     21h
                mov     old13h,bx       ;save it
                mov     old13h[2],es
                mov     ah,25h          ;point it to BDISK
                lea     dx,bdisk
                int     21h
                mov     ah,35h          ;get interrupt 28h vector
                mov     al,28h
                int     21h
                mov     old28h,bx       ;save it
                mov     old28h[2],es
                mov     ah,25h          ;point it to BACKPROC
                lea     dx,backproc
                int     21h
                mov     ah,49h
                mov     es,cs:002ch
                int     21h
                mov     carrieron_flag,00
                mov     carrieroff_flag,01
        ;Terminate but remain resident in memory.
                mov     dx,offset proend+2
                int     27h             ;terminate-but-stay-resident
init    endp
code    ends
        end begin
