;   filename: buzz.asm   Produces very low volume sound.
;

.model       small
.stack       200h    ; 512 byte stack
.data

no_cycles    equ          200
freq1        equ          300
freq2        equ          20000
port_b       equ          61h

.code

start:
             mov          ax,@data
             mov          ds,ax
             cli
             mov          dx,no_cycles
             in           al,port_b
             and          al,11111110b ; 510 in decimal
next_cycle:
             or           al,2         ; 00000010b
             out          port_b,al
             mov          cx,freq1
             loop         $
             and          al,11111101b
             out          port_b,al
             mov          cx,freq2
             loop         $
             dec          dx
             jnz          next_cycle
             sti
exit:
             mov          ah,4ch
             int          21h

end          start


